/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TimeUnitParam {
    private static final Map<TimeUnit, Byte> timeUnitToByte = new EnumMap<TimeUnit, Byte>(TimeUnit.class);
    private static final byte TIME_UNIT_DEFAULT = 7;
    private static final byte TIME_UNIT_INFINITE = 8;

    private static byte encodeDuration(long duration, TimeUnit timeUnit) {
        return (byte)(duration == 0L ? 7 : (duration < 0L ? 8 : (int)timeUnitToByte.get((Object)timeUnit).byteValue()));
    }

    public static byte encodeTimeUnits(long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        byte encodedLifespan = TimeUnitParam.encodeDuration(lifespan, lifespanTimeUnit);
        byte encodedMaxIdle = TimeUnitParam.encodeDuration(maxIdle, maxIdleTimeUnit);
        return (byte)(encodedLifespan << 4 | encodedMaxIdle);
    }

    static {
        timeUnitToByte.put(TimeUnit.SECONDS, (byte)0);
        timeUnitToByte.put(TimeUnit.MILLISECONDS, (byte)1);
        timeUnitToByte.put(TimeUnit.NANOSECONDS, (byte)2);
        timeUnitToByte.put(TimeUnit.MICROSECONDS, (byte)3);
        timeUnitToByte.put(TimeUnit.MINUTES, (byte)4);
        timeUnitToByte.put(TimeUnit.HOURS, (byte)5);
        timeUnitToByte.put(TimeUnit.DAYS, (byte)6);
    }
}

