interface IdentConfig {
    port: number;
    address: string;
}
/**
 * Runs an ident server to auth a list of usernames.
 *
 * This purposefully has no dependencies on any other library and is kept as
 * generic as possible. It consists of three functions:
 *
 * configure(opts) : opts => { port: {Number} }
 *      Configure the ident server.
 *
 * run()
 *      Start listening on the configured port for incoming requests.
 *
 * setMapping(username, port) : username => {String}, port => {Number}
 *      Assign a username/port mapping. Setting a port of 0 removes the mapping.
 **/
declare class IdentSrv {
    private config;
    private portMappings;
    private pendingConnections;
    private isEnabled;
    get enabled(): boolean;
    run(): void;
    configure(opts: IdentConfig): void;
    setMapping(username: string, port: number): void;
    private onConnection;
    clientBegin(): () => void;
    private respond;
}
declare const _default: IdentSrv;
export default _default;
