/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Glacier2;

import com.zeroc.Glacier2.PermissionDeniedException;
import com.zeroc.Ice.Current;
import com.zeroc.Ice.FormatType;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;

public interface PermissionsVerifier
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public CheckPermissionsResult checkPermissions(String var1, String var2, Current var3) throws PermissionDeniedException;

    @Override
    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    @Override
    default public String ice_id(Current current) {
        return PermissionsVerifier.ice_staticId();
    }

    public static String ice_staticId() {
        return "::Glacier2::PermissionsVerifier";
    }

    public static CompletionStage<OutputStream> _iceD_checkPermissions(PermissionsVerifier obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_userId = istr.readString();
        String iceP_password = istr.readString();
        inS.endReadParams();
        inS.setFormat(FormatType.SlicedFormat);
        CheckPermissionsResult ret = obj.checkPermissions(iceP_userId, iceP_password, current);
        OutputStream ostr = inS.startWriteParams();
        ret.write(ostr);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    @Override
    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return PermissionsVerifier._iceD_checkPermissions(this, in, current);
            }
            case 1: {
                return Object._iceD_ice_id(this, in, current);
            }
            case 2: {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 3: {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 4: {
                return Object._iceD_ice_ping(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Glacier2::PermissionsVerifier", "::Ice::Object"};
        _iceOps = new String[]{"checkPermissions", "ice_id", "ice_ids", "ice_isA", "ice_ping"};
    }

    public static class CheckPermissionsResult {
        public boolean returnValue;
        public String reason;

        public CheckPermissionsResult() {
        }

        public CheckPermissionsResult(boolean returnValue, String reason) {
            this.returnValue = returnValue;
            this.reason = reason;
        }

        public void write(OutputStream ostr) {
            ostr.writeString(this.reason);
            ostr.writeBool(this.returnValue);
        }

        public void read(InputStream istr) {
            this.reason = istr.readString();
            this.returnValue = istr.readBool();
        }
    }
}

