/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.mac;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.mac.ResourceType;

public class ResourceMap {
    private final byte[] headerCopy = new byte[16];
    private int nextResourceMap;
    private int fileReferenceNumber;
    private int attributes;
    private ResourceType[] types;

    public ResourceMap(DataInput dataInput) throws IOException {
        int n;
        dataInput.readFully(this.headerCopy);
        this.nextResourceMap = dataInput.readInt();
        this.fileReferenceNumber = dataInput.readUnsignedShort();
        this.attributes = dataInput.readUnsignedShort();
        int n2 = dataInput.readUnsignedShort();
        int n3 = dataInput.readUnsignedShort();
        int n4 = dataInput.readUnsignedShort() + 1;
        this.types = new ResourceType[n4];
        for (n = 0; n < n4; ++n) {
            this.types[n] = new ResourceType(dataInput);
        }
        for (n = 0; n < n4; ++n) {
            this.types[n].readRefs(dataInput);
        }
        for (n = 0; n < n4; ++n) {
            this.types[n].readNames(dataInput);
        }
    }

    public ResourceType getResourceType(String string) {
        for (ResourceType resourceType : this.types) {
            String string2 = resourceType.getTypeAsString();
            if (!resourceType.getTypeAsString().equals(string)) continue;
            return resourceType;
        }
        return null;
    }

    public ResourceType getResourceType(int n) {
        return this.types[n];
    }

    public int getResourceTypeCount() {
        return this.types.length;
    }
}

