/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseShorthandSetter;
import io.sf.carte.doc.style.css.om.ShorthandValue;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.InheritValue;
import io.sf.carte.doc.style.css.property.InitialValue;
import io.sf.carte.doc.style.css.property.KeywordValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RevertValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.UnsetValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueItem;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.DOMException;

class ShorthandSetter
extends BaseShorthandSetter {
    private static CSSValueSyntax imageSyntax = new SyntaxParser().parseSyntax("<image>");
    private boolean priorityImportant = false;
    final ValueFactory valueFactory;
    private final HashMap<String, StyleValue> mypropValue = new HashMap();
    private final List<String> mypropertyList = new ArrayList<String>();
    private final List<Boolean> mypriorities = new ArrayList<Boolean>();
    protected LexicalUnit currentValue = null;
    private final StringBuilder valueBuffer = new StringBuilder(40);
    private final StringBuilder miniValueBuffer = new StringBuilder(40);
    private transient boolean attrTainted;
    private final ArrayList<String> unassignedProperties = new ArrayList(6);

    ShorthandSetter(BaseCSSStyleDeclaration baseCSSStyleDeclaration, String string) {
        super(baseCSSStyleDeclaration, string);
        this.valueFactory = baseCSSStyleDeclaration.getValueFactory();
    }

    public boolean isPriorityImportant() {
        return this.priorityImportant;
    }

    String getPriority() {
        return this.priorityImportant ? "important" : null;
    }

    void setPriority(boolean bl) {
        this.priorityImportant = bl;
    }

    protected boolean isAttrTainted() {
        return this.attrTainted;
    }

    @Override
    public void setAttrTainted(boolean bl) {
        this.attrTainted = bl;
    }

    boolean hasCompatValue() {
        for (LexicalUnit lexicalUnit = this.currentValue; lexicalUnit != null; lexicalUnit = lexicalUnit.getNextLexicalUnit()) {
            LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
            if (lexicalType != LexicalUnit.LexicalType.COMPAT_IDENT && lexicalType != LexicalUnit.LexicalType.COMPAT_PRIO) continue;
            return true;
        }
        return false;
    }

    void addUnassignedProperty(String string) {
        this.unassignedProperties.add(string);
    }

    List<String> getUnassignedProperties() {
        return this.unassignedProperties;
    }

    boolean scanUnassigned(List<LexicalUnit> list) {
        block0: for (LexicalUnit lexicalUnit : list) {
            String string;
            Iterator<Object> iterator;
            Object object;
            if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                if (!this.isNotValidIdentifier(lexicalUnit)) continue;
                object = lexicalUnit.getStringValue();
                iterator = this.getUnassignedProperties().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (!string.endsWith("-color") || !((String)object).endsWith("-color")) continue;
                    this.setSubpropertyValue(string, this.createCSSValue(string, lexicalUnit));
                    iterator.remove();
                    continue block0;
                }
            } else if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.FUNCTION) {
                object = this.getUnassignedProperties();
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (!string.endsWith("-color")) continue;
                    for (LexicalUnit lexicalUnit2 = lexicalUnit.getParameters(); lexicalUnit2 != null; lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) {
                        if (!BaseCSSStyleDeclaration.testColor(lexicalUnit2)) continue;
                        this.setSubpropertyValue(string, this.createCSSValue(string, lexicalUnit));
                        iterator.remove();
                        continue block0;
                    }
                }
            } else if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                object = this.getUnassignedProperties();
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (string.endsWith("-color")) {
                        if (object.size() != 1) continue;
                        this.setSubpropertyValue(string, this.createCSSValue(string, lexicalUnit));
                        iterator.remove();
                        break block0;
                    }
                    if (!string.endsWith("-image") || object.size() != 1) continue;
                    this.setSubpropertyValue(string, this.createCSSValue(string, lexicalUnit));
                    iterator.remove();
                    break block0;
                }
            }
            if ((object = this.styleDeclaration.getStyleDeclarationErrorHandler()) != null) {
                object.unassignedShorthandValue(this.getShorthandName(), lexicalUnit.toString());
            }
            return false;
        }
        return true;
    }

    byte scanForCssWideKeywords(LexicalUnit lexicalUnit) {
        KeywordValue keywordValue = this.createKeywordValueSubproperty(lexicalUnit);
        if (keywordValue != null) {
            if (lexicalUnit.getNextLexicalUnit() != null) {
                this.reportMixedKeywords(keywordValue.getCssText());
                return 2;
            }
            this.setSubpropertiesToKeyword(keywordValue);
            this.initValueString();
            this.appendValueItemString(keywordValue);
            return 1;
        }
        return 0;
    }

    KeywordValue createKeywordValueSubproperty(LexicalUnit lexicalUnit) {
        KeywordValue keywordValue;
        switch (lexicalUnit.getLexicalUnitType()) {
            case INHERIT: {
                keywordValue = InheritValue.getValue().asSubproperty();
                break;
            }
            case INITIAL: {
                keywordValue = InitialValue.getValue().asSubproperty();
                break;
            }
            case UNSET: {
                keywordValue = UnsetValue.getValue().asSubproperty();
                break;
            }
            case REVERT: {
                keywordValue = RevertValue.getValue().asSubproperty();
                break;
            }
            default: {
                keywordValue = null;
            }
        }
        return keywordValue;
    }

    private void reportMixedKeywords(String string) {
        StyleDeclarationErrorHandler styleDeclarationErrorHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
        if (styleDeclarationErrorHandler != null) {
            styleDeclarationErrorHandler.shorthandError(this.getShorthandName(), "Found '" + string + "' keyword mixed with other values");
        }
    }

    protected void setSubpropertiesToKeyword(StyleValue styleValue) {
        String[] stringArray;
        for (String string : stringArray = this.getShorthandSubproperties()) {
            String[] stringArray2;
            if (!this.getShorthandDatabase().isShorthand(string)) {
                this.styleDeclaration.setProperty(string, styleValue, this.isPriorityImportant());
                continue;
            }
            for (String string2 : stringArray2 = this.getShorthandDatabase().getShorthandSubproperties(string)) {
                this.styleDeclaration.setProperty(string2, styleValue, this.isPriorityImportant());
            }
        }
    }

    void setListSubpropertyValue(String string, ValueList valueList) {
        if (valueList.getLength() == 1) {
            StyleValue styleValue = valueList.item(0);
            if (styleValue.isPrimitiveValue()) {
                ((PrimitiveValue)styleValue).setSubproperty(true);
            } else {
                CSSValue.CssType cssType = styleValue.getCssValueType();
                if (cssType == CSSValue.CssType.KEYWORD) {
                    styleValue = ((KeywordValue)styleValue).asSubproperty();
                } else if (cssType == CSSValue.CssType.LIST) {
                    ((ValueList)styleValue).setSubproperty(true);
                }
            }
            this.setSubpropertyValue(string, styleValue);
        } else {
            valueList.setSubproperty(true);
            this.setSubpropertyValue(string, valueList);
        }
    }

    protected String[] getShorthandSubproperties() {
        return this.getShorthandDatabase().getShorthandSubproperties(this.getShorthandName());
    }

    protected void nextCurrentValue() {
        if (this.currentValue != null) {
            this.currentValue = this.currentValue.getNextLexicalUnit();
            this.appendValueItemString();
        }
    }

    @Override
    public void init(LexicalUnit lexicalUnit, boolean bl) {
        this.currentValue = lexicalUnit;
        this.setPriority(bl);
        this.unassignedProperties.clear();
        this.initValueString();
        this.appendValueItemString();
    }

    protected void resetSubproperties() {
        List<String> list = this.getUnassignedProperties();
        for (String string : list) {
            String[] stringArray;
            if (!this.getShorthandDatabase().isShorthand(string)) {
                this.setPropertyToDefault(string);
                continue;
            }
            for (String string2 : stringArray = this.getShorthandDatabase().getShorthandSubproperties(string)) {
                this.setPropertyToDefault(string2);
            }
        }
    }

    protected void setSubpropertiesToDefault() {
        String[] stringArray;
        for (String string : stringArray = this.getShorthandSubproperties()) {
            String[] stringArray2;
            if (!this.getShorthandDatabase().isShorthand(string)) {
                this.setPropertyToDefault(string);
                continue;
            }
            for (String string2 : stringArray2 = this.getShorthandDatabase().getShorthandSubproperties(string)) {
                this.setPropertyToDefault(string2);
            }
        }
    }

    StyleValue defaultPropertyValue(String string) {
        StyleValue styleValue = this.styleDeclaration.defaultPropertyValue(string);
        if (styleValue != null) {
            CSSValue.CssType cssType = styleValue.getCssValueType();
            if (cssType == CSSValue.CssType.TYPED) {
                ((PrimitiveValue)styleValue).setSubproperty(true);
            } else if (cssType == CSSValue.CssType.LIST) {
                ((ValueList)styleValue).setSubproperty(true);
            }
        } else {
            styleValue = InitialValue.getValue().asSubproperty();
        }
        return styleValue;
    }

    void setPropertyToDefault(String string) {
        StyleValue styleValue = this.defaultPropertyValue(string);
        this.setProperty(string, styleValue, this.isPriorityImportant());
    }

    void setDeclarationPropertyToDefault(String string) {
        StyleValue styleValue = this.defaultPropertyValue(string);
        this.styleDeclaration.setProperty(string, styleValue, this.isPriorityImportant());
    }

    protected List<String> subpropertyList() {
        String[] stringArray = this.getShorthandSubproperties();
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        Collections.addAll(arrayList, stringArray);
        return arrayList;
    }

    @Override
    public boolean assignSubproperties() {
        boolean bl = this.draftSubproperties();
        if (bl) {
            this.flush();
        }
        return bl;
    }

    boolean draftSubproperties() {
        byte by = this.scanForCssWideKeywords(this.currentValue);
        if (by == 1) {
            return true;
        }
        if (by == 2) {
            return false;
        }
        LinkedList<LexicalUnit> linkedList = new LinkedList<LexicalUnit>();
        List<String> list = this.subpropertyList();
        while (this.currentValue != null) {
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                if (!this.assignSubproperty(string)) continue;
                list.remove(i);
                bl = true;
                break;
            }
            if (bl) continue;
            linkedList.add(this.currentValue);
            this.nextCurrentValue();
        }
        if (!list.isEmpty()) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                this.addUnassignedProperty(iterator.next());
            }
        }
        if (!linkedList.isEmpty() && !this.scanUnassigned(linkedList)) {
            return false;
        }
        this.resetSubproperties();
        return true;
    }

    boolean isNotValidIdentifier(LexicalUnit lexicalUnit) {
        return !lexicalUnit.getStringValue().equalsIgnoreCase("none");
    }

    protected boolean assignSubproperty(String string) {
        LexicalUnit.LexicalType lexicalType = this.currentValue.getLexicalUnitType();
        if (lexicalType == LexicalUnit.LexicalType.IDENT && this.assignIdentifiers(string)) {
            return true;
        }
        if (string.endsWith("-color") ? BaseCSSStyleDeclaration.testColor(this.currentValue) : (string.endsWith("-width") ? ValueFactory.isSizeSACUnit(this.currentValue) : string.endsWith("-image") && this.isImage())) {
            return this.setCurrentValue(string);
        }
        return false;
    }

    boolean isImage() {
        LexicalUnit.LexicalType lexicalType = this.currentValue.getLexicalUnitType();
        return lexicalType == LexicalUnit.LexicalType.URI || lexicalType == LexicalUnit.LexicalType.SRC || lexicalType == LexicalUnit.LexicalType.FUNCTION && this.isImageFunctionOrGradientName() || lexicalType == LexicalUnit.LexicalType.ELEMENT_REFERENCE || this.currentValue.shallowClone().matches(imageSyntax) == CSSValueSyntax.Match.TRUE;
    }

    private boolean isImageFunctionOrGradientName() {
        String string = this.currentValue.getFunctionName().toLowerCase(Locale.ROOT);
        return string.endsWith("-gradient") || string.equals("image") || string.equals("image-set") || string.equals("cross-fade");
    }

    boolean setCurrentValue(String string) {
        StyleValue styleValue = this.createCSSValue(string, this.currentValue);
        if (styleValue != null) {
            this.setSubpropertyValue(string, styleValue);
            this.nextCurrentValue();
            return true;
        }
        return false;
    }

    boolean assignIdentifiers(String string) {
        if (this.testIdentifiers(string)) {
            StyleValue styleValue = this.createCSSValue(string, this.currentValue);
            this.setSubpropertyValue(string, styleValue);
            this.nextCurrentValue();
            return true;
        }
        return false;
    }

    boolean testIdentifiers(String string) {
        return this.getShorthandDatabase().isIdentifierValue(string, this.currentValue.getStringValue());
    }

    protected void setSubpropertyValue(String string, StyleValue styleValue) {
        this.setProperty(string, styleValue, this.isPriorityImportant());
    }

    void setSubpropertyValueWListCheck(String string, StyleValue styleValue) {
        ValueList valueList;
        if (styleValue.getCssValueType() == CSSValue.CssType.LIST && (valueList = (ValueList)styleValue).getLength() == 1) {
            styleValue = valueList.item(0);
        }
        this.setSubpropertyValue(string, styleValue);
    }

    void addSubpropertyValue(String string, StyleValue styleValue, boolean bl) {
        StyleValue styleValue2 = this.getDeclaredCSSValue(string);
        if (styleValue2 == null) {
            this.setSubpropertyValue(string, styleValue);
        } else {
            switch (styleValue2.getCssValueType()) {
                case LIST: {
                    ((ValueList)styleValue2).add(styleValue);
                    styleValue = styleValue2;
                    break;
                }
                default: {
                    ValueList valueList = bl ? ValueList.createCSValueList() : ValueList.createWSValueList();
                    valueList.add(styleValue2);
                    valueList.add(styleValue);
                    styleValue = valueList;
                }
            }
            this.setProperty(string, styleValue, this.isPriorityImportant());
        }
    }

    void setProperty(String string, StyleValue styleValue, boolean bl) {
        this.mypropertyList.add(string);
        this.mypriorities.add(bl);
        this.mypropValue.put(string, styleValue);
    }

    boolean isPropertySet(String string) {
        return this.mypropertyList.contains(string);
    }

    StyleValue getDeclaredCSSValue(String string) {
        return this.mypropValue.get(string);
    }

    void flush() {
        int n = 0;
        for (String string : this.mypropertyList) {
            this.styleDeclaration.setProperty(string, this.mypropValue.get(string), (boolean)this.mypriorities.get(n));
            ++n;
        }
        this.mypropertyList.clear();
        this.mypriorities.clear();
        this.mypropValue.clear();
    }

    StyleValue createCSSValue() throws DOMException {
        StyleDeclarationErrorHandler styleDeclarationErrorHandler;
        ValueItem valueItem = this.valueFactory.createCSSValueItem(this.currentValue, true);
        if (valueItem.hasWarnings() && (styleDeclarationErrorHandler = this.styleDeclaration.getStyleDeclarationErrorHandler()) != null) {
            valueItem.handleSyntaxWarnings(styleDeclarationErrorHandler);
        }
        this.currentValue = valueItem.getNextLexicalUnit();
        return valueItem.getCSSValue();
    }

    protected StyleValue createCSSValue(String string, LexicalUnit lexicalUnit) throws DOMException {
        return this.createCSSValue(string, lexicalUnit, true);
    }

    StyleValue createCSSValue(String string, LexicalUnit lexicalUnit, boolean bl) throws DOMException {
        StyleDeclarationErrorHandler styleDeclarationErrorHandler;
        ValueItem valueItem = this.valueFactory.createCSSValueItem(lexicalUnit, bl);
        StyleValue styleValue = valueItem.getCSSValue();
        if (valueItem.hasWarnings() && (styleDeclarationErrorHandler = this.styleDeclaration.getStyleDeclarationErrorHandler()) != null) {
            valueItem.handleSyntaxWarnings(styleDeclarationErrorHandler);
        }
        return styleValue;
    }

    void initValueString() {
        this.valueBuffer.setLength(0);
        this.miniValueBuffer.setLength(0);
    }

    void appendValueItemString(StyleValue styleValue) {
        if (styleValue != null) {
            String string = styleValue.getCssText();
            String string2 = styleValue.getMinifiedCssText(this.getShorthandName());
            StringBuilder stringBuilder = this.getValueItemBuffer();
            StringBuilder stringBuilder2 = this.getValueItemBufferMini();
            int n = stringBuilder.length();
            if (n != 0) {
                char c = stringBuilder.charAt(n - 1);
                if (!this.isDelimiterChar(c, string2)) {
                    stringBuilder2.append(' ');
                }
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
            stringBuilder2.append(string2);
        }
    }

    protected boolean isDelimiterChar(char c, String string) {
        return c == ',' || c == '/';
    }

    void appendValueItemString(String string) {
        this.getValueItemBuffer().append(string);
        this.getValueItemBufferMini().append(string);
    }

    protected void appendValueItemString() {
        if (this.currentValue != null) {
            this.valueFactory.appendValueString(this.getValueItemBuffer(), this.currentValue);
            this.valueFactory.appendMinifiedValueString(this.getValueItemBufferMini(), this.currentValue);
        }
    }

    StringBuilder getValueItemBuffer() {
        return this.valueBuffer;
    }

    StringBuilder getValueItemBufferMini() {
        return this.miniValueBuffer;
    }

    void appendToValueBuffer(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        this.valueBuffer.append((CharSequence)stringBuilder);
        this.miniValueBuffer.append((CharSequence)stringBuilder2);
    }

    @Override
    public String getCssText() {
        return this.valueBuffer.toString();
    }

    @Override
    public String getMinifiedCssText() {
        return this.miniValueBuffer.toString();
    }

    @Override
    public ShorthandValue createCSSShorthandValue(LexicalUnit lexicalUnit) {
        return ShorthandValue.createCSSShorthandValue(this.getShorthandDatabase(), this.getShorthandName(), lexicalUnit, this.isPriorityImportant(), this.attrTainted);
    }

    void reportDeclarationError(String string, String string2) {
        BaseCSSDeclarationRule baseCSSDeclarationRule = this.styleDeclaration.getParentRule();
        if (baseCSSDeclarationRule != null) {
            baseCSSDeclarationRule.getStyleDeclarationErrorHandler().shorthandError(string, string2);
        }
    }
}

