/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSStyleDeclaration;

public final class AttributeToStyle {
    public static void align(String attribute, CSSStyleDeclaration style) {
        if (attribute.equalsIgnoreCase("center") || attribute.equalsIgnoreCase("middle")) {
            style.setProperty("text-align", "center", null);
        } else if (attribute.equalsIgnoreCase("justify")) {
            style.setProperty("text-align", "justify", null);
        } else if (attribute.equalsIgnoreCase("left")) {
            style.setProperty("text-align", "left", null);
        } else if (attribute.equalsIgnoreCase("right")) {
            style.setProperty("text-align", "right", null);
        }
    }

    public static void bgcolor(String bgcolorAttr, CSSStyleDeclaration style) {
        if ((bgcolorAttr = bgcolorAttr.trim()).length() != 0) {
            style.setProperty("background-color", bgcolorAttr, null);
        }
    }

    public static void width(String widthAttr, CSSStyleDeclaration style) {
        int attlen = widthAttr.length();
        if (attlen != 0) {
            char c = widthAttr.charAt(attlen - 1);
            if (AttributeToStyle.isDigit(c)) {
                widthAttr = widthAttr + "px";
            }
            style.setProperty("width", widthAttr, null);
        }
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static void height(String heightAttr, CSSStyleDeclaration style) {
        int attlen = heightAttr.length();
        if (attlen != 0) {
            char c = heightAttr.charAt(attlen - 1);
            if (AttributeToStyle.isDigit(c)) {
                heightAttr = heightAttr + "px";
            }
            style.setProperty("height", heightAttr, null);
        }
    }

    public static void face(String attribute, CSSStyleDeclaration style) {
        if ((attribute = attribute.trim()).length() != 0) {
            style.setProperty("font-family", attribute, null);
        }
    }

    public static void size(String attribute, CSSStyleDeclaration style) {
        String sz;
        if ((attribute = attribute.trim()).length() != 0 && !(sz = AttributeToStyle.translateFontSize(attribute)).isEmpty()) {
            style.setProperty("font-size", sz, null);
        }
    }

    private static String translateFontSize(String size) {
        int sz;
        if (size.charAt(0) == '+') {
            return "larger";
        }
        if (size.charAt(0) == '-') {
            return "smaller";
        }
        try {
            sz = Integer.parseInt(size);
        }
        catch (NumberFormatException e) {
            return "";
        }
        switch (sz) {
            case 1: {
                size = "8px";
                break;
            }
            case 2: {
                size = "10px";
                break;
            }
            case 3: {
                size = "12px";
                break;
            }
            case 4: {
                size = "14px";
                break;
            }
            case 5: {
                size = "18px";
                break;
            }
            case 6: {
                size = "24px";
                break;
            }
            case 7: {
                size = "28px";
                break;
            }
            default: {
                size = "";
            }
        }
        return size;
    }

    public static void color(String attribute, CSSStyleDeclaration style) {
        if ((attribute = attribute.trim()).length() != 0) {
            style.setProperty("color", attribute, null);
        }
    }

    public static boolean border(String attribute, CSSStyleDeclaration style) {
        int attlen = (attribute = attribute.trim()).length();
        if (attlen != 0) {
            char c = attribute.charAt(attlen - 1);
            if (AttributeToStyle.isDigit(c)) {
                attribute = attribute + "px";
            }
            style.setProperty("border-top-width", attribute, null);
            style.setProperty("border-right-width", attribute, null);
            style.setProperty("border-bottom-width", attribute, null);
            style.setProperty("border-left-width", attribute, null);
            return true;
        }
        return false;
    }

    public static void borderColor(String attribute, CSSStyleDeclaration style) {
        int attlen = (attribute = attribute.trim()).length();
        if (attlen != 0) {
            style.setProperty("border-top-color", attribute, null);
            style.setProperty("border-right-color", attribute, null);
            style.setProperty("border-bottom-color", attribute, null);
            style.setProperty("border-left-color", attribute, null);
        }
    }

    public static void cellSpacing(String attribute, CSSStyleDeclaration style) {
        int attlen = (attribute = attribute.trim()).length();
        if (attlen != 0) {
            char c = attribute.charAt(attlen - 1);
            if (AttributeToStyle.isDigit(c)) {
                attribute = attribute + "px";
            }
            style.setProperty("border-spacing", attribute, null);
        }
    }

    public static void background(String attribute, CSSStyleDeclaration style) {
        if ((attribute = attribute.trim()).length() != 0) {
            style.setProperty("background-image", attribute, null);
        }
    }

    public static void hspace(String attribute, CSSStyleDeclaration style) {
        int attlen = (attribute = attribute.trim()).length();
        if (attlen != 0) {
            char c = attribute.charAt(attlen - 1);
            if (AttributeToStyle.isDigit(c)) {
                attribute = attribute + "px";
            }
            style.setProperty("margin-right", attribute, null);
            style.setProperty("margin-left", attribute, null);
        }
    }

    public static void vspace(String attribute, CSSStyleDeclaration style) {
        int attlen = (attribute = attribute.trim()).length();
        if (attlen != 0) {
            char c = attribute.charAt(attlen - 1);
            if (AttributeToStyle.isDigit(c)) {
                attribute = attribute + "px";
            }
            style.setProperty("margin-top", attribute, null);
            style.setProperty("margin-bottom", attribute, null);
        }
    }
}

