/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import oracle.jdbc.internal.NetStat;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;

public class FailoverablePooledConnectionHelper {
    static final String CLASS_NAME = FailoverablePooledConnectionHelper.class.getName();
    private static final Object[] NO_ARGS = new Object[0];
    private static final Map<Class<?>, InvocationVector> oracleConnCache = Collections.synchronizedMap(new HashMap());

    static boolean isUsableOnOracleConnection(Connection oconn) {
        boolean ret_value = false;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodIsUsable();
            if (null != method) {
                ret_value = (Boolean)method.invoke((Object)oconn, NO_ARGS);
            } else {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "isUsableOnOracleConnection", "failed to invoke isUsable(): no such method", null, null, new Object[0]);
                ret_value = !oconn.isClosed();
            }
        }
        catch (Exception e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "isUsableOnOracleConnection", "", null, e, new Object[0]);
        }
        return ret_value;
    }

    static long getLastNetworkAccessTime(Connection oconn) {
        long ret_value = 0L;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodNetworkStat();
            if (null != method) {
                NetStat stat = (NetStat)method.invoke((Object)oconn, NO_ARGS);
                if (stat != null) {
                    ret_value = stat.getLastNetworkAccessTime();
                }
            } else {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "getLastNetworkAccessTime", "failed to invoke getNetworkStat(): no such method", null, null, new Object[0]);
            }
        }
        catch (Exception e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "getLastNetworkAccessTime", "", null, e, new Object[0]);
        }
        return ret_value;
    }

    public static Properties getSessionInfoOnOracleConnection(Connection oconn) {
        Properties props = new Properties();
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodGetServerSessionInfo();
            if (null != method) {
                props = (Properties)method.invoke((Object)oconn, NO_ARGS);
            } else {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "getSessionInfoOnOracleConnection", "failed to invoke getServerSessionInfo: method not found", null, null, new Object[0]);
                props = FailoverablePooledConnectionHelper.getSessionInfoOnOracleConnectionHelper(oconn);
            }
        }
        catch (Exception e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "getSessionInfoOnOracleConnection", "", null, e, new Object[0]);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getSessionInfoOnOracleConnectionHelper(Connection connection) throws SQLException {
        String query = "select sys_context('userenv', 'instance_name'),sys_context('userenv', 'server_host'),sys_context('userenv', 'service_name'),sys_context('userenv', 'db_unique_name') from dual";
        Properties props = new Properties();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String val = null;
                val = rs.getString(1);
                if (val != null) {
                    props.setProperty("INSTANCE_NAME", val);
                }
                if ((val = rs.getString(2)) != null) {
                    props.setProperty("SERVER_HOST", val);
                }
                if ((val = rs.getString(3)) != null) {
                    props.setProperty("SERVICE_NAME", val);
                }
                if ((val = rs.getString(4)) == null) continue;
                props.setProperty("DATABASE_NAME", val);
            }
        }
        catch (SQLException ea) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "getSessionInfoOnOracleConnectionHelper", "", null, ea, new Object[0]);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return props;
    }

    static void cancelOnOracleConnection(Connection oconn) throws SQLException {
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodCancel();
            if (null != method) {
                method.invoke((Object)oconn, NO_ARGS);
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "cancelOnOracleConnection", "conn cancelled successfully", null, null, new Object[0]);
            } else {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "cancelOnOracleConnection", "failed to cancel a connection: method not found", null, null, new Object[0]);
            }
        }
        catch (Exception exc) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "cancelOnOracleConnection", "", null, exc, new Object[0]);
        }
    }

    static void enableStatementPooling(Connection oconn, int maxStatements) throws SQLException {
        block6: {
            try {
                if (null == oconn) {
                    DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "enableStatementPooling", "failed to get SQL conn", null, null, new Object[0]);
                    return;
                }
                InvocationVector vector = FailoverablePooledConnectionHelper.getInvocationVector(oconn);
                Method method = vector.getMethodSetStatementCacheSize();
                if (null != method) {
                    method.invoke((Object)oconn, maxStatements);
                    DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "enableStatementPooling", "setStatementCacheSize invoked", null, null, new Object[0]);
                }
                if (null != (method = vector.getMethodSetImplicitCachingEnabled())) {
                    method.invoke((Object)oconn, true);
                    DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "enableStatementPooling", "setImplicitCachingEnabled invoked", null, null, new Object[0]);
                }
                if (null != (method = vector.getMethodSetExplicitCachingEnabled())) {
                    method.invoke((Object)oconn, true);
                    DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "enableStatementPooling", "setExplicitCachingEnabled invoked", null, null, new Object[0]);
                }
            }
            catch (Exception e) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "enableStatementPooling", "", null, e, new Object[0]);
                if (!(e instanceof SQLException)) break block6;
                throw (SQLException)e;
            }
        }
    }

    static void disableStatementPooling(Connection oconn) throws SQLException {
        block6: {
            try {
                if (null == oconn) {
                    DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "disableStatementPooling", "failed to get SQL conn", null, null, new Object[0]);
                    return;
                }
                InvocationVector vector = FailoverablePooledConnectionHelper.getInvocationVector(oconn);
                Method method = vector.getMethodSetStatementCacheSize();
                if (null != method) {
                    method.invoke((Object)oconn, 0);
                    DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "disableStatementPooling", "setStatementCacheSize invoked", null, null, new Object[0]);
                }
                if (null != (method = vector.getMethodSetImplicitCachingEnabled())) {
                    method.invoke((Object)oconn, false);
                    DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "disableStatementPooling", "setImplicitCachingEnabled invoked", null, null, new Object[0]);
                }
                if (null != (method = vector.getMethodSetExplicitCachingEnabled())) {
                    method.invoke((Object)oconn, false);
                    DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "disableStatementPooling", "setExplicitCachingEnabled invoked", null, null, new Object[0]);
                }
            }
            catch (Exception e) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "disableStatementPooling", "", null, e, new Object[0]);
                if (!(e instanceof SQLException)) break block6;
                throw (SQLException)e;
            }
        }
    }

    static boolean pingDatabaseOnOracleConnection(Connection oconn) {
        Object[] arg;
        InvocationVector vector = FailoverablePooledConnectionHelper.getInvocationVector(oconn);
        Method method = vector.getMethodPingDatabase();
        if (null == method) {
            method = vector.getMethodPingDatabaseInt();
            arg = new Object[]{0};
        } else {
            arg = NO_ARGS;
        }
        try {
            return vector.getConnClass().getField("DATABASE_OK").getInt(null) == ((Integer)method.invoke((Object)oconn, arg)).intValue();
        }
        catch (Exception e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "pingDatabaseOnOracleConnection", "", null, e, new Object[0]);
            return true;
        }
    }

    public static void abortOracleConnection(final Connection oconn) {
        if (oconn == null) {
            return;
        }
        try {
            final Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodAbort();
            if (null != method) {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IllegalAccessException, InvocationTargetException {
                        method.invoke((Object)oconn, NO_ARGS);
                        return null;
                    }
                });
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "abortOracleConnection", "connection aborted", null, null, new Object[0]);
            } else {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "abortOracleConnection", "failed to abort connection: method not found", null, null, new Object[0]);
            }
        }
        catch (Exception ex) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "abortOracleConnection", "", null, ex, new Object[0]);
        }
    }

    protected static InvocationVector getInvocationVector(Connection oracleConn) {
        Class<?> connClass = oracleConn.getClass();
        InvocationVector vector = oracleConnCache.get(connClass);
        if (null != vector) {
            return vector;
        }
        Class<?> c = null;
        try {
            c = Class.forName("oracle.jdbc.internal.OracleConnection", true, connClass.getClassLoader());
        }
        catch (Exception e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "getInvocationVector", "", null, e, new Object[0]);
        }
        final Class<?> cls = c;
        vector = new InvocationVector(){
            private final Method abort = this.getMethod("abort");
            private final Method cancel = this.getMethod("cancel");
            private final Method isUsable = this.getMethod("isUsable");
            private final Method setStatementCacheSize = this.getMethod("setStatementCacheSize", Integer.TYPE);
            private final Method setImplicitCachingEnabled = this.getMethod("setImplicitCachingEnabled", Boolean.TYPE);
            private final Method setExplicitCachingEnabled = this.getMethod("setExplicitCachingEnabled", Boolean.TYPE);
            private final Method getServerSessionInfo = this.getMethod("getServerSessionInfo");
            private final Method pingDatabase = this.getMethod("pingDatabase");
            private final Method pingDatabaseInt = this.getMethod("pingDatabase", Integer.TYPE);
            private final Method getVersionNumber = this.getMethod("getVersionNumber");
            private final Method attachServerConnection = this.getMethod("attachServerConnection");
            private final Method detachServerConnection = this.getMethod("detachServerConnection", String.class);
            private final Method isDRCPEnabled = this.getMethod("isDRCPEnabled");
            private final Method isDRCPMultitagEnabled = this.getMethod("isDRCPMultitagEnabled");
            private final Method getDRCPReturnTag = this.getMethod("getDRCPReturnTag");
            private final Method getDRCPPLSQLCallbackName = this.getMethod("getDRCPPLSQLCallbackName");
            private final Method getNetworkStat = this.getMethod("getNetworkStat");

            private Method getMethod(String method, Class<?> type) {
                if (null != cls) {
                    try {
                        return cls.getMethod(method, type);
                    }
                    catch (NoSuchMethodException e) {
                        DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "getInvocationVector", "", null, e, new Object[0]);
                        return null;
                    }
                }
                return null;
            }

            private Method getMethod(String method) {
                if (null != cls) {
                    try {
                        return cls.getMethod(method, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "getInvocationVector", "", null, e, new Object[0]);
                        return null;
                    }
                }
                return null;
            }

            @Override
            public Class<?> getConnClass() {
                return cls;
            }

            @Override
            public Method getMethodAbort() {
                return this.abort;
            }

            @Override
            public Method getMethodCancel() {
                return this.cancel;
            }

            @Override
            public Method getMethodIsUsable() {
                return this.isUsable;
            }

            @Override
            public Method getMethodNetworkStat() {
                return this.getNetworkStat;
            }

            @Override
            public Method getMethodSetStatementCacheSize() {
                return this.setStatementCacheSize;
            }

            @Override
            public Method getMethodSetImplicitCachingEnabled() {
                return this.setImplicitCachingEnabled;
            }

            @Override
            public Method getMethodSetExplicitCachingEnabled() {
                return this.setExplicitCachingEnabled;
            }

            @Override
            public Method getMethodGetServerSessionInfo() {
                return this.getServerSessionInfo;
            }

            @Override
            public Method getMethodPingDatabase() {
                return this.pingDatabase;
            }

            @Override
            public Method getMethodPingDatabaseInt() {
                return this.pingDatabaseInt;
            }

            @Override
            public Method getMethodGetVersionNumber() {
                return this.getVersionNumber;
            }

            @Override
            public Method getMethodAttachServerConnection() {
                return this.attachServerConnection;
            }

            @Override
            public Method getMethodIsDRCPEnabled() {
                return this.isDRCPEnabled;
            }

            @Override
            public Method getMethodDetachServerConnection() {
                return this.detachServerConnection;
            }

            @Override
            public Method getMethodIsDRCPMultitagEnabled() {
                return this.isDRCPMultitagEnabled;
            }

            @Override
            public Method getMethodGetDRCPReturnTag() {
                return this.getDRCPReturnTag;
            }

            @Override
            public Method getDRCPPLSQLCallbackName() {
                return this.getDRCPPLSQLCallbackName;
            }
        };
        oracleConnCache.put(connClass, vector);
        return vector;
    }

    public static int getDatabaseVersion(Connection oconn) throws UniversalConnectionPoolException {
        int dbVersion = 0;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodGetVersionNumber();
            if (null != method) {
                dbVersion = ((Short)method.invoke((Object)oconn, NO_ARGS)).intValue();
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "getDatabaseVersion", "db version obtained successfully", null, null, new Object[0]);
            } else {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "getDatabaseVersion", "failed to get db version: method not found", null, null, new Object[0]);
            }
        }
        catch (Exception exc) {
            dbVersion = 0;
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "getDatabaseVersion", "", null, exc, new Object[0]);
        }
        return dbVersion;
    }

    public static boolean attachServerConnection(Connection oconn) throws SQLException {
        boolean returnValue = true;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodAttachServerConnection();
            if (null != method) {
                returnValue = (Boolean)method.invoke((Object)oconn, NO_ARGS);
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "attachServerConnection", "Invoked attachServerConnection Successfully", null, null, new Object[0]);
            } else {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "attachServerConnection", "failed to invoke attachServerConnection", null, null, new Object[0]);
            }
        }
        catch (InvocationTargetException targetException) {
            Throwable throwable = targetException.getCause();
            if (throwable != null && throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            throw new SQLException(targetException);
        }
        catch (Throwable exc) {
            throw new SQLException(exc);
        }
        return returnValue;
    }

    public static void detachServerConnection(Connection oconn, String tag) throws SQLException {
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodDetachServerConnection();
            if (null != method) {
                method.invoke((Object)oconn, tag);
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "detachServerConnection", "Invoked detachServerConnection Successfully", null, null, new Object[0]);
            } else {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "detachServerConnection", "failed to invoke detachServerConnection", null, null, new Object[0]);
            }
        }
        catch (InvocationTargetException targetException) {
            Throwable throwable = targetException.getCause();
            if (throwable != null && throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            throw new SQLException(targetException);
        }
        catch (Throwable exc) {
            throw new SQLException(exc);
        }
    }

    public static boolean isDRCPEnabled(Connection oconn) throws SQLException {
        Boolean returnValue = Boolean.FALSE;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodIsDRCPEnabled();
            if (null != method) {
                returnValue = (Boolean)method.invoke((Object)oconn, NO_ARGS);
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "isDRCPEnabled", "Invoked isDRCPEnabled Successfully", null, null, new Object[0]);
            } else {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "isDRCPEnabled", "failed to invoke isDRCPEnabled", null, null, new Object[0]);
            }
        }
        catch (Exception exc) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "isDRCPEnabled", "", null, exc, new Object[0]);
        }
        return returnValue;
    }

    static boolean isDRCPMultitagEnabled(Connection oconn) throws SQLException {
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodIsDRCPMultitagEnabled();
            if (method != null) {
                return (Boolean)method.invoke((Object)oconn, NO_ARGS);
            }
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "isDRCPMultitagEnabled", "failed to invoke isDRCPMultitagEnabled", null, null, new Object[0]);
        }
        catch (Exception exc) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "isDRCPMultitagEnabled", "", null, exc, new Object[0]);
        }
        return false;
    }

    static String getDRCPReturnTag(Connection oconn) throws SQLException {
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodGetDRCPReturnTag();
            if (method != null) {
                return (String)method.invoke((Object)oconn, NO_ARGS);
            }
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "getDRCPReturnTag", "failed to invoke getDRCPReturnTag", null, null, new Object[0]);
        }
        catch (Exception exc) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "getDRCPReturnTag", "", null, exc, new Object[0]);
        }
        return null;
    }

    static String getDRCPPLSQLCallbackName(Connection oconn) throws SQLException {
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getDRCPPLSQLCallbackName();
            if (method != null) {
                return (String)method.invoke((Object)oconn, NO_ARGS);
            }
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "getDRCPPLSQLCallbackName", "failed to invoke getDRCPPLSQLCallbackName", null, null, new Object[0]);
        }
        catch (Exception exc) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "getDRCPPLSQLCallbackName", "", null, exc, new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getInstanceNumber(Connection connection) throws SQLException {
        Properties props = FailoverablePooledConnectionHelper.getSessionInfoOnOracleConnection(connection);
        String instIdStr = props.getProperty("AUTH_SC_INSTANCE_ID");
        if (instIdStr != null && !"".equals(instIdStr)) {
            return Integer.parseInt(instIdStr);
        }
        DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "getInstanceNumber", "Failed to obtain instance number without roundtrip, doing a query", null, null, new Object[0]);
        String query = "select sys_context('userenv', 'instance') from dual";
        int instId = -1;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(query);
            rs.next();
            instId = rs.getInt(1);
        }
        catch (SQLException ea) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "getInstanceNumber", "", null, ea, new Object[0]);
            instId = -1;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return instId;
    }

    public static Date getInstanceStartTime(String timestampString) {
        if (timestampString == null) {
            return null;
        }
        StringBuffer instStartTimeString = new StringBuffer(timestampString);
        int nanosecStartIndex = instStartTimeString.indexOf(".", 18);
        instStartTimeString.delete(nanosecStartIndex, nanosecStartIndex + 10);
        instStartTimeString.insert(nanosecStartIndex + 1, "GMT");
        DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "getInstanceStartTime", "instance start time string: {0}", null, null, instStartTimeString);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        format.setLenient(false);
        Date ts = null;
        try {
            ts = format.parse(instStartTimeString.toString());
        }
        catch (ParseException pe) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "getInstanceStartTime", "Invalid instance start time, return null: {0}", null, null, instStartTimeString);
            ts = null;
        }
        return ts;
    }

    static interface InvocationVector {
        public Class<?> getConnClass();

        public Method getMethodAbort();

        public Method getMethodCancel();

        public Method getMethodIsUsable();

        public Method getMethodSetStatementCacheSize();

        public Method getMethodSetImplicitCachingEnabled();

        public Method getMethodSetExplicitCachingEnabled();

        public Method getMethodGetServerSessionInfo();

        public Method getMethodPingDatabase();

        public Method getMethodPingDatabaseInt();

        public Method getMethodGetVersionNumber();

        public Method getMethodAttachServerConnection();

        public Method getMethodDetachServerConnection();

        public Method getMethodIsDRCPEnabled();

        public Method getMethodIsDRCPMultitagEnabled();

        public Method getMethodGetDRCPReturnTag();

        public Method getDRCPPLSQLCallbackName();

        public Method getMethodNetworkStat();
    }
}

