/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.search.profile.ProfileMetric;

@PublicApi(since="3.2.0")
public class Timer
extends ProfileMetric {
    public static final String TIMING_TYPE_COUNT_SUFFIX = "_count";
    public static final String TIMING_TYPE_START_TIME_SUFFIX = "_start_time";
    private boolean doTiming;
    private long timing;
    private long count;
    private long lastCount;
    private long start;
    private long earliestTimerStartTime;

    public Timer(String name) {
        super(name);
    }

    public Timer(long timing, long count, long lastCount, long start, long earliestTimerStartTime, String name) {
        super(name);
        this.timing = timing;
        this.count = count;
        this.lastCount = lastCount;
        this.start = start;
        this.earliestTimerStartTime = earliestTimerStartTime;
    }

    long nanoTime() {
        return System.nanoTime();
    }

    public final void start() {
        assert (this.start == 0L) : "#start call misses a matching #stop call";
        boolean bl = this.doTiming = this.count - this.lastCount >= Math.min(this.lastCount >>> 8, 1024L);
        if (this.doTiming) {
            this.start = this.nanoTime();
            if (this.count == 0L) {
                this.earliestTimerStartTime = this.start;
            }
        }
        ++this.count;
    }

    public final void stop() {
        if (this.doTiming) {
            this.timing += (this.count - this.lastCount) * Math.max(this.nanoTime() - this.start, 1L);
            this.lastCount = this.count;
            this.start = 0L;
        }
    }

    public final long getCount() {
        if (this.start != 0L) {
            throw new IllegalStateException("#start call misses a matching #stop call");
        }
        return this.count;
    }

    public final long getEarliestTimerStartTime() {
        if (this.start != 0L) {
            throw new IllegalStateException("#start call misses a matching #stop call");
        }
        return this.earliestTimerStartTime;
    }

    public final long getApproximateTiming() {
        if (this.start != 0L) {
            throw new IllegalStateException("#start call misses a matching #stop call");
        }
        long timing = this.timing;
        if (this.count > this.lastCount) {
            assert (this.lastCount > 0L);
            timing += (this.count - this.lastCount) * timing / this.lastCount;
        }
        return timing;
    }

    @Override
    public Map<String, Long> toBreakdownMap() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(this.getName(), this.getApproximateTiming());
        map.put(this.getName() + TIMING_TYPE_COUNT_SUFFIX, this.getCount());
        map.put(this.getName() + TIMING_TYPE_START_TIME_SUFFIX, this.getEarliestTimerStartTime());
        return map;
    }
}

