/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.visitor;

import java.util.Iterator;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectorySnapshottableFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;

public interface NamespaceVisitor {
    default public INodeVisitor getDefaultVisitor() {
        return INodeVisitor.DEFAULT;
    }

    default public void visitFile(INodeFile file, int snapshot) {
        this.getDefaultVisitor().visit(file, snapshot);
    }

    default public void visitSymlink(INodeSymlink symlink, int snapshot) {
        this.getDefaultVisitor().visit(symlink, snapshot);
    }

    default public void visitReference(INodeReference ref, int snapshot) {
        this.getDefaultVisitor().visit(ref, snapshot);
    }

    default public void visitReferenceRecursively(INodeReference ref, int snapshot) {
        this.visitReference(ref, snapshot);
        INode referred = ref.getReferredINode();
        this.preVisitReferred(referred);
        referred.accept(this, snapshot);
        this.postVisitReferred(referred);
    }

    default public void preVisitReferred(INode referred) {
    }

    default public void postVisitReferred(INode referred) {
    }

    default public void visitDirectory(INodeDirectory dir, int snapshot) {
        this.getDefaultVisitor().visit(dir, snapshot);
    }

    default public void visitDirectoryRecursively(INodeDirectory dir, int snapshot) {
        DirectorySnapshottableFeature snapshottable;
        this.visitDirectory(dir, snapshot);
        this.visitSubs(NamespaceVisitor.getChildren(dir, snapshot));
        if (snapshot == 0x7FFFFFFE && (snapshottable = dir.getDirectorySnapshottableFeature()) != null) {
            this.visitSnapshottable(dir, snapshottable);
            this.visitSubs(NamespaceVisitor.getSnapshots(snapshottable));
        }
    }

    default public void preVisitSub(Element sub, int index, boolean isLast) {
    }

    default public void postVisitSub(Element sub, int index, boolean isLast) {
    }

    default public void visitSnapshottable(INodeDirectory dir, DirectorySnapshottableFeature snapshottable) {
    }

    default public void visitSubs(Iterable<Element> subs) {
        if (subs == null) {
            return;
        }
        int index = 0;
        Iterator<Element> i = subs.iterator();
        while (i.hasNext()) {
            Element e = i.next();
            boolean isList = !i.hasNext();
            this.preVisitSub(e, index, isList);
            e.getInode().accept(this, e.getSnapshotId());
            this.postVisitSub(e, index, isList);
            ++index;
        }
    }

    public static Iterable<Element> getChildren(INodeDirectory dir, final int snapshot) {
        final Iterator i = dir.getChildrenList(snapshot).iterator();
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new Iterator<Element>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Element next() {
                        return new Element(snapshot, (INode)i.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable<Element> getSnapshots(final DirectorySnapshottableFeature snapshottable) {
        final Iterator i = snapshottable.getDiffs().iterator();
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new Iterator<Element>(){
                    private DirectoryWithSnapshotFeature.DirectoryDiff next = this.findNext();

                    private DirectoryWithSnapshotFeature.DirectoryDiff findNext() {
                        while (i.hasNext()) {
                            DirectoryWithSnapshotFeature.DirectoryDiff diff = (DirectoryWithSnapshotFeature.DirectoryDiff)i.next();
                            if (!diff.isSnapshotRoot()) continue;
                            return diff;
                        }
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public Element next() {
                        int id = this.next.getSnapshotId();
                        Element e = new Element(id, snapshottable.getSnapshotById(id).getRoot());
                        this.next = this.findNext();
                        return e;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static class Element {
        private final int snapshotId;
        private final INode inode;

        Element(int snapshot, INode inode) {
            this.snapshotId = snapshot;
            this.inode = inode;
        }

        INode getInode() {
            return this.inode;
        }

        int getSnapshotId() {
            return this.snapshotId;
        }
    }

    public static interface INodeVisitor {
        public static final INodeVisitor DEFAULT = new INodeVisitor(){};

        default public void visit(INode iNode, int snapshot) {
        }
    }
}

