//MIT License
//
//Copyright (c) 2016 Drake Levy
//Copyright (c) 2023 szlldm
//
//Permission is hereby granted, free of charge, to any person obtaining a copy
//of this software and associated documentation files (the "Software"), to deal
//in the Software without restriction, including without limitation the rights
//to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//copies of the Software, and to permit persons to whom the Software is
//furnished to do so, subject to the following conditions:
//
//The above copyright notice and this permission notice shall be included in all
//copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//SOFTWARE.


static const int16_t fx2d_paramFeatureBias[16] = {
    121, -829, 103, -715, 24, -502, 7, -629, -1036, -229, -53, 344, 58, 90, -152, -203, 
};

static const int16_t fx2d_paramFeatureWeights[400] = {
    212, -279, 344, 267, 111, -136, 357, -122, -108, 219, 570, -52, -350, 283, -35, 216, 
    -35, -13, 155, -389, -187, 9, 177, 254, 131, 121, 589, 34, -176, -165, -216, -62, 
    465, 716, 465, -509, 216, 1158, 754, -539, 328, 415, 391, -692, -171, -216, 39, -148, 
    -251, -585, 388, 826, 130, -151, 116, -136, -133, 547, 542, 603, -27, -377, 61, -436, 
    125, 524, -246, -502, -108, -616, -351, 43, 154, 16, 717, -209, 583, 491, -96, -75, 
    334, 717, 260, 976, 587, 38, 799, -328, -696, 134, -994, -393, 870, 259, 18, -405, 
    -860, 483, 541, -288, 586, 1465, -1412, -806, 600, -80, 342, 735, 712, -728, -248, 714, 
    -2652, 1478, -311, 1125, 1484, 374, -1396, 408, 1031, -2543, -179, 919, -1139, 90, 1497, 482, 
    -261, 31, -842, 426, -80, 801, 1078, -280, 61, -210, 529, -1438, -662, -365, 562, 1084, 
    -116, -332, 265, 352, 351, 127, -140, 324, -322, -314, 853, 300, -354, -586, 223, -333, 
    -245, 569, 455, 824, -843, -663, 955, -552, 119, 374, -1114, 686, -855, 357, -128, 3, 
    -287, -37, -657, 1908, 654, 985, 744, 871, -122, -761, 347, 2102, 3206, 924, -2968, -1749, 
    3645, 1265, -1103, 2131, -1176, 2297, -2638, 3381, 1610, 2882, -797, 1617, -2103, 3804, 3521, 1658, 
    -406, -985, 2596, 887, 288, -665, -861, 1253, 1547, 2112, -830, -2115, -713, -1913, -559, 1579, 
    -117, -466, -246, -339, -449, -54, -315, 272, 198, -59, 280, 373, 1072, 758, 381, -978, 
    -4, -780, -171, 163, -169, -876, -60, 485, -306, -387, 582, 110, -471, -507, 231, 298, 
    493, 404, -1465, -460, 208, 42, 1344, 251, 1574, -392, -530, 182, 459, -983, 16, 92, 
    2066, -305, 790, 442, 731, -1219, 2347, 2356, 493, -236, 62, -1770, 359, -600, -2125, -644, 
    -1160, -188, 522, -968, -685, -477, -451, 1168, 697, -641, -93, -990, -284, -1252, 1252, -845, 
    563, -162, -423, 537, 253, -415, -218, -387, -41, -54, -73, -608, 460, 249, -444, 108, 
    -269, 615, 68, 115, -336, 78, 288, -63, -112, 152, -303, 242, -94, 423, -189, -96, 
    204, -156, 77, -250, 335, 1100, -871, -384, -734, -307, -257, -917, 178, -400, -218, -452, 
    -951, 183, -1774, -58, -1504, -818, -197, 416, 199, -190, -437, 446, -988, 550, -376, 815, 
    -227, -233, 372, 40, 143, -300, 260, 484, -584, -441, -275, -302, -369, -193, -25, 56, 
    -340, 189, -285, -269, -655, -102, -34, 259, -14, 113, 112, 200, 367, 266, 307, -101, 
};

static const int16_t fx2d_paramModel1Bias[16] = {
    441, 170, 209, 126, 41, -188, -274, -614, 419, 295, -152, 420, -3831, 489, -1142, -388, 
};

static const int16_t fx2d_paramModel1Weights[2304] = {
    772, 731, 1395, 429, 1371, -446, -982, -347, 422, -489, 2268, 2925, -1641, -1066, 924, 796, 
    -521, 340, -493, -1223, 219, 1057, -898, -50, -887, -2035, -404, -1235, -52, 229, 458, -701, 
    474, 2317, -1103, 262, -572, 957, 1147, 318, 309, 308, 971, 723, 17, -711, 28, -134, 
    232, 1337, 1266, -1143, -564, -604, -978, 521, 1226, -1676, -1631, 1627, 769, 698, 527, 144, 
    415, 1871, 2460, 590, 1754, -1101, 1267, 509, -446, -181, 3910, -116, -792, 138, 467, -1428, 
    -393, -1377, -355, 581, -1743, 549, -384, 692, 296, 2290, -737, 632, -774, 270, -1064, -206, 
    1475, -524, 1992, 301, -364, -565, 479, -1072, -43, -893, -744, -765, -708, 1124, 334, 578, 
    -1398, 155, -970, 818, -846, 1164, -548, 323, -691, 1360, -4237, 1683, -539, 1041, 1471, 44, 
    1636, 586, -163, -1718, 1136, -516, -469, 1418, -262, 503, 8, 789, 755, -1116, -1023, -360, 
    957, -1028, -721, 1361, -1882, 53, -439, -1756, 1878, 1426, 3, -565, 1090, 822, -692, 101, 
    1498, 472, 178, -73, -510, -902, -589, -1124, -1625, -1060, -534, -523, -859, 126, 293, -2545, 
    997, 854, -1009, -896, -365, -537, 487, -1346, -47, -2432, -75, 1183, 228, 436, -654, 1295, 
    597, -338, -741, -719, -411, -1115, -1176, -2904, 973, 700, -1288, 1323, -323, 460, 1624, 830, 
    841, -499, 426, 526, 819, -971, -474, -1274, -496, -1746, 851, 1721, 1152, 424, 18, -2592, 
    804, -860, -1984, 241, -2001, 1813, 1737, -666, 369, -2806, -841, -415, 583, 1080, 500, -223, 
    839, 641, 1128, -2095, -705, 846, -531, 1070, -606, -147, -67, 1431, -1118, -759, 118, 1234, 
    -1117, -750, 256, -306, -1527, 1041, 131, -1860, -1023, 39, 874, 319, 38, 979, 88, 985, 
    1699, -415, 1024, 985, -479, -819, 1631, -1592, -1482, 362, -1538, -446, -395, -894, -1275, 525, 
    620, 141, 1049, 1458, 1590, 741, 1049, -61, -66, 1665, 1044, 1058, -1351, 177, -1303, 881, 
    1778, 2, 887, 664, -191, 810, -557, 1797, -1725, -201, -204, -1645, -545, -709, -1530, -1161, 
    492, -1670, 2639, 1566, 879, 317, -1662, -1019, -482, 1245, 1260, 2636, -167, -254, -658, 975, 
    -423, 1792, 1295, -244, 1285, -569, -128, -1202, -2722, -1040, 1453, 576, 917, 22, -6, -622, 
    2392, 131, 608, -933, -1206, 480, -2419, 280, 899, -2506, -160, -1790, 710, 640, 719, -174, 
    -50, 2287, -1134, -592, 384, 518, 1130, 702, 984, -4701, -1214, 887, 478, -496, 186, -1288, 
    -1502, -819, 92, 295, -2744, 839, 244, 1317, 1365, -24, 1780, -1020, -1248, 1104, -1189, -50, 
    998, -117, -1437, 1606, 3084, -524, -1443, 2190, -2959, 748, -694, -342, -474, -216, -1087, -2847, 
    -44, -198, -1783, 640, -1342, -7, 325, 2264, -1198, -1679, 1133, -567, -1172, 396, -1769, 236, 
    -319, -1182, 364, -87, 632, 737, -749, -598, 768, -1327, -1238, 311, -2164, 993, -572, 626, 
    344, -876, 3504, -114, -1331, 1177, -468, -225, -484, -193, 164, -282, -480, -71, -235, 331, 
    -2355, -334, 491, -1973, -1653, -2333, -653, -593, 1119, 84, -1626, 1301, 2421, 614, 154, 1242, 
    211, -1768, -85, 1039, 653, -331, -529, -1563, 261, -1301, 1689, -220, 583, 422, 500, 1230, 
    77, -1160, 33, 583, -228, 1046, -152, 811, -197, 1604, -280, -166, 1075, 596, -934, 570, 
    16, 1867, -151, 626, 46, -556, -596, -72, 1277, -588, -2679, -98, -1298, -222, -1017, -898, 
    1306, -1203, 386, -197, -411, 179, 184, -802, 1327, 1174, -1121, -1609, -189, -453, -897, -1010, 
    618, 423, -717, 495, -620, -961, 643, -550, -669, -293, -356, -124, -338, -100, -1181, -611, 
    -857, 138, 464, -745, 1481, 1291, -659, -546, -229, 2745, 517, -76, -507, 247, -213, 49, 
    1428, -1460, 748, -203, 1350, 347, -306, -803, -295, 1359, -1426, 811, 739, -189, -1990, -519, 
    1641, 165, 42, -12, 569, -459, 1104, 986, -1829, -637, -909, -30, -1331, -823, 336, -150, 
    -140, -661, 2671, -497, 824, 3258, 2471, 615, 2460, 899, -415, 3245, 236, -721, 221, 194, 
    -118, 1905, -50, 923, 103, 1917, 1577, 1689, 405, -1417, -1484, -4927, 281, -225, 905, -1622, 
    -811, -463, 2262, 714, 313, -598, 1372, 237, 96, 1004, 1540, 1423, 1339, -1813, -206, 172, 
    -233, 389, -323, 736, -1690, -787, 666, -385, 1281, -170, 35, 1754, -1277, 14, -955, 78, 
    -217, 833, 527, -435, 20, 117, -1613, -1326, -87, 154, 800, 203, -336, 180, -784, 739, 
    250, -1664, -662, -571, -572, 42, 2047, -798, -632, -590, -4580, -2065, -134, 610, 1799, -1914, 
    -203, 365, 1191, 905, -618, -828, -1404, -398, 842, -312, 1135, 1652, -748, 1341, -12, 1143, 
    -209, 44, -1913, 1404, 1130, -110, -500, -2285, 2615, 1171, 1289, -742, -2183, -450, -408, 12, 
    189, 2372, 2477, 1702, -533, 178, -633, -232, 1749, 354, -843, 175, -72, -960, 188, -1711, 
    827, 1005, 1387, -1605, 171, 982, -139, -119, -686, -733, -454, 1251, -1369, 106, -1520, 334, 
    -1728, -288, 1403, -921, -598, 1364, 1882, 1614, 1019, -227, -584, -1754, -126, 1549, -1054, 180, 
    1672, -650, -1298, 155, 689, -418, 641, -1454, 1101, 978, 519, -1291, 1136, -84, 1007, 528, 
    2650, -30, 621, -414, -390, -608, -551, -704, 1643, 431, 149, 1041, 295, -439, -1713, 1555, 
    -250, -629, 502, 893, -402, 532, -3186, 2353, -86, -593, -205, 200, -85, 164, -118, -1033, 
    -359, -1332, -1010, -1512, -1511, 380, 2679, 339, -517, -365, -868, -136, -533, -1913, -841, 310, 
    -3996, 1661, -1055, -929, 743, -739, -101, 103, -866, -1225, 1530, -290, 483, 1216, 676, 9, 
    -1568, 2475, 659, 167, 177, -2250, -2258, 1242, -1467, -1020, 1319, -1412, -950, 430, 461, -303, 
    342, 1345, -3108, 1214, 103, 758, -1265, -613, 556, 1538, 70, 689, -85, -1144, 651, 292, 
    -1273, -1437, -453, -402, -12, -782, 391, -2766, 307, -699, -307, -1428, -1554, -292, 2564, 1172, 
    -1266, -764, -912, -262, 198, -1600, 1239, 327, -1403, -1352, -932, 2099, 3417, 398, 95, 386, 
    261, -326, 1621, -1528, 882, 471, 1265, -619, -192, 415, -1045, 372, 1062, 559, -26, 1968, 
    945, 1131, 816, -1112, 1890, -1373, -79, -1712, -17, 1391, -850, -273, 178, 196, -880, 258, 
    -351, -1812, -506, -283, -1391, -1599, 1086, 2395, -1769, 1615, 1595, -229, -1628, 331, 2660, -2279, 
    -143, -711, -1320, -947, 463, -3793, 560, -407, 1870, -1328, 601, -2049, 302, 784, -1266, 772, 
    724, -1004, -425, -1170, -68, -2870, 85, -71, -977, 201, -3205, 1383, -254, -1796, -783, -1980, 
    -961, -929, 981, 2259, 744, 889, -731, 336, -32, 1535, 934, -196, 637, -2452, -200, -1034, 
    3653, -1737, -2931, -1866, 264, 246, -1778, -258, -1003, 1727, -466, 2948, 293, -348, -1541, 835, 
    -236, 1659, 1828, 1160, -1852, 1038, -85, 1083, -355, 582, -3374, -1235, -744, 510, 1954, 663, 
    1179, 3617, 978, -683, 1058, 662, -2291, 756, 2932, -1775, 1217, 1008, 1980, 1592, -2819, 685, 
    1312, -840, 458, -531, 3716, -1179, 298, -698, -163, 1086, -750, -963, 196, -1322, -818, -1647, 
    -1261, 3371, -2307, 1234, -207, -327, -76, -3498, -2256, 1283, -362, 2910, 2610, 494, -2008, -1975, 
    2676, -146, -1641, 938, 514, 1699, 1704, 105, 6017, -1470, 654, -3614, 334, 927, 2404, 512, 
    115, -763, -2640, 3092, 2045, 1081, -3883, 2438, -5147, 3674, 1294, 1865, 1601, 346, 1025, -925, 
    1209, 1961, -1881, 35, 850, 1206, 27, -1845, -331, -141, -1868, 3267, 3294, 1317, 1370, -3185, 
    1605, -2190, -1143, 1185, 4354, 652, -1207, -1912, -97, -109, 1184, -804, -3931, -753, 1531, -2008, 
    262, 1424, 1531, 1154, -1178, 3024, -1068, 2152, 1435, -423, -682, 493, -2251, 1613, 2607, -64, 
    591, 1042, -1863, -28, 3690, 2994, 513, -3032, 287, -2697, 1982, 949, 1117, -2761, -3760, -891, 
    179, 2189, -98, -2225, 1035, 3401, 597, -3059, -743, 552, -1189, -91, 998, -3706, -1350, 61, 
    -711, 281, 1637, 1593, 3045, -1614, -554, -1969, 1269, -847, 1700, -6090, 1063, -2516, -2090, -847, 
    3579, -1924, 1620, -1375, -1625, 2789, 3432, 258, -5377, 3090, -169, 3934, -983, 417, -833, 1104, 
    -349, -658, -559, 1247, 2780, 121, -2016, -1113, 2559, 275, -1048, -2000, 566, -53, 258, -1700, 
    -1036, 656, -1109, 2800, -361, -2983, -897, -1966, 3184, -263, 1429, -2060, 3911, 1382, -929, -721, 
    1565, -372, -1643, 1885, -1047, 2188, -1498, 1575, -524, 776, 1063, -94, -600, -369, -450, 929, 
    576, 1723, 127, -2304, 88, -883, -441, 1650, -98, 2663, 835, 1224, -635, 2025, -1133, 1415, 
    -289, 1420, -1959, -1627, 252, 1228, -791, 500, 538, -3060, -923, 664, 1825, 516, -893, 1587, 
    -1099, 787, 143, -1078, 1760, -346, 869, -36, -161, 338, -172, 1258, 16, -616, 446, 669, 
    -1123, -14, 3, 914, 448, -0, 2017, -932, 1482, 621, -4368, 3173, 223, -1698, 904, 336, 
    -2790, 903, 282, 438, -927, -914, -296, 2317, 1255, 1364, 1225, -1512, -707, 1540, -1792, -800, 
    -585, 920, -444, 860, 1838, -1766, 231, -158, 95, 242, -330, -130, -264, 379, 653, -37, 
    1671, 260, -1173, -17, 640, -664, 640, -187, -47, 1446, 1088, 952, 361, -783, 51, -2247, 
    1476, 1008, -1607, 1028, -726, -220, 1919, -366, -468, 215, 2032, -984, -338, 1585, 1361, 1882, 
    2047, 515, 616, 381, -2793, 2341, 572, -1581, 96, -1305, -364, -1230, -523, 1884, 2271, 805, 
    -1430, -892, 255, 1472, -408, -2653, -1061, -1623, 2169, -407, 1098, 892, 2588, 614, -1694, 2413, 
    178, -346, -252, -809, -711, 202, -41, 1927, 608, 2212, -1779, 176, 722, -2614, 2835, -2555, 
    835, 392, 1070, 2844, 559, 584, 999, 1591, -1447, 487, 2086, 661, 555, -343, 84, 1558, 
    -4145, -1074, 302, 1443, -2101, 2521, -909, 888, 2323, -1349, -1028, -1907, -807, 300, -841, -270, 
    452, 649, -192, -1751, 1807, -1465, -385, 154, -1510, -1725, -1612, 2114, 278, -568, -484, 2740, 
    1687, 1026, -61, -567, 1480, 23, 197, -628, -1766, 960, -406, -1387, -1855, 1060, -81, -306, 
    -1165, -172, 1281, 523, -290, -376, -29, 1793, -641, 1477, -3096, 455, -1698, 1092, -260, 261, 
    -2753, 1839, -318, 941, 797, -774, -187, 246, 2794, 552, -874, 377, -1160, 589, 1423, -1196, 
    -585, -1077, 37, -315, 1836, -266, 1769, 859, -877, -133, -469, -1511, 231, -1035, -2144, 720, 
    -1218, -724, -1628, -769, 795, -161, -1612, 1319, -629, 1330, 2665, -73, -967, -1538, -150, 154, 
    -234, 1359, 11, 410, 1165, 551, 863, 198, -220, -1973, 565, -290, -1455, 192, 620, 121, 
    1105, -178, -202, -303, -1802, -2117, -764, -1908, -3265, -656, -412, -1552, 129, 53, -703, 601, 
    -901, -639, 1617, -550, 1153, 1166, 1340, -236, 2686, -887, 2109, 921, -981, -204, 5, -1350, 
    -902, -480, 1810, -58, 1726, 527, -753, 286, 1549, -876, 85, 971, -893, -77, 15, 145, 
    -445, 1571, 159, -353, -1666, 391, 56, -559, 1614, -615, -2125, -1127, -63, 1044, 709, 387, 
    853, 425, -530, -304, 193, 1194, -570, 962, -1945, -1574, 1019, 154, 494, -904, 336, 976, 
    1250, 391, -330, -564, -609, -1147, -2227, 2560, 1406, -1315, -1018, 657, -731, 610, -881, -1813, 
    1412, 1026, 106, -79, 587, -290, 1284, 1350, -164, -788, 3363, -1676, -614, 1468, -412, 1142, 
    523, -267, -1289, -448, 191, -586, 1333, -456, 172, -153, 2545, -43, 1628, -781, 2154, -58, 
    582, 1527, 876, -515, -670, -1870, -600, -1647, 161, -762, -1815, -816, 161, -1702, -2249, -1652, 
    -1109, -534, -2856, 425, 1543, -17, 1506, 1646, 939, -331, -21, -869, -81, 810, 296, 637, 
    -467, -803, 1057, -1676, 691, 1037, 292, -46, -189, -2302, 787, -242, 326, -678, 2466, 1118, 
    -345, 2124, -760, 2522, 1721, -527, -755, 267, -2167, 1453, -980, -3465, 2057, 305, -2078, 1852, 
    276, 135, -504, -686, 439, -1784, 1948, -525, -1510, 1134, -134, 799, 340, -1406, -747, 2416, 
    -5977, -824, -244, -2737, 1624, -1661, -1618, -1638, 774, -502, 678, -215, -1006, -2809, 786, 1054, 
    -2309, 975, -181, 358, 2209, -509, 988, -1167, 1005, -1162, 597, -34, 786, -917, -124, -1203, 
    170, -1801, -575, -2647, -179, 1112, 1904, -253, -484, -1343, -1281, -1183, 503, 493, -235, -293, 
    -777, -950, 1194, 680, -471, -658, 1563, 661, -1752, -792, -1653, 1319, -331, -1725, 688, -1543, 
    2015, -91, -798, 346, 2254, 556, -2432, 1084, 312, 2636, -616, 376, -3325, 206, -189, -921, 
    -174, -1731, 3383, -2123, 686, 1868, -136, 261, 370, 1348, -752, -2796, -1140, 959, 1482, 1123, 
    -17, 1329, 327, -360, -675, 81, -3475, 955, -1631, -1135, -2947, -1715, 587, 626, 1597, -327, 
    -207, 271, 701, -504, 2419, -158, -650, -581, -233, 325, -624, -75, 92, -703, 1819, -388, 
    -2203, -1957, 1587, -510, -2340, 722, -1063, -582, 2475, 726, 425, 1837, 1268, -1213, 1114, 81, 
    1938, 761, 81, -578, -216, 2763, -2188, 1581, 1025, 964, 3191, 72, -822, 359, 581, 1434, 
    -1218, -3297, 1341, -724, 1040, 1745, 186, 247, 1681, -424, 1202, 785, 363, 965, 462, 2582, 
    -603, 1301, 431, 689, 2445, -104, 863, -864, -1864, 267, -1114, -355, 2848, 49, 392, 178, 
    1183, -1743, -1168, -1554, -2162, -1043, -734, -358, 1319, -831, 2221, -268, -266, 750, 654, -1268, 
    -1224, -350, 1026, -312, 494, 393, 1027, -282, 1829, 34, 1427, 1100, 379, 2063, 1175, -1789, 
    -1888, -589, -553, -2755, -971, -923, 1244, -211, 436, -548, -230, 1260, -251, 2089, -1185, -320, 
    -1393, 1249, 46, -160, 1238, 1356, 1514, -1295, -1446, -479, -607, 973, 758, 1329, -1284, -548, 
    -1970, -692, -1957, -1016, 1158, 3104, 99, 400, -1079, -2182, -202, -67, -1457, 124, -406, -641, 
    -143, 1176, 1400, 248, 1119, -382, -2118, -213, 731, 1341, -89, -1975, -601, -2329, 738, 1335, 
    471, 1781, -759, -1323, 402, 252, -1362, 804, 176, 405, -1254, -1685, -185, 341, -96, -239, 
    1099, -1410, 1134, -2511, 71, -1520, 142, -785, 2012, 1571, -1670, -997, -444, -2283, 765, 501, 
    1258, -969, -1267, 367, -722, -339, 669, 1757, -3791, 408, -246, 54, -128, -1409, -398, -1117, 
    -1507, -2579, 3757, -856, 306, -684, 1074, -926, -388, 677, 2714, -1985, -1129, -549, -1277, -1397, 
    145, -1044, 1172, -977, -577, -579, 2438, 386, -60, 1471, -20, 805, -1128, -268, -592, -560, 
    -369, -496, -307, -292, -778, 1906, 463, 459, -586, -837, -22, 807, -903, -399, -1140, 1025, 
    18, -1065, -48, 237, -16, -472, -1508, -106, 1265, 2404, 87, -344, -1704, -2606, 1326, -521, 
    963, 465, 1218, 196, 379, -159, 1098, 2602, -427, 1639, 2085, 353, -1243, -19, 1590, 703, 
    -2139, 1300, -773, 199, -1013, 1036, -1417, -2027, 146, -348, 1349, -2081, -961, -644, -205, 493, 
    1676, 1025, -373, -348, -213, 654, -1499, -1890, -1518, -682, -331, -351, -1226, -1298, 1625, -367, 
    -2717, 479, 2016, -316, -1250, 584, 465, -1150, 1050, 1306, 2249, 83, 379, -1239, -0, -217, 
    -152, -2261, -983, -427, -1613, -1443, -357, 387, -621, 1603, -1061, 330, -746, -1096, 2435, 296, 
};

static const int16_t fx2d_paramModel1Alpha[16] = {
    3760, -140, 909, 5772, -1779, 8396, 6022, 1842, 1089, 4051, -234, 4117, -150, -49, -2678, 1231, 
};

static const int16_t fx2d_paramModel2Bias[16] = {
    238, -38, 301, 203, -66, -689, -283, -38, -25, 633, -154, -582, 27, -56, -138, 460, 
};

static const int16_t fx2d_paramModel2Weights[2304] = {
    118, -156, -212, 1076, 2574, -57, -529, -700, 1158, 1411, -687, 981, -2762, -1143, -32, 2340, 
    -422, -160, -454, 521, 1114, -1150, -1309, 486, -334, -2517, -949, -474, -1137, -356, 124, 232, 
    517, -128, -332, -277, -232, 2107, 1391, -715, 326, 2532, -2568, -977, 2230, -137, -1145, -449, 
    1344, 257, 583, -243, -1231, -875, -313, 76, -1251, -459, 319, 1100, -2540, -567, -143, -932, 
    57, 1494, 425, -1353, -309, 1424, -600, 560, 901, -16, -436, 726, 97, 327, 44, -1778, 
    -122, -9, 357, -490, -419, -300, 373, 711, 392, 701, 188, -318, -416, 870, 982, 695, 
    -1080, -411, 1058, -833, 829, 378, 1472, 884, -668, 761, -348, 940, -1501, -338, -56, -656, 
    132, 1526, 1629, -184, -1267, -538, 1127, 84, 1789, -476, -485, 982, 4189, 279, -429, -414, 
    -375, -478, 87, -449, 2200, 396, -1681, -147, -1169, -1826, 29, -552, -446, -1670, -17, -964, 
    -57, -1006, 207, -310, 1202, -949, -875, 514, -1990, -336, -956, 1448, -1099, 385, 449, 1384, 
    719, -879, -1803, -31, -648, 619, 388, -634, -82, -2848, 559, 1215, 679, 1273, 1534, 1300, 
    282, 871, 660, 324, -1013, -191, 1010, -1855, -2425, -878, -1502, -648, 1505, 683, 1008, 316, 
    -1119, -258, 1082, 2069, -1193, -21, -671, -120, -1408, -966, -682, -403, 1032, -819, 461, 356, 
    -672, 328, -804, -821, -1057, 302, -895, 60, -765, 124, -158, 312, -502, 961, 1076, -755, 
    -1564, -1557, 66, 322, 463, -113, 1156, -1259, 1011, 840, -137, -412, -493, 1730, -820, -1127, 
    -543, -671, -1614, 976, -709, -2708, 440, -603, 1814, -111, 1096, -6, 317, 2350, -168, -644, 
    -3747, 838, -96, 26, 525, -2239, 60, -3589, 1644, -669, -100, -784, 242, -734, -1519, -6289, 
    81, 256, -1501, 873, -330, -772, -876, -941, 654, -415, -3821, -936, 1252, 1513, -287, -608, 
    796, 156, 529, 140, -341, 1559, 650, 585, -329, 1375, 239, 430, -852, -85, -1143, -331, 
    -4516, -354, -61, 491, -560, -1230, 896, -1319, -1578, 570, 1528, -216, 2309, 1095, -1133, -241, 
    1128, 2938, 450, -1732, -1353, 719, -3051, 3304, 1410, -2081, 840, 470, -2171, 816, -264, -545, 
    903, -880, -534, 573, -622, 1199, -808, 190, 171, -790, -344, 521, -2854, 1017, -253, 598, 
    -1256, -554, 1424, 110, 429, 859, -1364, 718, 578, -2180, 2333, -1074, 758, 906, 768, -635, 
    -1734, -1610, 171, -1203, -318, 81, -79, 98, 86, -96, 770, -704, 703, -394, 2355, -155, 
    -1828, 719, -595, -1805, -450, 2141, -539, 2324, -1881, 1183, -1424, -337, 1813, -1206, -658, 666, 
    2126, 955, -1840, -407, -858, 1421, -535, -76, 1300, 1344, 161, -886, 63, 334, -1058, 1245, 
    -3738, -1421, 2804, -1577, 269, -1960, -988, -1931, 1861, -435, 396, 871, 164, 1248, 866, -1800, 
    -291, 835, -1964, -1088, -2114, -768, 297, -333, 2197, -2187, -2601, -149, 20, 541, 87, 1567, 
    1800, -300, 312, -59, 828, 1598, 7, -98, -736, -122, 160, -215, 1254, 506, 87, 1103, 
    843, 541, 993, 1554, 2, 209, -869, 164, 51, 192, 1259, -397, -102, 1274, 1071, 488, 
    -401, -2361, 426, -2738, 1456, 722, -1096, -563, -179, 1124, -477, 824, -633, 1153, 683, -558, 
    -1020, 742, 2119, -1590, -295, -1155, -283, -130, -1723, -262, -824, 292, 802, 1501, -36, 122, 
    1448, -410, 2108, -652, 683, 664, -448, -241, 71, -358, -228, -639, 644, 853, 1068, -635, 
    1044, -505, -9, 153, -424, -1208, -1134, -936, -1311, -37, 441, -811, 503, -53, 600, 964, 
    -304, 388, -1346, -849, 1477, 1592, -1572, 863, -1305, 2327, -711, 1339, -1292, 705, 2085, -150, 
    2547, 453, -595, 85, 700, -292, 1196, -1554, 258, 943, 343, 915, 508, -509, -605, 572, 
    -1458, 1890, -402, -914, 339, -108, -1367, -2167, -818, 612, 687, 996, 2978, -1454, 194, 477, 
    556, 401, -317, -72, -1047, 841, 1960, -1182, -919, 107, 110, 368, 11, 1237, 711, -279, 
    -918, 986, -1434, -772, -1506, 32, -637, -425, 421, -1211, -1636, -26, 2056, 931, 728, -686, 
    -679, 1226, 786, -1647, -138, -112, 825, -59, -715, -294, 234, 101, -446, -2371, -1207, 69, 
    482, -160, -120, 1442, -155, 1189, -800, -274, 892, -2160, -399, -1502, 242, -791, 455, 342, 
    1135, -103, -204, 853, -83, -1453, -813, -719, -788, -1147, 368, -176, -654, -11, 1635, -81, 
    -563, -222, -544, 944, -1091, 605, -434, 319, 86, -881, -369, 1508, 327, -364, -1279, -88, 
    -1620, -82, -954, -538, 167, -242, -410, -1603, 26, 86, 867, 888, 402, 127, 1213, 1313, 
    -978, 1456, 249, -293, 499, -1729, -630, -422, -86, -91, -615, -514, -386, -43, -121, -101, 
    -1077, 724, -1498, -172, -414, -1330, -121, 371, -204, -73, -833, 147, -330, -469, -547, 326, 
    507, -711, 277, -609, 876, 427, 65, 21, 1369, -470, -528, -307, 1728, -1101, 3183, 520, 
    1571, 365, 1007, -1094, 279, -803, -317, -72, -211, -1024, -399, 34, -145, -700, 1068, 313, 
    -270, 615, 845, -2372, -81, 211, 1048, -1567, -1191, 1373, -119, -1193, 837, -333, 123, -3856, 
    -664, 321, 525, 199, 1447, -1613, 1855, -331, 1959, -938, -2252, -469, 687, 604, 190, -72, 
    411, -984, 713, 494, -244, 824, 1996, -1431, -1344, 1730, -1602, -843, 539, 534, -282, 2281, 
    -2677, -481, -617, -588, -777, 1950, -1101, 1349, -1821, 406, -909, -1627, 686, -1310, 573, -1103, 
    -838, 1067, 165, -790, 560, -450, 1300, 1298, -589, -948, -1147, -327, 174, -976, 270, 3466, 
    -253, 660, 549, -1016, 1323, -325, -61, 1042, -555, -1135, -616, -1069, 560, -1241, 23, 906, 
    -2573, 1579, 710, -638, 1400, -632, 1956, -224, -221, -1083, 143, -1637, -783, -255, 326, 1122, 
    -72, 761, 984, -483, 608, -2364, -1570, -1429, 2779, -521, -597, 492, -513, 756, -1716, 553, 
    -549, -1715, -544, 1605, 254, 62, 1345, 159, -1472, -489, 217, 976, -3131, 2768, -875, 2366, 
    -2534, -1578, -116, 1845, -1460, -3347, 721, -915, 2651, -658, 1546, -316, 1473, -438, -1062, -637, 
    -536, -1456, -523, 144, -1238, -565, 723, -304, -1509, -1583, 360, -892, 1604, -74, -659, -1971, 
    -390, -5398, 1840, 174, -2625, -621, -588, 615, -2844, -129, -339, -263, 936, -1317, -520, -749, 
    -1911, -233, -2477, -2454, -1896, 175, -683, 698, -1888, -1015, -859, -158, 1818, 1676, -2928, 115, 
    1686, 31, -276, 4, 180, 750, 3066, -842, -621, 511, 889, -396, 315, -3030, 1045, -954, 
    -580, 993, 982, 1847, -3002, 123, 1235, 540, -373, 663, -170, 251, -775, 4390, -1529, -699, 
    -627, 862, -1295, 1016, -939, -2437, -945, -414, -94, 863, -683, -13, 368, 715, 46, -622, 
    -1793, -3277, 3210, -1064, 881, -1117, 1500, 2095, 1858, 2223, -2419, 2397, 349, 933, 1319, 7831, 
    3188, 2688, 1072, -1480, -3411, -248, 911, 659, -41, -1414, -1827, -384, -1581, 434, 1928, -762, 
    -57, -1804, 2026, 1986, 556, -329, 1054, -708, -1107, 2153, -1778, -1421, -395, -804, 345, -604, 
    -952, -1540, 1206, 1849, 1097, -542, 580, 168, 2099, 1788, -830, -426, 3961, 951, -1698, -912, 
    610, 1821, 411, -1837, -1266, -1936, -1002, -5086, 120, -1652, 1066, -1990, -1845, 941, -2182, 723, 
    -733, 1103, 782, 1563, 2584, -162, 288, 1949, 1340, -2051, 3001, 3108, 1392, -1283, -1612, -493, 
    -3653, 1901, -1769, 841, -737, -828, 925, -1158, 1742, -1134, 3164, 1480, -2226, -96, 77, -690, 
    -1459, -325, 1267, -280, 877, 341, 208, 1325, -2839, -987, -360, 534, -2240, 960, 2597, -619, 
    -2748, 456, -719, -592, -2529, -1195, 3288, -3138, 1625, 580, 451, -1228, -1488, 4218, 2906, -1492, 
    1034, 1626, 1368, 2909, 759, 3158, 1498, -1505, -1982, 1236, 2240, -1258, -1443, -72, -428, 1914, 
    -582, -2168, 2680, -95, 916, -999, 2151, 800, -173, 1859, -2590, 261, -810, 1061, -2378, -205, 
    -1290, -8596, 1298, -1261, 1816, -507, 879, 889, -1690, 1827, -2314, -1542, 446, -291, -1396, 107, 
    -616, -4619, -1417, -921, -1822, 577, 167, 288, -2334, -343, 359, -538, 4191, -461, -676, 2093, 
    -574, -1026, 1319, -80, 159, 3477, 751, -800, 875, 855, 718, -556, -865, 1740, -2101, -3437, 
    441, 1887, -1710, -976, 880, 2306, -3659, 1417, -661, 798, 338, 765, -1689, 3042, -2270, -601, 
    218, 1893, 2637, -1073, 964, -470, -1517, -309, -2080, -1134, -15, -884, 3968, 604, 900, -851, 
    1642, 1342, -1541, 1230, 1739, -1427, -785, 2162, -600, 1031, -564, 148, -1271, -4508, -883, 2939, 
    -230, 1238, 530, 981, -458, 1123, -214, -291, -99, -1229, 603, -577, -27, -1330, -956, 356, 
    -1919, 1763, -8125, 587, 1091, 381, 128, 557, 1629, 2148, 994, 601, 553, -1625, 3665, 32, 
    900, 359, -136, -287, -363, -862, -95, 1558, -364, 615, -1682, 190, -1189, 711, -895, 1457, 
    -840, 96, 297, -2861, -1041, 3032, 1165, 1681, 365, 1857, -77, -2208, 269, 542, 402, -503, 
    329, 85, -71, -50, 1174, -267, -684, -76, 465, -157, 418, 1342, -80, 662, -1830, 1013, 
    352, -1532, 2802, 131, -1419, 544, -3762, 1373, -1454, -321, -169, -1462, -489, -965, -1924, -1043, 
    -294, -2708, 1198, -2262, 821, 967, 929, 108, 868, -1022, -404, 715, -1704, 494, 1962, -1108, 
    207, -510, -946, 78, 1870, -1505, 1719, 1987, 1697, -347, 996, -1812, 2076, -2165, -1368, -223, 
    -407, 3327, -668, 831, -442, -146, -438, -1114, -2224, -141, 406, -2326, 60, -2424, 422, -993, 
    -368, 1292, -1847, -2186, 868, 294, -525, 385, -324, 642, 361, -1357, 469, -446, 1828, 186, 
    943, -1745, -917, -1005, -783, 2032, -91, 1075, 1251, -183, 606, -395, -659, -319, -512, 445, 
    -3099, -1813, 464, 876, -1580, 215, 934, -473, 466, 107, -790, 375, 279, -2086, 1045, 1653, 
    -391, -1883, 364, -355, -986, -2167, 234, -1290, 43, 403, 441, 87, -1643, -239, 729, 809, 
    283, -977, -121, -187, -584, -1269, 927, 2260, 963, 142, -1040, -305, -327, 541, 2863, -71, 
    296, 243, 1434, -1245, 133, -1096, -930, 307, 778, 299, -776, 380, 864, 1228, 785, -287, 
    98, -136, -291, 988, -1601, -1102, -2221, 1993, -700, -613, 564, 720, 760, -392, -467, 1568, 
    981, -390, 227, -107, -1056, 243, 80, 715, 2462, -357, -582, -167, -453, -306, 1866, -706, 
    -275, 58, -8, -316, -766, 94, 627, -94, -770, 39, 481, -1225, -785, 1826, -1119, 1416, 
    275, 351, 417, 311, -146, 1017, 888, 29, -976, -2685, -291, -1842, -1159, 525, 1426, 315, 
    269, 992, 495, -1378, -984, 1840, -1077, -826, -1257, -988, -1755, -109, -1174, 1856, 272, -1715, 
    455, -740, 1035, -122, -763, -586, 1187, -298, -994, 580, -224, -305, -220, -550, 489, -1247, 
    -443, -421, 1722, 819, -471, 21, -401, -386, -1221, 356, -1007, -757, -111, -1662, -425, -960, 
    6, -1616, 24, 618, -441, 1710, 252, 978, -1334, 18, 1573, 1058, -1019, -1098, -1275, 1012, 
    -37, -214, 1202, 105, -675, -1399, -1302, -240, -977, -501, 589, 364, 784, -1606, 197, -394, 
    -535, 502, -754, -92, -603, -510, 42, 841, 1842, -2153, 1136, 2008, 476, 60, 555, -778, 
    -88, 276, -905, -1209, 109, 873, 68, -2185, 692, -1218, 711, 979, -257, -469, 367, 1421, 
    100, 1862, 811, 451, -502, -1379, 994, -595, -240, -1360, 138, 719, 2230, -3595, -750, -189, 
    -2333, 75, -1352, 232, 169, -694, -847, -657, -511, -1409, 276, -670, -36, 1530, 412, -985, 
    1083, -1063, 947, -242, 513, -886, 1793, -300, -267, -133, 217, -891, -156, -456, -270, -89, 
    877, -617, 1909, -1045, -1550, -1029, 166, 523, 1314, 1115, -990, 305, -177, 2931, -741, -1184, 
    -1233, -360, -203, 695, 421, 1302, -3, 314, -1024, -1643, 591, -5, -578, -1153, 245, 931, 
    668, -357, -2100, 53, -378, 1609, -1565, -1870, -359, -402, 217, -1360, 1005, 1296, -3480, -3536, 
    -1605, 794, 49, 253, -604, -496, 20, 104, 20, -3, -608, 446, -960, 1143, 185, 65, 
    -935, -223, 590, 2547, 130, -1389, -318, -124, -2407, -226, 1097, 1460, -319, 632, -1034, -856, 
    1750, 2428, -490, 1413, -1081, 1462, -1487, -773, 484, -1904, -715, -520, 1149, 29, 34, 1591, 
    282, 1538, -1161, -434, 146, 21, 2969, 1563, -300, 2426, 89, 692, -2423, -748, 279, 1027, 
    812, -1229, 747, -149, 265, 1836, 609, -701, 36, -59, 14, -890, 1867, 738, 439, -573, 
    -626, -228, -1126, -1391, -1975, 1236, 339, 1499, -466, -324, 1315, 0, 664, -220, -586, 1849, 
    -12, 894, 2263, 308, 1155, 59, -672, 926, -2127, 3015, -1181, 1239, 518, -1056, -196, -619, 
    856, -923, 608, 524, -1118, -228, -1146, 2281, -1803, 12, 1033, -1022, -1887, 348, -787, -1488, 
    -615, -117, -146, -479, 470, 622, -297, -379, 563, -1704, -1899, -595, 2594, -628, -722, 484, 
    925, -535, 460, -198, 2047, -360, 1209, 798, -198, 2670, -3786, 1901, -551, -1694, -1172, 36, 
    -571, 1902, 791, 1781, -693, 1325, -2033, -877, -598, 1123, -248, -1896, -1124, -1427, -874, -3105, 
    -2864, 487, -2615, 200, -2169, 200, -4090, -750, 1107, -1261, -1851, -1044, -2102, -80, -152, -429, 
    385, -1198, -269, -2083, 2127, -883, -968, -501, -777, -1066, 719, 676, -2993, -950, -285, -785, 
    1420, -1346, -617, 1104, 538, -1802, 139, 673, 832, 554, -367, -767, 349, 920, -381, -1663, 
    1353, -1632, -81, 2335, -485, -1581, -387, 393, -686, 861, 567, 1538, 2280, -1597, 13, 397, 
    631, -503, -1222, -901, 481, 206, 1089, -370, 1727, 250, 38, -1722, -1634, 828, 4562, -2576, 
    -1379, 25, -1350, -3, -546, 1802, -423, 239, 1504, -909, 1709, -172, 1045, -437, -27, 560, 
    -1527, 136, -401, -126, -193, -119, -142, -743, -984, -494, 535, 829, 541, -822, -401, -1998, 
    -1184, 906, -76, 338, -786, 241, -1618, -981, -2073, -1299, 311, -447, -1009, 252, 183, -1063, 
    -537, 489, -1555, -549, 509, -2211, -172, -161, -1288, -1736, -2833, 1781, 346, -940, 1232, 670, 
    -379, -710, 911, 766, -81, -693, -601, 702, 1152, 2594, -55, 87, 285, 561, -1625, 147, 
    -147, -673, 530, -412, -834, -696, -102, -1172, -131, 797, -326, -1098, -551, -207, -1173, -516, 
    -101, 1655, 1942, 21, -1258, -268, 385, -52, 413, 2038, 659, -187, -1627, 1849, 134, 172, 
    266, -131, 835, -796, 1027, 668, -33, -1900, -367, -2847, 1083, 1023, 1834, 1835, 925, 1156, 
    -533, -131, -441, 1412, -879, 337, 951, 171, -1558, -329, -129, -49, -322, -1655, -181, -1642, 
    925, 1031, -184, -307, 641, 865, -659, -328, -913, -200, -2318, 544, -486, -674, 1697, 1246, 
    -17, 388, 306, -140, 599, -1613, 14, 223, 1257, -472, 1689, 1916, 223, -129, 124, -334, 
    -2129, -757, 1909, -573, -739, 182, -132, -439, -371, -555, -1153, -221, -1627, -998, 2115, -846, 
    1986, 1089, -45, 195, 989, -5, 488, -455, -155, 490, -1037, 100, 494, -1573, -1912, -1076, 
    178, -585, 295, 1886, 20, -136, -414, 1848, 346, -130, -427, 1070, 658, -322, 2293, -1287, 
    -294, -657, -1025, 753, 82, 757, -251, 712, -313, -235, -134, -264, -1139, -328, -2774, 336, 
};

static const int16_t fx2d_paramModel2Alpha[16] = {
    1183, 665, 1950, -452, 2823, 4104, 1361, 9478, 3351, -33, -1529, 4607, 48, -700, 6866, 834, 
};

static const int16_t fx2d_paramModel3Bias[16] = {
    -244, 191, -95, -395, -656, 493, 455, -352, 1431, -484, -73, -429, 378, -98, 224, 200, 
};

static const int16_t fx2d_paramModel3Weights[2304] = {
    -586, 1419, -952, 715, -1980, -596, -2448, -667, -1643, -3786, -393, -1347, 1339, -421, 177, -254, 
    707, 274, -509, 535, 1144, -525, -1055, 993, -1751, -787, 591, -1470, 57, 223, 336, 426, 
    -1326, 1637, 298, -70, 464, -1077, -10, 1419, -27, -98, -2103, -132, -3142, -617, -244, 981, 
    49, 1808, 855, -258, -438, 2039, 835, -663, -436, -418, -1424, 1521, 834, 575, 713, -612, 
    2421, 238, 738, 190, -1115, -361, -1009, -1542, -1438, 224, 289, -1511, 1172, -130, -469, 1889, 
    1532, 355, 210, 1686, -946, 328, -653, 1817, 755, -216, -318, -1516, 70, -479, -243, 1633, 
    -727, 500, -587, 178, 319, -968, -65, -58, 1503, 1405, 919, 118, -110, -4, 115, 360, 
    -78, 472, 178, -23, 224, -339, 350, -81, 1374, -325, 242, -1065, 62, 488, -415, -394, 
    -348, -3391, 252, -138, -598, -233, 275, -1211, -919, 602, -2812, 976, -21, 1657, 455, 890, 
    829, 659, -772, 375, -508, -122, -737, 857, -195, 319, -659, -297, 349, -334, 633, 264, 
    603, 731, 424, -2187, 1262, -608, -540, -735, -1538, 505, -1214, 697, 1307, -633, -31, 770, 
    491, 87, -27, 941, -919, 572, -180, -457, -999, -193, 724, 954, -375, 888, -229, 292, 
    787, 550, 1783, 756, -827, -2007, 772, -2105, 1113, 2383, 659, 1644, -32, -2971, -831, 790, 
    -533, -187, -214, -772, 390, 268, 925, 820, 596, 456, 194, 184, -1565, -321, -476, 1369, 
    1138, 745, 751, -126, -1068, 940, 1328, 954, 435, 724, -2011, 336, 819, -1312, 1685, -412, 
    491, -1136, 288, -352, 971, -527, 520, 536, -711, 489, -288, -643, -601, 171, 163, -255, 
    -795, -319, -258, 1106, -1154, 1863, -315, 943, 456, 1626, 296, -624, 2672, -1958, 530, -3546, 
    418, 429, -610, 2246, -40, 136, -526, 1949, -572, 1378, -925, -3327, -695, 985, 2236, 242, 
    -2272, 135, -232, -589, 178, -1444, -271, -109, -534, 1140, 284, -680, -626, 689, -133, 1036, 
    994, 494, -873, -37, -775, -409, -456, -375, 620, 1286, -395, -483, -373, 1646, -399, 714, 
    348, -838, 1480, -1365, -368, -973, -224, -1280, -336, -1618, 416, -234, 423, 213, 1050, -1058, 
    -265, 462, 272, -486, -272, 267, -270, 294, -98, 742, 47, -1944, -930, -494, 1346, -521, 
    -315, 1716, 356, 1582, -345, -331, 2901, 562, 1059, -912, -770, -1074, 1472, -194, -281, 836, 
    -242, -1381, 747, -49, -951, -922, 848, -258, -582, 615, -297, 1607, 221, -1855, -232, -923, 
    -45, 969, 1196, 795, 169, -513, -1047, -1335, -579, -1014, -1901, -261, 1009, 625, 2446, 205, 
    -961, 713, -102, 90, -542, -453, 770, 1529, 1150, -50, 380, -1717, -1291, 795, 69, -829, 
    -1668, 404, 85, -399, 975, -540, 36, 1623, -132, 78, -1581, -1227, 200, -242, -1305, -1958, 
    520, -271, 535, -169, 231, 442, -1614, -99, -612, 1216, 172, 265, 145, 446, -1484, 415, 
    135, -980, 1008, -498, -152, 1468, 17, 1353, -594, -815, 469, -2890, -1932, -1730, 404, 532, 
    758, -698, 136, -303, 1051, 496, 833, 1701, -195, -935, -1045, -3494, -2288, -724, -2918, 187, 
    1197, -273, 2059, -601, -2128, 1142, -1308, 887, 238, 1625, -1889, 2229, -991, 278, 517, -1445, 
    -145, 822, 300, -541, -913, 1205, -674, -1858, -52, 1345, 70, 233, 692, -13, -987, 858, 
    282, 410, 756, -1294, -507, 1555, -1896, -358, -880, 594, 1334, -2378, 3045, 349, 1836, -1752, 
    1036, 106, 25, 250, 470, -310, 439, -1973, 663, 1201, -2326, 2125, -2883, 237, 68, 2624, 
    -1394, -9, 342, -1014, -594, -80, -1599, -508, -1230, -1663, -1312, -384, -2068, 1107, 238, 1022, 
    -231, 964, -206, 1054, -1168, 3135, -351, 1013, -312, 1228, 841, -1471, 756, -493, -216, -185, 
    961, -967, -1980, 503, 349, -1487, -1584, -116, -1478, 1886, 443, -1500, -1002, 64, -1279, -1707, 
    31, -439, 564, 886, 107, 97, 165, 1593, -1103, 21, -955, -470, 836, -889, 247, -1109, 
    -1405, -436, 249, 434, 702, -522, -426, -66, 1187, 475, -484, -1163, 833, 214, -927, -101, 
    -266, 245, 47, 557, -1782, -482, 67, 1278, 534, -526, 418, 58, 516, 437, 964, 499, 
    -756, 73, 540, -1319, 14, 294, -1110, -824, 51, -962, -1047, -325, -748, 1237, -1077, -929, 
    -890, -10, -469, -641, -1703, -593, 734, 642, 495, 63, 437, 542, 388, -42, 212, -1474, 
    -823, -287, 453, -136, 1054, -765, 894, 729, -130, 279, 225, -96, 603, 558, -1184, -1102, 
    1217, 539, -490, -1054, -738, -2447, 958, 563, -419, 206, 37, 911, 992, 1238, -761, 654, 
    633, 1389, -388, 2296, 650, 579, 607, 1604, 1462, -1864, -818, -1686, 650, 881, 1285, 598, 
    450, 115, -146, 1321, 649, 288, 746, 1072, 550, -142, -1191, -172, -1396, 393, -569, -1131, 
    -1631, 602, -174, -541, -305, -2596, -3045, 1360, -471, 1044, 858, -51, -216, -939, 2027, -942, 
    133, 605, -1100, -1316, -153, 1125, -1080, 1172, 727, -202, -121, 1071, -1494, -25, -764, -1409, 
    869, 1434, -1986, 1504, -598, 2194, 1486, -977, 508, -2191, -1150, -545, 1929, 932, 1056, 464, 
    1013, -1378, -294, 1044, 318, 774, -135, -743, -2328, 712, 40, 185, -877, -349, 215, 1307, 
    -1518, 247, -1472, -442, -706, 223, -788, 78, -1138, -689, 82, 748, -1853, -573, -798, 6, 
    -1762, 373, -884, 1422, -1067, 1381, 1566, -730, -299, 547, 847, 142, -622, -829, -542, -582, 
    -3605, -846, 812, -1875, 299, 1758, 1343, -2024, 501, -4167, -922, -919, 649, -2754, 455, -97, 
    664, 851, 501, -2918, -923, -158, 2116, 404, 480, 682, 1005, 2147, 285, 1078, 482, -437, 
    161, 792, 418, -2435, -1700, -1096, 751, -1424, -529, 883, -166, 1528, -1092, -1496, 726, -709, 
    652, -516, -208, 386, 667, 332, 1119, -1321, -931, 50, 2024, 896, -476, 1336, 1787, 117, 
    155, -974, -374, 1554, -1506, -375, -55, 1175, 582, 4551, -5492, 4168, -152, 73, 331, 1476, 
    173, -803, -493, -964, 352, 408, -631, 310, 1475, 474, -980, 1543, -1698, -885, -627, 26, 
    -295, 1905, -84, -831, -1169, 478, 12, 250, -2296, 2306, -115, 1792, 785, -915, 1052, -1303, 
    -484, -1572, 883, 1110, -78, 1200, -584, -1325, 25, -501, -588, -3128, 771, -1001, -44, -1360, 
    -1993, -841, -62, -850, -456, -104, 3096, 503, -4806, -230, 28, -455, -665, -903, 530, 1035, 
    -1617, 548, -328, -18, 585, -390, 1412, 419, -244, 37, -1633, 3, 774, 254, -1165, 1883, 
    -126, 800, 1554, -632, 857, 1021, 1546, -468, 151, 703, 598, 3, -275, 1299, 115, 2744, 
    439, -481, 532, 343, 15, 561, -168, 435, 381, 182, 1110, -1006, 1283, -760, 752, 1261, 
    -99, -654, 182, -1237, 1162, -2069, -3048, 2242, 4197, 538, -242, -254, 2743, -1648, 2789, 2641, 
    -3447, -808, -2323, -242, 2539, -2907, 1080, -2681, 1116, -185, -1240, 2166, -2843, -1560, -279, 30, 
    -374, 1465, 587, 1416, 1741, -14, 1712, 122, 29, 445, -243, 2776, -987, -997, -174, 152, 
    74, -1745, -192, -536, -938, 706, -1524, -911, 162, -441, -219, 1672, -1864, -841, 385, 245, 
    903, 1175, -156, -393, 2627, 2091, -1503, 511, -285, -273, 1253, -1891, -3050, 1371, 409, 66, 
    -2571, 1105, 554, -605, 763, 232, 1514, 3318, -860, 2088, -64, 1218, 2793, 2067, 1355, -1996, 
    264, 529, -261, -4728, -690, -404, -879, 1739, -39, -2188, -764, 2360, -248, 2800, -687, -284, 
    1495, 140, 1758, -317, 2151, 1449, 72, -3, -856, -1006, 1054, 350, 1499, -494, 223, 3085, 
    1099, 494, -323, -2, -4083, -2091, 2453, -861, 338, 2688, -1118, -1246, -164, 1482, 1529, -1269, 
    951, -365, 202, 51, -78, -1420, 121, -3186, 1435, 2585, 1454, 1351, -798, 274, -489, 497, 
    772, -2742, -1712, -479, 172, -30, -1245, 214, -3417, 1412, -98, -607, 504, -2608, -1018, 374, 
    -616, 1973, 813, 258, 2233, -1394, -526, -482, -1334, 1173, -1320, 1795, 368, 671, 1036, 73, 
    -64, -2781, 1061, 2581, -404, -60, -67, 1316, 1594, 1896, -1236, -2270, 2423, -725, -109, -1510, 
    406, -1031, -3065, 418, 2587, -1280, -2203, -202, -1495, 757, -1135, -231, 1609, 1707, -637, 373, 
    2052, -2382, 579, 188, 1469, 3604, 1607, 2130, 219, -2422, -1266, -557, 633, 1595, -1888, 1277, 
    477, 797, -157, -177, -675, -185, -1244, -1777, 681, 135, 637, -697, 546, 32, 1534, 394, 
    394, 265, -782, -863, 1133, 922, -1240, 352, -643, 1465, 637, 231, 1859, -242, 1067, 46, 
    326, -521, 1873, 1637, 532, -330, -706, -352, 922, 326, -1361, 102, -290, -1176, 3115, 452, 
    208, 118, -829, -522, 54, 411, 387, 248, -1790, -2251, 564, -71, -208, 2848, -111, -1308, 
    728, 685, -1009, 229, -1634, -292, 1612, -94, 2623, -14, -301, -1092, -1025, -1444, 413, 25, 
    -1889, 203, -441, 1078, 998, -657, -857, 1373, -968, 674, -998, -1149, 585, 1532, 1245, 484, 
    1286, -1127, 619, 1634, 1775, 1200, 1505, 2140, -1180, 86, -18, 442, -354, 919, 576, -1066, 
    -1168, -837, 873, 1713, 1080, -485, 74, -278, 1330, -377, -616, 1516, -677, 562, -1905, -1204, 
    -126, 366, -1622, -438, 1189, 466, -2226, 349, -600, 609, -434, -16, 1082, 849, 672, 1047, 
    -640, 282, 520, 454, -972, -2088, -888, 389, 13, -162, -698, -158, -533, -68, 1466, 72, 
    1462, -1554, -667, -1644, -2512, -1113, -2140, -3082, 1218, -135, 1351, 838, -1813, -197, 918, 2295, 
    -1762, -554, -352, -532, 1586, 2, 1380, 254, -635, 293, -1223, -646, 724, -1319, -458, -1581, 
    1764, 320, -193, 332, 242, -1219, 1344, 316, -225, 367, 189, 1889, 1925, 285, -1485, 367, 
    311, 660, 700, 2470, -986, -949, -614, -603, -2337, 1321, -1541, -1175, 2003, 628, 1065, 2198, 
    -1203, -914, -826, 1376, 559, -765, -997, 176, 2734, -847, -343, 2015, -951, -395, 21, -754, 
    -2524, 1855, 1068, -1075, -316, -72, 2165, 415, 320, -2316, -405, 1019, -1344, 107, -793, 1346, 
    673, -1654, -1607, -2040, -651, -1556, -479, 962, 566, 1462, -595, 326, 1092, -609, -1387, -235, 
    2061, -2264, -1796, -682, -864, 1373, -1976, -1530, -94, -718, -848, -671, 2534, -614, -826, 1369, 
    1267, -1707, -515, 313, 298, 877, -1999, 1004, 68, 417, -379, -502, 437, 141, 1442, 1284, 
    -810, -274, -2550, 562, -1367, 534, 360, 3073, 230, -233, -152, -769, -4028, 512, -503, 639, 
    -1082, 999, -932, -116, 1052, 551, -406, -240, -477, -306, -381, 909, 963, -270, -828, -10, 
    -637, -1626, -908, -893, 1823, -967, 80, 239, 2247, 566, 686, 129, 361, -706, 1099, -666, 
    411, 1331, -814, 1226, -76, -18, 1000, -844, -1483, 370, -574, -61, 191, 524, 28, 22, 
    -597, -225, -343, 953, 329, -517, 228, -782, -385, 858, 748, 205, 931, -1651, 807, -920, 
    81, 223, -465, 54, 101, -151, 417, 258, 950, -769, -243, -1321, 523, -11, -38, -378, 
    -3295, -3381, 761, -2373, 11, -56, 1554, -554, -416, 2429, 423, 1182, -65, 306, -541, 724, 
    568, 566, -978, 1137, 220, -167, 554, -239, -470, -348, 868, -2533, 596, 110, 20, 515, 
    784, -1034, 137, 384, -225, -700, 1096, -1645, -1247, 174, 314, -160, 162, 1450, 302, 1356, 
    -88, 148, -47, 876, 702, 622, 768, 521, 453, 674, -182, -970, 176, -119, -246, -117, 
    -648, 1929, 204, 1554, -1578, -394, -674, -705, -2377, 342, 1093, -1599, -940, -1466, 264, 153, 
    -962, -412, -376, -90, -905, 326, -77, 1261, 1977, 865, -470, -1539, -1043, 344, -163, -1909, 
    967, 852, 331, -1443, -242, -420, 203, -792, 939, -930, 986, -974, 744, 309, 1194, -38, 
    1004, -482, 919, -1928, -550, 442, -773, -393, 380, 1482, -262, 106, -153, -531, 592, -1100, 
    367, -839, 1380, -281, -295, 625, -123, -376, -1831, 89, 391, -839, 3554, -893, -259, -1498, 
    -4383, 650, -4973, 336, -33, -307, -1308, 3083, -978, -1023, -505, -484, 669, 1353, 1683, 1733, 
    1125, -395, -2604, 51, 267, -1621, -904, 2684, 848, 575, -346, -287, -2184, 51, -2077, 559, 
    -268, -1693, 179, 149, 29, 447, 1825, -1925, -152, -249, 493, 855, 508, -376, -639, -147, 
    -572, -431, -49, -522, -2960, 1895, -692, 2845, 746, -441, -1412, -235, -2187, -938, 159, 812, 
    1391, 1774, 205, 3550, 979, -166, -518, -2588, 703, 961, -553, 1443, -1091, -145, -8, -1433, 
    -967, -3024, 799, 595, 361, 295, -262, -1747, -104, -47, 603, -595, -160, 860, -121, 531, 
    400, -580, -10, -338, 524, 513, 452, -2511, -240, 957, -929, 1576, -810, -121, 517, -881, 
    -308, 856, -1696, -1093, 1925, -1081, -547, 1845, -17, 1505, -1318, 439, 1274, 1063, -323, 363, 
    -769, 799, -382, -1281, 1357, -1196, 730, -3176, 770, 725, -441, -2231, -613, 484, 147, 1914, 
    80, -1942, 244, 522, 838, -2066, -103, 25, -1906, 1061, -46, -1087, 22, 1828, 728, 201, 
    108, -1649, -493, 782, -1081, 181, -1205, -1349, 398, 2617, -902, -1732, 478, 67, -360, 14, 
    682, -2676, 700, 2572, -1436, 628, 1374, -493, 41, 1363, 555, 1159, -545, 189, 521, 593, 
    -411, -2253, -1711, -123, 412, -735, 605, 216, -203, -1144, -650, -1737, -23, -434, -967, -571, 
    -1944, -1821, 1438, -792, 44, -208, 554, 682, 726, -1472, 771, 218, 1253, 255, -1072, 961, 
    1505, -1997, -577, -1974, 422, -238, -201, 1313, 1316, -1890, -867, -646, 249, -244, 279, -1204, 
    824, -21, 1006, 1026, 946, 1986, -241, 451, 384, 1086, 637, 567, 1249, 599, 1204, -828, 
    609, 835, 1150, -919, 359, 746, -213, 104, 439, -291, 240, -287, -1100, -249, -121, 3203, 
    1930, -132, -955, -19, 57, -939, -502, 1257, 10, -302, -899, -248, -731, -2462, 119, 187, 
    411, 337, 8, 691, 1, 61, 182, -775, 706, 10, -304, 5, 292, -576, 636, 1035, 
    185, -136, -1159, -141, 296, -1199, -254, -199, 2186, 168, -722, 1107, 101, 541, -44, -296, 
    243, 722, 1125, 836, 1481, -280, -345, -4928, -675, -503, -1238, -220, 1152, -315, 22, -507, 
    483, -1531, 826, 796, 1342, -146, 677, -570, 251, -352, -1, 794, 673, 808, -301, -882, 
    -937, 761, -360, -922, -874, -285, -44, 1065, 67, -621, 603, -1111, 582, 1377, -675, -319, 
    -1747, -411, -913, -497, -1676, -278, 266, 289, -83, -116, -437, -205, -852, 632, -840, -1130, 
    668, 177, -189, 1059, -435, -452, 473, -3458, 1088, 457, 571, -822, 2071, 431, 16, -1154, 
    293, -1130, 425, -1116, 299, -819, 1104, -1123, -146, -176, -472, -107, 102, -108, -475, 375, 
    113, -165, -68, 722, -43, -876, 216, 327, -904, 1069, -319, 560, -612, 823, -39, -1029, 
    1203, -1130, -678, 2491, -1176, -874, -150, -1334, 1137, 1322, -1684, 956, 686, 86, 286, 1162, 
    -662, 313, 2728, 771, -2363, -143, 695, 2303, 1365, 650, -232, -1490, 1642, -535, 150, -1512, 
    -3011, 1413, 898, -2161, 476, 507, 106, 255, -1333, 1568, 958, -262, -1190, 1196, -104, 695, 
    256, 452, 179, -176, -138, -51, -950, 43, -530, 192, -9, -347, 211, 812, -1089, -629, 
};

static const int16_t fx2d_paramModel3Alpha[16] = {
    1807, -613, 2068, 1717, 2417, 85, 2884, -681, 53, -491, 6027, -681, 7202, 711, 10533, 2269, 
};

static const int16_t fx2d_paramModel4Bias[16] = {
    201, 462, -212, -362, 143, -39, -69, 29, 264, 217, 12, 163, -261, -486, -52, 440, 
};

static const int16_t fx2d_paramModel4Weights[2304] = {
    -535, -140, -2075, 818, 757, -134, 749, -1497, -392, 481, 1270, 844, 551, 262, 1850, -66, 
    -393, -1100, 529, -528, -441, -186, -347, -214, -1180, 1056, 1474, -183, -607, 804, -850, 341, 
    -434, 1236, 885, 246, 113, 1914, -1, -425, 1192, -2396, -1215, -1789, 971, -151, -870, -185, 
    -860, 434, -857, 860, 127, -12, 678, 53, 309, 1313, 1032, -329, 198, -157, 643, -404, 
    -154, 1259, -283, -1220, 124, -552, -176, 652, 962, 837, -594, -975, -103, 1245, 464, -2474, 
    -342, 1271, -196, 250, -567, -1858, -517, -576, -1231, 957, -3110, -7, 162, 2778, 1569, 7, 
    -150, 4, -592, 23, -520, 477, 222, 438, 113, -2671, -1143, 1407, -1290, -1122, -544, -2321, 
    809, 458, 352, 238, -237, -589, -327, 708, 598, -258, -62, 201, 307, 910, 762, -1054, 
    1795, -498, 1281, 1995, 789, -389, -581, -963, 183, -1000, -970, 415, -133, 68, 225, 691, 
    -1688, -749, -1809, 376, 1378, -544, -2643, -438, -1267, -1242, -259, -511, -1488, -562, -2360, -42, 
    -332, -188, -624, 1074, -870, 1797, 779, -140, -913, 1458, 1313, -115, 1214, -2019, -255, -173, 
    -479, 581, -870, 98, -478, 144, -2085, -384, 240, 883, -120, 544, 479, -70, 297, -80, 
    -72, 397, -740, -202, 675, -308, 1108, 930, 1288, -560, 2666, -348, -321, 79, -925, 1549, 
    644, 222, -2921, 1549, 234, 1122, -1260, 1272, 502, 364, 1404, -43, -3668, 530, 716, 316, 
    337, 1717, 30, 932, 883, 353, 177, -151, 285, -842, 304, 150, 703, 521, -356, -417, 
    652, -1015, 7, 208, -308, 271, 321, -742, -121, -98, -142, -1269, 151, -171, 22, -29, 
    118, -741, 964, 1478, 609, 1016, 1237, -1332, -696, 643, 1011, 1153, 3, 514, 84, -1421, 
    1709, -1322, 156, 606, 1250, 719, 438, -717, 206, 667, 60, -175, -1241, -1024, 221, -331, 
    -515, -59, 785, -45, 222, 835, -572, -269, 1214, -679, -1672, -721, -282, -129, 597, 511, 
    -52, 1013, 275, -1045, 380, -1514, 457, -196, 755, -326, 635, -115, 527, -6, -160, -193, 
    -691, 660, -755, 2794, -62, -949, 374, 523, -911, -292, -72, -504, -1110, 2603, 2406, -868, 
    -470, 1456, -170, 887, -54, -1205, -909, -1612, 426, 1429, -710, 427, -911, 2113, 622, -180, 
    -69, -663, -702, 1210, -744, 1414, 728, 128, -37, -507, -284, -835, 449, -2304, -1664, -2882, 
    686, 1503, 763, 741, -1050, 23, 109, -315, -332, -338, -785, 102, 1067, -1689, 1886, -1510, 
    1146, 168, 135, -424, -236, -1074, 3417, -1191, 245, -778, -743, -226, -735, 1216, 1808, -705, 
    -806, -1516, -58, -1148, -181, 245, -422, 791, -952, -1531, -777, -188, 2375, -244, -395, -236, 
    -1473, 485, -272, -338, 447, 2310, 1983, -1067, -1020, 821, 400, -830, 864, -576, -2083, -444, 
    -364, -1190, -861, -31, 1616, 2038, 884, -589, 202, -1367, -110, 196, 1353, 161, 1479, 234, 
    -275, 21, -1278, -1099, -555, -74, -406, -518, -1744, 23, 908, -467, 722, -160, 625, -1036, 
    -822, 358, 1454, -1210, -245, 168, 480, -850, -570, 450, 776, 434, 707, 384, 368, -198, 
    -271, -1067, 576, 211, 951, -790, 1082, 263, 545, 1297, -279, -183, -1001, -392, 135, -1575, 
    -717, 686, -106, 279, -174, -1652, -527, -484, -790, -569, -445, -682, 900, -161, 1073, 665, 
    434, 835, 267, -788, -1203, -210, -2121, 748, 208, -454, 1305, -124, 107, -35, 138, 380, 
    -993, -2501, 139, -525, 1393, 1430, 66, 220, 951, 847, -1112, 1634, -611, -298, 299, 90, 
    -553, 571, 678, -1286, 22, -970, -331, 1060, -411, 880, 1288, -696, 264, -171, -563, 22, 
    39, -231, 807, 157, -1297, -1108, -1245, -1080, 495, 497, 966, 89, -381, -929, 553, 393, 
    1103, 26, 518, 135, 762, 124, 284, -260, -210, 772, -815, -410, -48, 212, -1532, 391, 
    -400, 507, -324, -160, -248, -394, -473, -1095, -83, 257, 267, -2158, -681, 1612, 40, 851, 
    -717, -442, -1096, -321, -521, 247, 236, -494, 354, 986, -258, 501, -16, -3372, 615, -558, 
    786, -1813, 733, 107, 447, -236, 201, 178, 498, -1113, -287, -261, -329, 1134, 185, 13, 
    1454, -582, -112, -1901, -477, 1259, -8, -1729, 98, 1198, 815, -158, -580, 777, 393, -623, 
    336, -2001, -194, -3162, -527, -597, 41, -1178, 823, -633, -395, -2730, 210, 1380, 223, -3347, 
    -415, 682, -670, 527, 188, -68, -1039, -265, 611, -126, -636, -840, 1136, -527, -725, -1262, 
    -129, -464, 28, 885, -793, -2341, -1708, 162, 765, -1535, 236, -97, 191, -1284, 1319, -1077, 
    1166, -1096, -869, -86, 1070, -232, -112, -1461, 715, 1, 83, 315, 718, -707, 632, 97, 
    -173, -1332, 233, -1162, 85, -1251, -761, -4366, 268, 1314, -146, 482, 337, -131, -15, 235, 
    303, -561, 577, -511, 206, -1301, 312, -869, -409, -1604, 10, 270, -419, 57, -424, -1124, 
    806, 1254, 244, 65, 36, 151, -17, -606, 459, 217, 285, 686, -304, 659, 347, -466, 
    262, -169, 87, 941, 748, 213, 153, -1070, 627, -503, 1588, -442, -481, 638, -583, 272, 
    -253, 190, 1517, -138, -1896, -295, -1769, -107, -4744, -604, 1546, -180, -1564, 945, -4061, 507, 
    -1756, 469, 1020, -1277, 828, 1198, 1886, 34, 1652, 946, 1119, 767, 940, -748, -1948, 845, 
    183, 1102, -94, 158, 1134, 582, 404, 259, 333, -1226, 287, 901, 840, -70, 379, 72, 
    -104, 274, -644, -2905, -915, -979, 1023, -1130, 310, 1533, 42, -1502, -1055, 891, 2826, -3071, 
    2054, -36, -1585, 532, -2121, 328, -1915, 327, -1167, 321, -1486, 66, 1001, 92, -1797, 49, 
    -1105, 52, 663, -2858, 15, 1870, 2741, 664, 1131, -1299, -1224, -66, 2286, 1340, -169, -2861, 
    595, -65, 900, -1656, 273, -1245, 1262, 473, 1203, -108, 1585, -762, 2760, 933, 1972, -992, 
    508, 916, 269, 803, -245, 1184, 424, -537, 199, 120, 158, -646, 466, -376, -302, 1149, 
    -1308, 729, -1832, 482, 1290, -790, -4738, -279, 519, 581, 1863, -991, -1689, -170, -2732, 347, 
    -2248, -744, -910, -442, -1726, -762, -1530, -2202, -1608, 1850, -657, -1062, -151, 666, 2527, -673, 
    281, 1387, -201, -389, -329, -239, 171, -540, -471, 1640, 358, -999, -838, 157, -883, -762, 
    -1532, 733, -1548, -191, -114, 420, 143, 1796, 712, 395, 2882, 215, -256, -23, -966, 1177, 
    400, 898, -3447, 1978, 1153, -1512, -1129, -164, -569, -18, 1100, -19, -4993, -778, -5941, 1985, 
    -1035, -1003, -2539, -664, 123, -918, -1659, 413, 970, -1045, 136, -234, 2580, 435, -819, 1246, 
    479, -1258, -98, -120, 1247, 1663, -750, 529, 921, 117, 303, 709, -5, 484, 428, 1166, 
    -1078, 159, -816, -60, 113, 1300, 918, -5223, 990, -534, 617, -84, -214, -1139, -313, -25, 
    1979, -480, 1305, 513, 1823, -1891, 630, 680, -2128, 1030, -2373, 527, 79, 3070, -1663, -3153, 
    810, 2217, -376, -1641, 554, 1004, 1240, 104, 1143, 853, -952, -43, -2608, 1558, 867, -1077, 
    682, -1360, -352, 139, 2005, -20, 870, 1207, -369, -794, -1026, 533, -1219, -1118, -1186, -266, 
    -3527, -78, -2058, 386, -1428, 1770, 330, -1420, -3174, 857, -2073, 200, -2697, -1931, -2425, -1794, 
    -2536, 2402, -700, 68, 2678, -425, 2737, 3139, 1321, -505, -898, 411, -2184, -1392, -112, 402, 
    1963, -285, 884, -1397, 720, -438, -2420, 1565, 2578, -2685, -2478, 814, 6, -1634, 310, 323, 
    -402, 3623, -577, -1765, 2938, 657, -1736, 800, -1096, 683, 1787, -807, 442, -453, -882, 545, 
    299, 821, 508, 1122, -871, 81, -1111, -4101, -524, -918, 106, 1692, 2233, -423, -76, -1718, 
    -276, 1564, 851, 631, 200, -935, 1236, 218, -853, -503, -1226, -160, -1579, 4279, -674, -1548, 
    -1914, -1568, -805, -1218, 206, 943, 2489, -2984, -833, 695, 638, -489, -135, 1086, 1803, -2247, 
    765, -1535, 243, -834, 832, 2014, 1083, -1461, -294, -1103, 649, 93, -400, -1869, -1176, -1225, 
    1971, 1618, -1261, -723, -620, 360, -2350, -1286, -614, 2431, 2891, -1965, 2060, 513, 1192, 774, 
    930, -642, 1645, -41, -207, -3062, -456, 652, 95, 413, 1566, 1915, 1371, -778, 1855, -258, 
    453, -450, 195, -676, -589, -666, -397, 1646, 2236, 1018, -1818, 1385, 1229, -2499, -493, 97, 
    1602, 13, 142, 701, -679, -3489, -596, 2594, 158, -316, 905, 1387, -71, 1018, -1165, 1717, 
    -3764, -1686, 412, 3027, -2384, -362, -3540, 1700, 3056, -211, 2176, -2961, -146, 107, 1391, -316, 
    -1920, -269, -1353, 510, -884, 1802, 73, 455, 2068, -1559, -137, 1889, 1056, 1803, 452, -2580, 
    -2530, -1541, 1086, -2125, -1288, -2134, 234, -1574, 1571, 52, -1934, -882, 889, -1498, -2448, -2191, 
    -866, 1391, -962, -3188, -3237, 783, -9, -1597, 429, -3003, 1003, 860, -33, 441, 1610, -2948, 
    921, 347, 4013, -270, 1400, 559, -396, 11, 669, -187, -839, 327, -1400, -390, -149, 1625, 
    481, -172, -65, 1380, -447, 198, 912, -3476, -99, 1058, 263, -1090, -43, -638, -54, 775, 
    517, 179, -2194, -2587, -239, 1565, 1168, 1162, 1062, -769, 350, -352, 689, -1883, 239, -1023, 
    -570, -2674, 1010, -1051, 845, -12, 983, 1568, 381, 1293, 854, 879, -779, 566, -928, -2424, 
    1191, -416, 1402, -1318, 129, -514, -2609, 424, -1311, -77, 1217, 857, 833, -719, 1555, -1282, 
    -662, 1706, 449, 516, -213, -1319, 290, 2080, 462, 95, 678, -756, 1327, -1156, 260, -3391, 
    -1340, -403, -354, -364, 22, -201, 873, 182, 1130, 1759, -650, -1075, 1365, 275, 618, -1230, 
    -52, -1097, 347, -995, -624, 155, -394, 755, -443, 870, 316, -718, 917, -94, 1160, 137, 
    907, 664, -1429, 1184, -335, -1035, 100, 1522, -150, 413, 736, 673, 352, -186, -205, 760, 
    -65, 1443, 1419, -3387, 546, -1331, -612, -3361, 427, 302, 237, -1864, 553, -1124, 879, -2555, 
    42, -2655, 2219, 181, 1882, -1657, 466, 846, 758, -873, -447, 168, 785, 335, -707, 306, 
    62, 784, 110, 235, 512, 2511, 331, -213, 72, 1742, 208, 542, 218, -340, 786, 740, 
    88, 315, 612, 318, 214, -447, 145, -24, 24, 709, 132, 371, 203, -168, -72, -16, 
    348, -100, 403, -641, 87, 699, 1229, -149, -90, -1161, -690, -744, -949, 235, -2641, 843, 
    96, -792, 30, -1179, -335, 1705, 1711, -539, 179, -336, -316, -821, 1143, -171, -863, 704, 
    1648, 421, 349, -280, 448, -8, 682, -332, 183, 1204, -84, 420, -149, -220, 251, 290, 
    77, -755, -1087, -312, -31, 141, -1402, -1120, 754, -582, 816, -477, -219, 367, -1621, 1094, 
    660, 89, -376, -40, 741, -73, -137, 222, -1588, 1274, -486, 229, 859, -333, -504, -272, 
    259, 1591, 1366, 71, -278, 178, -80, -704, 1383, -866, 515, 1570, 841, 640, 1719, -2232, 
    -411, 849, -477, 480, -807, -310, -144, 749, 1097, -1975, 363, -1078, -193, -650, 2, 82, 
    195, -110, 50, 1028, 318, 239, 452, -1316, 277, -850, -269, -163, 189, -190, 511, 381, 
    -1907, 270, -1330, 69, 846, -128, -862, -154, 621, -40, 282, 365, -1253, -43, -1301, -276, 
    -161, -692, -1744, 472, 213, 1332, -411, 648, -2, 962, 1881, 797, 924, -1104, -907, -117, 
    139, -306, -549, -621, 442, -298, -578, 133, 614, 708, 766, 5, 212, 399, -3, -494, 
    847, -28, -600, -1143, 7, -430, 2390, 497, 480, -528, 1842, 900, -161, -402, -794, 1489, 
    -211, -33, -3047, 470, -17, -162, -249, 856, -198, 402, -638, 262, -2732, 952, -1067, 736, 
    -114, -914, -139, -380, 1219, -613, -838, 284, 65, 1231, 512, -289, 955, 133, 923, 1297, 
    268, -527, -715, -95, 331, 744, 738, -1003, 653, 587, 704, 531, -31, -223, 373, -174, 
    -1102, -1076, -1095, -1845, 522, -791, 936, 1401, -205, -8, 1177, 2991, -693, 180, 95, -945, 
    717, -516, 710, 906, -92, 1047, 657, 41, -281, 345, -110, -635, -647, -756, 478, -427, 
    -97, 1534, 1580, -1806, 755, 1544, 1981, -201, 1181, 992, 362, -837, 815, -662, -553, -1806, 
    -232, 301, -153, -757, 88, 230, 268, -1218, -23, -524, 1466, 477, -1804, -268, 335, -220, 
    -166, 551, 1177, 813, -1335, 286, 507, 1141, 1595, 627, -1339, 73, -9, -1560, -389, 2593, 
    516, -1107, 47, 1613, -669, 647, -602, -1553, -708, 291, 434, -807, -387, -437, 83, 54, 
    2054, -895, -777, 808, -383, -1540, -362, -18, -202, -320, -476, 434, 2003, -781, 496, -2778, 
    -12, 1721, -1042, 1944, -994, 1063, 286, -1628, -800, -1941, -602, -98, -2352, 1145, 354, 1744, 
    -62, 67, 780, -189, 240, -91, 107, 480, 269, -663, 315, 396, -288, 1519, 1587, -1883, 
    337, 119, 738, -589, 239, -123, 4, 425, -1819, -1809, 46, 1767, -806, -202, 968, 501, 
    -212, 449, 92, 813, 59, 999, 2071, -1128, 1475, -1100, 472, 3315, -1709, -1047, -3002, -750, 
    744, -430, 248, -371, 820, 194, 211, 911, 524, -573, -1450, 1723, 164, -375, 299, 108, 
    221, 100, -1779, -818, -886, -623, -1263, 287, -803, 675, -65, -318, -339, -311, 1368, -712, 
    288, -1671, -810, -977, -430, -1341, 378, -133, -557, -221, -349, 570, 1246, 562, -636, -914, 
    -356, -114, 1141, 401, -747, -742, -598, 1838, 483, 169, -53, 175, 1262, 295, -797, 1939, 
    -80, 736, -315, -177, -561, -699, -469, -248, -203, -682, 414, -807, 991, 310, -71, -1568, 
    -678, 1029, -803, -700, -12, 157, 382, -1099, 126, -317, 821, -533, 265, 1093, -1628, 1267, 
    -38, 303, 331, -511, 700, -376, -146, 933, 1167, -450, -352, -903, -115, -1611, -153, -2203, 
    1448, -992, 396, -2355, -220, 445, -457, -96, 478, 1185, -1628, 957, 1424, 331, 113, 2053, 
    -289, 506, -874, 1016, 126, -32, -388, 918, 593, -1239, 453, -1031, 1406, -1339, -142, 1219, 
    950, 6, 1072, -175, 332, -314, 729, 901, 1321, -914, 1349, 389, 832, 838, 936, -352, 
    -165, -3, 128, -334, 43, -123, 930, -860, -912, 1123, 384, 402, 485, -1505, -82, 223, 
    1050, 31, -498, 1227, -358, 372, -97, -579, -787, -168, 121, -1216, 2039, -310, 336, -1518, 
    -211, -1362, -252, -134, 44, -1340, 444, -813, -271, 663, 563, -741, -1084, -450, -727, 510, 
    1321, -408, 750, -49, -136, -151, -894, 993, -300, 554, -219, -816, 1236, -923, 2205, -980, 
    -687, 593, -159, -2402, -775, 210, -272, 234, 1167, -1257, 102, 536, 521, -228, -436, -1509, 
    589, -620, -554, 0, -264, 1138, 500, 280, 849, 1423, 202, 2023, -95, 580, 687, -1365, 
    -150, 529, 853, -667, -274, -326, -132, 346, -69, -895, -733, 798, 308, 552, 900, -626, 
    -589, -991, -315, 1299, 407, 1109, 737, -395, 305, -322, 242, 10, -71, 756, 120, -43, 
    392, 76, 1005, -1288, -236, -349, -477, -1394, 423, -4, -83, -424, 205, -575, 205, -1922, 
    349, 1000, 1565, 919, 1204, -253, -657, 1348, 747, -267, 278, -317, -616, -970, -243, 1303, 
    -102, 608, 770, -314, 622, 312, -259, 552, 403, -422, 233, -946, 753, -2314, -6, 217, 
};

static const int16_t fx2d_paramModel4Alpha[16] = {
    6934, 4506, -1022, 1792, -128, 1901, 595, 1631, 679, 891, 2079, 2285, 5036, 4240, 3588, 4501, 
};

static const int16_t fx2d_paramResidualBias[16] = {
    -326, 541, -689, 180, -378, 435, 222, 337, 155, -69, 230, -496, 25, -222, 209, -151, 
};

static const int16_t fx2d_paramResidualWeights[256] = {
    -741, -251, -3065, 1637, -2414, 2436, 337, -1300, -679, -2572, 2163, -400, -6094, 464, -4217, -2451, 
    605, -1669, -1468, -3418, -2264, 3737, 2923, 113, 1488, -51, 1035, 331, -681, -80, -3704, 1903, 
    4441, 1089, -3240, 900, 637, -24, -605, 2363, 1293, 827, 737, -630, -346, -24, 2529, -1523, 
    -1727, -1790, -943, -2272, -426, -445, 2659, 3257, 322, -467, 275, 426, 629, -2797, -3125, 2848, 
    832, -2957, 1384, -910, -390, 2144, -1151, -1189, 1143, 4464, -207, -3234, 591, -253, 1443, -990, 
    1647, 2499, -2587, 2136, 5, -4012, -1343, 382, -1177, -381, -3235, 2066, 25, 2195, -3747, -883, 
    -89, 811, 2870, 2855, -332, -1204, 1814, -782, 2206, -152, 244, 3886, 3928, 3598, 5049, 1446, 
    584, 823, -673, -1403, 816, -3315, -1279, -2056, -71, 1272, -484, 2330, -4654, -131, -39, 5333, 
    2341, -1165, -3098, 3738, -2419, 2706, -2646, -832, -789, -3022, 4505, -217, -1696, -1593, 532, -2686, 
    641, 1730, -1387, 11, -1898, -519, 116, 508, -233, 4083, 1543, -2267, 197, -889, -1153, -220, 
    -4154, 3299, -1355, -1877, -1743, -1764, 795, 790, 3207, -526, -1500, -1812, 5088, -5158, -1486, 491, 
    -551, 1358, -549, 251, -5173, -2612, -712, 2124, 2272, -2635, 1257, -1222, 1778, -1211, 191, -120, 
    2108, -1093, -3150, 1088, 807, 2496, -3103, -141, -3010, 4503, 2980, -2150, -646, -260, 4175, -2286, 
    -1446, -4360, -454, 2492, 147, -178, 2281, -1919, -2746, 4516, -335, 306, 4167, -884, -1118, 3981, 
    -369, -1426, 2246, 2120, 1964, 252, -1781, 3134, -3016, -3100, -3301, 1307, -3020, 3452, 546, -2722, 
    -1049, 626, -605, -390, 3479, 3549, 1213, -2167, -660, 1190, 345, -3149, 1246, -1297, -256, -1717, 
};

static const int16_t fx2d_paramResidualAlpha[16] = {
    2308, 8969, 330, 8414, 4203, 4810, 5656, 6931, 8166, 1088, 2606, 4023, 988, -70, 4757, 51, 
};

static const int16_t fx2d_paramSubConvolutionBias[4] = {
    576, 544, 562, 528, 
};

static const int16_t fx2d_paramSubConvolutionWeights[576] = {
    -181, -22, 9, 49, -130, -60, -138, -58, -152, -106, -85, 37, -166, -80, -129, -103, 
    786, 141, 111, -39, -155, -73, -126, -50, 201, 66, -41, -70, 100, -7, 51, 9, 
    -66, 9, -23, 19, -362, -129, -542, -81, -177, 5, -105, 16, 111, -40, 27, -73, 
    -10, -32, 47, 94, -60, 15, 27, 40, 398, 183, 165, 144, 142, -106, 180, -6, 
    443, 73, -289, -275, 286, 77, 90, -16, -536, 505, -89, -61, 209, 261, 248, 381, 
    749, 970, 150, 89, 71, -154, 135, -64, 278, 297, 202, 116, 367, 559, 247, 410, 
    55, 94, 154, 174, 160, -65, -358, -713, -9, 35, 18, 27, 127, 24, 16, -70, 
    66, -185, 75, 30, -384, -267, 159, 82, -287, 121, -336, -133, -97, -88, -48, -147, 
    -59, 48, 34, -103, -65, 15, -79, -118, 146, 63, -86, 146, -103, -183, -143, -236, 
    -74, -86, -72, -164, -58, -82, -53, -21, 79, -4, -17, -58, -82, -194, -112, -247, 
    -27, -122, -62, -102, -71, 90, -18, 12, 111, -64, 51, 35, 2, -27, -27, 123, 
    -23, 44, -15, -36, 45, -201, -1, 5, -18, 177, 97, 43, -50, 6, 17, -35, 
    -458, -160, -165, -213, 223, 45, 50, -28, -160, -157, -82, -291, 440, 129, 343, 228, 
    -30, -39, 170, -39, 185, 137, 50, 94, 249, 292, 465, 289, 602, 218, 642, 285, 
    396, 117, 388, 175, 155, 39, 371, -54, -516, 199, -111, 101, -68, 20, -88, -2, 
    -278, 481, -160, 381, -162, -35, -261, -69, 324, -194, 121, -164, 724, -1062, 303, -696, 
    -966, -1071, 1860, 1128, 1196, 1136, 1031, 806, -397, 255, -899, 1007, 2123, 1959, 1521, 1373, 
    477, -26, -396, -578, 1248, 870, 719, 312, -951, -881, -107, -5, 2110, 2014, 2467, 2366, 
    1538, 1614, 1412, 1527, -138, 91, 454, 939, -59, -267, 204, 332, 645, -853, -76, -1065, 
    333, -1240, 322, -961, 1151, 875, -119, -7, 191, 1159, -976, 31, -331, 1404, -283, 719, 
    -135, -513, -20, 492, 141, 289, 167, 342, 68, 371, 333, 77, 324, 763, 357, 630, 
    -261, -308, -327, -553, -121, 99, -24, 17, 192, -328, 265, -76, 84, 556, 302, 735, 
    131, 341, 285, 345, 7, 96, 61, 158, 141, -83, 56, -144, -363, 626, -264, -17, 
    -9, 318, 9, 354, -41, 44, 16, -317, -54, 414, -446, -13, -69, -154, -90, -87, 
    42, -27, -33, 45, -16, -9, -27, -54, 18, -34, -69, 6, -115, -84, -205, -249, 
    103, -124, 62, -127, -0, 25, -32, -27, 51, -7, 200, 189, -120, -76, 38, -65, 
    -80, -29, -86, -115, -5, 56, 58, 66, 171, 82, -428, 68, -9, -89, 52, -47, 
    133, 63, 88, 177, -2, -10, -191, -54, -26, -28, 55, -195, -112, -80, 375, -526, 
    68, -40, -213, -264, 201, 155, 165, 183, -126, 132, -112, -42, 123, 284, 326, 401, 
    180, 77, 115, -59, 129, -7, 412, 208, 112, 43, -260, -293, 226, 236, 434, 469, 
    224, 249, 363, 386, -86, -51, 43, 43, 66, 431, -504, -589, -120, -247, 452, -166, 
    25, 13, 77, -322, 39, 17, -340, -337, -192, 58, -50, 474, -27, -283, -120, 544, 
    -50, 25, -12, -86, 4, -54, -88, -127, -18, 2, 0, 215, -51, -188, -147, -156, 
    82, -11, -166, -231, -4, 12, -153, -44, 86, -8, 116, -97, -96, -154, -224, -160, 
    -4, -100, -140, -127, -55, 2, -29, 139, 95, -34, 117, -151, -104, 42, -136, 455, 
    -34, -26, -34, 54, 69, -40, -45, -364, -45, 55, 147, 268, 19, 24, 3, -3, 
};

