% Справочный указатель

## Вступление

Это приложение представляет собой многоплатформенный проигрыватель MIDI-файлов для Linux, Windows и 
macOS. Он читает .MID (стандартные файлы MIDI), .KAR (караоке) и .WRK (Cakewalk).
форматы файлов и вывод MIDI-событий на аппаратные MIDI-порты, а также на программное обеспечение 
синтезаторы.

[Drumstick](https://drumstick.sourceforge.io) - это набор GPLv3 
лицензионные библиотеки C ++ / Qt для MIDI-приложений. Проект включает в себя несколько
инструменты в качестве примеров, и среди них есть утилита drumstick-guiplayer, которая 
использует библиотеку Drumstick :: ALSA, поэтому она доступна только для Linux 
(потому что секвенсор ALSA - это технология только для Linux). У некоторых людей есть
запросил программу с такими же функциями в Windows и macOS, и 
вот. Но эта программа - это нечто большее, и она также работает на
Linux ...

Некоторые ключевые особенности:

* MIDI-выход на аппаратные MIDI-порты или любой другой бэкэнд Drumstick, например, софт
  синтезаторы
* [Транспонирование](https://ru.wikipedia.org/wiki/%D0%A2%D1%80%D0%B0%D0%BD%D1%81%D0%BF%D0%BE%D0%B7%D0%B8%D1%86%D0%B8%D1%8F_(%D0%BC%D1%83%D0%B7%D1%8B%D0%BA%D0%B0)) тональность песни 
  от -12 до +12 полутонов
* Изменить уровень громкости MIDI (используя MIDI CC7)
* Масштабируйте скорость песни от половины до удвоения 
  [темп](https://ru.wikipedia.org/wiki/%D0%A2%D0%B5%D0%BC%D0%BF_(%D0%BC%D1%83%D0%B7%D1%8B%D0%BA%D0%B0))
* Просмотр текстов песен, пианино и MIDI-каналов
* Поддерживает форматы файлов MID / KAR (стандартные файлы MIDI) и WRK (Cakewalk).

## MIDI выход

Любой MIDI-плеер выводит только MIDI-события, но без звука. Для воспроизведения звука MIDI
Синтезатор необходим для преобразования событий в цифровой звук, который может быть 
воспроизводится аудиодинамиками компьютера (или внешних). События также могут
воспроизводиться с помощью внешнего музыкального MIDI-инструмента, подключенного к компьютеру, 
например, орган MIDI, фортепиано или синтезатор с интерфейсом USB. Если это
опция недоступна, другая обычная альтернатива - программный синтезатор 
(программа).

В операционные системы компьютера включены программные синтезаторы, 
например, Microsoft Windows включает "Microsoft GS Wavetable Synth" и
Apple macOS включает «Apple DLS Synthesizer». Чтобы использовать их, вам нужно открыть
диалоговое окно «Настройка MIDI», а затем:

* В **Windows** выберите параметр «Windows MM» в первом списке и 
  «Microsoft GS Wavetable Synth» во втором списке. Вместо этого синтезатора
  который очень прост и ограничен, вы можете предпочесть лучшую / бесплатную альтернативу, например 
  [Виртуальный MIDI-синтезатор](https://coolsoft.altervista.org/en/virtualmidisynth)
  который будет отображаться как «VirtualMIDISynth #n» во втором поле списка при запуске.
  Если к компьютеру подключен внешний MIDI-инструмент, его имя
  также должен появиться во втором списке.
* В **macOS** выберите «DLS Synth» в первом и втором списках. 
  Этот синтезатор имеет возможность конфигурации для использования файлов звуковых шрифтов DLS или SF2, если 
  ты хочешь. Чтобы использовать другое подключенное MIDI-устройство или программный синтезатор,
  вам нужно выбрать «CoreMIDI» в первом списке и имя вашего
  synth во втором.
* В **Linux** и других **Unix** операционных системах "SonivoxEAS" является программным 
  синтезатор готов к использованию. Это очень простой синтезатор GM, который не использует файлы.
  и зависит только от звуковой системы PulseAudio. Для подключенных внешних устройств
  к компьютеру или произвольным программным синтезаторам необходимо выбрать «ALSA» (или «OSS») 
  в первом списке.
* **FluidSynth** - еще один мультиплатформенный синтезатор с открытым программным обеспечением. 
  и доступен во всех операционных системах. Это очень настраиваемый, принимающий
  файлы soundfont и многие цифровые аудиосистемы. Выбирать
  [FluidSynth](https://github.com/FluidSynth/fluidsynth) в обоих списках 
  использовать это.
* **Network** - это многоплатформенный выход UDP Multicast, который может использоваться для отправки 
  MIDI-события в виде сетевых пакетов для других компьютеров и устройств в том же 
  локальная сеть. Он совместим с
  [ipMIDI](https://www.nerds.de/en/ipmidi.html),
  [QmidiNet](https://qmidinet.sourceforge.io/) и 
  [multimidicast](https://llg.cubic.org/tools/multimidicast/) 
  среди прочего программного обеспечения.

## Элементы управления воспроизведением

Следующие стандартные действия доступны в меню `Файл`, а также
панель инструментов с обычными функциями любого медиаплеера: 

* `Играть` 
* `Пауза` (и продолжить)
* `Стоп`, 
* «Быстрая перемотка вперед» (на 1 бар)
* `Rewind` (на 1 бар)

По умолчанию `Play` активируется автоматически при загрузке MIDI-файла, кроме 
когда эта функция отключена в диалоговом окне конфигурации.

Строка состояния, необязательно расположенная в нижней части главного окна, показывает 
текущий статус воспроизведения: «Воспроизведение», «Остановлено», «Приостановлено» и т. д.

### Транспонировать

Элемент управления высотой тона находится в главном окне. Это инициализированное поле счетчика
до нуля с допустимым диапазоном от -12 до +12 полутонов. Пределы эквивалентны
на одну октаву выше или ниже исходного тона. Этого должно хватить певцам
или инструменталисты, которым нужно настроить тональность для своего комфорта.

Все MIDI-каналы хроматически транспонированы, кроме перкуссионного канала. 
(GM канал 10 по умолчанию).

### Уровень громкости
 
«Регулятор громкости» находится в главном окне. Это слайдер, инициализированный
до 100% с допустимым диапазоном от 0% до 200%. Эффект верхнего предела может быть ниже
потому что MIDI CC 7 имеет допустимый диапазон от 0 до 127. Также есть кнопка для
`Сбросить громкость`.
 
### Темп

«Контроль темпа» находится в главном окне. Это инициализированный слайдер
до 100% с допустимым диапазоном от 50% до 200%. Есть кнопка `Reset Tempo`
а также дисплей темпа, показывающий эффективный темп в ударах в минуту с
начальное значение 120 ударов в минуту. Это темп по умолчанию для файла MIDI, если он
не содержит изменения темпа. Это значение обновляется при изменении
управление темпом, а также во время воспроизведения MIDI-файла, содержащего изменения темпа.

### Прыжок, петля и позиционирование

Действие «Перейти» (находится в меню «Файл» и на панели инструментов по умолчанию), запрашивает
номер такта между 1 и последним тактом загруженной песни, чтобы изменить 
текущая позиция песни в данном баре.

Действие «Loop» (находится в меню «Файл» и на панели инструментов по умолчанию), запрашивает
два номера столбца. Песня будет воспроизводиться между двумя заданными тактами, когда она
активирован. Вы можете выключить цикл в любой момент, выбрав действие еще раз.

Элемент управления позиционированием находится в главном окне. Это слайдер, который
перемещается при изменении текущей позиции, и может быть перемещен вручную в
изменить позицию на любую произвольную точку в песне.

## Взгляды

В меню «Вид» доступны следующие параметры:

Три вида - это независимые окна, которые вы можете открывать и закрывать по своему усмотрению. 
удобство: каналы, тексты песен и пианино.

С другой стороны, вы также можете скрыть или показать еще три встроенных представления. 
в главном окне: Панель инструментов, Строка состояния и Ритм.

### Каналы

В этом окне отображается до 16 строк, по одной для каждого MIDI-канала, используемого текущим
MIDI файл. Столбцы:

* Номер MIDI-канала и текст (редактируемый). Обычно название инструмента или
  краткое описание взято из метаданных файла.
* Кнопка выключения звука. С помощью этой опции текущий канал может быть отключен.
* Сольная кнопка. Увеличивает громкость текущего канала, понижая при этом
  другие каналы.
* Уровень. Индикатор активности на текущем канале.
* Замок. Эта кнопка фиксирует патч на текущем канале, предотвращая изменения
  хранится в файле.
* Пластырь. Соответствует событиям изменения программы MIDI в соответствии с Общими
  Список MIDI с названиями инструментов.

### Пианист

В этом окне отображается до 16 строк, по одной для каждого MIDI-канала, используемого текущим
MIDI файл. Каждая строка содержит:

* Номер канала и текст (те же данные, что и в окне каналов)
* Клавиатура пианино. Клавиши будут выделены цветом, который можно полностью
  настраиваются событиями нот MIDI, воспроизводимыми текущим файлом MIDI. Это может
  также при желании показать имена заметок. Ключи могут быть активированы
  вручную с помощью компьютерной клавиатуры и мыши

Есть меню окна со следующими опциями:

* Просмотр в полноэкранном режиме. Увеличивает окно, заполняющее текущий монитор
* Показать все каналы
* Скрыть все каналы
* Затяните количество ключей. По умолчанию на каждой клавиатуре отображается 88 клавиш, начиная с A0.
  в C8. Используя эту опцию, клавиатура действительно использует только количество октав.
  используется файлом MIDI, который обычно представляет собой меньшее число
* До 16 вариантов каналов, чтобы скрыть или показать каждый канал индивидуально. По
  по умолчанию выбраны все MIDI-каналы, используемые в текущем MIDI-файле.

### Текст песни

В этом окне отображаются текстовые метаданные из загруженного файла MIDI с фильтрацией 
данные с рядом элементов управления, расположенных на панели инструментов окна:

* Дорожка: список для выбора из «Все дорожки» или одного элемента, соответствующего
  каждая использованная дорожка в загруженном MIDI-файле. Этот номер трека заменяет
  концепция MIDI-канала в этом окне, потому что текстовые метаданные не имеют 
  атрибут канала, но он всегда принадлежит некоторому треку. По умолчанию
  дорожка, содержащая больше данных, выбирается автоматически
* Тип: поле со списком для выбора одного из типов текста метаданных или их всех. В
  Тип Lyric Events - наиболее вероятный выбор
* Кодировка: кодировка текста определяется автоматически, но в некоторых случаях
  обнаружение может быть неверным, поэтому правильный можно выбрать вручную

Есть меню окна со следующими опциями:

* Копировать в буфер обмена: копирует метаданные, отображаемые в данный момент в окне.
* Сохранить в файл ... После открытия диалогового окна "Сохранить файл" этот параметр создает текст 
  файл на диске, с текстом, отображаемым окном, и выбранной кодировкой
* Печать ... После открытия диалогового окна печати эта опция печатает текст, показанный
  окно на выбранном принтере
* Полный экран: увеличивает окно, заполняющее текущий монитор.
* Шрифт ... Открывает окно выбора шрифта, чтобы выбрать типографику и размер для
  текст окна

## Плейлисты

Списки воспроизведения - это наборы имен файлов, которые можно использовать для воспроизведения серии 
MIDI-пьес, как музыкальный «репертуар».

Действие `Файл`->` Список воспроизведения ... `управляет созданием, изменением, упорядочиванием, 
открытие и сохранение файлов списка воспроизведения. В этом окне отображается текущий список воспроизведения.
имя файла в заголовке окна.

Действия `File`->` Next` и `File`->` Prev` используются для навигации по плейлисту.
вручную вперед и назад. Есть параметры конфигурации для начала воспроизведения
автоматически после загрузки файлов MIDI и автоматически переходить к следующему 
элемент списка воспроизведения после завершения воспроизведения текущего элемента. Оба варианта конфигурации
включены по умолчанию.

Первоначальный список воспроизведения по умолчанию содержит набор примеров файлов MIDI. Если
вы предпочитаете начинать с пустого списка, вам следует использовать кнопку «Очистить» и
затем сохраните пустой список воспроизведения со значимым именем. Это будет новый
начальный плейлист в будущем.

Последний открытый или сохраненный файл списка воспроизведения должен быть запомнен в следующий раз, когда 
программа запускается, но списки воспроизведения не сохраняются автоматически.

Списки воспроизведения - это простые текстовые файлы с именем файла в каждой текстовой строке. Файл
имена могут быть относительно местоположения самого файла списка воспроизведения (поэтому они 
не иметь в начале абсолютного пути) или каждый файл может иметь абсолютный путь на 
свой собственный.

У вас может быть несколько плейлистов, которые можно легко создать вне 
программа, например, в командной строке Linux эта команда создает список воспроизведения 
файл с именем "my_playlist.lst" со всеми файлами MIDI, расположенными в рабочем 
каталог:

~~~
$ ls -1 * .mid> my_playlist.lst
~~~

## Открытие файлов MIDI

Вы можете открывать отдельные файлы ...

* Использование стандартного действия «Файл» -> «Открыть»
* Использование меню «Файл» -> «Открыть последние файлы», которое запоминает до десяти файлов. 
  недавно открылся.
* Указание имени (имен) файла в командной строке. Набор файлов становится
  временный список воспроизведения. Это позволяет легко интегрировать программу с файлом
  менеджеры, использующие действия "Открыть с помощью ...".
* Перетаскивание файлов из файлового менеджера в главное окно. В
  набор файлов становится временным списком воспроизведения.

## Настройка

### Настройки

Для инициализации всех параметров в этом диалоговом окне есть кнопка «Восстановить настройки по умолчанию».
к их значениям по умолчанию.

Есть три вкладки, группирующие параметры конфигурации.

#### Общий

* Перкуссионный MIDI-канал: номер от 1 до 16. По умолчанию 10, соответствует
  Стандартный перкуссионный канал General MIDI
* Автоматическое начало воспроизведения после загрузки. Включено по умолчанию
* Автоматический переход к следующему элементу списка воспроизведения. Включено по умолчанию
* Принудительный темный режим. Может быть полезно в Windows. В Linux и macOS темный режим
  автоматически применяется при настройке в операционной системе
* Используйте внутреннюю тему значков. Этот параметр необходим в Windows и macOS.
* Стиль виджетов Qt. В зависимости от операционной системы влияет на визуальный
  интеграция с другими программами
* Эксклюзивный сброс системы MIDI. Игрок отправляет это сообщение незадолго до старта.
  воспроизведение каждого файла MIDI 

#### Текст песни

* Шрифт текста. Открывает окно выбора шрифта, чтобы выбрать типографику и размер для
  текст окна. Этот параметр также доступен в меню окна текста песен.
* Будущий цвет текста. Этот параметр применяется к тексту, который не воспроизводился.
* Прошлый цвет текста. Этот параметр применяется к уже проигранному тексту.

#### Игрок Фортепиано

* Подсветка заметок. Доступно несколько палитр подсветки.
* Одиночный цвет выделения. Когда выбрана одноцветная палитра выделения,
  эта настройка - цвет выделения заметки
* Обратите внимание на скорость цветового оттенка. С этой опцией скорость событий MIDI-ноты
  атрибут используется для придания цвету мелирования более светлого или более темного тона
* Обратите внимание на шрифт имен. Открывает окно выбора шрифта, чтобы выбрать типографику и
  размер названий заметок
* Показывать названия заметок: доступные варианты: «Никогда», «Минимум», «При активации», «Всегда».
  Параметр Minimal показывает только названия клавиш C.

### Настройка панели инструментов

Панель инструментов расположена в главном окне, которое обычно очень маленькое. 
доступное пространство и может быть перемещен в верхнюю или нижнюю часть окна, а также 
также вне его. Действия, доступные в виде кнопок инструментов, можно настроить в
это диалоговое окно. Все действия также являются пунктами главного меню.

* Доступные действия: показывает список действий, которые в настоящее время не отображаются как
  кнопки инструментов
* Выбранные действия: это список выбранных в данный момент кнопок инструментов.

Чтобы выбрать одно действие из списка Доступные, сначала выберите его мышью и 
затем нажмите кнопку «добавить». Действие удаляется из списка доступных и
помещается в конец выбранного списка.

Чтобы убрать одну кнопку с панели инструментов, выберите ее мышью в выбранном 
list, а затем нажмите кнопку «удалить».

Чтобы изменить порядок кнопок на панели инструментов, используйте клавиши «вверх» и «вниз». 
кнопки после выбора элемента в списке «Выбранное».

Стиль кнопок инструментов: содержит следующие параметры, применимые ко всем 
кнопки на панели инструментов

* Только значок
* Только текст
* Текст рядом со значком
* Текст под значком
* Follow Style: настройка определяется настройкой "Qt Widgets Style".
  в диалоговом окне «Настройки».

