/*	Copyright (C) 2018-2024 Martin Guy <martinwguy@gmail.com>
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * usage.c: Help messages
 */
#include "spettro.h"
#include "usage.h"

char *usage_keys[] = {
"Space      Play/Pause/Resume/Restart the audio player",
"n          Play the next audio file",
"p          Make it pause at the end of the audio file and replay on [Space]",
"P          Turn autoplay back on",
"Left/Right Skip back/forward by a tenth of a screenful",
"           Shift: by a screenful; Ctrl: by one pixel; Shift-Ctrl: by one second",
"Up/Down    Pan up/down the frequency axis by a tenth of a screenful",
"           Shift: by a screenful; Ctrl: by one pixel; Shift-Ctrl: by a semitone",
"PgUp/PgDn  Pan up/down the frequency axis by a screenful, like Shift-Up/Down",
"X/x        Zoom in/out by a factor of two on the time axis",
"Y/y        Zoom in/out by a factor of two on the frequency axis",
"           With Ctrl, zoom in/out by two pixels: one at top, one at bottom",
"D/d        Move the green line right/left by one pixel",
"c          Cycle through the color maps: heatmap/grayscale/gray-for-printers",
"z/Z        Decrease/increase the contrast by 6dB (by 1dB if Ctrl is held down)",
"i/I        Decrease/increase the brightness by 1dB (by 1/6th dB with Ctrl)",
"f/F        Halve/double the length of the sample taken to calculate each column",
"Ctrl K/D/N/B/H  Set the window function to Kaiser/Dolph/Nuttall/Blackman/Hann",
"Ctrl w/W   Cycle forward/backward through the window functions",
"Ctrl F     Toggle full-screen mode",
"a          Toggle the frequency axes",
"A          Toggle the time axis and status line",
"k          Toggle the overlay of frequencies of a grand piano's 88 keys",
"s          Toggle the overlay of conventional score notation's staff lines",
"g          Toggle the overlay of frequencies of a classical guitar's strings",
"l/r        Set the left/right bar marker for an overlay of bar lines",
"1-9/F1-F12 Set the number of beats per bar (1 or F1 means \"no beat lines\")",
"0          Remove the bar lines",
"+/-        Increase/decrease the soft volume control",
"o          Output (save) the current screenful into a PNG file",
"Ctrl O     Output the region between the left and right bar lines as a WAV file",
"Ctrl P     Print lots of info on the console about the current settings",
"Ctrl L     Redraw the display from the already-calculated results",
"Ctrl R     Redraw the display by recalculating everything from the audio data",
"q/Ctrl Q   Quit",
NULL
};
