import os.path
from setuptools import setup
from setuptools.command.build_py import build_py
from setuptools.command.sdist import sdist
from versioningit import get_cmdclasses


class MySdist(sdist):
    def make_release_tree(self, base_dir, files):
        super().make_release_tree(base_dir, files)
        with open(os.path.join(base_dir, "generated.txt"), "w") as fp:
            print("This was generated by a custom sdist command.", file=fp)


class MyBuildPy(build_py):
    def run(self):
        super().run()
        with open(os.path.join(self.build_lib, "generated.txt"), "w") as fp:
            print("This was generated by a custom build_py command.", file=fp)


setup(cmdclass=get_cmdclasses({"sdist": MySdist, "build_py": MyBuildPy}))
