/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;

public class FilterModelProvider {
    protected static Logger logger = Logger.getLogger(FilterModelProvider.class.getName());
    protected String fFilterPropertyName = "filter";
    protected static IChoiceSet choiceSet = ChoiceSetFactory.getStructChoiceSet("FilterCondition", "operator");
    private List columnList;
    protected static final String[] EMPTY = new String[0];

    public String[] getColumnNames(String[] keys) {
        assert (keys != null);
        String[] columnNames = new String[keys.length];
        int i = 0;
        while (i < keys.length) {
            IStructureDefn structure = DEUtil.getMetaDataDictionary().getStructure("FilterCondition");
            columnNames[i] = structure.getMember(keys[i]).getDisplayName();
            ++i;
        }
        return columnNames;
    }

    public Object[] getElements(List input) {
        Object obj = input.get(0);
        if (!(obj instanceof DesignElementHandle)) {
            return EMPTY;
        }
        DesignElementHandle element = (DesignElementHandle)obj;
        PropertyHandle propertyHandle = element.getPropertyHandle(this.fFilterPropertyName);
        Iterator iterator = propertyHandle.iterator();
        if (iterator == null) {
            return EMPTY;
        }
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list.toArray();
    }

    public String getText(Object element, String key) {
        if (!(element instanceof StructureHandle)) {
            return "";
        }
        String value = ((StructureHandle)element).getMember(key).getStringValue();
        if (value == null) {
            value = "";
        }
        if (key.equals("operator")) {
            IChoice choice = choiceSet.findChoice(value);
            if (choice != null) {
                return choice.getDisplayName();
            }
        } else {
            return value;
        }
        return "";
    }

    public boolean setStringValue(Object item, Object element, String key, String newValue) throws NameException, SemanticException {
        String value;
        if (!key.equals("operator") && (value = DEUtil.getExpression((Object)this.getResultSetColumn(newValue))) != null) {
            newValue = value;
        }
        String saveValue = newValue;
        StructureHandle handle = (StructureHandle)element;
        if (key.equals("operator")) {
            IChoice choice = choiceSet.findChoiceByDisplayName(newValue);
            saveValue = choice == null ? null : choice.getName();
        }
        handle.getMember(key).setStringValue(saveValue);
        return true;
    }

    public String[] getChoiceSet(Object item, String key) {
        if (key.equals("operator")) {
            choiceSet = ChoiceSetFactory.getStructChoiceSet("FilterCondition", key);
            return ChoiceSetFactory.getDisplayNamefromChoiceSet(choiceSet);
        }
        if (!(item instanceof DesignElementHandle)) {
            return EMPTY;
        }
        return this.getDataSetColumns((DesignElementHandle)item);
    }

    private String[] getDataSetColumns(DesignElementHandle handle) {
        this.columnList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)handle);
        if (this.columnList.isEmpty()) {
            return EMPTY;
        }
        String[] values = new String[this.columnList.size()];
        int i = 0;
        while (i < this.columnList.size()) {
            values[i] = ((ComputedColumnHandle)this.columnList.get(i)).getName();
            ++i;
        }
        return values;
    }

    private Object getResultSetColumn(String name) {
        if (this.columnList.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < this.columnList.size()) {
            ComputedColumnHandle column = (ComputedColumnHandle)this.columnList.get(i);
            if (column.getName().equals(name)) {
                return column;
            }
            ++i;
        }
        return null;
    }

    public boolean moveItem(Object item, int oldPos, int newPos) throws PropertyValueException {
        DesignElementHandle element = (DesignElementHandle)item;
        PropertyHandle propertyHandle = element.getPropertyHandle(this.fFilterPropertyName);
        propertyHandle.moveItem(oldPos, newPos);
        return true;
    }

    public boolean deleteItem(Object item, int pos) throws PropertyValueException {
        DesignElementHandle element = (DesignElementHandle)item;
        PropertyHandle propertyHandle = element.getPropertyHandle(this.fFilterPropertyName);
        if (propertyHandle.getAt(pos) != null) {
            propertyHandle.removeItem(pos);
        }
        try {
            if (propertyHandle.getListValue() == null || propertyHandle.getListValue().size() == 0) {
                element.setProperty(this.fFilterPropertyName, null);
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        return true;
    }

    public boolean doAddItem(Object item, int pos) throws SemanticException {
        return true;
    }
}

