/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.action;

import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.gef.ui.actions.Clipboard;

public class CopyCrosstabCellContentsAction
extends AbstractViewAction {
    public static final String ID = CopyCrosstabCellContentsAction.class.getName();

    public CopyCrosstabCellContentsAction(Object selectedObject) {
        super(selectedObject, Messages.getString((String)"CopyCellContentsContextAction.actionText"));
        this.setId(ID);
    }

    public void run() {
        Object cloneElements = null;
        if (this.getSelection() instanceof ExtendedItemHandle) {
            PropertyHandle container = ((ExtendedItemHandle)this.getSelection()).getPropertyHandle("content");
            cloneElements = DNDUtil.cloneSource((Object)container.getContents().toArray());
        }
        if (this.getSelection() instanceof CrosstabCellHandle) {
            cloneElements = ((CrosstabCellHandle)this.getSelection()).getContents().toArray();
        }
        if (cloneElements != null) {
            Clipboard.getDefault().setContents(cloneElements);
        }
    }

    public boolean isEnabled() {
        if (this.canCopy(this.getSelection())) {
            return super.isEnabled();
        }
        return false;
    }

    private boolean canCopy(Object selection) {
        if (selection instanceof ExtendedItemHandle) {
            return ((ExtendedItemHandle)selection).getPropertyHandle("content").getContentCount() > 0;
        }
        if (selection instanceof CrosstabCellHandle) {
            return ((CrosstabCellHandle)selection).getContents().size() > 0;
        }
        return false;
    }
}

