/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb;

import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;

public class ToggleBreadcrumbAction
extends Action
implements IPropertyChangeListener,
IPerspectiveListener {
    private IPreferenceStore fStore;
    private IWorkbenchPage fPage;

    public ToggleBreadcrumbAction(IWorkbenchPage page) {
        super(null, 2);
        this.setToolTipText(Messages.getString((String)"ToggleBreadcrumbAction.tooltip.switch.breadcrumb"));
        this.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor("ToggleBreadcrumb"));
        this.setDisabledImageDescriptor(ReportPlatformUIImages.getImageDescriptor("DisableToggleBreadcrumb"));
        this.fPage = page;
        this.fPage.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
        this.update();
    }

    public void run() {
        this.fStore.setValue(this.getPreferenceKey(), this.isChecked());
    }

    public void update() {
        String key;
        if (this.fStore == null) {
            this.fStore = ReportPlugin.getDefault().getPreferenceStore();
            this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
        }
        this.setChecked((key = this.getPreferenceKey()) != null && this.fStore.getBoolean(key));
        this.setEnabled(true);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(this.getPreferenceKey())) {
            this.setChecked(Boolean.parseBoolean(event.getNewValue().toString()));
        }
    }

    public void dispose() {
        if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        if (this.fPage != null) {
            this.fPage.getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this);
            this.fPage = null;
        }
    }

    private String getPreferenceKey() {
        IPerspectiveDescriptor perspective = this.fPage.getPerspective();
        if (perspective == null) {
            return null;
        }
        return "breadcrumb." + perspective.getId();
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        boolean isChecked = this.fStore.getBoolean(this.getPreferenceKey());
        if (isChecked != this.isChecked()) {
            Boolean value = isChecked;
            this.fStore.firePropertyChangeEvent(this.getPreferenceKey(), (Object)value, (Object)value);
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }
}

