/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.actions.cheatsheets;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.layout.ReportLayoutEditor;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.editors.MultiPageReportEditor;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.AbstractEditPartViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;
import org.eclipse.ui.forms.editor.FormEditor;

public abstract class TemplateBaseAction
extends Action
implements ICheatSheetAction {
    protected EditPart selection;
    protected String[] params;

    public void run(String[] params, ICheatSheetManager manager) {
        this.params = params;
        FormEditor editor = UIUtil.getActiveReportEditor();
        if (editor instanceof MultiPageReportEditor) {
            ((MultiPageReportEditor)editor).setActivePage("org.eclipse.birt.report.designer.ui.editors.layout");
            ReportLayoutEditor reportDesigner = (ReportLayoutEditor)((MultiPageReportEditor)editor).getActivePageInstance();
            AbstractEditPartViewer viewer = (AbstractEditPartViewer)reportDesigner.getGraphicalViewer();
            this.selectEditPartForItemName(params[0], (MultiPageReportEditor)editor, viewer);
            this.selection = this.matchSelectionType(viewer);
            if (this.selection != null) {
                IAction action = this.getAction(reportDesigner);
                if (action != null && action.isEnabled()) {
                    action.run();
                }
            } else {
                this.showErrorWrongElementSelection();
            }
        } else {
            this.showErrorWrongEditor();
        }
    }

    protected void showErrorWrongEditor() {
    }

    protected abstract void showErrorWrongElementSelection();

    protected EditPart matchSelectionType(AbstractEditPartViewer viewer) {
        EditPart part = null;
        List editParts = viewer.getSelectedEditParts();
        for (Object iterEditPart : editParts) {
            if (!this.checkType(iterEditPart.getClass())) continue;
            part = (EditPart)iterEditPart;
            break;
        }
        return part;
    }

    protected abstract boolean checkType(Class var1);

    protected void selectEditPartForItemName(String itemName, MultiPageReportEditor editor, AbstractEditPartViewer viewer) {
        EditPart editPart;
        ModuleHandle reportDesign = editor.getModel();
        DesignElementHandle elementHandle = reportDesign.findElement(itemName);
        if (elementHandle != null && (editPart = (EditPart)viewer.getEditPartRegistry().get(elementHandle)) != null) {
            viewer.select(editPart);
        }
    }

    protected abstract IAction getAction(ReportLayoutEditor var1);
}

