/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editors;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.ui.editors.MultiPageReportEditor;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.command.LibraryChangeEvent;
import org.eclipse.birt.report.model.api.command.ResourceChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.PartInitException;

public class RCPMultiPageReportEditor
extends MultiPageReportEditor {
    public static final String REPROT_EDITOR_ID = "org.eclipse.birt.report.designer.ui.editors.ReportEditor";
    public static final String TEMPLATE_EDITOR_ID = "org.eclipse.birt.report.designer.ui.editors.TemplateEditor";
    public static final String LIBRARY_EDITOR_ID = "org.eclipse.birt.report.designer.ui.editors.LibraryEditor";

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
    }

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        try {
            this.refreshMarkers(this.getEditorInput());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void doSaveAs() {
        super.doSaveAs();
        String resource = new Path(this.getModel().getFileName()).removeLastSegments(1).toOSString();
        this.getModel().setResourceFolder(resource);
        SessionHandleAdapter.getInstance().getSessionHandle().fireResourceChange((ResourceChangeEvent)new LibraryChangeEvent(this.getModel().getFileName()));
    }

    public void refreshMarkers(IEditorInput input) throws CoreException {
        ModuleHandle reportDesignHandle = this.getModel();
        if (reportDesignHandle != null) {
            reportDesignHandle.checkReport();
        }
    }
}

