/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.UnitPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;

public class CrosstabCellHeightProvider
extends UnitPropertyDescriptorProvider {
    public CrosstabCellHeightProvider(String property, String element) {
        super(property, element);
    }

    public Object load() {
        String text = null;
        try {
            ExtendedItemHandle handle = (ExtendedItemHandle)DEUtil.getInputFirstElement((Object)this.input);
            if (handle.getReportItem() instanceof CrosstabCellHandle) {
                CrosstabCellHandle cell = (CrosstabCellHandle)handle.getReportItem();
                text = cell.getCrosstab().getRowHeight(cell).getStringValue();
            }
        }
        catch (Exception e) {
            ExceptionUtil.handle((Throwable)e);
        }
        if (text == null) {
            return "";
        }
        return text;
    }

    public void save(Object value) throws SemanticException {
        DimensionValue dimensionValue = null;
        if (value != null) {
            dimensionValue = DimensionValue.parse((String)value.toString());
        }
        try {
            ExtendedItemHandle handle = (ExtendedItemHandle)DEUtil.getInputFirstElement((Object)this.input);
            if (handle.getReportItem() instanceof CrosstabCellHandle) {
                CrosstabCellHandle cell = (CrosstabCellHandle)handle.getReportItem();
                cell.getCrosstab().setRowHeight(cell, dimensionValue);
            }
        }
        catch (Exception e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }
}

