/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api.querydefn;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryExecutionHints;
import org.eclipse.birt.data.engine.api.querydefn.BaseTransform;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryExecutionHints;
import org.eclipse.birt.data.engine.core.DataException;

public abstract class BaseQueryDefinition
extends BaseTransform
implements IBaseQueryDefinition {
    protected List groups = new ArrayList();
    protected boolean hasDetail = true;
    private IDataQueryDefinition parentDataQuery;
    protected IBaseQueryDefinition parentQuery;
    protected int maxRowCount = 0;
    protected int startingRow = 0;
    protected boolean distinctValue = false;
    private boolean cacheQueryResults = false;
    private Map resultExprsMap = new LinkedHashMap();
    private Map bindingMap = new LinkedHashMap();
    private IQueryExecutionHints queryExecutionHints = new QueryExecutionHints();
    private String name;
    private boolean isTempQuery = false;

    BaseQueryDefinition(IDataQueryDefinition parent) {
        this.parentDataQuery = parent;
        if (parent instanceof IBaseQueryDefinition) {
            this.parentQuery = (IBaseQueryDefinition)parent;
        }
    }

    @Override
    public List getGroups() {
        return this.groups;
    }

    public void addGroup(GroupDefinition group) {
        this.groups.add(group);
    }

    @Override
    public boolean usesDetails() {
        return this.hasDetail;
    }

    public void setUsesDetails(boolean usesDetails) {
        this.hasDetail = usesDetails;
    }

    @Override
    public IBaseQueryDefinition getParentQuery() {
        return this.parentQuery;
    }

    public IDataQueryDefinition getParentDataQuery() {
        return this.parentDataQuery;
    }

    @Override
    public int getMaxRows() {
        return this.maxRowCount;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRowCount = maxRows;
    }

    public void setStartingRow(int startingRow) {
        this.startingRow = startingRow;
    }

    @Override
    public int getStartingRow() {
        return this.startingRow;
    }

    public void setDistinctValue(boolean distinctValue) {
        this.distinctValue = distinctValue;
    }

    @Override
    public boolean getDistinctValue() {
        return this.distinctValue;
    }

    @Deprecated
    public void addResultSetExpression(String name, IBaseExpression expression) {
        Binding binding = new Binding(name);
        binding.setExpression(expression);
        if (expression != null) {
            binding.setDataType(expression.getDataType());
        }
        this.bindingMap.put(name, binding);
    }

    @Override
    public void addBinding(IBinding binding) throws DataException {
        String bindingName;
        if (binding.getExpression() != null && binding.getExpression().getGroupName().equals("Total.OVERALL")) {
            binding.getExpression().setGroupName(null);
        }
        if (this.bindingMap.containsKey(bindingName = binding.getBindingName())) {
            throw new DataException("data.engine.DuplicatedBindingName", bindingName);
        }
        this.bindingMap.put(bindingName, binding);
    }

    @Override
    public Map getBindings() {
        Iterator it = this.resultExprsMap.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            IBaseExpression expr = (IBaseExpression)this.resultExprsMap.get(key);
            if (this.bindingMap.get(key) != null) continue;
            Binding binding = new Binding(key);
            binding.setExpression(expr);
            this.bindingMap.put(key, binding);
        }
        return this.bindingMap;
    }

    @Override
    public Map getResultSetExpressions() {
        return this.resultExprsMap;
    }

    @Override
    public boolean cacheQueryResults() {
        return this.cacheQueryResults;
    }

    public void setCacheQueryResults(boolean cacheQueryResults) {
        this.cacheQueryResults = cacheQueryResults;
    }

    public void setQueryExecutionHints(IQueryExecutionHints hints) {
        this.queryExecutionHints = hints;
    }

    @Override
    public IQueryExecutionHints getQueryExecutionHints() {
        return this.queryExecutionHints;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setAsTempQuery() {
        this.isTempQuery = true;
    }

    public boolean isTempQuery() {
        return this.isTempQuery;
    }

    protected void cloneFields(BaseQueryDefinition clone) {
        clone.groups.addAll(this.groups);
        clone.hasDetail = this.hasDetail;
        if (this.parentQuery instanceof IQueryDefinition) {
            clone.parentQuery = ((IQueryDefinition)this.parentQuery).clone();
        }
        clone.maxRowCount = this.maxRowCount;
        clone.startingRow = this.startingRow;
        clone.distinctValue = this.distinctValue;
        clone.cacheQueryResults = this.cacheQueryResults;
        clone.resultExprsMap.putAll(this.resultExprsMap);
        clone.bindingMap.putAll(this.bindingMap);
        clone.queryExecutionHints = this.queryExecutionHints;
        clone.name = this.name;
        clone.isTempQuery = this.isTempQuery;
    }
}

