/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.document.IRandomDataAccessObject;
import org.eclipse.birt.data.engine.olap.data.util.Bytes;

public class DocumentObject
implements IDocumentObject {
    IRandomDataAccessObject delegate = null;
    private static Logger logger = Logger.getLogger(DocumentObject.class.getName());

    DocumentObject(IRandomDataAccessObject randomAccessObject) throws IOException {
        this.delegate = randomAccessObject;
    }

    @Override
    public long getFilePointer() {
        try {
            return this.delegate.getFilePointer();
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return -1L;
        }
    }

    @Override
    public long length() throws IOException {
        return this.delegate.length();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.delegate.readBoolean();
    }

    @Override
    public BigDecimal readBigDecimal() throws IOException {
        if (this.delegate.readByte() == 0) {
            return null;
        }
        return this.delegate.readBigDecimal();
    }

    @Override
    public int read(byte[] b, int pos, int len) throws IOException {
        return this.delegate.read(b, pos, len);
    }

    @Override
    public Date readDate() throws IOException {
        if (this.delegate.readByte() == 0) {
            return null;
        }
        return this.delegate.readDate();
    }

    @Override
    public double readDouble() throws IOException {
        return this.delegate.readDouble();
    }

    @Override
    public int readInt() throws IOException {
        return this.delegate.readInt();
    }

    @Override
    public int readShort() throws IOException {
        return this.delegate.readShort();
    }

    @Override
    public String readString() throws IOException {
        if (this.delegate.readByte() == 0) {
            return null;
        }
        return this.delegate.readUTF();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.delegate.seek(pos);
    }

    @Override
    public void setLength(long newLength) throws IOException {
        this.delegate.setLength(newLength);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.delegate.skipBytes(n);
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        this.delegate.writeBoolean(b);
    }

    @Override
    public void writeBigDecimal(BigDecimal value) throws IOException {
        if (value == null) {
            this.delegate.writeByte(0);
            return;
        }
        this.delegate.writeByte(1);
        this.delegate.writeBigDecimal(value);
    }

    @Override
    public void write(byte[] b, int pos, int len) throws IOException {
        this.delegate.write(b, pos, len);
    }

    @Override
    public void writeDate(Date value) throws IOException {
        if (value == null) {
            this.delegate.writeByte(0);
            return;
        }
        this.delegate.writeByte(1);
        this.delegate.writeDate(value);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.delegate.writeDouble(value);
    }

    @Override
    public void writeShort(int value) throws IOException {
        this.delegate.writeShort(value);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.delegate.writeInt(value);
    }

    @Override
    public void writeString(String value) throws IOException {
        if (value == null) {
            this.delegate.writeByte(0);
            return;
        }
        this.delegate.writeByte(1);
        this.delegate.writeUTF(value);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public byte readByte() throws IOException {
        return this.delegate.readByte();
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.delegate.writeByte(b);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public Bytes readBytes() throws IOException {
        if (this.delegate.readByte() == 0) {
            return null;
        }
        return this.delegate.readBytes();
    }

    @Override
    public void writeBytes(Bytes b) throws IOException {
        if (b == null) {
            this.delegate.writeByte(0);
            return;
        }
        this.delegate.writeByte(1);
        this.delegate.writeBytes(b);
    }

    @Override
    public Object readObject() throws IOException {
        if (this.delegate.readByte() == 0) {
            return null;
        }
        return this.delegate.readObject();
    }

    @Override
    public void writeObject(Object o) throws IOException {
        if (o == null) {
            this.delegate.writeByte(0);
            return;
        }
        this.delegate.writeByte(1);
        this.delegate.writeObject(o);
    }
}

