/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal.instance;

import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.instance.IScriptStyle;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;

public class StyleInstance
implements IScriptStyle {
    private IStyle style;
    private RunningState runningState;

    public StyleInstance(IStyle style, RunningState runningState) {
        this.style = style;
        this.runningState = runningState;
    }

    @Override
    public String getVisibleFormat() {
        return this.style.getVisibleFormat();
    }

    @Override
    public void setVisibleFormat(String format) {
        this.style.setVisibleFormat(format);
    }

    @Override
    public String getLetterSpacing() {
        return this.style.getLetterSpacing();
    }

    @Override
    public void setLetterSpacing(String spacing) {
        this.checkWritable();
        this.style.setLetterSpacing(spacing);
    }

    @Override
    public String getLineHeight() {
        return this.style.getLineHeight();
    }

    @Override
    public void setLineHeight(String lineHeight) {
        this.checkWritable();
        this.style.setLineHeight(lineHeight);
    }

    @Override
    public String getTextAlign() {
        return this.style.getTextAlign();
    }

    @Override
    public void setTextAlign(String align) {
        this.checkWritable();
        this.style.setTextAlign(align);
    }

    @Override
    public String getTextIndent() {
        return this.style.getTextIndent();
    }

    @Override
    public void setTextIndent(String indent) {
        this.checkWritable();
        this.style.setTextIndent(indent);
    }

    @Override
    public String getTextTransform() {
        return this.style.getTextTransform();
    }

    @Override
    public void setTextTransform(String transform) {
        this.checkWritable();
        this.style.setTextTransform(transform);
    }

    @Override
    public String getVerticalAlign() {
        return this.style.getVerticalAlign();
    }

    @Override
    public void setVerticalAlign(String valign) {
        this.checkWritable();
        this.style.setVerticalAlign(valign);
    }

    @Override
    public String getWhiteSpace() {
        return this.style.getWhiteSpace();
    }

    @Override
    public void setWhiteSpace(String whitespace) {
        this.checkWritable();
        this.style.setWhiteSpace(whitespace);
    }

    @Override
    public String getWordSpacing() {
        return this.style.getWordSpacing();
    }

    @Override
    public void setWordSpacing(String wordspacing) {
        this.checkWritable();
        this.style.setWordSpacing(wordspacing);
    }

    @Override
    public String getColor() {
        return this.style.getColor();
    }

    @Override
    public void setColor(String color) {
        this.checkWritable();
        this.style.setColor(color);
    }

    @Override
    @Deprecated
    public String getBackgroundAttachement() {
        return this.style.getBackgroundAttachment();
    }

    @Override
    @Deprecated
    public void setBackgroundAttachement(String attachement) {
        this.checkWritable();
        this.style.setBackgroundAttachment(attachement);
    }

    @Override
    public String getBackgroundAttachment() {
        return this.style.getBackgroundAttachment();
    }

    @Override
    public void setBackgroundAttachment(String attachment) {
        this.checkWritable();
        this.style.setBackgroundAttachment(attachment);
    }

    @Override
    public String getBackgroundColor() {
        return this.style.getBackgroundColor();
    }

    @Override
    public void setBackgroundColor(String color) {
        this.checkWritable();
        this.style.setBackgroundColor(color);
    }

    @Override
    public String getBackgroundImage() {
        return this.style.getBackgroundImage();
    }

    @Override
    public void setBackgroundImage(String imageURI) {
        this.checkWritable();
        this.style.setBackgroundImage(imageURI);
    }

    @Override
    public String getBackgroundImageType() {
        return this.style.getBackgroundImage();
    }

    @Override
    public void setBackgroundImageType(String imageType) {
        this.checkWritable();
        this.style.setBackgroundImageType(imageType);
    }

    @Override
    public String getBackgroundRepeat() {
        return this.style.getBackgroundRepeat();
    }

    @Override
    public void setBackgroundRepeat(String repeat) {
        this.checkWritable();
        this.style.setBackgroundRepeat(repeat);
    }

    @Override
    public String getBorderBottomColor() {
        return this.style.getBorderBottomColor();
    }

    @Override
    public void setBorderBottomColor(String color) {
        this.checkWritable();
        this.style.setBorderBottomColor(color);
    }

    @Override
    public String getBorderTopColor() {
        return this.style.getBorderTopColor();
    }

    @Override
    public void setBorderTopColor(String color) {
        this.checkWritable();
        this.style.setBorderTopColor(color);
    }

    @Override
    public String getBorderRightColor() {
        return this.style.getBorderRightColor();
    }

    @Override
    public void setBorderRightColor(String color) {
        this.checkWritable();
        this.style.setBorderRightColor(color);
    }

    @Override
    public String getBorderLeftColor() {
        return this.style.getBorderLeftColor();
    }

    @Override
    public void setBorderLeftColor(String color) {
        this.checkWritable();
        this.style.setBorderLeftColor(color);
    }

    @Override
    public String getBorderBottomStyle() {
        return this.style.getBorderBottomStyle();
    }

    @Override
    public void setBorderBottomStyle(String borderstyle) {
        this.checkWritable();
        this.style.setBorderBottomStyle(borderstyle);
    }

    @Override
    public String getBorderTopStyle() {
        return this.style.getBorderTopStyle();
    }

    @Override
    public void setBorderTopStyle(String borderstyle) {
        this.checkWritable();
        this.style.setBorderTopStyle(borderstyle);
    }

    @Override
    public String getBorderLeftStyle() {
        return this.style.getBorderLeftStyle();
    }

    @Override
    public void setBorderLeftStyle(String borderstyle) {
        this.checkWritable();
        this.style.setBorderLeftStyle(borderstyle);
    }

    @Override
    public String getBorderRightStyle() {
        return this.style.getBorderRightStyle();
    }

    @Override
    public void setBorderRightStyle(String borderstyle) {
        this.checkWritable();
        this.style.setBorderRightStyle(borderstyle);
    }

    @Override
    public String getBorderBottomWidth() {
        return this.style.getBorderBottomWidth();
    }

    @Override
    public void setBorderBottomWidth(String width) {
        this.checkWritable();
        this.style.setBorderBottomWidth(width);
    }

    @Override
    public String getBorderTopWidth() {
        return this.style.getBorderTopWidth();
    }

    @Override
    public void setBorderTopWidth(String width) {
        this.checkWritable();
        this.style.setBorderTopWidth(width);
    }

    @Override
    public String getBorderLeftWidth() {
        return this.style.getBorderLeftWidth();
    }

    @Override
    public void setBorderLeftWidth(String width) {
        this.checkWritable();
        this.style.setBorderLeftWidth(width);
    }

    @Override
    public String getBorderRightWidth() {
        return this.style.getBorderRightWidth();
    }

    @Override
    public void setBorderRightWidth(String width) {
        this.checkWritable();
        this.style.setBorderRightWidth(width);
    }

    @Override
    public String getMarginBottom() {
        return this.style.getMarginBottom();
    }

    @Override
    public void setMarginBottom(String margin) {
        this.checkWritable();
        this.style.setMarginBottom(margin);
    }

    @Override
    public String getMarginTop() {
        return this.style.getMarginTop();
    }

    @Override
    public void setMarginTop(String margin) {
        this.checkWritable();
        this.style.setMarginTop(margin);
    }

    @Override
    public String getMarginLeft() {
        return this.style.getMarginLeft();
    }

    @Override
    public void setMarginLeft(String margin) {
        this.checkWritable();
        this.style.setMarginLeft(margin);
    }

    @Override
    public String getMarginRight() {
        return this.style.getMarginRight();
    }

    @Override
    public void setMarginRight(String margin) {
        this.checkWritable();
        this.style.setMarginRight(margin);
    }

    @Override
    public String getPaddingBottom() {
        return this.style.getPaddingBottom();
    }

    @Override
    public void setPaddingBottom(String padding) {
        this.checkWritable();
        this.style.setPaddingBottom(padding);
    }

    @Override
    public String getPaddingTop() {
        return this.style.getPaddingTop();
    }

    @Override
    public void setPaddingTop(String padding) {
        this.checkWritable();
        this.style.setPaddingTop(padding);
    }

    @Override
    public String getPaddingLeft() {
        return this.style.getPaddingLeft();
    }

    @Override
    public void setPaddingLeft(String padding) {
        this.checkWritable();
        this.style.setPaddingLeft(padding);
    }

    @Override
    public String getPaddingRight() {
        return this.style.getPaddingRight();
    }

    @Override
    public void setPaddingRight(String padding) {
        this.checkWritable();
        this.style.setPaddingRight(padding);
    }

    @Override
    public String getDisplay() {
        return this.style.getDisplay();
    }

    @Override
    public void setDisplay(String display) {
        this.checkWritable();
        this.style.setDisplay(display);
    }

    @Override
    public String getMasterPage() {
        return this.style.getMasterPage();
    }

    @Override
    public void setMasterPage(String masterPage) {
        this.checkWritable();
        this.style.setMasterPage(masterPage);
    }

    @Override
    public String getPageBreakBefore() {
        return this.style.getPageBreakBefore();
    }

    @Override
    public void setPageBreakBefore(String pageBreak) {
        this.checkWritable();
        this.checkRunningState();
        this.style.setPageBreakBefore(pageBreak);
    }

    @Override
    public String getPageBreakAfter() {
        return this.style.getPageBreakAfter();
    }

    @Override
    public void setPageBreakAfter(String pageBreak) {
        this.checkWritable();
        this.checkRunningState();
        this.style.setPageBreakAfter(pageBreak);
    }

    @Override
    public String getPageBreakInside() {
        return this.style.getPageBreakInside();
    }

    @Override
    public void setPageBreakInside(String pageBreak) {
        this.checkWritable();
        this.checkRunningState();
        this.style.setPageBreakInside(pageBreak);
    }

    @Override
    public String getShowIfBlank() {
        return this.style.getShowIfBlank();
    }

    @Override
    public void setShowIfBlank(String showIfBlank) {
        this.checkWritable();
        this.style.setShowIfBlank(showIfBlank);
    }

    @Override
    public String getCanShrink() {
        return this.style.getCanShrink();
    }

    @Override
    public void setCanShrink(String canShrink) {
        this.checkWritable();
        this.style.setCanShrink(canShrink);
    }

    @Override
    public String getNumberFormat() {
        return this.style.getNumberFormat();
    }

    @Override
    public void setNumberFormat(String numberFormat) {
        this.checkWritable();
        this.style.setNumberFormat(numberFormat);
    }

    @Override
    public String getNumberLocale() {
        DataFormatValue value = this.style.getDataFormat();
        if (value == null) {
            return null;
        }
        return value.getNumberLocale();
    }

    @Override
    public void setNumberLocale(String locale) {
        this.checkWritable();
        DataFormatValue oldValue = this.style.getDataFormat();
        DataFormatValue value = DataFormatValue.createDataFormatValue(oldValue);
        this.style.setDataFormat(value);
        value.setNumberFormat(oldValue == null ? null : oldValue.getNumberPattern(), locale);
    }

    @Override
    public String getDateFormat() {
        return this.style.getDateTimeFormat();
    }

    @Override
    public void setDateFormat(String dateTimeFormat) {
        this.checkWritable();
        DataFormatValue oldValue = this.style.getDataFormat();
        DataFormatValue value = DataFormatValue.createDataFormatValue(oldValue);
        this.style.setDataFormat(value);
        value.setDateTimeFormat(dateTimeFormat, oldValue == null ? null : oldValue.getDateTimeLocale());
    }

    @Override
    public String getDateLocale() {
        DataFormatValue value = this.style.getDataFormat();
        if (value == null) {
            return null;
        }
        return value.getDateTimeLocale();
    }

    @Override
    public void setDateLocale(String locale) {
        this.checkWritable();
        DataFormatValue oldValue = this.style.getDataFormat();
        DataFormatValue value = DataFormatValue.createDataFormatValue(oldValue);
        this.style.setDataFormat(value);
        value.setDateTimeFormat(oldValue == null ? null : oldValue.getDateTimePattern(), locale);
    }

    @Override
    public String getStringFormat() {
        return this.style.getStringFormat();
    }

    @Override
    public void setStringFormat(String stringFormat) {
        this.checkWritable();
        this.style.setStringFormat(stringFormat);
    }

    @Override
    public String getStringLocale() {
        DataFormatValue value = this.style.getDataFormat();
        if (value == null) {
            return null;
        }
        return value.getStringLocale();
    }

    @Override
    public void setStringLocale(String locale) {
        this.checkWritable();
        DataFormatValue oldValue = this.style.getDataFormat();
        DataFormatValue value = DataFormatValue.createDataFormatValue(oldValue);
        this.style.setDataFormat(value);
        value.setStringFormat(oldValue == null ? null : oldValue.getStringPattern(), locale);
    }

    @Override
    public String getFontFamily() {
        return this.style.getFontFamily();
    }

    @Override
    public void setFontFamily(String fontFamily) {
        this.checkWritable();
        this.style.setFontFamily(fontFamily);
    }

    @Override
    public String getFontStyle() {
        return this.style.getFontStyle();
    }

    @Override
    public void setFontStyle(String fontStyle) {
        this.checkWritable();
        this.style.setFontStyle(fontStyle);
    }

    @Override
    public String getFontVariant() {
        return this.style.getFontVariant();
    }

    @Override
    public void setFontVariant(String fontVariant) {
        this.checkWritable();
        this.style.setFontVariant(fontVariant);
    }

    @Override
    public String getFontWeight() {
        return this.style.getFontWeight();
    }

    @Override
    public void setFontWeight(String fontWeight) {
        this.checkWritable();
        this.style.setFontWeight(fontWeight);
    }

    @Override
    public String getFontSize() {
        return this.style.getFontSize();
    }

    @Override
    public void setFontSize(String fontSize) {
        this.checkWritable();
        this.style.setFontSize(fontSize);
    }

    @Override
    public String getTextUnderline() {
        return this.style.getTextUnderline();
    }

    @Override
    public void setTextUnderline(String underline) throws ScriptException {
        this.checkWritable();
        try {
            this.style.setTextUnderline(underline);
        }
        catch (DOMException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    @Override
    public String getTextOverline() {
        return this.style.getTextOverline();
    }

    @Override
    public void setTextOverline(String overline) throws ScriptException {
        this.checkWritable();
        try {
            this.style.setTextOverline(overline);
        }
        catch (DOMException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    @Override
    public String getTextLineThrough() {
        return this.style.getTextLineThrough();
    }

    @Override
    public void setTextLineThrough(String through) throws ScriptException {
        this.checkWritable();
        try {
            this.style.setTextLineThrough(through);
        }
        catch (DOMException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    @Override
    public String getBackgroundPositionX() {
        return this.style.getBackgroundPositionX();
    }

    @Override
    public void setBackgroundPositionX(String x) throws ScriptException {
        this.checkWritable();
        try {
            this.style.setBackgroundPositionX(x);
        }
        catch (DOMException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    @Override
    public String getBackgroundPositionY() {
        return this.style.getBackgroundPositionY();
    }

    @Override
    public void setBackgroundPositionY(String y) throws ScriptException {
        this.checkWritable();
        try {
            this.style.setBackgroundPositionY(y);
        }
        catch (DOMException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public CSSValue getProperty(int index) {
        return this.style.getProperty(index);
    }

    public String getDirection() {
        return this.style.getDirection();
    }

    public void setDirection(String dir) {
        this.checkWritable();
        this.style.setDirection(dir);
    }

    private void checkRunningState() {
        if (this.runningState == RunningState.RENDER) {
            throw new UnsupportedOperationException("Page break can not be set at render time.");
        }
        if (this.runningState == RunningState.PAGEBREAK) {
            throw new UnsupportedOperationException("Page break can not be set on page break.");
        }
    }

    private void checkWritable() {
        if (this.runningState == RunningState.PAGEBREAK) {
            throw new UnsupportedOperationException("the content is read only in onPageBreak script.");
        }
    }
}

