/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.StyleComboPropertyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StyleComboSection
extends Section {
    protected StyleComboPropertyDescriptor combo;
    IDescriptorProvider provider;
    private int width = -1;
    private boolean fillCombo = false;
    private String text;

    public StyleComboSection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    @Override
    public void createSection() {
        this.getLabelControl(this.parent);
        this.getComboControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    @Override
    public void layout() {
        GridData gd = (GridData)this.combo.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - 1 - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - 1 - this.placeholder;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillCombo;
        }
    }

    public StyleComboPropertyDescriptor getComboControl() {
        return this.combo;
    }

    protected StyleComboPropertyDescriptor getComboControl(Composite parent) {
        if (this.combo == null) {
            this.combo = DescriptorToolkit.createStyleComboPropertyDescriptor(this.isFormStyle);
            if (this.getProvider() != null) {
                this.combo.setDescriptorProvider(this.getProvider());
            }
            this.combo.createControl(parent);
            if (this.text != null) {
                this.combo.setText(this.text);
            }
            this.combo.getControl().setLayoutData((Object)new GridData());
            this.combo.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    StyleComboSection.this.combo = null;
                }
            });
        } else {
            this.checkParent(this.combo.getControl(), parent);
        }
        return this.combo;
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.combo != null) {
            this.combo.setDescriptorProvider(provider);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setInput(Object input) {
        assert (input != null);
        this.combo.setInput(input);
    }

    public boolean isFillCombo() {
        return this.fillCombo;
    }

    public void setFillCombo(boolean fillCombo) {
        this.fillCombo = fillCombo;
    }

    public void setFocus() {
        if (this.combo != null) {
            this.combo.getControl().setFocus();
        }
    }

    @Override
    public void load() {
        if (this.combo != null && !this.combo.getControl().isDisposed()) {
            this.combo.load();
        }
    }

    @Override
    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, (boolean)isHidden);
        }
        if (this.combo != null) {
            this.combo.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.combo != null) {
            this.combo.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.combo != null) {
            this.combo.setText(text);
        }
    }
}

