/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IDimLevel;
import org.eclipse.birt.core.exception.CoreException;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.AggregationArgument;
import org.eclipse.birt.report.model.api.elements.structures.CalculationArgument;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.DimensionCondition;
import org.eclipse.birt.report.model.api.elements.structures.DimensionJoinCondition;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.elements.structures.ScriptLib;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.ReferencableStyledElement;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.DataSource;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.MemberValue;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ReportItemTheme;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.Measure;
import org.eclipse.birt.report.model.elements.olap.TabularDimension;
import org.eclipse.birt.report.model.extension.IExtendableElement;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.ElementFactoryUtil;
import org.eclipse.birt.report.model.util.EncryptionUtil;
import org.eclipse.birt.report.model.util.LevelContentIterator;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.StructureRefUtil;

class ReportDesignSerializerImpl
extends ElementVisitor {
    private static Logger logger = Logger.getLogger(ReportDesignSerializerImpl.class.getName());
    protected ReportDesign targetDesign = null;
    protected ReportDesign sourceDesign = null;
    private Stack<DesignElement> elements = new Stack();
    private Map<DesignElement, DesignElement> externalElements = new LinkedHashMap<DesignElement, DesignElement>(12);
    private Map<IStructure, IStructure> externalStructs = new LinkedHashMap<IStructure, IStructure>(6);
    private Map<Cube, Cube> cubes = new LinkedHashMap<Cube, Cube>(6);
    private Map<Dimension, Dimension> dimensions = new LinkedHashMap<Dimension, Dimension>(6);
    protected DesignElement currentNewElement = null;
    private List<PropertyBinding> propertyBindings = new ArrayList<PropertyBinding>();
    protected Map<String, ReportItemTheme> reportItemThemes = new LinkedHashMap<String, ReportItemTheme>(12);
    protected Map<ReportItemTheme, List<ReportItem>> ReportItemThemeMapping = new LinkedHashMap<ReportItemTheme, List<ReportItem>>(12);
    protected Map<ExtendedItem, StyleHandle[]> referencedStyleMap = new LinkedHashMap<ExtendedItem, StyleHandle[]>(6);

    ReportDesignSerializerImpl() {
    }

    public ReportDesign getTarget() {
        return this.targetDesign;
    }

    @Override
    public void visitReportDesign(ReportDesign obj) {
        long startTime = 0L;
        long endTime = 0L;
        if (logger.isLoggable(Level.FINE)) {
            startTime = Calendar.getInstance().getTimeInMillis();
        }
        this.sourceDesign = obj;
        this.localizeDesign(obj);
        this.visitSlots(obj, this.targetDesign, 11);
        List<IElementPropertyDefn> properties = obj.getContents();
        if (properties.size() > 0) {
            this.visitContainerProperties(obj, this.targetDesign, properties);
        }
        this.localizeExternalSelectors();
        this.addExternalElements();
        this.addExternalStructures();
        this.localizeDimensionConditions();
        this.localizeDefaultHierarchy();
        if (this.propertyBindings != null && !this.propertyBindings.isEmpty()) {
            this.targetDesign.setProperty("propertyBindings", this.propertyBindings);
        }
        this.addThemes();
        this.addReportItemThemes();
        this.processAllReferencedStyle();
        this.release();
        this.targetDesign.getVersionManager().setVersion(this.sourceDesign.getVersionManager().getVersion());
        if (logger.isLoggable(Level.FINE)) {
            endTime = Calendar.getInstance().getTimeInMillis();
            String filename = this.sourceDesign.getFileName();
            if (filename == null) {
                filename = "";
            }
            logger.fine("total time to flatten design " + filename + " in milliseconds " + (endTime - startTime));
        }
    }

    private void release() {
        this.elements = null;
        this.externalElements = null;
        this.externalStructs = null;
        this.currentNewElement = null;
        this.cubes = null;
        this.propertyBindings = null;
    }

    @Override
    public void visitDesignElement(DesignElement obj) {
        DesignElement newElement = this.localize(obj);
        ElementDefn elementDefn = (ElementDefn)obj.getDefn();
        if (obj.isContainer()) {
            List<IElementPropertyDefn> properties;
            int slotCount = elementDefn.getSlotCount();
            if (slotCount > 0) {
                this.visitSlots(obj, newElement, slotCount);
            }
            if ((properties = obj.getContents()).size() > 0) {
                this.visitContainerProperties(obj, newElement, properties);
            }
        }
        this.currentNewElement = newElement;
    }

    @Override
    public void visitExtendedItem(ExtendedItem obj) {
        StyleHandle[] styles;
        super.visitExtendedItem(obj);
        assert (this.currentNewElement instanceof ExtendedItem);
        IReportItem extItem = obj.getExtendedElement();
        if (extItem != null && (styles = extItem.getReferencedStyle()) != null && styles.length > 0) {
            this.referencedStyleMap.put((ExtendedItem)this.currentNewElement, styles);
        }
    }

    private String insertStyle(StyleHandle styleHandle) {
        Style newStyle;
        block3: {
            Style style = (Style)styleHandle.getElement();
            newStyle = null;
            try {
                newStyle = (Style)style.clone();
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        if (newStyle != null) {
            ContainerContext context = new ContainerContext((DesignElement)this.targetDesign, 0);
            this.addElement(this.targetDesign, context, newStyle);
            this.targetDesign.manageId(newStyle, true);
            return newStyle.getName();
        }
        return null;
    }

    private void processAllReferencedStyle() {
        if (!this.referencedStyleMap.isEmpty()) {
            HashMap<StyleHandle, String> processedStyles = new HashMap<StyleHandle, String>();
            for (ExtendedItem item : this.referencedStyleMap.keySet()) {
                this.processExtendedItemReferencedStyle(item, this.referencedStyleMap.get(item), processedStyles);
            }
        }
    }

    private void processExtendedItemReferencedStyle(ExtendedItem extendedItem, StyleHandle[] styles, Map<StyleHandle, String> processedStyles) {
        HashMap<String, String> styleMap = new HashMap<String, String>();
        int i = 0;
        while (i < styles.length) {
            String name;
            String originalName;
            if (!processedStyles.containsKey(styles[i])) {
                originalName = styles[i].getName();
                name = this.insertStyle(styles[i]);
                if (name != null) {
                    if (originalName != null && !originalName.equals(name)) {
                        styleMap.put(originalName, name);
                    }
                    processedStyles.put(styles[i], name);
                }
            } else {
                originalName = styles[i].getName();
                name = processedStyles.get(styles[i]);
                if (!name.equals(originalName)) {
                    styleMap.put(originalName, name);
                }
            }
            ++i;
        }
        if (!styleMap.isEmpty()) {
            IReportItem item = extendedItem.getExtendedElement();
            if (item != null) {
                item.updateStyleReference(styleMap);
            } else {
                try {
                    extendedItem.initializeReportItem(this.targetDesign);
                    item = extendedItem.getExtendedElement();
                    if (item != null) {
                        item.updateStyleReference(styleMap);
                    }
                }
                catch (ExtendedElementException e) {
                    logger.log(Level.WARNING, "can not load extended item.", (Throwable)((Object)e));
                }
            }
        }
    }

    private void addExternalStructures() {
        ElementPropertyDefn propDefn = this.targetDesign.getPropertyDefn("images");
        Iterator<IStructure> embeddedImages = this.externalStructs.values().iterator();
        StructureContext context = new StructureContext(this.targetDesign, propDefn, null);
        while (embeddedImages.hasNext()) {
            EmbeddedImage image = (EmbeddedImage)embeddedImages.next();
            this.targetDesign.rename(image);
            context.add(image);
        }
    }

    private void addExternalElements() {
        ArrayList<DesignElement> tmpElements = new ArrayList<DesignElement>(this.externalElements.keySet());
        ArrayList<DesignElement> processedElements = new ArrayList<DesignElement>();
        int index = 0;
        HashMap<DesignElement, List<String>> tmpOLAPNames = new HashMap<DesignElement, List<String>>();
        int i = 0;
        while (i < tmpElements.size()) {
            DesignElement tmpElement = (DesignElement)tmpElements.get(i);
            if (this.needUpdateBinding(tmpElement)) {
                tmpOLAPNames.put(tmpElement, this.collectOLAPNames(this.sourceDesign, tmpElement));
            }
            ++i;
        }
        while (processedElements.size() < this.externalElements.size()) {
            DesignElement originalElement = (DesignElement)tmpElements.get(index++);
            this.addExternalElement(tmpElements, processedElements, originalElement);
        }
        for (Map.Entry entry : tmpOLAPNames.entrySet()) {
            Cube originalElement = (Cube)entry.getKey();
            Cube newCube = (Cube)this.externalElements.get(originalElement);
            List<String> newNames = this.collectOLAPNames(this.targetDesign, newCube);
            List oldNames = (List)entry.getValue();
            this.updateReferredOLAPColumnBinding(this.targetDesign, newCube, this.buildOLAPNameMap(oldNames, newNames));
        }
    }

    protected boolean needUpdateBinding(DesignElement element) {
        return element instanceof Cube;
    }

    private void addExternalElement(List<DesignElement> elements, List<DesignElement> processedElements, DesignElement originalElement) {
        int newId;
        if (processedElements.contains(originalElement)) {
            return;
        }
        DesignElement originalContainer = originalElement.getContainer();
        if (elements.contains(originalContainer)) {
            this.addExternalElement(elements, processedElements, originalContainer);
        }
        processedElements.add(originalElement);
        DesignElement tmpElement = this.externalElements.get(originalElement);
        DesignElement tmpContainer = this.getTargetContainer(originalElement, tmpElement, processedElements);
        ContainerContext context = null;
        if (tmpContainer != null) {
            context = originalElement.getContainerInfo().createContext(tmpContainer);
        }
        if (context == null && originalContainer instanceof Theme) {
            newId = 0;
            context = new ContainerContext((DesignElement)this.targetDesign, newId);
        }
        if (context == null && originalContainer instanceof Library) {
            context = originalElement.getContainerInfo();
            if (!context.isROMSlot()) {
                String propName = context.getPropertyName();
                context = propName != null ? new ContainerContext(tmpContainer, context.getPropertyName()) : new ContainerContext(tmpContainer, -1);
            } else {
                newId = -1;
                switch (context.getSlotID()) {
                    case 0: {
                        newId = -1;
                        assert (false);
                        break;
                    }
                    case 6: {
                        newId = 9;
                        break;
                    }
                    default: {
                        newId = context.getSlotID();
                    }
                }
                context = new ContainerContext(tmpContainer, newId);
            }
        }
        assert (context != null);
        if (context.contains(this.targetDesign, tmpElement)) {
            return;
        }
        String originalName = originalElement.getName();
        this.addElement(this.targetDesign, context, tmpElement);
        if (tmpElement instanceof OdaDataSource && !tmpElement.getName().equals(originalName)) {
            OdaDataSource odaDataSource = (OdaDataSource)tmpElement;
            odaDataSource.setProperty("externalConnectionName", (Object)originalName);
        }
        this.targetDesign.manageId(tmpElement, true);
        this.localizePropertyBindings(originalElement, tmpElement);
    }

    private List<String> collectOLAPNames(Module module, DesignElement cube) {
        ArrayList<String> retMap = new ArrayList<String>();
        LevelContentIterator iter = new LevelContentIterator(module, cube, 3);
        while (iter.hasNext()) {
            DesignElement innerElement = iter.next();
            if (innerElement instanceof Dimension || innerElement instanceof Measure) {
                retMap.add(innerElement.getName());
                continue;
            }
            if (!(innerElement instanceof org.eclipse.birt.report.model.elements.olap.Level)) continue;
            retMap.add(((org.eclipse.birt.report.model.elements.olap.Level)innerElement).getFullName());
        }
        return retMap;
    }

    private Map<String, String> buildOLAPNameMap(List<String> oldNames, List<String> newNames) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        int i = 0;
        while (i < oldNames.size()) {
            String oldName = oldNames.get(i);
            String newName = newNames.get(i);
            retMap.put(oldName, newName);
            ++i;
        }
        return retMap;
    }

    private void updateReferredOLAPColumnBinding(Module module, Cube cube, Map<String, String> nameMap) {
        this.updateDerivedMeasure(module, cube, nameMap);
        List<BackRef> clients = cube.getClientList();
        int i = 0;
        while (i < clients.size()) {
            BackRef ref = clients.get(i);
            DesignElement client = ref.getElement();
            List columnBindings = (List)client.getLocalProperty(module, "boundDataColumns");
            if (columnBindings == null || columnBindings.isEmpty()) {
                return;
            }
            int j = 0;
            while (j < columnBindings.size()) {
                ComputedColumn binding = (ComputedColumn)columnBindings.get(j);
                this.updateBindingExpr(binding, nameMap);
                this.updateAggregateOnList(binding, nameMap);
                this.updateAggregationArguments(binding, nameMap);
                this.updateCalculationArguments(binding, nameMap);
                this.updateTimeDimension(binding, nameMap);
                ++j;
            }
            ++i;
        }
    }

    private void updateBindingExpr(ComputedColumn binding, Map<String, String> nameMap) {
        Expression objExpr = binding.getExpressionProperty("expression");
        if (objExpr == null) {
            return;
        }
        Expression newExpr = this.getUpdatedExpression(objExpr, nameMap);
        if (newExpr != null) {
            binding.setExpressionProperty("expression", newExpr);
        }
    }

    private Expression getUpdatedExpression(Expression old, Map<String, String> nameMap) {
        String type;
        if (old == null) {
            return null;
        }
        String expr = old.getStringExpression();
        Map<String, String> updateMap = this.getUpdateBindingMap(expr, nameMap, type = old.getType());
        if (updateMap != null && !updateMap.isEmpty()) {
            String newExpr = expr;
            for (Map.Entry<String, String> entry : updateMap.entrySet()) {
                String oldName = entry.getKey();
                String newName = entry.getValue();
                newExpr = newExpr.replaceAll("(\\W)" + oldName + "(\\W)", "$1" + newName + "$2");
            }
            return new Expression(newExpr, old.getUserDefinedType());
        }
        return null;
    }

    protected Map<String, String> getUpdateBindingMap(String expr, Map<String, String> nameMap, String type) {
        HashMap<String, String> updateMap;
        block8: {
            updateMap = new HashMap<String, String>();
            if (!"javascript".equalsIgnoreCase(type)) break block8;
            Set measureNameSet = null;
            try {
                measureNameSet = ExpressionUtil.getAllReferencedMeasures((String)expr);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (measureNameSet != null && !measureNameSet.isEmpty()) {
                for (String measureName : measureNameSet) {
                    String newName = nameMap.get(measureName);
                    if (newName == null) continue;
                    updateMap.put(measureName, newName);
                }
            } else {
                Set tmpSet = null;
                try {
                    tmpSet = ExpressionUtil.getReferencedDimLevel((String)expr);
                }
                catch (CoreException e) {
                    return null;
                }
                for (IDimLevel tmpObj : tmpSet) {
                    String oldName = tmpObj.getDimensionName();
                    String newName = nameMap.get(oldName);
                    if (newName == null || newName.equals(oldName)) continue;
                    updateMap.put(oldName, newName);
                }
            }
        }
        return updateMap;
    }

    private void updateAggregateOnList(ComputedColumn binding, Map<String, String> nameMap) {
        List aggreOnList = binding.getAggregateOnList();
        int i = 0;
        while (i < aggreOnList.size()) {
            String levelFullName = (String)aggreOnList.get(i);
            String newName = nameMap.get(levelFullName);
            if (newName != null) {
                aggreOnList.set(i, newName);
            }
            ++i;
        }
    }

    private void updateAggregationArguments(ComputedColumn binding, Map<String, String> nameMap) {
        List arguments = (List)binding.getProperty(null, "arguments");
        if (arguments != null && !arguments.isEmpty()) {
            for (AggregationArgument aggArg : arguments) {
                Expression objExpr = aggArg.getExpressionProperty("value");
                if (objExpr == null) {
                    return;
                }
                Expression newExpr = this.getUpdatedExpression(objExpr, nameMap);
                if (newExpr == null) continue;
                aggArg.setExpressionProperty("value", newExpr);
            }
        }
    }

    private void updateCalculationArguments(ComputedColumn binding, Map<String, String> nameMap) {
        List calculationArgs = (List)binding.getProperty(null, "calculationArguments");
        if (calculationArgs != null && !calculationArgs.isEmpty()) {
            for (CalculationArgument calArg : calculationArgs) {
                Expression objExpr = calArg.getExpressionProperty("value");
                if (objExpr == null) {
                    return;
                }
                Expression newExpr = this.getUpdatedExpression(objExpr, nameMap);
                if (newExpr == null) continue;
                calArg.setExpressionProperty("value", newExpr);
            }
        }
    }

    private void updateDerivedMeasure(Module module, Cube cube, Map<String, String> nameMap) {
        ArrayList<Measure> derivedMeasureList = new ArrayList<Measure>();
        LevelContentIterator iter = new LevelContentIterator(module, cube, 3);
        while (iter.hasNext()) {
            Measure measure;
            DesignElement innerElement = iter.next();
            if (!(innerElement instanceof Measure) || !(measure = (Measure)innerElement).getBooleanProperty(module, "isCalculated")) continue;
            derivedMeasureList.add(measure);
        }
        if (!derivedMeasureList.isEmpty()) {
            for (Measure derivedMeasure : derivedMeasureList) {
                Expression expr = (Expression)derivedMeasure.getProperty(module, "measureExpression");
                Expression newExpr = this.getUpdatedExpression(expr, nameMap);
                if (newExpr == null) continue;
                derivedMeasure.setProperty("measureExpression", (Object)newExpr);
            }
        }
    }

    private void updateTimeDimension(ComputedColumn binding, Map<String, String> nameMap) {
        String timeDimension = (String)binding.getProperty(null, "timeDimension");
        String newTimeDimension = nameMap.get(timeDimension);
        if (newTimeDimension != null) {
            binding.setProperty("timeDimension", (Object)newTimeDimension);
        }
    }

    protected void addElement(Module module, ContainerContext context, DesignElement content) {
        assert (context != null);
        assert (content != null);
        context.add(module, content);
        if (context.isManagedByNameSpace()) {
            if (content instanceof ReportItemTheme) {
                module.makeUniqueName(content);
            } else {
                module.rename(context.getElement(), content);
            }
        }
        this.addElement2NameSpace(content);
        ContentIterator iter = new ContentIterator(module, content);
        while (iter.hasNext()) {
            DesignElement child = iter.next();
            this.addElement2NameSpace(child);
        }
        if (content instanceof Cube) {
            Cube cube = (Cube)content;
            cube.updateLayout(this.targetDesign);
        } else if (content instanceof TabularDimension) {
            TabularDimension dimension = (TabularDimension)content;
            dimension.updateLayout(this.targetDesign);
        }
    }

    private void addElement2NameSpace(DesignElement element) {
        NameExecutor executor;
        NameSpace namespace;
        if (element == null || !element.isManagedByNameSpace()) {
            return;
        }
        if (element.getName() != null && (namespace = (executor = new NameExecutor(this.targetDesign, element)).getNameSpace()) != null) {
            if (namespace.contains(element.getName())) {
                throw new RuntimeException("element name is not unique");
            }
            namespace.insert(element);
        }
    }

    @Override
    public void visitStyle(Style obj) {
        this.visitDesignElement(obj);
    }

    @Override
    public void visitTheme(Theme obj) {
    }

    @Override
    public void visitReportItem(ReportItem obj) {
        this.visitStyledElement(obj);
    }

    @Override
    public void visitScalarParameter(ScalarParameter obj) {
        this.visitParameter(obj);
    }

    @Override
    public void visitStyledElement(StyledElement obj) {
        this.visitDesignElement(obj);
        this.localizeStyle((StyledElement)this.currentNewElement, obj);
        this.localizeReportItemThemeProperty((StyledElement)this.currentNewElement, obj);
    }

    private void localizeStyle(StyledElement target, StyledElement source) {
        HashSet<String> notEmptyProperties = new HashSet<String>();
        this.localizeSelfStyleProperties(target, source, notEmptyProperties);
        notEmptyProperties.clear();
    }

    private void localizeReportItemThemeProperty(StyledElement target, StyledElement source) {
        if (source instanceof ReportItem) {
            ReportItem sourceItem = (ReportItem)source;
            ReportItem targetItem = (ReportItem)target;
            ReportItemTheme sourceTheme = (ReportItemTheme)sourceItem.getTheme(this.sourceDesign);
            if (sourceTheme != null) {
                ReportItemTheme targetTheme = this.reportItemThemes.get(sourceTheme.getHandle(sourceTheme.getRoot()).getQualifiedName());
                assert (targetTheme != null);
                ElementRefValue themeRef = new ElementRefValue(null, targetTheme.getName());
                themeRef.resolve(targetTheme);
                targetItem.setProperty("theme", (Object)themeRef);
                this.addReportItemThemeMap(targetItem, targetTheme);
                List<ReportItem> reportItems = this.ReportItemThemeMapping.get(targetTheme);
                if (reportItems == null) {
                    reportItems = new ArrayList<ReportItem>();
                    reportItems.add(targetItem);
                    this.ReportItemThemeMapping.put(targetTheme, reportItems);
                } else {
                    reportItems.add(targetItem);
                }
            }
        }
    }

    private void addReportItemThemeMap(ReportItem targetItem, ReportItemTheme targetTheme) {
        List<ReportItem> reportItems = this.ReportItemThemeMapping.get(targetTheme);
        if (reportItems == null) {
            reportItems = new ArrayList<ReportItem>();
            reportItems.add(targetItem);
            this.ReportItemThemeMapping.put(targetTheme, reportItems);
        } else {
            reportItems.add(targetItem);
        }
    }

    @Override
    public void visitTabularDimension(TabularDimension obj) {
        if (obj.getSharedDimension(this.sourceDesign) != null) {
            TabularDimension newElement = (TabularDimension)this.localize(obj);
            newElement.updateLayout(this.targetDesign);
            this.targetDesign.manageId(newElement, true);
            this.currentNewElement = newElement;
        } else {
            super.visitTabularDimension(obj);
        }
    }

    private void localizeExternalSelectors() {
        assert (this.elements.isEmpty());
        this.elements.push(this.targetDesign);
        Theme theme = this.sourceDesign.getTheme(this.sourceDesign);
        if (theme == null) {
            this.elements.pop();
            return;
        }
        Module tmpRoot = theme.getRoot();
        List<StyleElement> styles = theme.getAllStyles();
        int i = 0;
        while (i < styles.size()) {
            Style tmpStyle = (Style)styles.get(i);
            this.visitExternalSelector(tmpStyle, tmpRoot);
            ++i;
        }
        this.elements.pop();
    }

    private void localizeSelfStyleProperties(StyledElement target, StyledElement source, Set<String> notEmptyProperties) {
        StyledElement tmpElement = source;
        while (tmpElement != null) {
            Module root = tmpElement.getRoot();
            this.localizePrivateStyleProperties(target, tmpElement, root, notEmptyProperties);
            Style style = (Style)tmpElement.getStyle(root);
            if (style != null) {
                Module styleRoot = style.getRoot();
                if (styleRoot != this.sourceDesign) {
                    this.localizePrivateStyleProperties(target, style, styleRoot, notEmptyProperties);
                } else {
                    target.setStyleName(tmpElement.getStyleName());
                }
            }
            tmpElement = tmpElement.isVirtualElement() ? (StyledElement)tmpElement.getVirtualParent() : (StyledElement)tmpElement.getExtendsElement();
        }
    }

    private void localizePrivateStyleProperties(DesignElement target, DesignElement source, Module root, Set<String> notEmptyProperties) {
        if (!source.hasLocalPropertyValues()) {
            return;
        }
        IElementDefn defn = source.getDefn();
        Iterator<String> iter = source.propertyWithLocalValueIterator();
        while (iter.hasNext()) {
            ElementPropertyDefn targetProp;
            String propName;
            ElementPropertyDefn prop = (ElementPropertyDefn)defn.getProperty(iter.next());
            if (prop == null || !prop.isStyleProperty() || notEmptyProperties.contains(propName = prop.getName()) || (targetProp = target.getPropertyDefn(propName)) == null) continue;
            if (target.getLocalProperty((Module)this.targetDesign, prop) != null) {
                notEmptyProperties.add(propName);
                continue;
            }
            Object value = source.getLocalProperty(root, prop);
            if (value == null) continue;
            switch (targetProp.getTypeCode()) {
                case 20: {
                    target.setProperty(targetProp, ModelUtil.copyValue(targetProp, value));
                    break;
                }
                case 16: {
                    this.handleStructureValue(target, targetProp, value);
                    break;
                }
                default: {
                    target.setProperty(targetProp, ModelUtil.copyValue(targetProp, value));
                }
            }
            notEmptyProperties.add(propName);
        }
    }

    @Override
    public void visitMasterPage(MasterPage obj) {
        this.visitStyledElement(obj);
    }

    @Override
    public void visitGroup(GroupElement obj) {
        this.visitDesignElement(obj);
    }

    @Override
    public void visitRow(TableRow obj) {
        this.visitStyledElement(obj);
    }

    @Override
    public void visitCell(Cell obj) {
        this.visitStyledElement(obj);
    }

    @Override
    public void visitColumn(TableColumn obj) {
        this.visitStyledElement(obj);
    }

    @Override
    public void visitDataSet(DataSet obj) {
        this.visitDesignElement(obj);
    }

    @Override
    public void visitDataSource(DataSource obj) {
        this.visitDesignElement(obj);
    }

    @Override
    public void visitTemplateParameterDefinition(TemplateParameterDefinition obj) {
        this.visitDesignElement(obj);
    }

    private void visitSlots(DesignElement obj, DesignElement newElement, int slotCount) {
        this.elements.push(newElement);
        int i = 0;
        while (i < slotCount) {
            if (obj != this.sourceDesign || i != 10) {
                this.visitContents(this.sourceDesign, new ContainerContext(obj, i));
            }
            ++i;
        }
        this.elements.pop();
    }

    private void visitExternalSlots(DesignElement obj, DesignElement newElement, int slotCount) {
        this.elements.push(newElement);
        int i = 0;
        while (i < slotCount) {
            this.visitExternalContents(this.sourceDesign, new ContainerContext(obj, i));
            ++i;
        }
        this.elements.pop();
    }

    private void visitContainerProperties(DesignElement obj, DesignElement newElement, List<IElementPropertyDefn> properties) {
        this.elements.push(newElement);
        int i = 0;
        while (i < properties.size()) {
            PropertyDefn propDefn = (PropertyDefn)((Object)properties.get(i));
            this.visitContents(this.sourceDesign, new ContainerContext(obj, propDefn.getName()));
            ++i;
        }
        this.elements.pop();
    }

    private DesignElement createNewElement(DesignElement element) {
        ContainerContext sourceContainment = element.getContainerInfo();
        ContainerContext containment = null;
        DesignElement container = this.elements.peek();
        String containmentProp = sourceContainment.getPropertyName();
        containment = containmentProp != null ? new ContainerContext(container, containmentProp) : new ContainerContext(container, sourceContainment.getSlotID());
        DesignElement newElement = this.newElement(element.getDefn().getName(), element.getName(), containment).getElement();
        Set<DesignElement> externalOriginalElements = this.externalElements.keySet();
        if (externalOriginalElements.contains(element) || element instanceof ReportDesign) {
            return newElement;
        }
        if (newElement instanceof GroupElement) {
            newElement.setProperty("groupName", element.getLocalProperty((Module)this.sourceDesign, "groupName"));
        }
        newElement.setID(element.getID());
        this.addElement(this.targetDesign, containment, newElement);
        if (!(newElement instanceof ContentElement)) {
            this.targetDesign.addElementID(newElement);
        }
        return newElement;
    }

    private IStructure visitExternalStruct(IStructure struct) {
        IStructure newStrcut = struct.copy();
        this.cacheMapping(struct, newStrcut);
        return newStrcut;
    }

    protected DesignElement localize(DesignElement element) {
        DesignElement newElement = this.createNewElement(element);
        DesignElement extendsElement = element.getExtendsElement();
        if (extendsElement != null) {
            this.targetDesign.cacheFlattenElement(extendsElement, newElement);
        }
        this.localizePropertyValues(element, newElement);
        this.localizePropertyBindings(element, newElement);
        if (newElement instanceof ExtendedItem) {
            ElementRefValue value;
            if (((ExtendedItem)newElement).getProperty(newElement.getRoot(), "extensionName").equals("MeasureView") && (value = (ElementRefValue)newElement.getProperty(newElement.getRoot(), "measure")) != null) {
                value.setLibraryNamespace(null);
                newElement.setProperty("measure", (Object)value);
            }
            if (((ExtendedItem)newElement).getProperty(newElement.getRoot(), "extensionName").equals("DimensionView") && (value = (ElementRefValue)newElement.getProperty(newElement.getRoot(), "dimension")) != null) {
                value.setLibraryNamespace(null);
                newElement.setProperty("dimension", (Object)value);
            }
        }
        return newElement;
    }

    private void localizePropertyBindings(DesignElement element, DesignElement newElement) {
        DesignElementHandle tmpElementHandle = element.getHandle(element.getRoot());
        List elementBindings = tmpElementHandle.getPropertyBindings();
        ArrayList<PropertyBinding> newList = new ArrayList<PropertyBinding>();
        long newID = newElement.getID();
        int i = 0;
        while (i < elementBindings.size()) {
            PropertyBinding propBinding = (PropertyBinding)elementBindings.get(i);
            PropertyBinding newBinding = (PropertyBinding)propBinding.copy();
            newBinding.setID(newID);
            newList.add(newBinding);
            ++i;
        }
        this.propertyBindings.addAll(newList);
    }

    protected void localizeDesign(ReportDesign source) {
        block3: {
            this.targetDesign = new ReportDesign(source.getSession());
            this.targetDesign.setFileName(source.getFileName());
            this.targetDesign.setSystemId(source.getSystemId());
            this.targetDesign.setID(this.targetDesign.getNextID());
            this.targetDesign.addElementID(this.targetDesign);
            ModuleOption options = source.getOptions();
            try {
                if (options != null) {
                    this.targetDesign.setOptions((ModuleOption)options.copy());
                }
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        this.localizePropertyValues(source, this.targetDesign);
        this.localizeIncludeResourceValues(source, this.targetDesign);
        this.localizeScriptLibValues(source, this.targetDesign);
        this.localizeIncludeScriptValues(source, this.targetDesign);
        this.visitCssStyleSheets(source, this.targetDesign);
        this.localizeReportItemThemes(source, this.targetDesign);
    }

    private void localizeReportItemThemes(ReportDesign source, ReportDesign target) {
        this.elements.push(target);
        this.visitContents(source, new ContainerContext((DesignElement)source, 10));
        this.elements.pop();
        List<Library> libraries = source.getLibraries();
        if (libraries == null || libraries.isEmpty()) {
            return;
        }
        for (Library lib : libraries) {
            List<DesignElement> themes = lib.getSlot(0).getContents();
            if (themes == null || themes.isEmpty()) continue;
            for (DesignElement theme : themes) {
                if (!(theme instanceof ReportItemTheme)) continue;
                ReportItemTheme reportItemTheme = (ReportItemTheme)theme;
                this.localizeReportItemTheme(reportItemTheme);
            }
        }
    }

    private void localizeReportItemTheme(ReportItemTheme sourceTheme) {
        assert (sourceTheme != null);
        ReportItemTheme newTheme = null;
        try {
            newTheme = (ReportItemTheme)sourceTheme.FlattenClone();
            String newName = sourceTheme.getName();
            String namespace = sourceTheme.getRoot().getNamespace();
            newName = namespace == null ? String.valueOf(newName) + "-report" : String.valueOf(newName) + "-" + namespace;
            newTheme.setName(newName);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (newTheme == null) {
            return;
        }
        this.reportItemThemes.put(sourceTheme.getHandle(sourceTheme.getRoot()).getQualifiedName(), newTheme);
    }

    private void addReportItemThemes() {
        if (this.reportItemThemes == null || this.reportItemThemes.isEmpty()) {
            return;
        }
        for (ReportItemTheme newTheme : this.reportItemThemes.values()) {
            List<ReportItem> reportItems;
            if (newTheme.getContainer() != null) continue;
            ContainerContext context = new ContainerContext((DesignElement)this.targetDesign, 10);
            String originalName = newTheme.getName();
            this.addElement(this.targetDesign, context, newTheme);
            this.targetDesign.manageId(newTheme, true);
            if (originalName.equals(newTheme.getName()) || (reportItems = this.ReportItemThemeMapping.get(newTheme)) == null || reportItems.isEmpty()) continue;
            for (ReportItem reportItem : reportItems) {
                ElementRefValue themeRef = new ElementRefValue(null, newTheme.getName());
                themeRef.resolve(newTheme);
                reportItem.setProperty("theme", (Object)themeRef);
            }
        }
    }

    private void addThemes() {
        Theme sourceTheme = this.sourceDesign.getTheme();
        if (sourceTheme == null) {
            return;
        }
        String themeName = sourceTheme.getName();
        Theme newTheme = new Theme();
        String namespace = sourceTheme.getRoot().getNamespace();
        if (namespace != null) {
            newTheme.setName(String.valueOf(themeName) + "-" + namespace);
        }
        ContainerContext context = new ContainerContext((DesignElement)this.targetDesign, 10);
        this.addElement(this.targetDesign, context, newTheme);
        this.targetDesign.manageId(newTheme, true);
        ReportDesignHandle targetDesignHandle = (ReportDesignHandle)this.targetDesign.getHandle(this.targetDesign);
        try {
            targetDesignHandle.setThemeName(newTheme.getName());
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
    }

    private List<Object> getRootScriptLibsName(List<Object> scriptLibList) {
        ArrayList<Object> scriptLibsPath = new ArrayList<Object>();
        int i = 0;
        while (i < scriptLibList.size()) {
            ScriptLib sourceScriptLib = (ScriptLib)scriptLibList.get(i);
            scriptLibsPath.add(sourceScriptLib.getName());
            ++i;
        }
        return scriptLibsPath;
    }

    private List<Object> getRootScriptLibs(ReportDesign root) {
        Object obj = root.getProperty((Module)root, "scriptLibs");
        if (obj == null) {
            return Collections.emptyList();
        }
        return (List)obj;
    }

    private void localizeScriptLibValues(ReportDesign source, ReportDesign target) {
        List<Library> libs = source.getAllLibraries();
        ArrayList<Object> targetValueList = new ArrayList<Object>(this.getRootScriptLibs(source));
        List<Object> relativePathList = this.getRootScriptLibsName(targetValueList);
        ElementPropertyDefn propDefn = source.getPropertyDefn("scriptLibs");
        int i = 0;
        while (i < libs.size()) {
            Library lib = libs.get(i);
            Object obj = lib.getProperty((Module)lib, propDefn);
            if (obj != null) {
                List sourceValueList = (List)obj;
                int j = 0;
                while (j < sourceValueList.size()) {
                    ScriptLib sourceScriptLib = (ScriptLib)sourceValueList.get(j);
                    String sourceScriptLibPath = sourceScriptLib.getName();
                    if (!relativePathList.contains(sourceScriptLibPath)) {
                        ScriptLib targetScriptLib = new ScriptLib();
                        targetScriptLib.setName(sourceScriptLibPath);
                        targetScriptLib.setContext(new StructureContext(target, target.getPropertyDefn("scriptLibs"), (Structure)targetScriptLib));
                        relativePathList.add(sourceScriptLibPath);
                        targetValueList.add(targetScriptLib);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!targetValueList.isEmpty()) {
            target.setProperty(propDefn, targetValueList);
        }
    }

    void localizeIncludeResourceValues(ReportDesign source, ReportDesign target) {
        this.localizeIncludeValues(source, target, "includeResource");
    }

    private void localizeIncludeScriptValues(ReportDesign source, ReportDesign target) {
        this.localizeIncludeValues(source, target, "includeScripts");
    }

    private void localizeIncludeValues(ReportDesign source, ReportDesign target, String propName) {
        ElementPropertyDefn propDefn = source.getPropertyDefn(propName);
        Object obj = source.getProperty((Module)source, propDefn);
        ArrayList newValues = new ArrayList();
        if (obj != null) {
            newValues.addAll((List)obj);
        }
        for (Library lib : source.getAllLibraries()) {
            Object libObj = lib.getProperty((Module)lib, propDefn);
            if (libObj == null) continue;
            for (Object value : (List)libObj) {
                if (newValues.contains(value)) continue;
                newValues.add(value);
            }
        }
        if (!newValues.isEmpty()) {
            target.setProperty(propDefn, newValues);
        }
    }

    private void visitCssStyleSheets(ReportDesign source, ReportDesign target) {
        ArrayList<CssStyleSheet> allSheet = new ArrayList<CssStyleSheet>();
        List<CssStyleSheet> sheets = source.getCsses();
        int i = 0;
        while (i < sheets.size()) {
            CssStyleSheet sheet = sheets.get(i);
            CssStyleSheet newSheet = this.visitCssStyleSheet(sheet);
            newSheet.setContainer(target);
            target.addCss(newSheet);
            allSheet.add(newSheet);
            ++i;
        }
        Theme theme = source.getTheme(source.getRoot());
        if (theme != null) {
            sheets = theme.getCsses();
            int i2 = 0;
            while (i2 < sheets.size()) {
                CssStyleSheet sheet = sheets.get(i2);
                CssStyleSheet newSheet = this.visitCssStyleSheet(sheet);
                newSheet.setContainer(target);
                target.addCss(newSheet);
                allSheet.add(newSheet);
                ++i2;
            }
        }
        if (!allSheet.isEmpty()) {
            ArrayList<IncludedCssStyleSheet> value = new ArrayList<IncludedCssStyleSheet>();
            for (CssStyleSheet sheet : sheets) {
                IncludedCssStyleSheet css = StructureFactory.createIncludedCssStyleSheet();
                css.setFileName(sheet.getFileName());
                css.setExternalCssURI(sheet.getExternalCssURI());
                css.setUseExternalCss(sheet.isUseExternalCss());
                value.add(css);
            }
            ElementPropertyDefn defn = target.getPropertyDefn("cssStyleSheets");
            if (!value.isEmpty()) {
                target.setProperty(defn, ModelUtil.copyValue(defn, value));
            }
        }
    }

    private CssStyleSheet visitCssStyleSheet(CssStyleSheet sheet) {
        CssStyleSheet newSheet = new CssStyleSheet();
        newSheet.setFileName(sheet.getFileName());
        newSheet.setExternalCssURI(sheet.getExternalCssURI());
        newSheet.setUseExternalCss(sheet.isUseExternalCss());
        List<CssStyle> styles = sheet.getStyles();
        int i = 0;
        while (i < styles.size()) {
            CssStyle style = styles.get(i);
            CssStyle newStyle = this.visitCssStyle(style);
            newStyle.setCssStyleSheet(newSheet);
            newSheet.addStyle(newStyle);
            ++i;
        }
        return newSheet;
    }

    private CssStyle visitCssStyle(CssStyle style) {
        CssStyle newStyle = new CssStyle(style.getName());
        this.localizePrivateStyleProperties(newStyle, style, style.getRoot(), new HashSet<String>());
        return newStyle;
    }

    private DesignElement visitExternalElement(DesignElement element) {
        if (element instanceof Theme) {
            return null;
        }
        DesignElement newElement = ElementFactoryUtil.newElement(element.getDefn().getName(), element.getName());
        IElementDefn elementDefn = newElement.getDefn();
        if (elementDefn.isContainer()) {
            List<IElementPropertyDefn> properties;
            int slotCount = elementDefn.getSlotCount();
            if (slotCount > 0) {
                this.visitExternalSlots(element, newElement, slotCount);
            }
            if ((properties = elementDefn.getContents()).size() > 0) {
                this.visitExternalContainerProperties(element, newElement, properties);
            }
        }
        this.localizePropertyValues(element, newElement);
        this.cacheMapping(element, newElement);
        if (newElement instanceof Cube) {
            Cube cube = (Cube)newElement;
            cube.updateLayout(this.targetDesign);
        } else if (newElement instanceof TabularDimension) {
            TabularDimension dimension = (TabularDimension)newElement;
            dimension.updateLayout(this.targetDesign);
        }
        return newElement;
    }

    private DesignElement visitExternalReferencableStyledElement(ReferencableStyledElement element, DesignElement sourceElement) {
        ReportItem tmpItem = (ReportItem)element;
        DesignElement derivedElement = this.findExtendsChild(tmpItem, sourceElement);
        if (derivedElement == null) {
            logger.log(Level.WARNING, "Error occurs during resolves element references.");
            return null;
        }
        DesignElement tmpItem1 = this.findMatchedVirtualChild(this.sourceDesign, derivedElement, tmpItem);
        if (tmpItem1 == null) {
            logger.log(Level.WARNING, "Error occurs during resolves element references.");
            return null;
        }
        if ((tmpItem1 = this.targetDesign.getElementByID(tmpItem1.getID())) == null) {
            logger.log(Level.WARNING, "Error occurs during resolves element references.");
        }
        return tmpItem1;
    }

    private DesignElement findExtendsChild(ReferencableStyledElement element, DesignElement sourceElement) {
        DesignElement tmpElement = element;
        DesignElement sourceContainer = sourceElement;
        while (sourceContainer != null) {
            if (sourceContainer.getExtendsElement() != null) break;
            sourceContainer = sourceContainer.getContainer();
        }
        while (tmpElement != null) {
            if (!(tmpElement instanceof ReferencableStyledElement)) {
                tmpElement = tmpElement.getContainer();
                continue;
            }
            List<DesignElement> clients = tmpElement.getDerived();
            int i = 0;
            while (i < clients.size()) {
                DesignElement tmpDerived = clients.get(i);
                if (tmpDerived.getRoot() == this.sourceDesign && tmpDerived == sourceContainer) {
                    return tmpDerived;
                }
                ++i;
            }
            tmpElement = tmpElement.getContainer();
        }
        return tmpElement;
    }

    private DesignElement findMatchedVirtualChild(Module module, DesignElement container, DesignElement virtualParent) {
        ContentIterator iter1 = new ContentIterator(module, container);
        while (iter1.hasNext()) {
            DesignElement tmpElement = iter1.next();
            if (tmpElement.getBaseId() != virtualParent.getID()) continue;
            return tmpElement;
        }
        return null;
    }

    private void visitExternalContainerProperties(DesignElement obj, DesignElement newElement, List<IElementPropertyDefn> properties) {
        this.elements.push(newElement);
        int i = 0;
        while (i < properties.size()) {
            PropertyDefn propDefn = (PropertyDefn)((Object)properties.get(i));
            this.visitExternalContents(this.sourceDesign, new ContainerContext(obj, propDefn.getName()));
            ++i;
        }
        this.elements.pop();
    }

    private void visitExternalContents(Module module, ContainerContext context) {
        List<DesignElement> contents = context.getContents(module);
        Iterator<DesignElement> iter = contents.iterator();
        DesignElement tmpContainer = this.elements.peek();
        while (iter.hasNext()) {
            DesignElement tmpElement = iter.next();
            DesignElement cachedExternalElement = this.getCache(tmpElement);
            if (cachedExternalElement != null) {
                ContainerContext newContext = context.createContext(tmpContainer);
                this.addElement(module, newContext, cachedExternalElement);
                continue;
            }
            this.visitExternalElement(tmpElement);
        }
    }

    private void visitExternalSelector(Style element, Module elementRoot) {
        String tmpStyleName = element.getName().toLowerCase();
        if (MetaDataDictionary.getInstance().getPredefinedStyle(tmpStyleName) == null) {
            return;
        }
        Style sourceDesignStyle = (Style)this.targetDesign.findNativeStyle(tmpStyleName);
        if (sourceDesignStyle == null) {
            ElementFactory factory = new ElementFactory(this.targetDesign);
            DesignElement newElement = factory.newElement(element.getDefn().getName(), element.getName()).getElement();
            this.localizePropertyValues(element, newElement);
            this.cacheMapping(element, newElement);
            newElement.setName(tmpStyleName);
            return;
        }
        Iterator<String> iter1 = element.propertyWithLocalValueIterator();
        while (iter1.hasNext()) {
            String elem = iter1.next();
            if (sourceDesignStyle.getLocalProperty((Module)this.targetDesign, elem) != null) continue;
            Object value = element.getLocalProperty(elementRoot, elem);
            sourceDesignStyle.setProperty(elem, value);
        }
    }

    private void localizeUserPropDefn(DesignElement element, DesignElement newElement) {
        Iterator<UserPropertyDefn> iter = null;
        DesignElement current = element;
        do {
            if (!current.hasUserProperties()) continue;
            for (UserPropertyDefn uDefn : current.getLocalUserProperties()) {
                if (newElement.getLocalUserPropertyDefn(uDefn.getName()) != null) continue;
                newElement.addUserPropertyDefn((UserPropertyDefn)uDefn.copy());
            }
        } while ((current = current.isVirtualElement() ? current.getVirtualParent() : current.getExtendsElement()) != null);
    }

    protected Iterator<IElementPropertyDefn> getLocalizablePropertyDefns(DesignElement element) {
        Iterator<IElementPropertyDefn> iter = element.getPropertyDefns().iterator();
        return iter;
    }

    private void localizePropertyValues(DesignElement element, DesignElement newElement) {
        this.localizeUserPropDefn(element, newElement);
        Module root = element.getRoot();
        if (element instanceof IExtendableElement) {
            ModelUtil.duplicateExtensionIdentifier(element, newElement, root);
        }
        Iterator<IElementPropertyDefn> iter = this.getLocalizablePropertyDefns(element);
        block8: while (iter.hasNext()) {
            ElementPropertyDefn propDefn = (ElementPropertyDefn)iter.next();
            String propName = propDefn.getName();
            if ("extends".equals(propName) || "userProperties".equals(propName) || "theme".equals(propName) || "libraries".equals(propName) || "propertyBindings".equals(propName) || propDefn.isStyleProperty() && !(element instanceof Style)) continue;
            Object value = this.getLocalizablePropertyValue(root, element, propDefn);
            if ("style".equals(propName) && propDefn.getTypeCode() == 15) {
                if (value == null || ((ElementRefValue)value).isResolved() || !(element instanceof StyledElement)) continue;
                ((StyledElement)newElement).setStyleName(((ElementRefValue)value).getName());
                continue;
            }
            if (value == null) continue;
            switch (propDefn.getTypeCode()) {
                case 15: {
                    if (newElement instanceof Dimension && "defaultHierarchy".equals(propName)) {
                        this.handleDefaultHierarchy((Dimension)newElement, (Dimension)element);
                        break;
                    }
                    this.handleElementRefValue(newElement, element, propDefn, (ElementRefValue)value);
                    break;
                }
                case 19: {
                    this.handleStructureRefValue(newElement, propDefn, (StructRefValue)value);
                    break;
                }
                case 20: {
                    if (propDefn.getSubTypeCode() == 15) {
                        this.handleElementRefValueList(newElement, propDefn, (List)value);
                        break;
                    }
                    if (newElement.getLocalProperty(null, propDefn) != null) continue block8;
                    newElement.setProperty(propDefn, ModelUtil.copyValue(propDefn, value));
                    break;
                }
                case 16: {
                    if (newElement instanceof Cube && "dimensionConditions".equals(propDefn.getName()) && element.getRoot() == this.sourceDesign) {
                        this.handleDimensionConditions((Cube)newElement, (Cube)element);
                        break;
                    }
                    this.handleStructureValue(newElement, propDefn, value);
                    break;
                }
                case 23: {
                    break;
                }
                case 24: {
                    this.handleContentElementValue(newElement, propDefn, value);
                    break;
                }
                default: {
                    if (newElement.getLocalProperty(null, propDefn) != null) continue block8;
                    if (propDefn.isEncryptable()) {
                        String encryption = element.getEncryptionID(propDefn);
                        newElement.setEncryptionHelper(propDefn, encryption);
                        value = EncryptionUtil.encrypt(propDefn, encryption, value);
                        newElement.setProperty(propDefn, value);
                        break;
                    }
                    newElement.setProperty(propDefn, value);
                }
            }
        }
    }

    protected Object getLocalizablePropertyValue(Module module, DesignElement element, ElementPropertyDefn propDefn) {
        return element.getStrategy().getPropertyFromElement(module, element, propDefn);
    }

    private void handleDimensionConditions(Cube newCube, Cube cube) {
        if (newCube.getLocalProperty((Module)this.targetDesign, "dimensionConditions") != null) {
            return;
        }
        if (this.cubes.get(newCube) == null) {
            this.cubes.put(newCube, cube);
        }
    }

    private void localizeDimensionConditions() {
        if (this.cubes.isEmpty()) {
            return;
        }
        for (Cube newCube : this.cubes.keySet()) {
            Cube srcCube = this.cubes.get(newCube);
            ElementPropertyDefn propDefn = srcCube.getPropertyDefn("dimensionConditions");
            List dimensionConditionList = (List)srcCube.getProperty((Module)this.sourceDesign, propDefn);
            StructureContext dimensionConditionsContext = new StructureContext(newCube, propDefn, null);
            if (dimensionConditionList == null) continue;
            int i = 0;
            while (i < dimensionConditionList.size()) {
                DimensionCondition dimensionCond = (DimensionCondition)dimensionConditionList.get(i);
                DimensionCondition newDimensionCond = (DimensionCondition)dimensionCond.copy();
                dimensionConditionsContext.add(newDimensionCond);
                ElementRefValue hierarchyRef = (ElementRefValue)dimensionCond.getLocalProperty((Module)this.sourceDesign, "hierarchy");
                if (hierarchyRef != null && hierarchyRef.isResolved()) {
                    DesignElement hierarchy = hierarchyRef.getElement();
                    assert (hierarchy != null);
                    int hierarchyIndex = hierarchy.getIndex(this.sourceDesign);
                    DesignElement dimension = hierarchy.getContainer();
                    assert (dimension != null);
                    int dimensionIndex = dimension.getIndex(this.sourceDesign);
                    DesignElement newDimension = this.getContent(this.targetDesign, newCube, "dimensions", dimensionIndex);
                    assert (newDimension != null);
                    DesignElement newHierarchy = this.getContent(this.targetDesign, newDimension, "hierarchies", hierarchyIndex);
                    assert (newHierarchy != null);
                    newDimensionCond.setProperty("hierarchy", (Object)new ElementRefValue(null, newHierarchy));
                    List joinConditionList = (List)dimensionCond.getProperty((Module)this.sourceDesign, "joinConditions");
                    if (joinConditionList != null && !joinConditionList.isEmpty()) {
                        List newJoinConditionList = (List)newDimensionCond.getProperty((Module)this.targetDesign, "joinConditions");
                        int j = 0;
                        while (j < joinConditionList.size()) {
                            DimensionJoinCondition joinCond = (DimensionJoinCondition)joinConditionList.get(j);
                            DimensionJoinCondition newJoinCond = (DimensionJoinCondition)newJoinConditionList.get(j);
                            ElementRefValue levelRef = (ElementRefValue)joinCond.getLocalProperty((Module)this.sourceDesign, "level");
                            if (levelRef != null && levelRef.isResolved()) {
                                DesignElement level = levelRef.getElement();
                                assert (level != null);
                                int levelIndex = level.getIndex(this.sourceDesign);
                                if (level.getContainer() == hierarchy) {
                                    DesignElement newLevel = this.getContent(this.targetDesign, newHierarchy, "levels", levelIndex);
                                    assert (newLevel != null);
                                    newJoinCond.setProperty("level", (Object)new ElementRefValue(null, newLevel));
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void handleDefaultHierarchy(Dimension newDimension, Dimension dimension) {
        if (newDimension.getLocalProperty((Module)this.targetDesign, "defaultHierarchy") != null) {
            return;
        }
        if (this.dimensions.get(newDimension) == null) {
            this.dimensions.put(newDimension, dimension);
        }
    }

    private void localizeDefaultHierarchy() {
        if (this.dimensions.isEmpty()) {
            return;
        }
        for (Dimension newDimension : this.dimensions.keySet()) {
            Dimension srcDimension = this.dimensions.get(newDimension);
            ModelUtil.duplicateDefaultHierarchy(newDimension, srcDimension);
        }
    }

    private DesignElement getContent(Module module, DesignElement element, String propName, int index) {
        Object value = element.getProperty(module, propName);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List valueList = (List)value;
            if (index >= 0 && index < valueList.size()) {
                return (DesignElement)valueList.get(index);
            }
        } else if (value instanceof DesignElement && index == 0) {
            return (DesignElement)value;
        }
        return null;
    }

    private void handleContentElementValue(DesignElement newElement, PropertyDefn propDefn, Object value) {
        this.elements.push(newElement);
        if (propDefn.isListType()) {
            List tmplist = (List)value;
            int i = 0;
            while (i < tmplist.size()) {
                DesignElement tmpElement = (DesignElement)tmplist.get(i);
                tmpElement.apply(this);
                ++i;
            }
            this.elements.pop();
            return;
        }
        ((DesignElement)value).apply(this);
        this.elements.pop();
    }

    private void handleStructureValue(DesignElement newElement, PropertyDefn propDefn, Object valueList) {
        assert (propDefn.getTypeCode() == 16);
        if (propDefn.isList() && "images".equalsIgnoreCase(propDefn.getName())) {
            StructureContext context = new StructureContext(newElement, (ElementPropertyDefn)propDefn, null);
            this.localizeEmbeddedImage((List)valueList, context);
        } else {
            newElement.setProperty(propDefn, this.createNewStructureValue(propDefn, valueList));
        }
    }

    private Object createNewStructureValue(PropertyDefn propDefn, Object value) {
        Cloneable newValue = null;
        if (propDefn.isList()) {
            List sourceValue = (List)value;
            newValue = new ArrayList();
            int i = 0;
            while (i < sourceValue.size()) {
                Structure newStruct = this.doCreateNewStructureValue((Structure)sourceValue.get(i));
                ((List)((Object)newValue)).add(newStruct);
                ++i;
            }
        } else {
            newValue = this.doCreateNewStructureValue((Structure)value);
        }
        return newValue;
    }

    private Structure doCreateNewStructureValue(Structure struct) {
        Structure newStruct = (Structure)struct.copy();
        Iterator<IPropertyDefn> iter = struct.getObjectDefn().propertiesIterator();
        while (iter.hasNext()) {
            StructPropertyDefn memberDefn = (StructPropertyDefn)iter.next();
            Object value = struct.getLocalProperty((Module)this.sourceDesign, memberDefn);
            if (value == null) continue;
            switch (memberDefn.getTypeCode()) {
                case 15: {
                    this.handleElementRefValue(newStruct, memberDefn, (ElementRefValue)value);
                    break;
                }
                case 16: {
                    newStruct.setProperty(memberDefn, this.createNewStructureValue(memberDefn, value));
                    break;
                }
                default: {
                    newStruct.setProperty(memberDefn, ModelUtil.copyValue(memberDefn, value));
                }
            }
        }
        return newStruct;
    }

    private void handleElementRefValue(Structure structure, PropertyDefn propDefn, ElementRefValue value) {
        DesignElement refElement = value.getElement();
        if (this.needExportReferredElement(refElement)) {
            DesignElement newRefEelement = this.getCache(refElement);
            if (newRefEelement == null) {
                newRefEelement = this.visitExternalElement(refElement);
            }
            assert (newRefEelement != null);
            structure.setProperty(propDefn, (Object)new ElementRefValue(null, newRefEelement));
        } else {
            structure.setProperty(propDefn, (Object)new ElementRefValue(value.getLibraryNamespace(), value.getName()));
        }
    }

    private void handleElementRefValueList(DesignElement newElement, PropertyDefn propDefn, List<ElementRefValue> valueList) {
        ArrayList<ElementRefValue> values = new ArrayList<ElementRefValue>();
        int i = 0;
        while (i < valueList.size()) {
            ElementRefValue item = valueList.get(i);
            DesignElement refElement = item.getElement();
            if (this.needExportReferredElement(refElement)) {
                DesignElement newRefEelement = this.getCache(refElement);
                if (newRefEelement == null) {
                    newRefEelement = this.visitExternalElement(refElement);
                }
                values.add(new ElementRefValue(null, newRefEelement));
            } else {
                values.add(new ElementRefValue(null, item.getName()));
            }
            ++i;
        }
        newElement.setProperty(propDefn, values);
    }

    private void handleStructureRefValue(DesignElement newElement, PropertyDefn propDefn, StructRefValue value) {
        if (!this.isLocalImage(value.getQualifiedReference())) {
            EmbeddedImage targetEmbeddedImage = (EmbeddedImage)value.getTargetStructure();
            EmbeddedImage newEmbeddedIamge = this.localizeExternalEmbeddedImage(targetEmbeddedImage);
            newElement.setProperty(propDefn, (Object)new StructRefValue(null, newEmbeddedIamge));
        } else {
            newElement.setProperty(propDefn, ModelUtil.copyValue(propDefn, value));
        }
    }

    private void handleElementRefValue(DesignElement newElement, DesignElement sourceElement, PropertyDefn propDefn, ElementRefValue value) {
        DesignElement refElement = value.getElement();
        if (this.needExportReferredElement(refElement)) {
            DesignElement newRefElement = this.getCache(refElement);
            if (newRefElement == null) {
                newRefElement = refElement instanceof ReferencableStyledElement ? this.visitExternalReferencableStyledElement((ReferencableStyledElement)refElement, sourceElement) : this.visitExternalElement(refElement);
            }
            if (newRefElement != null) {
                newElement.setProperty(propDefn, (Object)new ElementRefValue(null, newRefElement));
            } else {
                newElement.setProperty(propDefn, (Object)new ElementRefValue(null, refElement.getName()));
            }
        } else {
            this.setElementRefProperty(newElement, propDefn, value);
        }
    }

    protected void setElementRefProperty(DesignElement newElement, PropertyDefn propDefn, ElementRefValue value) {
        boolean isDynamicLinkerChildren = false;
        DesignElement e = value.getElement();
        while (e != null) {
            Cube containerCube;
            if (e instanceof Cube && (containerCube = (Cube)e).getDynamicExtendsElement(this.sourceDesign) != null) {
                isDynamicLinkerChildren = true;
                break;
            }
            e = e.getContainer();
        }
        if (!isDynamicLinkerChildren) {
            newElement.setProperty(propDefn, (Object)new ElementRefValue(value.getLibraryNamespace(), value.getName()));
        } else {
            newElement.setProperty(propDefn, (Object)new ElementRefValue(null, value.getName()));
        }
    }

    private boolean needExportReferredElement(DesignElement element) {
        Module root;
        return element != null && (root = element.getRoot()) != this.sourceDesign && root instanceof Library && !this.isDynamicLinkerVirtualElement(root, element);
    }

    private boolean isDynamicLinkerVirtualElement(Module module, DesignElement element) {
        if (element.isVirtualElement()) {
            DesignElement focus = element;
            while (focus != null) {
                if (focus.getDynamicExtendsElement(module) != null) {
                    return true;
                }
                focus = focus.getContainer();
            }
        }
        return false;
    }

    private void localizeEmbeddedImage(List<Object> sourceEmbeddedImage, StructureContext targetContext) {
        List targetEmeddedImage = targetContext.getList(this.targetDesign);
        if (targetEmeddedImage == null) {
            targetEmeddedImage = Collections.emptyList();
        }
        int i = 0;
        while (i < sourceEmbeddedImage.size()) {
            EmbeddedImage sourceImage = (EmbeddedImage)sourceEmbeddedImage.get(i);
            if (!targetEmeddedImage.contains(sourceImage)) {
                EmbeddedImage newEmeddedImage = (EmbeddedImage)sourceImage.copy();
                this.localizeEmbeddedImageValues(sourceImage, newEmeddedImage);
                targetContext.add(newEmeddedImage);
            }
            ++i;
        }
    }

    private void localizeEmbeddedImageValues(EmbeddedImage sourceEmbeddedImage, EmbeddedImage targetEmeddedImage) {
        EmbeddedImage tmpEmeddedImage = sourceEmbeddedImage;
        while (tmpEmeddedImage != null && (targetEmeddedImage.getData(null) == null || targetEmeddedImage.getType(null) == null)) {
            targetEmeddedImage.setData(tmpEmeddedImage.getData(this.sourceDesign));
            targetEmeddedImage.setType(tmpEmeddedImage.getType(this.sourceDesign));
            StructRefValue refValue = (StructRefValue)tmpEmeddedImage.getProperty((Module)this.sourceDesign, "libReference");
            if (refValue == null) break;
            tmpEmeddedImage = (EmbeddedImage)refValue.getTargetStructure();
        }
        targetEmeddedImage.setProperty("libReference", null);
    }

    private EmbeddedImage localizeExternalEmbeddedImage(EmbeddedImage sourceEmbeddedImage) {
        EmbeddedImage newEmeddedImage = (EmbeddedImage)this.getCache(sourceEmbeddedImage);
        if (newEmeddedImage != null) {
            return newEmeddedImage;
        }
        newEmeddedImage = (EmbeddedImage)this.visitExternalStruct(sourceEmbeddedImage);
        this.localizeEmbeddedImageValues(sourceEmbeddedImage, newEmeddedImage);
        return newEmeddedImage;
    }

    private void cacheMapping(DesignElement sourceElement, DesignElement targetElement) {
        this.externalElements.put(sourceElement, targetElement);
        this.targetDesign.cacheFlattenElement(sourceElement, targetElement);
    }

    private void cacheMapping(IStructure sourceStruct, IStructure targetStruct) {
        this.externalStructs.put(sourceStruct, targetStruct);
    }

    private IStructure getCache(IStructure sourceStruct) {
        return this.externalStructs.get(sourceStruct);
    }

    private DesignElement getCache(DesignElement sourceElement) {
        return this.externalElements.get(sourceElement);
    }

    private boolean isLocalImage(String imageName) {
        StructureDefn defn = (StructureDefn)MetaDataDictionary.getInstance().getStructure("EmbeddedImage");
        return StructureRefUtil.findNativeStructure(this.targetDesign, defn, imageName) != null;
    }

    private DesignElement getTargetContainer(DesignElement sourceElement, DesignElement target, List<DesignElement> processedElement) {
        DesignElement sourceContainer = sourceElement.getContainer();
        long containerId = sourceContainer.getID();
        DesignElement tmpContainer = this.externalElements.get(sourceContainer);
        if (tmpContainer == null) {
            tmpContainer = this.targetDesign.getElementByID(containerId);
        }
        if (tmpContainer == null) {
            return null;
        }
        if (sourceContainer.getElementName().equalsIgnoreCase(tmpContainer.getElementName()) || sourceContainer instanceof Module && tmpContainer == this.targetDesign) {
            return tmpContainer;
        }
        if (sourceContainer instanceof Theme) {
            return this.targetDesign;
        }
        return tmpContainer;
    }

    @Override
    public void visitMemberValue(MemberValue obj) {
        this.visitDesignElement(obj);
    }

    public DesignElementHandle newElement(String elementTypeName, String name) {
        ElementDefn elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getExtension(elementTypeName);
        if (elemDefn != null) {
            return this.newExtensionElement(elementTypeName, name);
        }
        elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement(elementTypeName);
        if (elemDefn != null) {
            DesignElement element = ElementFactoryUtil.newElementExceptExtendedItem(this.targetDesign, elementTypeName, name);
            if (element == null) {
                return null;
            }
            return element.getHandle(this.targetDesign);
        }
        return null;
    }

    public DesignElementHandle newElement(String elementTypeName, String name, ContainerContext targetContext) {
        ElementDefn elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getExtension(elementTypeName);
        if (elemDefn != null) {
            return this.newExtensionElement(elementTypeName, name);
        }
        elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement(elementTypeName);
        if (elemDefn != null) {
            DesignElement element = ReportDesignSerializerImpl.newElement(this.targetDesign, targetContext, elementTypeName, name);
            if (element == null) {
                return null;
            }
            return element.getHandle(this.targetDesign);
        }
        return null;
    }

    public static DesignElement newElement(Module module, ContainerContext targetContainment, String elementTypeName, String name) {
        DesignElement element = ElementFactoryUtil.newElement(elementTypeName, name);
        if (targetContainment.isManagedByNameSpace()) {
            module.rename(targetContainment.getElement(), element);
        }
        return element;
    }

    protected DesignElementHandle newExtensionElement(String elementTypeName, String name) {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension(elementTypeName);
        if (extDefn == null) {
            return null;
        }
        String extensionPoint = extDefn.getExtensionPoint();
        if ("org.eclipse.birt.report.model.reportItemModel".equalsIgnoreCase(extensionPoint)) {
            return this.newExtendedItem(name, elementTypeName);
        }
        return null;
    }

    public ExtendedItemHandle newExtendedItem(String name, String extensionName) {
        try {
            return this.newExtendedItem(name, extensionName, null);
        }
        catch (ExtendsException e) {
            assert (false);
            return null;
        }
    }

    private ExtendedItemHandle newExtendedItem(String name, String extensionName, ExtendedItemHandle parent) throws ExtendsException {
        ExtendedItemHandle handle;
        block6: {
            MetaDataDictionary dd = MetaDataDictionary.getInstance();
            ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension(extensionName);
            if (extDefn == null) {
                return null;
            }
            if (parent != null) assert (((ExtendedItem)parent.getElement()).getExtDefn() == extDefn);
            if (!(extDefn instanceof PeerExtensionElementDefn)) {
                throw new IllegalOperationException("Only report item extension can be created through this method.");
            }
            ExtendedItem element = new ExtendedItem(name);
            element.setProperty("extensionName", (Object)extensionName);
            if (parent != null) {
                element.getHandle(this.targetDesign).setExtends(parent);
            }
            this.targetDesign.makeUniqueName(element);
            handle = element.handle(this.targetDesign);
            try {
                handle.loadExtendedElement();
            }
            catch (ExtendedElementException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        return handle;
    }

    @Override
    public void visitContentElement(ContentElement obj) {
        this.visitDesignElement(obj);
    }

    @Override
    public void visitReportItemTheme(ReportItemTheme obj) {
        this.visitDesignElement(obj);
        ReportItemTheme newTheme = (ReportItemTheme)this.currentNewElement;
        this.reportItemThemes.put(obj.getHandle(obj.getRoot()).getQualifiedName(), newTheme);
    }
}

