/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.newelement;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LineHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.RectangleHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.OdaCubeHandle;
import org.eclipse.birt.report.model.api.olap.OdaDimensionHandle;
import org.eclipse.birt.report.model.api.olap.OdaHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.OdaLevelHandle;
import org.eclipse.birt.report.model.api.olap.OdaMeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.OdaMeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureHandle;

public class DesignElementFactory
extends ElementFactory {
    protected Logger logger = Logger.getLogger(DesignElementFactory.class.getName());
    ElementFactory factory = null;

    @Deprecated
    public static DesignElementFactory getInstance() {
        return new DesignElementFactory(SessionHandleAdapter.getInstance().getReportDesignHandle());
    }

    public static DesignElementFactory getInstance(ModuleHandle module) {
        return new DesignElementFactory(module);
    }

    protected DesignElementFactory(ModuleHandle module) {
        super(module.getModule());
        this.factory = new ElementFactory(module.getModule());
    }

    private String getNewName(String elementTypeName, String name) {
        if (name == null) {
            name = ReportPlugin.getDefault().getCustomName(elementTypeName);
        }
        return name;
    }

    public DesignElementHandle newElement(String elementTypeName, String name) {
        String newName = this.getNewName(elementTypeName, name);
        return this.factory.newElement(elementTypeName, newName);
    }

    public FreeFormHandle newFreeForm(String name) {
        String newName = this.getNewName("FreeForm", name);
        return this.factory.newFreeForm(newName);
    }

    public DataItemHandle newDataItem(String name) {
        String newName = this.getNewName("Data", name);
        return this.factory.newDataItem(newName);
    }

    public AutoTextHandle newAutoText(String name) {
        String newName = this.getNewName("AutoText", name);
        return this.factory.newAutoText(newName);
    }

    public LabelHandle newLabel(String name) {
        String newName = this.getNewName("Label", name);
        return this.factory.newLabel(newName);
    }

    public ImageHandle newImage(String name) {
        String newName = this.getNewName("Image", name);
        return this.factory.newImage(newName);
    }

    public ListHandle newList(String name) {
        String newName = this.getNewName("List", name);
        return this.factory.newList(newName);
    }

    public GraphicMasterPageHandle newGraphicMasterPage(String name) {
        String newName = this.getNewName("GraphicMasterPage", name);
        return this.factory.newGraphicMasterPage(newName);
    }

    public SimpleMasterPageHandle newSimpleMasterPage(String name) {
        String newName = this.getNewName("SimpleMasterPage", name);
        return this.factory.newSimpleMasterPage(newName);
    }

    public ParameterGroupHandle newParameterGroup(String name) {
        String newName = this.getNewName("ParameterGroup", name);
        return this.factory.newParameterGroup(newName);
    }

    public ScalarParameterHandle newScalarParameter(String name) {
        String newName = this.getNewName("ScalarParameter", name);
        return this.factory.newScalarParameter(newName);
    }

    public SharedStyleHandle newStyle(String name) {
        String newName = this.getNewName("Style", name);
        return this.factory.newStyle(newName);
    }

    public ThemeHandle newTheme(String name) {
        String newName = this.getNewName("Theme", name);
        return this.factory.newTheme(newName);
    }

    public TextItemHandle newTextItem(String name) {
        String newName = this.getNewName("Text", name);
        return this.factory.newTextItem(newName);
    }

    public TableHandle newTableItem(String name) {
        String newName = this.getNewName("Table", name);
        return this.factory.newTableItem(newName);
    }

    public TableHandle newTableItem(String name, int columnNum) {
        String newName = this.getNewName("Table", name);
        return this.factory.newTableItem(newName, columnNum);
    }

    public TableHandle newTableItem(String name, int columnNum, int headerRow, int detailRow, int footerRow) {
        String newName = this.getNewName("Table", name);
        return this.factory.newTableItem(newName, columnNum, headerRow, detailRow, footerRow);
    }

    public GridHandle newGridItem(String name) {
        String newName = this.getNewName("Grid", name);
        return this.factory.newGridItem(newName);
    }

    public GridHandle newGridItem(String name, int columnNum, int rowNum) {
        String newName = this.getNewName("Grid", name);
        return this.factory.newGridItem(newName, columnNum, rowNum);
    }

    public LineHandle newLineItem(String name) {
        String newName = this.getNewName("Line", name);
        return this.factory.newLineItem(newName);
    }

    public RectangleHandle newRectangle(String name) {
        String newName = this.getNewName("Rectangle", name);
        return this.factory.newRectangle(newName);
    }

    public TextDataHandle newTextData(String name) {
        String newName = this.getNewName("TextData", name);
        return this.factory.newTextData(newName);
    }

    public ExtendedItemHandle newExtendedItem(String name, String extensionName) {
        String newName = this.getNewName(extensionName, name);
        return this.factory.newExtendedItem(newName, extensionName);
    }

    public ScriptDataSourceHandle newScriptDataSource(String name) {
        String newName = this.getNewName("ScriptDataSource", name);
        return this.factory.newScriptDataSource(newName);
    }

    public ScriptDataSetHandle newScriptDataSet(String name) {
        String newName = this.getNewName("ScriptDataSet", name);
        return this.factory.newScriptDataSet(newName);
    }

    public OdaDataSourceHandle newOdaDataSource(String name) {
        String newName = this.getNewName("OdaDataSource", name);
        return this.factory.newOdaDataSource(newName, null);
    }

    public OdaDataSourceHandle newOdaDataSource(String name, String extensionID) {
        String newName = this.getNewName("OdaDataSource", name);
        return this.factory.newOdaDataSource(newName, extensionID);
    }

    public OdaCubeHandle newOdaCube(String name) {
        String newName = this.getNewName("OdaCube", name);
        return this.factory.newOdaCube(newName);
    }

    public OdaDimensionHandle newOdaDimension(String name) {
        String newName = this.getNewName("OdaDimension", name);
        return this.factory.newOdaDimension(newName);
    }

    public OdaHierarchyHandle newOdaHierarchy(String name) {
        String newName = this.getNewName("OdaHierarchy", name);
        return this.factory.newOdaHierarchy(newName);
    }

    public OdaLevelHandle newOdaLevel(DimensionHandle dimensionHandle, String name) {
        String newName = this.getNewName("OdaLevel", name);
        return this.factory.newOdaLevel(dimensionHandle, newName);
    }

    @Deprecated
    public OdaLevelHandle newOdaLevel(String name) {
        String newName = this.getNewName("OdaLevel", name);
        return this.factory.newOdaLevel(newName);
    }

    public OdaMeasureHandle newOdaMeasure(String name) {
        String newName = this.getNewName("OdaMeasure", name);
        return this.factory.newOdaMeasure(newName);
    }

    public OdaMeasureGroupHandle newOdaMeasureGroup(String name) {
        String newName = this.getNewName("OdaMeasureGroup", name);
        return this.factory.newOdaMeasureGroup(newName);
    }

    public TabularCubeHandle newTabularCube(String name) {
        String newName = this.getNewName("TabularCube", name);
        return this.factory.newTabularCube(newName);
    }

    public TabularDimensionHandle newTabularDimension(String name) {
        String newName = this.getNewName("TabularDimension", name);
        return this.factory.newTabularDimension(newName);
    }

    public TabularHierarchyHandle newTabularHierarchy(String name) {
        String newName = this.getNewName("TabularHierarchy", name);
        return this.factory.newTabularHierarchy(newName);
    }

    @Deprecated
    public TabularLevelHandle newTabularLevel(String name) {
        String newName = this.getNewName("TabularLevel", name);
        return this.factory.newTabularLevel(newName);
    }

    public TabularLevelHandle newTabularLevel(DimensionHandle dimensionHandle, String name) {
        String newName = this.getNewName("TabularLevel", name);
        return this.factory.newTabularLevel(dimensionHandle, newName);
    }

    public TabularMeasureHandle newTabularMeasure(String name) {
        String newName = this.getNewName("TabularMeasure", name);
        return this.factory.newTabularMeasure(newName);
    }

    public TabularMeasureGroupHandle newTabularMeasureGroup(String name) {
        String newName = this.getNewName("TabularMeasureGroup", name);
        return this.factory.newTabularMeasureGroup(newName);
    }

    public OdaDataSetHandle newOdaDataSet(String name) {
        String newName = this.getNewName("OdaDataSet", name);
        return this.factory.newOdaDataSet(newName, null);
    }

    public OdaDataSetHandle newOdaDataSet(String name, String extensionID) {
        String newName = this.getNewName("OdaDataSet", name);
        return this.factory.newOdaDataSet(newName, extensionID);
    }

    public DesignElementHandle newElementFrom(DesignElementHandle element, String name) throws ExtendsException {
        String newName = this.getNewName(element.getElement().getElementName(), name);
        return this.factory.newElementFrom(element, newName);
    }

    public TableGroupHandle newTableGroup() {
        TableGroupHandle handle = this.factory.newTableGroup();
        try {
            handle.setHideDetail(false);
        }
        catch (SemanticException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return handle;
    }

    public ListGroupHandle newListGroup() {
        ListGroupHandle handle = this.factory.newListGroup();
        try {
            handle.setHideDetail(false);
        }
        catch (SemanticException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return handle;
    }
}

