/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.AbstractHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.CellContentHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.FlattenedTableHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;

public class FlattenedTableCellHandler
extends AbstractHandler {
    private CellContentHandler contentHandler;

    public FlattenedTableCellHandler(CellContentHandler contentHandler, Logger log, IHandler parent, ICellContent cell) {
        super(log, parent, (IContent)cell);
        this.contentHandler = contentHandler;
    }

    @Override
    public void startCell(HandlerState state, ICellContent cell) throws BirtException {
    }

    @Override
    public void endCell(HandlerState state, ICellContent cell) throws BirtException {
        this.contentHandler.lastCellContentsWasBlock = false;
        this.contentHandler.lastCellContentsRequiresSpace = true;
        state.setHandler(this.parent);
    }

    @Override
    public void startTable(HandlerState state, ITableContent table) throws BirtException {
        state.setHandler(new FlattenedTableHandler(this.contentHandler, this.log, this, table));
        state.getHandler().startTable(state, table);
    }

    @Override
    public void emitText(HandlerState state, ITextContent text) throws BirtException {
        this.contentHandler.emitText(state, text);
    }

    @Override
    public void emitData(HandlerState state, IDataContent data) throws BirtException {
        this.contentHandler.emitData(state, data);
    }

    @Override
    public void emitLabel(HandlerState state, ILabelContent label) throws BirtException {
        this.contentHandler.emitLabel(state, label);
    }

    @Override
    public void emitAutoText(HandlerState state, IAutoTextContent autoText) throws BirtException {
        this.contentHandler.emitAutoText(state, autoText);
    }

    @Override
    public void emitForeign(HandlerState state, IForeignContent foreign) throws BirtException {
        this.contentHandler.emitForeign(state, foreign);
    }

    @Override
    public void emitImage(HandlerState state, IImageContent image) throws BirtException {
        this.contentHandler.emitImage(state, image);
    }
}

