/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.UnitPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UnitPropertyDescriptor
extends PropertyDescriptor {
    protected static final String ERROR_MESSAGE = Messages.getString((String)"UnitPropertyDescriptor.error.message");
    protected static final String ERROR_BOX_TITLE = Messages.getString((String)"UnitPropertyDescriptor.error.title");
    protected Text text;
    protected CCombo combo;
    protected Composite container;
    protected String deMeasureValue;
    protected String deUnitValue;
    private boolean hasError = false;
    private boolean dirty = false;
    private boolean isReadOnly = false;

    public UnitPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    @Override
    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }

    @Override
    public void load() {
        boolean stateFlag;
        String value = this.getDescriptorProvider().load().toString();
        boolean bl = stateFlag = value == null == this.text.getEnabled();
        if (stateFlag) {
            this.text.setEnabled(value != null);
            this.combo.setEnabled(value != null);
        }
        if (this.getDescriptorProvider() instanceof UnitPropertyDescriptorProvider) {
            String deUnitValue;
            this.deMeasureValue = ((UnitPropertyDescriptorProvider)this.getDescriptorProvider()).getMeasureValue();
            if (this.deMeasureValue == null) {
                this.deMeasureValue = "";
            }
            if (!this.deMeasureValue.equals(this.text.getText())) {
                this.text.setText(this.deMeasureValue);
            }
            Object[] items = ((UnitPropertyDescriptorProvider)this.getDescriptorProvider()).getUnitItems();
            if (!Arrays.equals(this.combo.getItems(), items)) {
                this.combo.setItems((String[])items);
            }
            try {
                deUnitValue = ((UnitPropertyDescriptorProvider)this.getDescriptorProvider()).getUnitDisplayName(((UnitPropertyDescriptorProvider)this.getDescriptorProvider()).getUnit());
            }
            catch (Exception e) {
                ExceptionUtil.handle((Throwable)e);
                return;
            }
            if (deUnitValue == null) {
                this.combo.deselectAll();
            } else if (!deUnitValue.equals(this.combo.getText())) {
                this.combo.select(Arrays.asList(items).indexOf(deUnitValue));
            }
        }
    }

    @Override
    public Control getControl() {
        return this.container;
    }

    @Override
    public Control createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        this.container.setLayout((Layout)layout);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UnitPropertyDescriptor.this.handleEvent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                UnitPropertyDescriptor.this.handleEvent();
            }
        };
        this.text = this.isFormStyle() ? FormWidgetFactory.getInstance().createText(this.container, "", 131076) : new Text(this.container, 131076);
        this.text.addSelectionListener(listener);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (UnitPropertyDescriptor.this.combo.getItemCount() > 0 && (UnitPropertyDescriptor.this.combo.getText() == null || UnitPropertyDescriptor.this.combo.getText().length() == 0) && UnitPropertyDescriptor.this.getDescriptorProvider() instanceof UnitPropertyDescriptorProvider) {
                    String unit = ((UnitPropertyDescriptorProvider)UnitPropertyDescriptor.this.getDescriptorProvider()).getDefaultUnit();
                    if (unit != null) {
                        UnitPropertyDescriptor.this.combo.setText(unit);
                    } else {
                        UnitPropertyDescriptor.this.combo.setText(UnitPropertyDescriptor.this.combo.getItem(0));
                    }
                }
                UnitPropertyDescriptor.this.dirty = true;
            }
        });
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                UnitPropertyDescriptor.this.dirty = false;
            }

            public void focusLost(FocusEvent e) {
                if (!UnitPropertyDescriptor.this.hasError && UnitPropertyDescriptor.this.dirty) {
                    UnitPropertyDescriptor.this.handleEvent();
                }
            }
        });
        this.combo = new CCombo(this.container, 0x800008);
        this.combo.setVisibleItemCount(30);
        this.combo.addSelectionListener(listener);
        GridData data = new GridData();
        data.widthHint = (int)((double)this.combo.computeSize((int)-1, (int)-1).x * 1.5);
        if (this.text.computeSize((int)-1, (int)-1).y < this.combo.computeSize((int)-1, (int)-1).y) {
            data.heightHint = this.combo.computeSize((int)-1, (int)-1).y - 2;
        }
        this.text.setLayoutData((Object)data);
        data = new GridData(768);
        this.combo.setLayoutData((Object)data);
        return this.container;
    }

    protected boolean validateDimensionValue() {
        if (this.combo.isEnabled() && this.combo.getSelectionIndex() != -1) {
            String value = this.text.getText();
            String unit = this.combo.getText();
            if (this.getDescriptorProvider() instanceof UnitPropertyDescriptorProvider) {
                return ((UnitPropertyDescriptorProvider)this.getDescriptorProvider()).validateDimensionValue(value, unit);
            }
        }
        return true;
    }

    protected void handleEvent() {
        if (!this.validateDimensionValue()) {
            this.setError();
            ExceptionUtil.openError((String)ERROR_BOX_TITLE, (String)ERROR_MESSAGE);
            this.load();
            this.clearError();
            return;
        }
        String value = this.text.getText().trim();
        if (value.equals("")) {
            value = null;
        } else {
            String unitName;
            if (this.getDescriptorProvider() instanceof UnitPropertyDescriptorProvider && (unitName = ((UnitPropertyDescriptorProvider)this.getDescriptorProvider()).getUnitName(this.combo.getText())) != null) {
                value = String.valueOf(value) + unitName;
            }
            if (value.equals(String.valueOf(this.deMeasureValue) + this.deUnitValue)) {
                return;
            }
        }
        try {
            this.save(value);
        }
        catch (SemanticException e) {
            this.text.setText(this.deMeasureValue);
            WidgetUtil.processError((Shell)this.combo.getShell(), (Exception)((Object)e));
        }
        this.dirty = false;
    }

    protected void setError() {
        this.hasError = true;
    }

    protected void clearError() {
        this.hasError = false;
    }

    @Override
    public void save(Object obj) throws SemanticException {
        if (!this.isReadOnly) {
            this.getDescriptorProvider().save(obj);
        }
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.container, (boolean)isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.container.setVisible(isVisible);
    }

    public void setReadOnly(boolean isReadOnly) {
        this.text.setEditable(!isReadOnly);
        this.combo.setEnabled(!isReadOnly);
        this.isReadOnly = isReadOnly;
    }
}

