/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListBandEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListEditPart;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;

public class IncludeListHeaderAction
extends SelectionAction {
    private static final String ACTION_MSG_INCLUDE_HEADER = Messages.getString((String)"IncludeListHeaderAction.actionMsg.includeHeader");
    public static final String ID = "org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.IncludeListHeaderAction";

    public IncludeListHeaderAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setChecked(true);
        this.setText(ACTION_MSG_INCLUDE_HEADER);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void update() {
        super.update();
        if (this.getListEditpart() != null) {
            ListEditPart part = this.getListEditpart();
            this.setChecked(part.isIncludeSlotHandle(0));
        }
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Include list header action >> Run ...");
        }
        this.getListEditpart().includeSlotHandle(this.isChecked(), 0);
    }

    protected ListEditPart getListEditpart() {
        if (this.getSelectedObjects() == null || this.getSelectedObjects().isEmpty()) {
            return null;
        }
        List list = this.getSelectedObjects();
        int size = list.size();
        ListEditPart part = null;
        int i = 0;
        while (i < size) {
            Object obj = this.getSelectedObjects().get(i);
            if (obj instanceof ListEditPart) {
                part = (ListEditPart)obj;
            } else if (obj instanceof ListBandEditPart) {
                part = (ListEditPart)((ListBandEditPart)obj).getParent();
            }
            ++i;
        }
        return part;
    }
}

