/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.parameters.node;

import java.util.List;
import org.eclipse.birt.report.designer.ui.parameters.IParameter;
import org.eclipse.birt.report.designer.ui.parameters.IParameterGroup;
import org.eclipse.birt.report.designer.ui.parameters.ParameterFactory;
import org.eclipse.birt.report.designer.ui.parameters.node.CompositeParameterNode;
import org.eclipse.birt.report.designer.ui.parameters.node.IParameterNode;
import org.eclipse.birt.report.designer.ui.parameters.node.LeafParameterNode;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;

public class ParameterNodeFactory {
    public static IParameterNode buildParamTree(IGetParameterDefinitionTask task) {
        ParameterFactory factory = new ParameterFactory(task);
        List children = factory.getRootChildren();
        CompositeParameterNode rootNode = new CompositeParameterNode();
        for (Object obj : children) {
            if (obj instanceof IParameter) {
                IParameter param = (IParameter)obj;
                LeafParameterNode leaf = new LeafParameterNode(param);
                rootNode.add(leaf);
                continue;
            }
            if (!(obj instanceof IParameterGroup)) continue;
            IParameterGroup parameterGroup = (IParameterGroup)obj;
            CompositeParameterNode node = new CompositeParameterNode();
            List childList = parameterGroup.getChildren();
            rootNode.add(node);
            ParameterNodeFactory.buildParamGroup(node, childList);
        }
        return rootNode;
    }

    private static void buildParamGroup(CompositeParameterNode node, List childList) {
        assert (node != null);
        assert (childList != null);
        for (IParameter param : childList) {
            LeafParameterNode leaf = new LeafParameterNode(param);
            node.add(leaf);
        }
    }
}

