/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.activities;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.transition.common.activities.AbstractActivity;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class FinalizeSubsystemTransitionActivity
extends AbstractActivity {
    public static final String ID = "org.polarsys.capella.transition.system2subsystem.activities.FinalizeSubsystemTransitionActivity";
    public static final String PARAM__DELETE_PROJECT = "FinalizeSubsystemTransitionActivity_Delete_Project";

    protected IStatus _run(ActivityParameters activityParams_p) {
        this.unloadHoldingResource(activityParams_p);
        this.unloadTemporaryResource(activityParams_p);
        this.handleTemporaryProject(activityParams_p);
        return Status.OK_STATUS;
    }

    private boolean keepTransformationProject() {
        return Platform.getPreferencesService().getBoolean("org.polarsys.capella.transition.system2subsystem", "keeptransformationproject", false, null);
    }

    private void unloadHoldingResource(ActivityParameters activityParameters_p) {
        TransactionalEditingDomain domain = (TransactionalEditingDomain)this.getContext(activityParameters_p).get((Object)"TRANSITION_TARGET_EDITING_DOMAIN");
        if (domain != null) {
            HoldingResourceHelper.flushHoldingResource((TransactionalEditingDomain)domain);
        }
    }

    private void unloadTemporaryResource(ActivityParameters activityParams_p) {
        IContext context = this.getContext(activityParams_p);
        EObject transformationRoot = (EObject)context.get((Object)"_Tr_T_R");
        if (transformationRoot != null) {
            Resource transformationResource = transformationRoot.eResource();
            Resource targetResource = (Resource)context.get((Object)"_T_T_Res");
            if (transformationResource != null && transformationResource != targetResource) {
                if (this.keepTransformationProject()) {
                    try {
                        transformationResource.save(Collections.emptyMap());
                    }
                    catch (IOException exception_p) {
                        LogHelper.getInstance().log(exception_p.getMessage(), (IStatus)new Status(4, "org.polarsys.capella.transition.system2subsystem", exception_p.getMessage(), (Throwable)exception_p), Messages.Activity_Transformation);
                    }
                }
                transformationResource.unload();
                transformationResource.getResourceSet().getResources().remove((Object)transformationResource);
            }
            if (targetResource != null) {
                targetResource.unload();
                targetResource.getResourceSet().getResources().remove((Object)targetResource);
            }
        }
    }

    private void handleTemporaryProject(ActivityParameters activityParams_p) {
        IProject toDelete;
        if (!this.keepTransformationProject() && (toDelete = (IProject)this.getContext(activityParams_p).get((Object)PARAM__DELETE_PROJECT)) != null) {
            try {
                toDelete.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exception_p) {
                LogHelper.getInstance().log(exception_p.getMessage(), (IStatus)new Status(4, "org.polarsys.capella.transition.system2subsystem", exception_p.getMessage(), (Throwable)exception_p), Messages.Activity_Transformation);
            }
        }
    }

    public String getActivityIdentifier() {
        return ID;
    }
}

