/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests.mixed;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.transition.system2subsystem.rules.fa.FunctionalChainInvolvementRule;
import org.polarsys.capella.transition.system2subsystem.rules.fa.FunctionalChainRule;
import org.polarsys.capella.transition.system2subsystem.tests.System2SubsystemTest;

public class TestComposite568503
extends System2SubsystemTest
implements System2SubsystemTest.Interphase,
System2SubsystemTest.Crossphase {
    public static final String SUBCUTTED1 = "f310b2ee-c8a7-4038-a644-bb4d40627065";
    public static final String MAIN1 = "2436a10d-7ed4-4049-8840-5444ae27ccc5";
    public static final String MAIN2NOPRIMARYFUNCTIONS = "8c560adc-d219-45f6-a7dc-b270332ee2ac";
    public static final String SUB2 = "b83b0a73-ccf4-4e02-8009-a130d4e3c3d3";
    public static final String MAINDROPPEDSUB = "2491bf3e-e1fe-41e6-84bc-5a131f0b27d6";
    public static final String DROPPEDSUB = "a1e38021-673b-4e2a-8391-42bf9215c5e7";
    public static final String SUB4 = "c3ebee6d-8935-4cf6-9e62-43cc170c3f0c";
    public static final String SUB5CUTTED = "037256e8-f75d-4f19-978e-50173cd7f8bc";
    public static final String MAINSUB45 = "06570814-3b3d-4898-8ee0-a0bd975b156c";
    public static final String FUNCTIONALCHAIN_13 = "d6540774-7eba-4781-819c-61c823b61b26";
    public static final String FUNCTIONALCHAIN_12 = "80084302-e796-4be8-abd9-5e3d5d789d1a";
    public static final String MAININVFUNC = "68b33122-a672-48f1-802d-7269eacaa03d";
    public static final String FUNCTIONALCHAIN_14 = "37d97a54-8a76-40b7-8213-7cddea3de868";
    public static final String FUNCTIONALCHAIN_15 = "140ce902-c323-4a56-b2ab-f2023759c7b0";
    public static final String MAINFAKEFE = "beecfd69-5202-4b28-b8dd-3b43e37c927b";
    public static final String PHYSICALFUNCTION_7 = "55526991-3928-412a-8177-868d0bcb8755";
    public static final String PHYSICALFUNCTION_12 = "aac9c870-60ea-4eb2-8c16-4a5dd8e161f6";
    public static final String PHYSICALFUNCTION_13 = "043c2e24-34e7-402f-95a6-c99d3887d279";
    public static final String PHYSICALFUNCTION_20 = "b42793ad-f387-4245-a6bf-c03c1950adca";
    public static final String PHYSICALFUNCTION_19 = "30ce0602-7f15-4100-9a2e-e1ad70f268b1";
    public static final String PHYSICALFUNCTION_28 = "35cb76cd-c6d5-4d13-9037-48dcbdfcd71c";
    public static final String PC_2 = "3cef204b-79ac-41b1-8130-a1123736ea48";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_LINK_TO_PHYSICALFUNCTION_28 = "c8413d63-9f94-4e88-88f9-271de9950130";
    public static final String FUNCTIONAL_CHAIN_REFERENCE_TO_FUNCTIONALCHAIN_14 = "8fd2cd4b-d588-4073-b37d-525a5f3617d5";
    public static final String FUNCTIONAL_CHAIN_REFERENCE_TO_FUNCTIONALCHAIN_15 = "883800ee-65a4-40db-a48d-be88a26070cc";
    public static final String B = "dad4f386-b6f9-4691-a493-5ea4cb3c8285";
    public static final String BB = "0e48d080-84b4-4a4b-99bc-b8b2166497d9";
    public static final String BBB = "cb4d5b60-e0a1-45ed-b766-2903fac94aa4";
    public static final String B2 = "3e2edab9-daa2-4d07-8d0f-13c47f09c367";
    public static final String BB2 = "58fcdb66-166f-4731-846a-fe869b2f8a83";
    public static final String CC = "551a196b-fd63-47b2-af42-caa80c5cf23e";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_PHYSICALFUNCTION_33 = "34c170ea-fde6-4d29-80c0-b823455fb4f7";
    public static final String BBB_FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_PHYSICALFUNCTION_32 = "d34d496c-ca36-4ccd-8df0-30dbb12c0ebc";
    public static final String CC_FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_PHYSICALFUNCTION_34 = "b6be540f-ae43-4377-9029-17acbdbeb7a0";
    public static final String BB_FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_PHYSICALFUNCTION_34 = "23522280-e9d1-4729-9863-27aaabe57940";
    public static final String BB_FUNCTIONAL_CHAIN_REFERENCE_TO_BBB = "411900fb-dcff-4581-a7fd-ba5e206c6373";
    public static final String B2_FUNCTIONAL_CHAIN_REFERENCE_TO_BBB = "2e22b218-e610-4b4d-ab57-e0888f802ed5";
    public static final String BB2_FUNCTIONAL_CHAIN_REFERENCE_TO_CC = "3704f9c0-2f6e-49da-b709-dd66dbc03cab";
    public static final String B2_FUNCTIONAL_CHAIN_REFERENCE_TO_BB2 = "404106f6-8f72-4284-8caa-36eeb56ed0e8";
    public static final String BB2_FUNCTIONAL_CHAIN_REFERENCE_TO_BBB = "26934ac6-7341-4d0e-b3ce-65bb8d2e6f5d";

    @Override
    protected Collection<?> getProjectionElements() {
        return this.getObjects(new String[]{PC_2});
    }

    @Override
    protected void verify() {
        this.checkHelpers();
        this.shouldNotBeTransitioned(PHYSICALFUNCTION_7);
        this.shouldNotBeTransitioned(PHYSICALFUNCTION_12);
        this.shouldNotBeTransitioned(PHYSICALFUNCTION_13);
        this.shouldNotBeTransitioned(PHYSICALFUNCTION_20);
        this.shouldNotBeTransitioned(PHYSICALFUNCTION_19);
        this.shouldNotBeTransitioned(PHYSICALFUNCTION_28);
        FunctionalChain subCutted = (FunctionalChain)this.mustBeTransitioned(SUBCUTTED1);
        TestComposite568503.assertTrue((boolean)this.referenceFakeExchange(subCutted));
        FunctionalChain mainNoPrimary = (FunctionalChain)this.mustBeTransitioned(MAIN2NOPRIMARYFUNCTIONS);
        TestComposite568503.assertTrue((boolean)this.referenceSubChain(mainNoPrimary, (FunctionalChain)this.mustBeTransitioned(SUB2)));
        this.shouldNotBeTransitioned(DROPPEDSUB);
        FunctionalChain mainDroppedSub = (FunctionalChain)this.mustBeTransitioned(MAINDROPPEDSUB);
        TestComposite568503.assertTrue((boolean)this.referenceFakeExchange(mainDroppedSub));
        FunctionalChain sub5cutted = (FunctionalChain)this.mustBeTransitioned(SUB5CUTTED);
        TestComposite568503.assertTrue((sub5cutted.getOwnedFunctionalChainInvolvements().size() == 1 ? 1 : 0) != 0);
        FunctionalChain mainInvFunc = (FunctionalChain)this.mustBeTransitioned(MAININVFUNC);
        TestComposite568503.assertTrue((mainInvFunc.getOwnedFunctionalChainInvolvements().size() == 3 ? 1 : 0) != 0);
        FunctionalChain mainFakeFE = (FunctionalChain)this.mustBeTransitioned(MAINFAKEFE);
        TestComposite568503.assertTrue((boolean)this.referenceFakeExchange(mainFakeFE));
        FunctionalChainInvolvementLink link = this.referencingFakeExchange(mainFakeFE);
        TestComposite568503.assertTrue((boolean)link.getSourceReferenceHierarchy().contains((Object)this.mustBeTransitioned(FUNCTIONAL_CHAIN_REFERENCE_TO_FUNCTIONALCHAIN_14)));
        TestComposite568503.assertTrue((boolean)link.getTargetReferenceHierarchy().contains((Object)this.mustBeTransitioned(FUNCTIONAL_CHAIN_REFERENCE_TO_FUNCTIONALCHAIN_15)));
        this.ensureHierarchy((FunctionalChain)this.mustBeTransitioned(MAIN1));
        this.ensureHierarchy((FunctionalChain)this.mustBeTransitioned(MAINDROPPEDSUB));
        this.ensureHierarchy((FunctionalChain)this.mustBeTransitioned(MAININVFUNC));
        this.ensureHierarchy((FunctionalChain)this.mustBeTransitioned(MAINFAKEFE));
        this.mustBeTransitioned(BBB);
        this.shouldNotBeTransitioned(FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_PHYSICALFUNCTION_33);
        FunctionalChain bb = (FunctionalChain)this.mustBeTransitioned(BB);
        TestComposite568503.assertTrue((boolean)this.referenceFakeExchange(bb));
        TestComposite568503.assertTrue((this.referencingFakeExchanges(bb).size() == 1 ? 1 : 0) != 0);
        link = this.referencingFakeExchange(bb);
        TestComposite568503.assertTrue((boolean)link.getSourceReferenceHierarchy().contains((Object)this.mustBeTransitioned(BB_FUNCTIONAL_CHAIN_REFERENCE_TO_BBB)));
        TestComposite568503.assertTrue((boolean)this.toString((Collection)link.getSourceReferenceHierarchy()).equals("BBB"));
        TestComposite568503.assertTrue((boolean)link.getTargetReferenceHierarchy().isEmpty());
        FunctionalChain b2 = (FunctionalChain)this.mustBeTransitioned(B2);
        TestComposite568503.assertTrue((boolean)this.referenceFakeExchange(b2));
        TestComposite568503.assertTrue((this.referencingFakeExchanges(b2).size() == 1 ? 1 : 0) != 0);
        link = this.referencingFakeExchange(b2);
        TestComposite568503.assertTrue((boolean)link.getSourceReferenceHierarchy().contains((Object)this.mustBeTransitioned(B2_FUNCTIONAL_CHAIN_REFERENCE_TO_BBB)));
        TestComposite568503.assertTrue((boolean)this.toString((Collection)link.getSourceReferenceHierarchy()).equals("BBB"));
        TestComposite568503.assertTrue((boolean)link.getTargetReferenceHierarchy().contains((Object)this.mustBeTransitioned(BB2_FUNCTIONAL_CHAIN_REFERENCE_TO_CC)));
        TestComposite568503.assertTrue((boolean)link.getTargetReferenceHierarchy().contains((Object)this.mustBeTransitioned(B2_FUNCTIONAL_CHAIN_REFERENCE_TO_BB2)));
        TestComposite568503.assertTrue((boolean)this.toString((Collection)link.getTargetReferenceHierarchy()).equals("CC/BB2"));
        FunctionalChain bb2 = (FunctionalChain)this.mustBeTransitioned(BB2);
        TestComposite568503.assertTrue((boolean)this.referenceFakeExchange(bb2));
        TestComposite568503.assertTrue((this.referencingFakeExchanges(bb2).size() == 1 ? 1 : 0) != 0);
        link = this.referencingFakeExchange(bb2);
        TestComposite568503.assertTrue((boolean)link.getSourceReferenceHierarchy().contains((Object)this.mustBeTransitioned(BB2_FUNCTIONAL_CHAIN_REFERENCE_TO_BBB)));
        TestComposite568503.assertTrue((boolean)this.toString((Collection)link.getSourceReferenceHierarchy()).equals("BBB"));
        TestComposite568503.assertTrue((boolean)link.getTargetReferenceHierarchy().contains((Object)this.mustBeTransitioned(BB2_FUNCTIONAL_CHAIN_REFERENCE_TO_CC)));
        TestComposite568503.assertTrue((boolean)this.toString((Collection)link.getTargetReferenceHierarchy()).equals("CC"));
    }

    protected void checkHelpers() {
        FunctionalChainInvolvementRule rule = new FunctionalChainInvolvementRule();
        FunctionalChainInvolvementFunction inv = (FunctionalChainInvolvementFunction)this.getObject(BBB_FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_PHYSICALFUNCTION_32);
        Collection paths = rule.getPaths((FunctionalChainInvolvement)inv).stream().map(x -> this.toString(rule.createFullPath(inv, x))).collect(Collectors.toList());
        TestComposite568503.assertTrue((paths.size() == 3 ? 1 : 0) != 0);
        TestComposite568503.assertTrue((boolean)paths.contains("BBB/B2"));
        TestComposite568503.assertTrue((boolean)paths.contains("BBB/BB2/B2"));
        TestComposite568503.assertTrue((boolean)paths.contains("BBB/BB/B"));
        FunctionalChainInvolvementFunction inv2 = (FunctionalChainInvolvementFunction)this.getObject(CC_FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_PHYSICALFUNCTION_34);
        paths = rule.getPaths((FunctionalChainInvolvement)inv2).stream().map(x -> this.toString(rule.createFullPath(inv2, x))).collect(Collectors.toList());
        TestComposite568503.assertTrue((paths.size() == 1 ? 1 : 0) != 0);
        TestComposite568503.assertTrue((boolean)paths.contains("CC/BB2/B2"));
        FunctionalChainInvolvementFunction inv3 = (FunctionalChainInvolvementFunction)this.getObject(BB_FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_PHYSICALFUNCTION_34);
        paths = rule.getPaths((FunctionalChainInvolvement)inv3).stream().map(x -> this.toString(rule.createFullPath(inv3, x))).collect(Collectors.toList());
        TestComposite568503.assertTrue((paths.size() == 1 ? 1 : 0) != 0);
        TestComposite568503.assertTrue((boolean)paths.contains("BB/B"));
        TestComposite568503.assertTrue((boolean)this.equalsUnordered(this.toName(new FunctionalChainRule().getAllReferencingChains((FunctionalChain)this.getObject(BBB))), Arrays.asList("BB", "B", "B2", "BB2")));
        TestComposite568503.assertTrue((boolean)this.equalsUnordered(this.toName(new FunctionalChainRule().getAllReferencingChains((FunctionalChain)this.getObject(CC))), Arrays.asList("B2", "BB2")));
    }

    private <T> boolean equalsUnordered(Collection<T> o, Collection<T> r) {
        HashSet<T> result = new HashSet<T>(o);
        result.retainAll(r);
        return result.size() == o.size() && result.size() == r.size();
    }

    private <T> Collection<String> toName(Collection<T> arrayList) {
        return arrayList.stream().map(fcr -> this.getName(fcr)).collect(Collectors.toList());
    }

    private <T> String toString(Collection<T> arrayList) {
        return arrayList.stream().map(fcr -> this.getName(fcr)).collect(Collectors.joining("/"));
    }

    private <T> String getName(T obj) {
        if (obj instanceof FunctionalChain) {
            return ((FunctionalChain)obj).getName();
        }
        return ((FunctionalChain)((FunctionalChainReference)obj).getInvolved()).getName();
    }

    private void ensureHierarchy(FunctionalChain chain) {
        for (FunctionalChainInvolvement inv : chain.getOwnedFunctionalChainInvolvements()) {
            FunctionalChainInvolvementLink link;
            if (!(inv instanceof FunctionalChainInvolvementLink) || (link = (FunctionalChainInvolvementLink)inv).getSource().eContainer() == link.getTarget().eContainer()) continue;
            if (link.getSource().eContainer() != chain) {
                TestComposite568503.assertTrue((!link.getSourceReferenceHierarchy().isEmpty() ? 1 : 0) != 0);
            }
            if (link.getTarget().eContainer() == chain) continue;
            TestComposite568503.assertTrue((!link.getTargetReferenceHierarchy().isEmpty() ? 1 : 0) != 0);
        }
    }

    private boolean referenceSubChain(FunctionalChain chain, FunctionalChain sub) {
        return chain.getOwnedFunctionalChainInvolvements().stream().filter(x -> this.referenceSubChain((FunctionalChainInvolvement)x, sub)).findFirst().isPresent();
    }

    private boolean referenceSubChain(FunctionalChainInvolvement f, FunctionalChain sub) {
        return f.getInvolved().equals(sub);
    }

    private FunctionalChainInvolvementLink referencingFakeExchange(FunctionalChain chain) {
        return (FunctionalChainInvolvementLink)chain.getOwnedFunctionalChainInvolvements().stream().filter(this::referenceFakeExchange).findFirst().get();
    }

    private List<FunctionalChainInvolvementLink> referencingFakeExchanges(FunctionalChain chain) {
        return chain.getOwnedFunctionalChainInvolvements().stream().filter(this::referenceFakeExchange).map(FunctionalChainInvolvementLink.class::cast).collect(Collectors.toList());
    }

    private boolean referenceFakeExchange(FunctionalChain chain) {
        return this.referencingFakeExchange(chain) != null;
    }

    private boolean referenceFakeExchange(FunctionalChainInvolvement f) {
        return f instanceof FunctionalChainInvolvementLink && f.getInvolved() instanceof FunctionalExchange && ((FunctionalExchange)f.getInvolved()).getName().contains("Fake");
    }

    @Override
    public List<String> getRequiredTestModels() {
        return Arrays.asList("568503", "output");
    }
}

