/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.manager;

import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.context.ProductionContext;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.ContractMode;
import org.eclipse.egf.model.fcore.Invocation;
import org.eclipse.egf.model.fcore.InvocationContract;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.model.helper.ActivityCycleFinder;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.internal.manager.ModelElementManager;
import org.eclipse.egf.producer.l10n.ProducerMessages;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.egf.producer.manager.IModelElementManager;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public abstract class ActivityManager<P extends Activity>
extends ModelElementManager<P, Contract>
implements IActivityManager<P> {
    public ActivityManager(P activity) throws InvocationException {
        super(activity);
        ActivityCycleFinder finder = new ActivityCycleFinder(activity);
        ModelElement element = finder.getFirstRepetition();
        if (element != null) {
            throw new InvocationException(NLS.bind((String)"Activity cycle detected in ''{0}''", (Object)EMFHelper.getText((Object)element)));
        }
    }

    public ActivityManager(Bundle bundle, P activity) throws InvocationException {
        super(bundle, activity);
        ActivityCycleFinder finder = new ActivityCycleFinder(activity);
        ModelElement element = finder.getFirstRepetition();
        if (element != null) {
            throw new InvocationException(NLS.bind((String)"Activity cycle detected in ''{0}''", (Object)EMFHelper.getText((Object)element)));
        }
    }

    public <M extends Invocation> ActivityManager(IModelElementManager<M, InvocationContract> parent, P activity) throws InvocationException {
        super(parent, activity);
    }

    @Override
    protected BasicDiagnostic checkInputElement(boolean runtime) throws InvocationException {
        BasicDiagnostic diagnostic = ActivityManager.getDiagnostic(this.getElement(), runtime);
        BasicDiagnostic containerDiagnostic = null;
        ProductionContext context = this.getInternalProductionContext();
        for (Contract contract : ((Activity)this.getElement()).getContracts(ContractMode.IN)) {
            Object value;
            block5: {
                if (!contract.isMandatory() || !runtime && context.isSetAtRuntime((Object)contract.getName())) continue;
                value = null;
                try {
                    value = context.getInputValue((Object)contract.getName(), contract.getType().getType());
                }
                catch (InvocationException ie) {
                    if (ie.getCause() == null) break block5;
                    throw ie;
                }
            }
            if (value != null) continue;
            if (containerDiagnostic == null) {
                containerDiagnostic = ActivityManager.getDiagnostic((ModelElement)contract.getContractContainer(), runtime);
            }
            containerDiagnostic.add((Diagnostic)new BasicDiagnostic(4, EGFProducerPlugin.getDefault().getPluginID(), 0, NLS.bind((String)"Value is mandatory for ''{0}''", (Object)EMFHelper.getText((Object)contract)), new Object[]{contract}));
        }
        if (containerDiagnostic != null) {
            diagnostic.add(containerDiagnostic);
        }
        return diagnostic;
    }

    @Override
    protected BasicDiagnostic checkOutputElement(BasicDiagnostic diagnostic) throws InvocationException {
        BasicDiagnostic containerDiagnostic = null;
        ProductionContext context = this.getInternalProductionContext();
        for (Contract contract : ((Activity)this.getElement()).getContracts(ContractMode.OUT)) {
            Object value;
            block5: {
                if (!contract.isMandatory()) continue;
                value = null;
                try {
                    value = context.getOutputValue((Object)contract.getName(), contract.getType().getType());
                }
                catch (InvocationException ie) {
                    if (ie.getCause() == null) break block5;
                    throw ie;
                }
            }
            if (value != null) continue;
            if (containerDiagnostic == null) {
                containerDiagnostic = ActivityManager.getDiagnostic((ModelElement)contract.getContractContainer(), true);
            }
            containerDiagnostic.add((Diagnostic)new BasicDiagnostic(4, EGFProducerPlugin.getDefault().getPluginID(), 0, NLS.bind((String)ProducerMessages.ActivityManager_mandatory_value, (Object)EMFHelper.getText((Object)contract)), new Object[]{contract}));
        }
        if (containerDiagnostic != null) {
            diagnostic.add(containerDiagnostic);
        }
        return diagnostic;
    }

    @Override
    public void initializeContext() throws InvocationException {
        ProductionContext context = this.getInternalProductionContext();
        context.clear();
        for (Contract contract : ((Activity)this.getElement()).getContracts()) {
            if (contract.getType() == null) continue;
            ModelElementManager.populateContext(context, this.getBundle(), contract, contract.getMode(), contract.getType(), contract.getType().getValue());
        }
    }
}

