/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.registry;

import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.model.fcore.Orchestration;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.manager.OrchestrationManagerProducer;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.osgi.util.NLS;

public class OrchestrationManagerProducerProxy {
    private IConfigurationElement _element;
    private String _uniqueIdentifier;
    private int _handleId = -1;
    private String _orchestration;
    private String _class;
    private Object _executable;

    public static OrchestrationManagerProducerProxy createProxy(IConfigurationElement element) {
        String orchestration;
        if (element == null || !element.isValid()) {
            return null;
        }
        IExtension declaringExtension = element.getDeclaringExtension();
        String uniqueIdentifier = declaringExtension.getUniqueIdentifier();
        int handleId = -1;
        if (declaringExtension instanceof Handle) {
            handleId = ((Handle)declaringExtension).getId();
        }
        if ((orchestration = element.getAttribute("orchestration")) == null || orchestration.trim().length() == 0) {
            return null;
        }
        String clazz = element.getAttribute("class");
        if (clazz == null || clazz.trim().length() == 0) {
            return null;
        }
        return new OrchestrationManagerProducerProxy(element, orchestration, clazz, uniqueIdentifier, handleId);
    }

    public OrchestrationManagerProducerProxy(IConfigurationElement element, String activity, String clazz, String uniqueIdentifier, int handleId) {
        this._element = element;
        this._orchestration = activity.trim();
        this._class = clazz.trim();
        if (uniqueIdentifier != null && uniqueIdentifier.trim().length() != 0) {
            this._uniqueIdentifier = uniqueIdentifier.trim();
        }
        this._handleId = handleId;
    }

    public String getUniqueIdentifier() {
        return this._uniqueIdentifier;
    }

    public int getHandleId() {
        return this._handleId;
    }

    public <P extends Orchestration> OrchestrationManagerProducer<P> getOrchestrationManagerProducer(P orchestration) throws CoreException {
        if (this._executable == null && this._element.isValid()) {
            Object object = this._element.createExecutableExtension("class");
            if (object == null) {
                return null;
            }
            if (!(object instanceof OrchestrationManagerProducer)) {
                EGFProducerPlugin.getDefault().logError(NLS.bind((String)EGFCommonMessages.Wrong_Class_Message, (Object)object.getClass().getName()));
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Wrong_Class_Sub_Type_Message, (Object)OrchestrationManagerProducer.class.getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)this._element.getContributor().getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)this._element.getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Attribute_Message, (Object)this._class), 1);
                return null;
            }
            if (((OrchestrationManagerProducer)object).getOrchestration() == null) {
                EGFProducerPlugin.getDefault().logError(NLS.bind((String)EGFCommonMessages.Wrong_Class_Message, (Object)object.getClass().getName()));
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Missing_Element_Message, (Object)Orchestration.class.getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)this._element.getContributor().getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)this._element.getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Attribute_Message, (Object)this._class), 1);
                return null;
            }
            if (((OrchestrationManagerProducer)object).getOrchestration() != EMFHelper.solveAgainstStaticPackage((EClassifier)orchestration.eClass())) {
                EGFProducerPlugin.getDefault().logError(NLS.bind((String)EGFCommonMessages.Wrong_Class_Message, (Object)object.getClass().getName()));
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Type_mismatch_Message, (Object)orchestration.getClass().getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)this._element.getContributor().getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)this._element.getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Attribute_Message, (Object)this._class), 1);
                return null;
            }
            this._executable = object;
        }
        return (OrchestrationManagerProducer)this._executable;
    }

    public String getOrchestration() {
        return this._orchestration;
    }

    public boolean originatesFrom(IExtension extension) {
        String id = extension.getUniqueIdentifier();
        if (id != null) {
            return id.equals(this._uniqueIdentifier);
        }
        if (!(extension instanceof Handle)) {
            return false;
        }
        return this._handleId == ((Handle)extension).getId();
    }
}

