/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.formatting2;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.cbi.targetplatform.model.Environment;
import org.eclipse.cbi.targetplatform.model.GeneratedFeature;
import org.eclipse.cbi.targetplatform.model.IU;
import org.eclipse.cbi.targetplatform.model.IncludeDeclaration;
import org.eclipse.cbi.targetplatform.model.Location;
import org.eclipse.cbi.targetplatform.model.MavenDependency;
import org.eclipse.cbi.targetplatform.model.MavenLocation;
import org.eclipse.cbi.targetplatform.model.MavenRepository;
import org.eclipse.cbi.targetplatform.model.Options;
import org.eclipse.cbi.targetplatform.model.TargetContent;
import org.eclipse.cbi.targetplatform.model.TargetPlatform;
import org.eclipse.cbi.targetplatform.model.TargetPlatformPackage;
import org.eclipse.cbi.targetplatform.services.TargetPlatformGrammarAccess;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.internal.SinglelineDocCommentReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class TargetPlatformFormatter
extends AbstractFormatter2 {
    @Inject
    @Extension
    private TargetPlatformGrammarAccess _targetPlatformGrammarAccess;

    protected void _format(TargetPlatform it, @Extension IFormattableDocument document) {
        this.formatName(it, document);
        Consumer<TargetContent> _function = it_1 -> document.format(it_1);
        it.getContents().forEach(_function);
    }

    protected void _format(Options it, @Extension IFormattableDocument document) {
        this.formatWithKeyword(it, document);
        this.formatOptions(it, document);
    }

    protected void _format(Environment it, @Extension IFormattableDocument document) {
        this.formatEnvironmentKeyword(it, document);
        this.formatEnvironments(it, document);
    }

    protected void _format(IncludeDeclaration it, @Extension IFormattableDocument document) {
        Keyword includeKeyword = this._targetPlatformGrammarAccess.getIncludeDeclarationAccess().getIncludeKeyword_0();
        ISemanticRegion includeKeywordRegion = this.textRegionExtensions.regionFor((EObject)it).keyword(includeKeyword);
        ISemanticRegion firstIncludeKeywordRegion = (ISemanticRegion)IterableExtensions.head((Iterable)this.textRegionExtensions.allRegionsFor(it.eContainer()).keywords(new Keyword[]{includeKeyword}));
        Procedures.Procedure1 _function = it_1 -> {
            boolean _equals = Objects.equal((Object)includeKeywordRegion, (Object)firstIncludeKeywordRegion);
            if (_equals) {
                it_1.setNewLines(2, 2, 2);
            } else {
                it_1.setNewLines(1, 1, 1);
            }
        };
        document.prepend(includeKeywordRegion, _function);
        Procedures.Procedure1 _function_1 = it_1 -> it_1.oneSpace();
        document.append(includeKeywordRegion, _function_1);
    }

    protected void _format(Location it, @Extension IFormattableDocument document) {
        ISemanticRegion locationKeywordRegion = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getLocationAccess().getLocationKeyword_0());
        Procedures.Procedure1 _function = it_1 -> it_1.setNewLines(2, 2, 2);
        document.prepend(locationKeywordRegion, _function);
        Procedures.Procedure1 _function_1 = it_1 -> it_1.oneSpace();
        document.append(locationKeywordRegion, _function_1);
        Procedures.Procedure1 _function_2 = it_1 -> it_1.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)it).feature((EStructuralFeature)TargetPlatformPackage.Literals.LOCATION__ID), _function_2);
        ISemanticRegion begin = this.textRegionExtensions.regionFor((EObject)it).keyword("{");
        ISemanticRegion end = this.textRegionExtensions.regionFor((EObject)it).keyword("}");
        Procedures.Procedure1 _function_3 = it_1 -> it_1.oneSpace();
        document.prepend(begin, _function_3);
        Procedures.Procedure1 _function_4 = it_1 -> it_1.newLine();
        document.append(begin, _function_4);
        Procedures.Procedure1 _function_5 = it_1 -> it_1.indent();
        document.interior(begin, end, _function_5);
        Consumer<IU> _function_6 = it_1 -> document.format(it_1);
        it.getIus().forEach(_function_6);
        Procedures.Procedure1 _function_7 = it_1 -> it_1.newLine();
        document.prepend(end, _function_7);
    }

    protected void _format(IU it, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it_1 -> it_1.oneSpace();
        Procedures.Procedure1 _function_1 = it_1 -> it_1.noSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)it).feature((EStructuralFeature)TargetPlatformPackage.Literals.IU__VERSION), _function), _function_1);
        Procedures.Procedure1 _function_2 = it_1 -> it_1.newLine();
        document.append((EObject)it, _function_2);
    }

    protected void _format(MavenLocation it, @Extension IFormattableDocument document) {
        EList _repositories;
        EList _dependencies;
        List _keywords;
        List _ruleCalls;
        ISemanticRegion _keyword = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenLocationAccess().getMavenKeyword_0());
        ISemanticRegion _prepend = null;
        if (_keyword != null) {
            Procedures.Procedure1 _function = it_1 -> it_1.setNewLines(2);
            _prepend = document.prepend(_keyword, _function);
        }
        Procedures.Procedure1 _function_1 = it_1 -> it_1.oneSpace();
        document.append(_prepend, _function_1);
        ISemanticRegion _keyword_1 = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenLocationAccess().getScopeKeyword_2());
        ISemanticRegion _prepend_1 = null;
        if (_keyword_1 != null) {
            Procedures.Procedure1 _function_2 = it_1 -> it_1.oneSpace();
            _prepend_1 = document.prepend(_keyword_1, _function_2);
        }
        Procedures.Procedure1 _function_3 = it_1 -> it_1.noSpace();
        document.append(_prepend_1, _function_3);
        ISemanticRegion _ruleCall = this.textRegionExtensions.regionFor((EObject)it).ruleCall(this._targetPlatformGrammarAccess.getMavenLocationAccess().getScopesMavenScopeEnumRuleCall_4_0());
        if (_ruleCall != null) {
            Procedures.Procedure1 _function_4 = it_1 -> it_1.noSpace();
            document.prepend(_ruleCall, _function_4);
        }
        if ((_ruleCalls = this.textRegionExtensions.regionFor((EObject)it).ruleCalls(new RuleCall[]{this._targetPlatformGrammarAccess.getMavenLocationAccess().getScopesMavenScopeEnumRuleCall_5_1_0()})) != null) {
            Consumer<ISemanticRegion> _function_5 = it_1 -> {
                Procedures.Procedure1 _function_6 = it_2 -> it_2.noSpace();
                document.prepend(it_1, _function_6);
            };
            _ruleCalls.forEach(_function_5);
        }
        if ((_keywords = this.textRegionExtensions.regionFor((EObject)it).keywords(new Keyword[]{this._targetPlatformGrammarAccess.getMavenLocationAccess().getCommaKeyword_5_0()})) != null) {
            Consumer<ISemanticRegion> _function_6 = it_1 -> {
                Procedures.Procedure1 _function_7 = it_2 -> it_2.noSpace();
                document.surround(it_1, _function_7);
            };
            _keywords.forEach(_function_6);
        }
        ISemanticRegion _keyword_2 = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenLocationAccess().getDependencyDepthKeyword_6());
        ISemanticRegion _prepend_2 = null;
        if (_keyword_2 != null) {
            Procedures.Procedure1 _function_7 = it_1 -> it_1.oneSpace();
            _prepend_2 = document.prepend(_keyword_2, _function_7);
        }
        Procedures.Procedure1 _function_8 = it_1 -> it_1.noSpace();
        document.append(_prepend_2, _function_8);
        ISemanticRegion _ruleCall_1 = this.textRegionExtensions.regionFor((EObject)it).ruleCall(this._targetPlatformGrammarAccess.getMavenLocationAccess().getDependencyDepthMavenDependencyDepthEnumRuleCall_8_0());
        if (_ruleCall_1 != null) {
            Procedures.Procedure1 _function_9 = it_1 -> it_1.noSpace();
            document.prepend(_ruleCall_1, _function_9);
        }
        ISemanticRegion _keyword_3 = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenLocationAccess().getMissingManifestKeyword_9());
        ISemanticRegion _prepend_3 = null;
        if (_keyword_3 != null) {
            Procedures.Procedure1 _function_10 = it_1 -> it_1.oneSpace();
            _prepend_3 = document.prepend(_keyword_3, _function_10);
        }
        Procedures.Procedure1 _function_11 = it_1 -> it_1.noSpace();
        document.append(_prepend_3, _function_11);
        ISemanticRegion _ruleCall_2 = this.textRegionExtensions.regionFor((EObject)it).ruleCall(this._targetPlatformGrammarAccess.getMavenLocationAccess().getMissingManifestMavenMissingManifestEnumRuleCall_11_0());
        if (_ruleCall_2 != null) {
            Procedures.Procedure1 _function_12 = it_1 -> it_1.noSpace();
            document.prepend(_ruleCall_2, _function_12);
        }
        ISemanticRegion _keyword_4 = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenLocationAccess().getIncludeSourcesIncludeSourcesKeyword_12_0());
        ISemanticRegion _prepend_4 = null;
        if (_keyword_4 != null) {
            Procedures.Procedure1 _function_13 = it_1 -> it_1.oneSpace();
            _prepend_4 = document.prepend(_keyword_4, _function_13);
        }
        Procedures.Procedure1 _function_14 = it_1 -> it_1.oneSpace();
        document.append(_prepend_4, _function_14);
        ISemanticRegion leftCurly = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenLocationAccess().getLeftCurlyBracketKeyword_13());
        ISemanticRegion rightCurly = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenLocationAccess().getRightCurlyBracketKeyword_17());
        ISemanticRegion _prepend_5 = null;
        if (leftCurly != null) {
            Procedures.Procedure1 _function_15 = it_1 -> it_1.oneSpace();
            _prepend_5 = document.prepend(leftCurly, _function_15);
        }
        Procedures.Procedure1 _function_16 = it_1 -> it_1.newLine();
        document.append(_prepend_5, _function_16);
        if (rightCurly != null) {
            Procedures.Procedure1 _function_17 = it_1 -> it_1.newLine();
            document.surround(rightCurly, _function_17);
        }
        Procedures.Procedure1 _function_18 = it_1 -> it_1.indent();
        document.interior(leftCurly, rightCurly, _function_18);
        GeneratedFeature _generatedFeature = it.getGeneratedFeature();
        if (_generatedFeature != null) {
            document.format((Object)_generatedFeature);
        }
        if ((_dependencies = it.getDependencies()) != null) {
            Consumer<MavenDependency> _function_19 = it_1 -> document.format(it_1);
            _dependencies.forEach(_function_19);
        }
        if ((_repositories = it.getRepositories()) != null) {
            Consumer<MavenRepository> _function_20 = it_1 -> document.format(it_1);
            _repositories.forEach(_function_20);
        }
    }

    protected void _format(GeneratedFeature it, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it_1 -> it_1.noSpace();
        Procedures.Procedure1 _function_1 = it_1 -> it_1.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getGeneratedFeatureAccess().getFeatureKeyword_0()), _function), _function_1);
        ISemanticRegion leftCurly = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getGeneratedFeatureAccess().getLeftCurlyBracketKeyword_1());
        ISemanticRegion rightCurly = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getGeneratedFeatureAccess().getRightCurlyBracketKeyword_14());
        Procedures.Procedure1 _function_2 = it_1 -> it_1.oneSpace();
        Procedures.Procedure1 _function_3 = it_1 -> it_1.newLine();
        document.append(document.prepend(leftCurly, _function_2), _function_3);
        Procedures.Procedure1 _function_4 = it_1 -> it_1.newLine();
        document.surround(rightCurly, _function_4);
        Procedures.Procedure1 _function_5 = it_1 -> it_1.indent();
        document.interior(leftCurly, rightCurly, _function_5);
        ISemanticRegion _keyword = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getGeneratedFeatureAccess().getIdKeyword_2());
        ISemanticRegion _prepend = null;
        if (_keyword != null) {
            Procedures.Procedure1 _function_6 = it_1 -> it_1.newLine();
            _prepend = document.prepend(_keyword, _function_6);
        }
        Procedures.Procedure1 _function_7 = it_1 -> it_1.noSpace();
        document.append(_prepend, _function_7);
        ISemanticRegion _ruleCall = this.textRegionExtensions.regionFor((EObject)it).ruleCall(this._targetPlatformGrammarAccess.getGeneratedFeatureAccess().getIdSTRINGTerminalRuleCall_4_0());
        ISemanticRegion _prepend_1 = null;
        if (_ruleCall != null) {
            Procedures.Procedure1 _function_8 = it_1 -> it_1.noSpace();
            _prepend_1 = document.prepend(_ruleCall, _function_8);
        }
        Procedures.Procedure1 _function_9 = it_1 -> it_1.newLine();
        document.append(_prepend_1, _function_9);
        ISemanticRegion _keyword_1 = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getGeneratedFeatureAccess().getNameKeyword_5());
        ISemanticRegion _prepend_2 = null;
        if (_keyword_1 != null) {
            Procedures.Procedure1 _function_10 = it_1 -> it_1.newLine();
            _prepend_2 = document.prepend(_keyword_1, _function_10);
        }
        Procedures.Procedure1 _function_11 = it_1 -> it_1.noSpace();
        document.append(_prepend_2, _function_11);
        ISemanticRegion _ruleCall_1 = this.textRegionExtensions.regionFor((EObject)it).ruleCall(this._targetPlatformGrammarAccess.getGeneratedFeatureAccess().getNameSTRINGTerminalRuleCall_7_0());
        ISemanticRegion _prepend_3 = null;
        if (_ruleCall_1 != null) {
            Procedures.Procedure1 _function_12 = it_1 -> it_1.noSpace();
            _prepend_3 = document.prepend(_ruleCall_1, _function_12);
        }
        Procedures.Procedure1 _function_13 = it_1 -> it_1.newLine();
        document.append(_prepend_3, _function_13);
        ISemanticRegion _keyword_2 = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getGeneratedFeatureAccess().getVersionKeyword_8());
        ISemanticRegion _prepend_4 = null;
        if (_keyword_2 != null) {
            Procedures.Procedure1 _function_14 = it_1 -> it_1.newLine();
            _prepend_4 = document.prepend(_keyword_2, _function_14);
        }
        Procedures.Procedure1 _function_15 = it_1 -> it_1.noSpace();
        document.append(_prepend_4, _function_15);
        ISemanticRegion _ruleCall_2 = this.textRegionExtensions.regionFor((EObject)it).ruleCall(this._targetPlatformGrammarAccess.getGeneratedFeatureAccess().getVersionSTRINGTerminalRuleCall_10_0());
        ISemanticRegion _prepend_5 = null;
        if (_ruleCall_2 != null) {
            Procedures.Procedure1 _function_16 = it_1 -> it_1.noSpace();
            _prepend_5 = document.prepend(_ruleCall_2, _function_16);
        }
        Procedures.Procedure1 _function_17 = it_1 -> it_1.newLine();
        document.append(_prepend_5, _function_17);
        ISemanticRegion _keyword_3 = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getGeneratedFeatureAccess().getAdditionalBundlesKeyword_13_0());
        ISemanticRegion _prepend_6 = null;
        if (_keyword_3 != null) {
            Procedures.Procedure1 _function_18 = it_1 -> it_1.newLine();
            _prepend_6 = document.prepend(_keyword_3, _function_18);
        }
        Procedures.Procedure1 _function_19 = it_1 -> it_1.oneSpace();
        document.append(_prepend_6, _function_19);
        ISemanticRegion _keyword_4 = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getGeneratedFeatureAccess().getLeftCurlyBracketKeyword_13_1());
        ISemanticRegion _prepend_7 = null;
        if (_keyword_4 != null) {
            Procedures.Procedure1 _function_20 = it_1 -> it_1.oneSpace();
            _prepend_7 = document.prepend(_keyword_4, _function_20);
        }
        Procedures.Procedure1 _function_21 = it_1 -> it_1.newLine();
        ISemanticRegion bundlesLeftCurly = document.append(_prepend_7, _function_21);
        ISemanticRegion _keyword_5 = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getGeneratedFeatureAccess().getRightCurlyBracketKeyword_13_3());
        ISemanticRegion _surround = null;
        if (_keyword_5 != null) {
            Procedures.Procedure1 _function_22 = it_1 -> it_1.newLine();
            _surround = document.surround(_keyword_5, _function_22);
        }
        ISemanticRegion bundlesRightCurly = _surround;
        Procedures.Procedure1 _function_23 = it_1 -> it_1.indent();
        document.interior(bundlesLeftCurly, bundlesRightCurly, _function_23);
        EList _additionalBundles = it.getAdditionalBundles();
        if (_additionalBundles != null) {
            Consumer<IU> _function_24 = it_1 -> document.format(it_1);
            _additionalBundles.forEach(_function_24);
        }
    }

    protected void _format(MavenDependency it, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it_1 -> it_1.noSpace();
        Procedures.Procedure1 _function_1 = it_1 -> it_1.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenDependencyAccess().getDependencyKeyword_0()), _function), _function_1);
        ISemanticRegion leftCurly = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenDependencyAccess().getLeftCurlyBracketKeyword_1());
        ISemanticRegion rightCurly = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenDependencyAccess().getRightCurlyBracketKeyword_13());
        Procedures.Procedure1 _function_2 = it_1 -> it_1.oneSpace();
        Procedures.Procedure1 _function_3 = it_1 -> it_1.newLine();
        document.append(document.prepend(leftCurly, _function_2), _function_3);
        Procedures.Procedure1 _function_4 = it_1 -> it_1.newLine();
        document.surround(rightCurly, _function_4);
        Procedures.Procedure1 _function_5 = it_1 -> it_1.indent();
        document.interior(leftCurly, rightCurly, _function_5);
        ISemanticRegion _keyword = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenDependencyAccess().getGroupIdKeyword_2());
        ISemanticRegion _prepend = null;
        if (_keyword != null) {
            Procedures.Procedure1 _function_6 = it_1 -> it_1.newLine();
            _prepend = document.prepend(_keyword, _function_6);
        }
        Procedures.Procedure1 _function_7 = it_1 -> it_1.noSpace();
        document.append(_prepend, _function_7);
        ISemanticRegion _ruleCall = this.textRegionExtensions.regionFor((EObject)it).ruleCall(this._targetPlatformGrammarAccess.getMavenDependencyAccess().getGroupIdSTRINGTerminalRuleCall_4_0());
        ISemanticRegion _prepend_1 = null;
        if (_ruleCall != null) {
            Procedures.Procedure1 _function_8 = it_1 -> it_1.noSpace();
            _prepend_1 = document.prepend(_ruleCall, _function_8);
        }
        Procedures.Procedure1 _function_9 = it_1 -> it_1.newLine();
        document.append(_prepend_1, _function_9);
        ISemanticRegion _keyword_1 = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenDependencyAccess().getArtifactIdKeyword_5());
        ISemanticRegion _prepend_2 = null;
        if (_keyword_1 != null) {
            Procedures.Procedure1 _function_10 = it_1 -> it_1.newLine();
            _prepend_2 = document.prepend(_keyword_1, _function_10);
        }
        Procedures.Procedure1 _function_11 = it_1 -> it_1.noSpace();
        document.append(_prepend_2, _function_11);
        ISemanticRegion _ruleCall_1 = this.textRegionExtensions.regionFor((EObject)it).ruleCall(this._targetPlatformGrammarAccess.getMavenDependencyAccess().getArtifactIdSTRINGTerminalRuleCall_7_0());
        ISemanticRegion _prepend_3 = null;
        if (_ruleCall_1 != null) {
            Procedures.Procedure1 _function_12 = it_1 -> it_1.noSpace();
            _prepend_3 = document.prepend(_ruleCall_1, _function_12);
        }
        Procedures.Procedure1 _function_13 = it_1 -> it_1.newLine();
        document.append(_prepend_3, _function_13);
        ISemanticRegion _keyword_2 = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenDependencyAccess().getVersionKeyword_8());
        ISemanticRegion _prepend_4 = null;
        if (_keyword_2 != null) {
            Procedures.Procedure1 _function_14 = it_1 -> it_1.newLine();
            _prepend_4 = document.prepend(_keyword_2, _function_14);
        }
        Procedures.Procedure1 _function_15 = it_1 -> it_1.noSpace();
        document.append(_prepend_4, _function_15);
        ISemanticRegion _ruleCall_2 = this.textRegionExtensions.regionFor((EObject)it).ruleCall(this._targetPlatformGrammarAccess.getMavenDependencyAccess().getVersionSTRINGTerminalRuleCall_10_0());
        ISemanticRegion _prepend_5 = null;
        if (_ruleCall_2 != null) {
            Procedures.Procedure1 _function_16 = it_1 -> it_1.noSpace();
            _prepend_5 = document.prepend(_ruleCall_2, _function_16);
        }
        Procedures.Procedure1 _function_17 = it_1 -> it_1.newLine();
        document.append(_prepend_5, _function_17);
        ISemanticRegion _keyword_3 = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenDependencyAccess().getClassifierKeyword_11_0());
        ISemanticRegion _prepend_6 = null;
        if (_keyword_3 != null) {
            Procedures.Procedure1 _function_18 = it_1 -> it_1.newLine();
            _prepend_6 = document.prepend(_keyword_3, _function_18);
        }
        Procedures.Procedure1 _function_19 = it_1 -> it_1.noSpace();
        document.append(_prepend_6, _function_19);
        ISemanticRegion _ruleCall_3 = this.textRegionExtensions.regionFor((EObject)it).ruleCall(this._targetPlatformGrammarAccess.getMavenDependencyAccess().getClassifierSTRINGTerminalRuleCall_11_2_0());
        ISemanticRegion _prepend_7 = null;
        if (_ruleCall_3 != null) {
            Procedures.Procedure1 _function_20 = it_1 -> it_1.noSpace();
            _prepend_7 = document.prepend(_ruleCall_3, _function_20);
        }
        Procedures.Procedure1 _function_21 = it_1 -> it_1.newLine();
        document.append(_prepend_7, _function_21);
        ISemanticRegion _keyword_4 = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenDependencyAccess().getTypeKeyword_12_0());
        ISemanticRegion _prepend_8 = null;
        if (_keyword_4 != null) {
            Procedures.Procedure1 _function_22 = it_1 -> it_1.newLine();
            _prepend_8 = document.prepend(_keyword_4, _function_22);
        }
        Procedures.Procedure1 _function_23 = it_1 -> it_1.noSpace();
        document.append(_prepend_8, _function_23);
        ISemanticRegion _ruleCall_4 = this.textRegionExtensions.regionFor((EObject)it).ruleCall(this._targetPlatformGrammarAccess.getMavenDependencyAccess().getTypeSTRINGTerminalRuleCall_12_2_0());
        ISemanticRegion _prepend_9 = null;
        if (_ruleCall_4 != null) {
            Procedures.Procedure1 _function_24 = it_1 -> it_1.noSpace();
            _prepend_9 = document.prepend(_ruleCall_4, _function_24);
        }
        Procedures.Procedure1 _function_25 = it_1 -> it_1.newLine();
        document.append(_prepend_9, _function_25);
    }

    protected void _format(MavenRepository it, @Extension IFormattableDocument document) {
        ISemanticRegion _ruleCall;
        ISemanticRegion _keyword = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenRepositoryAccess().getRepositoryKeyword_0());
        ISemanticRegion _prepend = null;
        if (_keyword != null) {
            Procedures.Procedure1 _function = it_1 -> it_1.newLine();
            _prepend = document.prepend(_keyword, _function);
        }
        Procedures.Procedure1 _function_1 = it_1 -> it_1.oneSpace();
        document.append(_prepend, _function_1);
        ISemanticRegion _keyword_1 = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenRepositoryAccess().getIdKeyword_1());
        if (_keyword_1 != null) {
            Procedures.Procedure1 _function_2 = it_1 -> it_1.noSpace();
            document.append(_keyword_1, _function_2);
        }
        if ((_ruleCall = this.textRegionExtensions.regionFor((EObject)it).ruleCall(this._targetPlatformGrammarAccess.getMavenRepositoryAccess().getIdSTRINGTerminalRuleCall_3_0())) != null) {
            Procedures.Procedure1 _function_3 = it_1 -> it_1.noSpace();
            document.prepend(_ruleCall, _function_3);
        }
        ISemanticRegion _keyword_2 = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getMavenRepositoryAccess().getUrlKeyword_4());
        ISemanticRegion _append = null;
        if (_keyword_2 != null) {
            Procedures.Procedure1 _function_4 = it_1 -> it_1.noSpace();
            _append = document.append(_keyword_2, _function_4);
        }
        Procedures.Procedure1 _function_5 = it_1 -> it_1.oneSpace();
        document.prepend(_append, _function_5);
        ISemanticRegion _ruleCall_1 = this.textRegionExtensions.regionFor((EObject)it).ruleCall(this._targetPlatformGrammarAccess.getMavenRepositoryAccess().getUrlSTRINGTerminalRuleCall_6_0());
        if (_ruleCall_1 != null) {
            Procedures.Procedure1 _function_6 = it_1 -> it_1.noSpace();
            document.prepend(_ruleCall_1, _function_6);
        }
    }

    private ISemanticRegion formatName(TargetPlatform it, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it_1 -> it_1.oneSpace();
        Procedures.Procedure1 _function_1 = it_1 -> {
            it_1.noSpace();
            it_1.setPriority(-1);
        };
        return document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)it).feature((EStructuralFeature)TargetPlatformPackage.Literals.TARGET_PLATFORM__NAME), _function), _function_1);
    }

    private ISemanticRegion formatWithKeyword(Options it, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it_1 -> {
            it_1.oneSpace();
            it_1.setPriority(1);
        };
        return document.prepend(this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getOptionsAccess().getWithKeyword_0()), _function);
    }

    private void formatOptions(Options it, @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = it_1 -> {
            String _text = it_1.getText();
            boolean _equals = Objects.equal((Object)_text, (Object)",");
            if (_equals) {
                Procedures.Procedure1 _function_1 = it_2 -> it_2.noSpace();
                Procedures.Procedure1 _function_2 = it_2 -> it_2.oneSpace();
                document.append(document.prepend(it_1, _function_1), _function_2);
            } else {
                Procedures.Procedure1 _function_3 = it_2 -> {
                    it_2.oneSpace();
                    it_2.setPriority(1);
                };
                document.prepend(it_1, _function_3);
                Procedures.Procedure1 _function_4 = it_2 -> {
                    it_2.noSpace();
                    it_2.setPriority(-1);
                };
                document.append(it_1, _function_4);
            }
        };
        this.textRegionExtensions.allSemanticRegions((EObject)it).forEach(_function);
    }

    private ISemanticRegion formatEnvironmentKeyword(Environment it, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it_1 -> {
            it_1.oneSpace();
            it_1.setPriority(1);
        };
        return document.prepend(this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getEnvironmentAccess().getEnvironmentKeyword_1()), _function);
    }

    private void formatEnvironments(Environment it, @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = it_1 -> {
            String _text = it_1.getText();
            boolean _equals = Objects.equal((Object)_text, (Object)",");
            if (_equals) {
                Procedures.Procedure1 _function_1 = it_2 -> it_2.noSpace();
                Procedures.Procedure1 _function_2 = it_2 -> it_2.oneSpace();
                document.append(document.prepend(it_1, _function_1), _function_2);
            } else {
                Procedures.Procedure1 _function_3 = it_2 -> {
                    it_2.oneSpace();
                    it_2.setPriority(1);
                };
                document.prepend(it_1, _function_3);
                Procedures.Procedure1 _function_4 = it_2 -> {
                    it_2.noSpace();
                    it_2.setPriority(-1);
                };
                document.append(it_1, _function_4);
            }
        };
        this.textRegionExtensions.allSemanticRegions((EObject)it).forEach(_function);
    }

    public ITextReplacer createCommentReplacer(IComment comment) {
        String ruleName;
        boolean _startsWith;
        ITextReplacer _xblockexpression = null;
        EObject grammarElement = comment.getGrammarElement();
        if (grammarElement instanceof AbstractRule && (_startsWith = (ruleName = ((AbstractRule)grammarElement).getName()).startsWith("SL"))) {
            return new SinglelineDocCommentReplacer(comment, "//");
        }
        _xblockexpression = super.createCommentReplacer(comment);
        return _xblockexpression;
    }

    public void format(Object it, IFormattableDocument document) {
        if (it instanceof XtextResource) {
            this._format((XtextResource)it, document);
            return;
        }
        if (it instanceof Environment) {
            this._format((Environment)it, document);
            return;
        }
        if (it instanceof IncludeDeclaration) {
            this._format((IncludeDeclaration)it, document);
            return;
        }
        if (it instanceof Location) {
            this._format((Location)it, document);
            return;
        }
        if (it instanceof MavenLocation) {
            this._format((MavenLocation)it, document);
            return;
        }
        if (it instanceof Options) {
            this._format((Options)it, document);
            return;
        }
        if (it instanceof GeneratedFeature) {
            this._format((GeneratedFeature)it, document);
            return;
        }
        if (it instanceof IU) {
            this._format((IU)it, document);
            return;
        }
        if (it instanceof MavenDependency) {
            this._format((MavenDependency)it, document);
            return;
        }
        if (it instanceof MavenRepository) {
            this._format((MavenRepository)it, document);
            return;
        }
        if (it instanceof TargetPlatform) {
            this._format((TargetPlatform)it, document);
            return;
        }
        if (it instanceof EObject) {
            this._format((EObject)it, document);
            return;
        }
        if (it == null) {
            this._format(null, document);
            return;
        }
        if (it != null) {
            this._format(it, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, document).toString());
    }
}

