/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-03-06 06:14:25 +0100 (Thu, 06 Mar 2014) $
//  number=$Revision: 9876 $
//  type=si

/**
 * Localized names for the "si" locale.
 */
public class LocalizedNamesImpl_si extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "LK",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "IE",
        "IM",
        "IS",
        "AW",
        "AZ",
        "AR",
        "AM",
        "AI",
        "AO",
        "AQ",
        "AG",
        "AD",
        "VI",
        "AS",
        "DZ",
        "AL",
        "AC",
        "AF",
        "QO",
        "EC",
        "IT",
        "ET",
        "IN",
        "ID",
        "IQ",
        "IR",
        "EG",
        "IL",
        "UG",
        "KP",
        "MP",
        "UY",
        "UZ",
        "AE",
        "UM",
        "US",
        "GB",
        "ER",
        "SV",
        "EE",
        "AT",
        "OM",
        "AX",
        "AU",
        "QA",
        "KZ",
        "CX",
        "HR",
        "CP",
        "KH",
        "CA",
        "IC",
        "CM",
        "BQ",
        "CU",
        "KG",
        "KI",
        "CK",
        "CW",
        "KW",
        "KE",
        "CV",
        "KY",
        "CD",
        "CG",
        "CC",
        "KM",
        "CR",
        "XK",
        "CO",
        "CI",
        "GY",
        "GG",
        "GD",
        "GL",
        "GR",
        "GP",
        "GA",
        "GM",
        "GN",
        "GW",
        "GU",
        "GT",
        "GH",
        "TD",
        "CL",
        "CN",
        "CZ",
        "JP",
        "DE",
        "JE",
        "JM",
        "GI",
        "DJ",
        "GE",
        "JO",
        "TJ",
        "TM",
        "TC",
        "TT",
        "TA",
        "TZ",
        "TL",
        "TN",
        "TV",
        "TO",
        "TK",
        "TG",
        "DK",
        "DO",
        "DM",
        "TH",
        "TW",
        "TR",
        "ZA",
        "KR",
        "GS",
        "TF",
        "SS",
        "DG",
        "NE",
        "NG",
        "NC",
        "NZ",
        "NR",
        "NA",
        "NI",
        "NU",
        "AN",
        "NL",
        "NP",
        "NO",
        "NF",
        "PS",
        "PW",
        "GF",
        "PF",
        "FR",
        "PK",
        "PA",
        "PG",
        "PY",
        "PN",
        "PH",
        "PR",
        "PT",
        "PE",
        "PL",
        "BD",
        "EH",
        "BF",
        "BM",
        "BG",
        "BS",
        "BH",
        "BR",
        "IO",
        "VG",
        "BB",
        "BI",
        "BV",
        "BJ",
        "BY",
        "BE",
        "BZ",
        "BW",
        "BO",
        "BA",
        "BN",
        "BT",
        "MO",
        "CF",
        "FM",
        "YT",
        "MQ",
        "MW",
        "MV",
        "ML",
        "MH",
        "MG",
        "MY",
        "MK",
        "MM",
        "MU",
        "MX",
        "MN",
        "ME",
        "MS",
        "MC",
        "MR",
        "MA",
        "MD",
        "MZ",
        "MT",
        "UA",
        "EU",
        "YE",
        "RE",
        "RO",
        "RW",
        "RU",
        "LU",
        "LR",
        "LA",
        "LV",
        "LI",
        "LT",
        "LY",
        "LB",
        "LS",
        "VA",
        "VU",
        "WF",
        "VN",
        "VE",
        "LK",
        "KN",
        "PM",
        "BL",
        "MF",
        "SX",
        "LC",
        "VC",
        "SH",
        "GQ",
        "CY",
        "RS",
        "ES",
        "SK",
        "SI",
        "SZ",
        "CH",
        "SE",
        "SJ",
        "ST",
        "SM",
        "ZM",
        "WS",
        "SG",
        "ZW",
        "SL",
        "SY",
        "SC",
        "SR",
        "SD",
        "SN",
        "EA",
        "SB",
        "SO",
        "SA",
        "HU",
        "HT",
        "HM",
        "HK",
        "HN",
        "FO",
        "FI",
        "FJ",
        "FK",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ලෝකය");
    namesMap.put("002", "අප්‍රිකාව");
    namesMap.put("003", "උතුරු ඇමෙරිකාව");
    namesMap.put("005", "දකුණු ඇමෙරිකාව");
    namesMap.put("009", "ඕෂනියාව");
    namesMap.put("011", "බටහිරදිග අප්‍රිකාව");
    namesMap.put("013", "මධ්‍යම ඇමෙරිකාව");
    namesMap.put("014", "පෙරදිග අප්‍රිකාව");
    namesMap.put("015", "උතුරුදිග අප්‍රිකාව");
    namesMap.put("017", "මධ්‍යම අප්‍රිකාව");
    namesMap.put("018", "දකුණුදිග අප්‍රිකාව");
    namesMap.put("019", "ඇමරිකාව");
    namesMap.put("021", "උතුරුදිග ඇමෙරිකාව");
    namesMap.put("029", "කැරීබියන්");
    namesMap.put("030", "නැගෙනහිර ආසියාව");
    namesMap.put("034", "දකුණු ආසියාව");
    namesMap.put("035", "අග්නිදිග ආසියාව");
    namesMap.put("039", "දකුණුදිග යුරෝපය");
    namesMap.put("053", "ඕස්ට්‍රලේෂියාව");
    namesMap.put("054", "මෙලනීසියාව");
    namesMap.put("057", "මයික්‍රෝනීසියානු කළාපය");
    namesMap.put("061", "පොලිනීසියාව");
    namesMap.put("142", "ආසියාව");
    namesMap.put("143", "මධ්‍යම ආසියාව");
    namesMap.put("145", "බටහිර ආසියාව");
    namesMap.put("150", "යුරෝපය");
    namesMap.put("151", "නැගෙනහිර යුරෝපය");
    namesMap.put("154", "උතුරු යුරෝපය");
    namesMap.put("155", "බටහිර යුරෝපය");
    namesMap.put("419", "ලතින් ඇමෙරිකාව");
    namesMap.put("AC", "ඇසෙන්ෂන් දිවයින");
    namesMap.put("AD", "ඇන්ඩෝරාව");
    namesMap.put("AE", "එක්සත් අරාබි එමිර් රාජ්‍යය");
    namesMap.put("AF", "ඇෆ්ගනිස්ථානය");
    namesMap.put("AG", "ඇන්ටිගුවා සහ බාබියුඩාව");
    namesMap.put("AI", "ඇන්ගුයිලාව");
    namesMap.put("AL", "ඇල්බේනියාව");
    namesMap.put("AM", "ආර්මේනියාව");
    namesMap.put("AN", "නෙදර්ලන්ත ඇන්ටිලීසිය");
    namesMap.put("AO", "ඇන්ගෝලාව");
    namesMap.put("AQ", "ඇන්ටාක්ටිකාව");
    namesMap.put("AR", "ආර්ජෙන්ටිනාව");
    namesMap.put("AS", "ඇමරිකානු සැමෝවාව");
    namesMap.put("AT", "ඔස්ට්‍රියාව");
    namesMap.put("AU", "ඕස්ට්‍රේලියාව");
    namesMap.put("AW", "අරුබාව");
    namesMap.put("AX", "ඕලන්ඩ් දූපත්");
    namesMap.put("AZ", "අසර්බයිජානය");
    namesMap.put("BA", "බොස්නියාව සහ හර්සගොවීනාව");
    namesMap.put("BB", "බාර්බඩෝස්");
    namesMap.put("BD", "බංග්ලාදේශය");
    namesMap.put("BE", "බෙල්ජියම");
    namesMap.put("BF", "බර්කිනා ෆාසෝ");
    namesMap.put("BG", "බල්ගේරියාව");
    namesMap.put("BH", "බහරේන්");
    namesMap.put("BI", "බුරුන්දි");
    namesMap.put("BJ", "බෙනින්");
    namesMap.put("BL", "ශාන්ත බර්තලෙමි");
    namesMap.put("BM", "බර්මියුඩා");
    namesMap.put("BN", "බෲනායි");
    namesMap.put("BO", "බොලීවියාව");
    namesMap.put("BQ", "කැරිබියානු නෙදර්ලන්තය");
    namesMap.put("BR", "බ්‍රසීලය");
    namesMap.put("BS", "බහමාස්");
    namesMap.put("BT", "භූතානය");
    namesMap.put("BV", "බුවට් දුපත්");
    namesMap.put("BW", "බොට්ස්වානා");
    namesMap.put("BY", "බෙලරුස්");
    namesMap.put("BZ", "බෙලීස්");
    namesMap.put("CA", "කැනඩාව");
    namesMap.put("CC", "කොකෝස් දූපත්");
    namesMap.put("CD", "කොංගො - කින්ශාසා");
    namesMap.put("CF", "මධ්‍යම අප්‍රිකානු ජනරජය");
    namesMap.put("CG", "කොංගො - බ්‍රසාවිල්");
    namesMap.put("CH", "ස්විස්ටර්ලන්තය");
    namesMap.put("CI", "කෝට් දි අයිවරි");
    namesMap.put("CK", "කුක් දූපත්");
    namesMap.put("CL", "චිලී");
    namesMap.put("CM", "කැමරූන්");
    namesMap.put("CN", "චීනය");
    namesMap.put("CO", "කොළොම්බියාව");
    namesMap.put("CP", "ක්ලීපර්ටන් දූපත");
    namesMap.put("CR", "කොස්ටරිකාව");
    namesMap.put("CU", "කියුබාව");
    namesMap.put("CV", "කේප් වර්ඩ්");
    namesMap.put("CW", "කුරකාවෝ");
    namesMap.put("CX", "ක්‍රිස්මස් දූපත");
    namesMap.put("CY", "සයිප්‍රසය");
    namesMap.put("CZ", "චෙක් ජනරජය");
    namesMap.put("DE", "ජර්මනිය");
    namesMap.put("DG", "දියාගෝ ගාර්සියා");
    namesMap.put("DJ", "ජිබුටි");
    namesMap.put("DK", "ඩෙන්මාර්කය");
    namesMap.put("DM", "ඩොමිනිකාව");
    namesMap.put("DO", "ඩොමිනිකා ජනරජය");
    namesMap.put("DZ", "ඇල්ජීරියාව");
    namesMap.put("EA", "සෙයුටා සහ මෙලිල්ලා");
    namesMap.put("EC", "ඉක්වදෝරය");
    namesMap.put("EE", "එස්තෝනියාව");
    namesMap.put("EG", "ඊජිප්තුව");
    namesMap.put("EH", "බටහිර සහරාව");
    namesMap.put("ER", "එරිත්‍රියාව");
    namesMap.put("ES", "ස්පාඤ්ඤය");
    namesMap.put("ET", "ඉතියෝපියාව");
    namesMap.put("EU", "යුරෝපා සංගමය");
    namesMap.put("FI", "ෆින්ලන්තය");
    namesMap.put("FJ", "ෆීජී");
    namesMap.put("FK", "ෆෝක්ලන්ත දූපත්");
    namesMap.put("FM", "මයික්‍රොනීසියාව");
    namesMap.put("FO", "ෆැරෝ දූපත්");
    namesMap.put("FR", "ප්‍රංශය");
    namesMap.put("GA", "ගැබොන්");
    namesMap.put("GB", "එක්සත් රාජධානිය");
    namesMap.put("GD", "ග්‍රැනඩාව");
    namesMap.put("GE", "ජෝර්ජියාව");
    namesMap.put("GF", "ප්‍රංශ ගයනාව");
    namesMap.put("GG", "ගර්න්සිය");
    namesMap.put("GH", "ඝානාව");
    namesMap.put("GI", "ජිබ්‍රෝල්ටාව");
    namesMap.put("GL", "ග්‍රීන්ලන්තය");
    namesMap.put("GM", "ගැම්බියාව");
    namesMap.put("GN", "ගිණියාව");
    namesMap.put("GP", "ග්වෝඩලෝප්");
    namesMap.put("GQ", "සමක ගිනියාව");
    namesMap.put("GR", "ග්‍රීසිය");
    namesMap.put("GS", "දකුණු ජෝර්ජියාව සහ දකුණු සැන්ඩ්විච් දූපත්");
    namesMap.put("GT", "ගෝතමාලාව");
    namesMap.put("GU", "ගුවාම්");
    namesMap.put("GW", "ගිනි බිසව්");
    namesMap.put("GY", "ගයනාව");
    namesMap.put("HK", "හොංකොං චීන විශේෂ පරිපාලන කලාපය");
    namesMap.put("HM", "හර්ඩ් දූපත සහ මැක්ඩොනල්ඩ් දූපත්");
    namesMap.put("HN", "හොන්ඩුරාස්");
    namesMap.put("HR", "ක්‍රොඒෂියාව");
    namesMap.put("HT", "හයිටි");
    namesMap.put("HU", "හන්ගේරියාව");
    namesMap.put("IC", "කැනරි සූපත්");
    namesMap.put("ID", "ඉන්දුනීසියාව");
    namesMap.put("IE", "අයර්ලන්තය");
    namesMap.put("IL", "ඊශ්‍රායලය");
    namesMap.put("IM", "අයිල් ඔෆ් මෑන්");
    namesMap.put("IN", "ඉන්දියාව");
    namesMap.put("IO", "බ්‍රිතාන්‍ය ඉන්දීය සාගර බල ප්‍රදේශය");
    namesMap.put("IQ", "ඉරාකය");
    namesMap.put("IR", "ඉරානය");
    namesMap.put("IS", "අයිස්ලන්තය");
    namesMap.put("IT", "ඉතාලිය");
    namesMap.put("JE", "ජර්සි");
    namesMap.put("JM", "ජැමෙයිකාව");
    namesMap.put("JO", "ජෝර්දානය");
    namesMap.put("JP", "ජපානය");
    namesMap.put("KE", "කෙන්යාව");
    namesMap.put("KG", "කිර්ගිස්තානය");
    namesMap.put("KH", "කාම්බෝජය");
    namesMap.put("KI", "කිරිබති");
    namesMap.put("KM", "කොමොරෝස්");
    namesMap.put("KN", "ශාන්ත කිට්ස් සහ නේවිස්");
    namesMap.put("KP", "උතුරු කොරියාව");
    namesMap.put("KR", "දකුණු කොරියාව");
    namesMap.put("KW", "කුවේටය");
    namesMap.put("KY", "කේමන් දූපත්");
    namesMap.put("KZ", "කසකස්තානය");
    namesMap.put("LA", "ලාඕසය");
    namesMap.put("LB", "ලෙබනනය");
    namesMap.put("LC", "ශාන්ත ලුසියා");
    namesMap.put("LI", "ලික්ටන්ස්ටයින්");
    namesMap.put("LK", "ශ්‍රී ලංකාව");
    namesMap.put("LR", "ලයිබීරියාව");
    namesMap.put("LS", "ලෙසතෝ");
    namesMap.put("LT", "ලිතුවේනියාව");
    namesMap.put("LU", "ලක්ශම්බර්ග්");
    namesMap.put("LV", "ලැට්වියාව");
    namesMap.put("LY", "ලිබියාව");
    namesMap.put("MA", "මොරොක්කෝව");
    namesMap.put("MC", "මොනැකෝව");
    namesMap.put("MD", "මොල්ඩෝවාව");
    namesMap.put("ME", "මොන්ටෙනීග්‍රෝ");
    namesMap.put("MF", "ශාන්ත මාර්ටින්");
    namesMap.put("MG", "මැඩගස්කරය");
    namesMap.put("MH", "මාෂල් දූපත්");
    namesMap.put("MK", "මැසිඩෝනියාව");
    namesMap.put("ML", "මාලි");
    namesMap.put("MM", "මියන්මාරය (බුරුමය)");
    namesMap.put("MN", "මොන්ගෝලියාව");
    namesMap.put("MO", "මකාවු චීන විශේෂ පරිපාලන කලාපය");
    namesMap.put("MP", "උතුරු මරියානා දූපත්");
    namesMap.put("MQ", "මර්ටිනික්");
    namesMap.put("MR", "මොරිටේනියාව");
    namesMap.put("MS", "මොන්සෙරාට්");
    namesMap.put("MT", "මෝල්ටාව");
    namesMap.put("MU", "මුරුසිය");
    namesMap.put("MV", "මාල දිවයින");
    namesMap.put("MW", "මලාවි");
    namesMap.put("MX", "මෙක්සිකෝව");
    namesMap.put("MY", "මැලේසියාව");
    namesMap.put("MZ", "මොසැම්බික්");
    namesMap.put("NA", "නැමීබියාව");
    namesMap.put("NC", "නව කැලිඩෝනියාව");
    namesMap.put("NE", "නයිජර්");
    namesMap.put("NF", "නෝෆෝක් දූපත");
    namesMap.put("NG", "නයිජීරියාව");
    namesMap.put("NI", "නිකරගුවාව");
    namesMap.put("NL", "නෙදර්ලන්තය");
    namesMap.put("NO", "නෝර්වේ");
    namesMap.put("NP", "නේපාලය");
    namesMap.put("NR", "නාවුරු");
    namesMap.put("NU", "නියූ");
    namesMap.put("NZ", "නවසීලන්තය");
    namesMap.put("OM", "ඕමානය");
    namesMap.put("PA", "පැනමාව");
    namesMap.put("PE", "පේරු");
    namesMap.put("PF", "ප්‍රංශ පොලිනීසියාව");
    namesMap.put("PG", "පැපුවා නිව් ගිනියාව");
    namesMap.put("PH", "පිලිපීනය");
    namesMap.put("PK", "පාකිස්තානය");
    namesMap.put("PL", "පෝලන්තය");
    namesMap.put("PM", "ශාන්ත පියරේ සහ මැකෝලන්");
    namesMap.put("PN", "පිට්කෙය්න් දූපත්");
    namesMap.put("PR", "පුවර්ටෝ රිකෝ");
    namesMap.put("PS", "පලස්තීන රාජ්‍යය");
    namesMap.put("PT", "පෘතුගාලය");
    namesMap.put("PW", "පලාවු");
    namesMap.put("PY", "පැරගුවේ");
    namesMap.put("QA", "කටාර්");
    namesMap.put("QO", "ඈත ඕෂනියාව");
    namesMap.put("RE", "රීයුනියන්");
    namesMap.put("RO", "රුමේනියාව");
    namesMap.put("RS", "සර්බියාව");
    namesMap.put("RU", "රුසියාව");
    namesMap.put("RW", "රුවන්ඩාව");
    namesMap.put("SA", "සෞදි අරාබිය");
    namesMap.put("SB", "සොලමන් දූපත්");
    namesMap.put("SC", "සීශෙල්ස්");
    namesMap.put("SD", "සූඩානය");
    namesMap.put("SE", "ස්වීඩනය");
    namesMap.put("SG", "සිංගප්පූරුව");
    namesMap.put("SH", "ශාන්ත හෙලේනා");
    namesMap.put("SI", "ස්ලෝවේනියාව");
    namesMap.put("SJ", "ස්වෙල්බර්ඩ් සහ ජේන් මයේන්");
    namesMap.put("SK", "ස්ලෝවැකියාව");
    namesMap.put("SL", "සියරාලියෝන්");
    namesMap.put("SM", "සැන් මැරිනෝ");
    namesMap.put("SN", "සෙනගාලය");
    namesMap.put("SO", "සෝමාලියාව");
    namesMap.put("SR", "සුරිනාමය");
    namesMap.put("SS", "දකුණු සුඩානය");
    namesMap.put("ST", "සාඕ තෝම් සහ ප්‍රින්සිප්");
    namesMap.put("SV", "එල් සැල්වදෝරය");
    namesMap.put("SX", "ශාන්ත මාර්ටෙන්");
    namesMap.put("SY", "සිරියාව");
    namesMap.put("SZ", "ස්වාසිලන්තය");
    namesMap.put("TA", "ට්‍රිස්ටන් ද කුන්හා");
    namesMap.put("TC", "ටර්ක්ස් සහ කයිකොස් දූපත්");
    namesMap.put("TD", "චැච්");
    namesMap.put("TF", "දකුණු ප්‍රංශ දූපත් සමූහය");
    namesMap.put("TG", "ටොගෝ");
    namesMap.put("TH", "තායිලන්තය");
    namesMap.put("TJ", "ටජිකිස්තානය");
    namesMap.put("TK", "ටොකලාවු");
    namesMap.put("TL", "ටිමෝර් - ලෙස්ත්");
    namesMap.put("TM", "ටර්ක්මෙනිස්ථානය");
    namesMap.put("TN", "ටියුනීසියාව");
    namesMap.put("TO", "ටොංගා");
    namesMap.put("TR", "තුර්කිය");
    namesMap.put("TT", "ට්‍රිනිඩෑඩ් සහ ටොබැගෝ");
    namesMap.put("TV", "ටුවාලූ");
    namesMap.put("TW", "තායිවානය");
    namesMap.put("TZ", "ටැන්සානියාව");
    namesMap.put("UA", "යුක්රේනය");
    namesMap.put("UG", "උගන්ඩාව");
    namesMap.put("UM", "එක්සත් ජනපද ඈත දූපත්");
    namesMap.put("US", "එක්සත් ජනපදය");
    namesMap.put("UY", "උරුගුවේ");
    namesMap.put("UZ", "උස්බෙකිස්ථානය");
    namesMap.put("VA", "වතිකානු නගරය");
    namesMap.put("VC", "ශාන්ත වින්සන්ට් සහ ග්‍රෙනඩින්ස්");
    namesMap.put("VE", "වෙනිසියුලාව");
    namesMap.put("VG", "බ්‍රිතාන්‍ය වර්ජින් දූපත්");
    namesMap.put("VI", "ඇමරිකානු වර්ජින් දූපත්");
    namesMap.put("VN", "වියට්නාමය");
    namesMap.put("VU", "වනුවාටු");
    namesMap.put("WF", "වැලිස් සහ ෆුටුනා");
    namesMap.put("WS", "සැමෝවා");
    namesMap.put("XK", "කොසෝවෝ");
    namesMap.put("YE", "යේමනය");
    namesMap.put("YT", "මයෝට්");
    namesMap.put("ZA", "දකුණු අප්‍රිකාව");
    namesMap.put("ZM", "සැම්බියාව");
    namesMap.put("ZW", "සිම්බාබ්වේ");
    namesMap.put("ZZ", "හඳුනා නොගත් කළාපය");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ලෝකය",
        "002": "අප්‍රිකාව",
        "003": "උතුරු ඇමෙරිකාව",
        "005": "දකුණු ඇමෙරිකාව",
        "009": "ඕෂනියාව",
        "011": "බටහිරදිග අප්‍රිකාව",
        "013": "මධ්‍යම ඇමෙරිකාව",
        "014": "පෙරදිග අප්‍රිකාව",
        "015": "උතුරුදිග අප්‍රිකාව",
        "017": "මධ්‍යම අප්‍රිකාව",
        "018": "දකුණුදිග අප්‍රිකාව",
        "019": "ඇමරිකාව",
        "021": "උතුරුදිග ඇමෙරිකාව",
        "029": "කැරීබියන්",
        "030": "නැගෙනහිර ආසියාව",
        "034": "දකුණු ආසියාව",
        "035": "අග්නිදිග ආසියාව",
        "039": "දකුණුදිග යුරෝපය",
        "053": "ඕස්ට්‍රලේෂියාව",
        "054": "මෙලනීසියාව",
        "057": "මයික්‍රෝනීසියානු කළාපය",
        "061": "පොලිනීසියාව",
        "142": "ආසියාව",
        "143": "මධ්‍යම ආසියාව",
        "145": "බටහිර ආසියාව",
        "150": "යුරෝපය",
        "151": "නැගෙනහිර යුරෝපය",
        "154": "උතුරු යුරෝපය",
        "155": "බටහිර යුරෝපය",
        "419": "ලතින් ඇමෙරිකාව",
        "AC": "ඇසෙන්ෂන් දිවයින",
        "AD": "ඇන්ඩෝරාව",
        "AE": "එක්සත් අරාබි එමිර් රාජ්‍යය",
        "AF": "ඇෆ්ගනිස්ථානය",
        "AG": "ඇන්ටිගුවා සහ බාබියුඩාව",
        "AI": "ඇන්ගුයිලාව",
        "AL": "ඇල්බේනියාව",
        "AM": "ආර්මේනියාව",
        "AN": "නෙදර්ලන්ත ඇන්ටිලීසිය",
        "AO": "ඇන්ගෝලාව",
        "AQ": "ඇන්ටාක්ටිකාව",
        "AR": "ආර්ජෙන්ටිනාව",
        "AS": "ඇමරිකානු සැමෝවාව",
        "AT": "ඔස්ට්‍රියාව",
        "AU": "ඕස්ට්‍රේලියාව",
        "AW": "අරුබාව",
        "AX": "ඕලන්ඩ් දූපත්",
        "AZ": "අසර්බයිජානය",
        "BA": "බොස්නියාව සහ හර්සගොවීනාව",
        "BB": "බාර්බඩෝස්",
        "BD": "බංග්ලාදේශය",
        "BE": "බෙල්ජියම",
        "BF": "බර්කිනා ෆාසෝ",
        "BG": "බල්ගේරියාව",
        "BH": "බහරේන්",
        "BI": "බුරුන්දි",
        "BJ": "බෙනින්",
        "BL": "ශාන්ත බර්තලෙමි",
        "BM": "බර්මියුඩා",
        "BN": "බෲනායි",
        "BO": "බොලීවියාව",
        "BQ": "කැරිබියානු නෙදර්ලන්තය",
        "BR": "බ්‍රසීලය",
        "BS": "බහමාස්",
        "BT": "භූතානය",
        "BV": "බුවට් දුපත්",
        "BW": "බොට්ස්වානා",
        "BY": "බෙලරුස්",
        "BZ": "බෙලීස්",
        "CA": "කැනඩාව",
        "CC": "කොකෝස් දූපත්",
        "CD": "කොංගො - කින්ශාසා",
        "CF": "මධ්‍යම අප්‍රිකානු ජනරජය",
        "CG": "කොංගො - බ්‍රසාවිල්",
        "CH": "ස්විස්ටර්ලන්තය",
        "CI": "කෝට් දි අයිවරි",
        "CK": "කුක් දූපත්",
        "CL": "චිලී",
        "CM": "කැමරූන්",
        "CN": "චීනය",
        "CO": "කොළොම්බියාව",
        "CP": "ක්ලීපර්ටන් දූපත",
        "CR": "කොස්ටරිකාව",
        "CU": "කියුබාව",
        "CV": "කේප් වර්ඩ්",
        "CW": "කුරකාවෝ",
        "CX": "ක්‍රිස්මස් දූපත",
        "CY": "සයිප්‍රසය",
        "CZ": "චෙක් ජනරජය",
        "DE": "ජර්මනිය",
        "DG": "දියාගෝ ගාර්සියා",
        "DJ": "ජිබුටි",
        "DK": "ඩෙන්මාර්කය",
        "DM": "ඩොමිනිකාව",
        "DO": "ඩොමිනිකා ජනරජය",
        "DZ": "ඇල්ජීරියාව",
        "EA": "සෙයුටා සහ මෙලිල්ලා",
        "EC": "ඉක්වදෝරය",
        "EE": "එස්තෝනියාව",
        "EG": "ඊජිප්තුව",
        "EH": "බටහිර සහරාව",
        "ER": "එරිත්‍රියාව",
        "ES": "ස්පාඤ්ඤය",
        "ET": "ඉතියෝපියාව",
        "EU": "යුරෝපා සංගමය",
        "FI": "ෆින්ලන්තය",
        "FJ": "ෆීජී",
        "FK": "ෆෝක්ලන්ත දූපත්",
        "FM": "මයික්‍රොනීසියාව",
        "FO": "ෆැරෝ දූපත්",
        "FR": "ප්‍රංශය",
        "GA": "ගැබොන්",
        "GB": "එක්සත් රාජධානිය",
        "GD": "ග්‍රැනඩාව",
        "GE": "ජෝර්ජියාව",
        "GF": "ප්‍රංශ ගයනාව",
        "GG": "ගර්න්සිය",
        "GH": "ඝානාව",
        "GI": "ජිබ්‍රෝල්ටාව",
        "GL": "ග්‍රීන්ලන්තය",
        "GM": "ගැම්බියාව",
        "GN": "ගිණියාව",
        "GP": "ග්වෝඩලෝප්",
        "GQ": "සමක ගිනියාව",
        "GR": "ග්‍රීසිය",
        "GS": "දකුණු ජෝර්ජියාව සහ දකුණු සැන්ඩ්විච් දූපත්",
        "GT": "ගෝතමාලාව",
        "GU": "ගුවාම්",
        "GW": "ගිනි බිසව්",
        "GY": "ගයනාව",
        "HK": "හොංකොං චීන විශේෂ පරිපාලන කලාපය",
        "HM": "හර්ඩ් දූපත සහ මැක්ඩොනල්ඩ් දූපත්",
        "HN": "හොන්ඩුරාස්",
        "HR": "ක්‍රොඒෂියාව",
        "HT": "හයිටි",
        "HU": "හන්ගේරියාව",
        "IC": "කැනරි සූපත්",
        "ID": "ඉන්දුනීසියාව",
        "IE": "අයර්ලන්තය",
        "IL": "ඊශ්‍රායලය",
        "IM": "අයිල් ඔෆ් මෑන්",
        "IN": "ඉන්දියාව",
        "IO": "බ්‍රිතාන්‍ය ඉන්දීය සාගර බල ප්‍රදේශය",
        "IQ": "ඉරාකය",
        "IR": "ඉරානය",
        "IS": "අයිස්ලන්තය",
        "IT": "ඉතාලිය",
        "JE": "ජර්සි",
        "JM": "ජැමෙයිකාව",
        "JO": "ජෝර්දානය",
        "JP": "ජපානය",
        "KE": "කෙන්යාව",
        "KG": "කිර්ගිස්තානය",
        "KH": "කාම්බෝජය",
        "KI": "කිරිබති",
        "KM": "කොමොරෝස්",
        "KN": "ශාන්ත කිට්ස් සහ නේවිස්",
        "KP": "උතුරු කොරියාව",
        "KR": "දකුණු කොරියාව",
        "KW": "කුවේටය",
        "KY": "කේමන් දූපත්",
        "KZ": "කසකස්තානය",
        "LA": "ලාඕසය",
        "LB": "ලෙබනනය",
        "LC": "ශාන්ත ලුසියා",
        "LI": "ලික්ටන්ස්ටයින්",
        "LK": "ශ්‍රී ලංකාව",
        "LR": "ලයිබීරියාව",
        "LS": "ලෙසතෝ",
        "LT": "ලිතුවේනියාව",
        "LU": "ලක්ශම්බර්ග්",
        "LV": "ලැට්වියාව",
        "LY": "ලිබියාව",
        "MA": "මොරොක්කෝව",
        "MC": "මොනැකෝව",
        "MD": "මොල්ඩෝවාව",
        "ME": "මොන්ටෙනීග්‍රෝ",
        "MF": "ශාන්ත මාර්ටින්",
        "MG": "මැඩගස්කරය",
        "MH": "මාෂල් දූපත්",
        "MK": "මැසිඩෝනියාව",
        "ML": "මාලි",
        "MM": "මියන්මාරය (බුරුමය)",
        "MN": "මොන්ගෝලියාව",
        "MO": "මකාවු චීන විශේෂ පරිපාලන කලාපය",
        "MP": "උතුරු මරියානා දූපත්",
        "MQ": "මර්ටිනික්",
        "MR": "මොරිටේනියාව",
        "MS": "මොන්සෙරාට්",
        "MT": "මෝල්ටාව",
        "MU": "මුරුසිය",
        "MV": "මාල දිවයින",
        "MW": "මලාවි",
        "MX": "මෙක්සිකෝව",
        "MY": "මැලේසියාව",
        "MZ": "මොසැම්බික්",
        "NA": "නැමීබියාව",
        "NC": "නව කැලිඩෝනියාව",
        "NE": "නයිජර්",
        "NF": "නෝෆෝක් දූපත",
        "NG": "නයිජීරියාව",
        "NI": "නිකරගුවාව",
        "NL": "නෙදර්ලන්තය",
        "NO": "නෝර්වේ",
        "NP": "නේපාලය",
        "NR": "නාවුරු",
        "NU": "නියූ",
        "NZ": "නවසීලන්තය",
        "OM": "ඕමානය",
        "PA": "පැනමාව",
        "PE": "පේරු",
        "PF": "ප්‍රංශ පොලිනීසියාව",
        "PG": "පැපුවා නිව් ගිනියාව",
        "PH": "පිලිපීනය",
        "PK": "පාකිස්තානය",
        "PL": "පෝලන්තය",
        "PM": "ශාන්ත පියරේ සහ මැකෝලන්",
        "PN": "පිට්කෙය්න් දූපත්",
        "PR": "පුවර්ටෝ රිකෝ",
        "PS": "පලස්තීන රාජ්‍යය",
        "PT": "පෘතුගාලය",
        "PW": "පලාවු",
        "PY": "පැරගුවේ",
        "QA": "කටාර්",
        "QO": "ඈත ඕෂනියාව",
        "RE": "රීයුනියන්",
        "RO": "රුමේනියාව",
        "RS": "සර්බියාව",
        "RU": "රුසියාව",
        "RW": "රුවන්ඩාව",
        "SA": "සෞදි අරාබිය",
        "SB": "සොලමන් දූපත්",
        "SC": "සීශෙල්ස්",
        "SD": "සූඩානය",
        "SE": "ස්වීඩනය",
        "SG": "සිංගප්පූරුව",
        "SH": "ශාන්ත හෙලේනා",
        "SI": "ස්ලෝවේනියාව",
        "SJ": "ස්වෙල්බර්ඩ් සහ ජේන් මයේන්",
        "SK": "ස්ලෝවැකියාව",
        "SL": "සියරාලියෝන්",
        "SM": "සැන් මැරිනෝ",
        "SN": "සෙනගාලය",
        "SO": "සෝමාලියාව",
        "SR": "සුරිනාමය",
        "SS": "දකුණු සුඩානය",
        "ST": "සාඕ තෝම් සහ ප්‍රින්සිප්",
        "SV": "එල් සැල්වදෝරය",
        "SX": "ශාන්ත මාර්ටෙන්",
        "SY": "සිරියාව",
        "SZ": "ස්වාසිලන්තය",
        "TA": "ට්‍රිස්ටන් ද කුන්හා",
        "TC": "ටර්ක්ස් සහ කයිකොස් දූපත්",
        "TD": "චැච්",
        "TF": "දකුණු ප්‍රංශ දූපත් සමූහය",
        "TG": "ටොගෝ",
        "TH": "තායිලන්තය",
        "TJ": "ටජිකිස්තානය",
        "TK": "ටොකලාවු",
        "TL": "ටිමෝර් - ලෙස්ත්",
        "TM": "ටර්ක්මෙනිස්ථානය",
        "TN": "ටියුනීසියාව",
        "TO": "ටොංගා",
        "TR": "තුර්කිය",
        "TT": "ට්‍රිනිඩෑඩ් සහ ටොබැගෝ",
        "TV": "ටුවාලූ",
        "TW": "තායිවානය",
        "TZ": "ටැන්සානියාව",
        "UA": "යුක්රේනය",
        "UG": "උගන්ඩාව",
        "UM": "එක්සත් ජනපද ඈත දූපත්",
        "US": "එක්සත් ජනපදය",
        "UY": "උරුගුවේ",
        "UZ": "උස්බෙකිස්ථානය",
        "VA": "වතිකානු නගරය",
        "VC": "ශාන්ත වින්සන්ට් සහ ග්‍රෙනඩින්ස්",
        "VE": "වෙනිසියුලාව",
        "VG": "බ්‍රිතාන්‍ය වර්ජින් දූපත්",
        "VI": "ඇමරිකානු වර්ජින් දූපත්",
        "VN": "වියට්නාමය",
        "VU": "වනුවාටු",
        "WF": "වැලිස් සහ ෆුටුනා",
        "WS": "සැමෝවා",
        "XK": "කොසෝවෝ",
        "YE": "යේමනය",
        "YT": "මයෝට්",
        "ZA": "දකුණු අප්‍රිකාව",
        "ZM": "සැම්බියාව",
        "ZW": "සිම්බාබ්වේ",
        "ZZ": "හඳුනා නොගත් කළාපය"
    };
  }-*/;
}
