/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.coyote.ajp.AbstractAjpProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpProcessor
extends AbstractAjpProcessor<Socket> {
    private static final Log log = LogFactory.getLog(AjpProcessor.class);
    protected InputStream input;
    protected OutputStream output;

    @Override
    protected Log getLog() {
        return log;
    }

    public AjpProcessor(int packetSize, JIoEndpoint endpoint) {
        super(packetSize, endpoint);
        this.response.setOutputBuffer(new AbstractAjpProcessor.SocketOutputBuffer());
    }

    @Override
    public void recycle(boolean socketClosing) {
        super.recycle(socketClosing);
        if (socketClosing) {
            this.input = null;
            this.output = null;
        }
    }

    @Override
    protected void registerForEvent(boolean read, boolean write) {
    }

    @Override
    protected void resetTimeouts() {
    }

    @Override
    protected void setupSocket(SocketWrapper<Socket> socketWrapper) throws IOException {
        this.input = socketWrapper.getSocket().getInputStream();
        this.output = socketWrapper.getSocket().getOutputStream();
    }

    @Override
    protected void setTimeout(SocketWrapper<Socket> socketWrapper, int timeout) throws IOException {
        socketWrapper.getSocket().setSoTimeout(timeout);
    }

    @Override
    protected int output(byte[] src, int offset, int length, boolean block) throws IOException {
        this.output.write(src, offset, length);
        return length;
    }

    @Override
    protected boolean read(byte[] buf, int pos, int n, boolean blockFirstRead) throws IOException {
        int res = 0;
        for (int read = 0; read < n; read += res) {
            res = this.input.read(buf, read + pos, n - read);
            if (res > 0) {
                continue;
            }
            throw new IOException(sm.getString("ajpprocessor.failedread"));
        }
        return true;
    }
}

