/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.swt.modeling;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedMenu;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuServiceFilter
implements Listener {
    public static final String NUL_MENU_ITEM = "(None Applicable)";
    private static final String TMP_ORIGINAL_CONTEXT = "MenuServiceFilter.original.context";
    private static Method aboutToShow;
    @Inject
    private MApplication application;
    @Inject
    private IPresentationEngine renderer;
    @Inject
    private Logger logger;
    @Inject
    EModelService modelService;
    private HashMap<Menu, Runnable> pendingCleanup = new HashMap();

    private static void trace(String msg, Widget menu, MMenu menuModel) {
        WorkbenchSWTActivator.trace("/trace/menus", String.valueOf(msg) + ": " + menu + ": " + menuModel, null);
    }

    public static Method getAboutToShow() {
        if (aboutToShow == null) {
            try {
                aboutToShow = MenuManager.class.getDeclaredMethod("handleAboutToShow", new Class[0]);
                aboutToShow.setAccessible(true);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return aboutToShow;
    }

    public void handleEvent(final Event event) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (MenuServiceFilter.this.logger != null) {
                    MenuServiceFilter.this.logger.error(e);
                }
            }

            public void run() throws Exception {
                MenuServiceFilter.this.safeHandleEvent(event);
            }
        });
    }

    private void safeHandleEvent(Event event) {
        Object obj;
        if (!(event.widget instanceof Menu)) {
            return;
        }
        Menu menu = (Menu)event.widget;
        if (event.type == 12) {
            MenuServiceFilter.trace("handleMenu.Dispose", (Widget)menu, null);
            this.cleanUp(menu);
        }
        if ((obj = menu.getData("modelElement")) == null && menu.getParentItem() != null) {
            obj = menu.getParentItem().getData("modelElement");
        }
        if (obj instanceof MRenderedMenu) {
            this.handlerRenderedMenu(event, menu, (MRenderedMenu)obj);
        } else if (obj instanceof MPopupMenu) {
            this.handleContextMenu(event, menu, (MPopupMenu)obj);
        } else if (obj instanceof MMenu) {
            this.handleMenu(event, menu, (MMenu)obj);
        }
    }

    private void handleMenu(Event event, Menu menu, MMenu menuModel) {
        if ((menu.getStyle() & 2) != 0) {
            return;
        }
        switch (event.type) {
            case 22: {
                MenuServiceFilter.trace("handleMenu.Show", (Widget)menu, menuModel);
                this.cleanUp(menu);
                this.showMenu(event, menu, menuModel);
                break;
            }
            case 23: {
                MenuServiceFilter.trace("handleMenu.Hide", (Widget)menu, menuModel);
            }
        }
    }

    public void showMenu(Event event, final Menu menu, final MMenu menuModel) {
        MenuItem item;
        IEclipseContext parentContext = this.modelService.getContainingContext((MUIElement)menuModel);
        ArrayList toContribute = new ArrayList();
        final ArrayList menuContributionsToRemove = new ArrayList();
        ExpressionContext eContext = new ExpressionContext(parentContext);
        ContributionsAnalyzer.gatherMenuContributions((MMenu)menuModel, (List)this.application.getMenuContributions(), (String)menuModel.getElementId(), toContribute, (ExpressionContext)eContext, (boolean)false);
        if (menu.getItemCount() == 1 && NUL_MENU_ITEM.equals((item = menu.getItem(0)).getText())) {
            item.dispose();
        }
        ContributionsAnalyzer.addMenuContributions((MMenu)menuModel, toContribute, menuContributionsToRemove);
        this.pendingCleanup.put(menu, new Runnable(){

            public void run() {
                if (!menu.isDisposed()) {
                    MenuServiceFilter.this.unrender(menuContributionsToRemove);
                }
                MenuServiceFilter.this.removeMenuContributions(menuModel, menuContributionsToRemove);
            }
        });
        this.render(menu, menuModel);
        if (menu.getItemCount() == 0) {
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setText(NUL_MENU_ITEM);
            menuItem.setEnabled(false);
        }
    }

    private void handleContextMenu(Event event, Menu menu, MPopupMenu menuModel) {
        switch (event.type) {
            case 22: {
                MenuServiceFilter.trace("handleContextMenu.Show", (Widget)menu, (MMenu)menuModel);
                this.cleanUp(menu);
                this.showPopup(event, menu, menuModel);
                break;
            }
            case 23: {
                MenuServiceFilter.trace("handleContextMenu.Hide", (Widget)menu, (MMenu)menuModel);
                this.hidePopup(event, menu, menuModel);
            }
        }
    }

    public void hidePopup(Event event, Menu menu, MPopupMenu menuModel) {
        IEclipseContext popupContext = menuModel.getContext();
        final IEclipseContext parentContext = popupContext.getParent();
        final IEclipseContext originalChild = (IEclipseContext)popupContext.get(TMP_ORIGINAL_CONTEXT);
        popupContext.remove(TMP_ORIGINAL_CONTEXT);
        if (!menu.isDisposed()) {
            menu.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    parentContext.set("activeChildContext", (Object)originalChild);
                }
            });
        }
    }

    public void showPopup(Event event, final Menu menu, final MPopupMenu menuModel) {
        IEclipseContext popupContext = menuModel.getContext();
        IEclipseContext parentContext = popupContext.getParent();
        IEclipseContext originalChild = (IEclipseContext)parentContext.getLocal("activeChildContext");
        parentContext.set("activeChildContext", (Object)popupContext);
        popupContext.set(TMP_ORIGINAL_CONTEXT, (Object)originalChild);
        ArrayList toContribute = new ArrayList();
        final ArrayList menuContributionsToRemove = new ArrayList();
        ExpressionContext eContext = new ExpressionContext(popupContext);
        ContributionsAnalyzer.gatherMenuContributions((MMenu)menuModel, (List)this.application.getMenuContributions(), (String)menuModel.getElementId(), toContribute, (ExpressionContext)eContext, (boolean)true);
        for (String tag : menuModel.getTags()) {
            if (!tag.startsWith("popup:") || tag.length() <= 6) continue;
            ContributionsAnalyzer.gatherMenuContributions((MMenu)menuModel, (List)this.application.getMenuContributions(), (String)tag.substring(6), toContribute, (ExpressionContext)eContext, (boolean)false);
        }
        ContributionsAnalyzer.addMenuContributions((MMenu)menuModel, toContribute, menuContributionsToRemove);
        this.pendingCleanup.put(menu, new Runnable(){

            public void run() {
                if (!menu.isDisposed()) {
                    MenuServiceFilter.this.unrender(menuContributionsToRemove);
                }
                MenuServiceFilter.this.removeMenuContributions((MMenu)menuModel, menuContributionsToRemove);
            }
        });
        this.render(menu, (MMenu)menuModel);
    }

    private void render(Menu menu, MMenu menuModel) {
        MenuServiceFilter.trace("render", (Widget)menu, menuModel);
        for (MMenuElement element : menuModel.getChildren()) {
            this.renderer.createGui((MUIElement)element, (Object)menu, null);
            if (!(element instanceof MHandledMenuItem)) continue;
            this.setEnabled((MHandledMenuItem)element);
        }
    }

    private void setEnabled(MHandledMenuItem item) {
        if (!item.isToBeRendered() || !item.isVisible() || item.getWidget() == null) {
            return;
        }
        ParameterizedCommand cmd = item.getWbCommand();
        if (cmd == null) {
            return;
        }
        IEclipseContext lclContext = this.modelService.getContainingContext((MUIElement)item);
        EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class);
        item.setEnabled(service.canExecute(cmd));
    }

    private void unrender(List<MMenuElement> menuModel) {
        MenuServiceFilter.trace("unrender", null, null);
        for (MMenuElement element : menuModel) {
            this.renderer.removeGui((MUIElement)element);
        }
    }

    private void removeMenuContributions(MMenu menuModel, ArrayList<MMenuElement> menuContributionsToRemove) {
        for (MMenuElement item : menuContributionsToRemove) {
            MenuServiceFilter.trace("removeMenuContributions " + item, (Widget)menuModel.getWidget(), menuModel);
            menuModel.getChildren().remove(item);
        }
    }

    private void handlerRenderedMenu(Event event, Menu menu, MRenderedMenu menuModel) {
        switch (event.type) {
            case 22: {
                MenuServiceFilter.trace("handlerRenderedMenu.Show", (Widget)menu, (MMenu)menuModel);
                this.cleanUp(menu);
                this.showRenderedMenu(event, menu, menuModel);
                break;
            }
            case 23: {
                MenuServiceFilter.trace("handlerRenderedMenu.Hide", (Widget)menu, (MMenu)menuModel);
            }
        }
    }

    public void showRenderedMenu(Event event, Menu menu, MRenderedMenu menuModel) {
        if (!(menuModel.getContributionManager() instanceof MenuManager)) {
            return;
        }
        MenuManager manager = (MenuManager)menuModel.getContributionManager();
        Method handleAboutToShow = MenuServiceFilter.getAboutToShow();
        try {
            handleAboutToShow.invoke((Object)manager, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        if (menuModel.getChildren().size() == 1 && menuModel.getChildren().get(0) instanceof MPopupMenu) {
            this.showPopup(event, menu, (MPopupMenu)menuModel.getChildren().get(0));
        } else {
            this.showMenu(event, menu, (MMenu)menuModel);
        }
        event.type = 0;
        event.doit = false;
    }

    public void cleanUp(Menu menu) {
        MenuServiceFilter.trace("cleanUp", (Widget)menu, null);
        if (this.pendingCleanup.isEmpty()) {
            return;
        }
        Runnable cleanUp = this.pendingCleanup.remove(menu);
        if (cleanUp != null) {
            MenuServiceFilter.trace("cleanUp.run()", (Widget)menu, null);
            cleanUp.run();
        }
    }

    public void dispose() {
        Menu[] keys;
        Menu[] menuArray = keys = this.pendingCleanup.keySet().toArray(new Menu[this.pendingCleanup.size()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Menu menu = menuArray[n2];
            this.cleanUp(menu);
            ++n2;
        }
    }
}

