/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.javabean.metadata.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.e4.xwt.javabean.metadata.Behavior;
import org.eclipse.e4.xwt.metadata.ILoadingType;
import org.eclipse.e4.xwt.metadata.IProperty;
import org.eclipse.e4.xwt.metadata.ISetPostAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProperty
extends Behavior
implements IProperty {
    static final int VALUE_AS_PARENT = 2;
    protected Collection<ISetPostAction> setPostActions = Collections.EMPTY_LIST;
    private Class<?> type;
    protected ILoadingType loadingType;

    public AbstractProperty(String name, Class<?> type) {
        this(name, type, ILoadingType.DEFAULT);
    }

    public AbstractProperty(String name, Class<?> type, ILoadingType loadingType) {
        super(name);
        this.setType(type);
        this.loadingType = loadingType;
    }

    @Override
    public void addSetPostAction(ISetPostAction setPostAction) {
        if (this.setPostActions == Collections.EMPTY_LIST) {
            this.setPostActions = new ArrayList<ISetPostAction>();
        }
        if (!this.setPostActions.contains(setPostAction)) {
            this.setPostActions.add(setPostAction);
        }
    }

    @Override
    public void removeSetPostAction(ISetPostAction setPostAction) {
        this.setPostActions.remove(setPostAction);
    }

    protected void fireSetPostAction(Object target, IProperty property, Object value) {
        for (ISetPostAction setPostAction : this.setPostActions) {
            setPostAction.action(target, property, value);
        }
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean isContainement() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setType(Class<?> type) {
        if (type == Boolean.TYPE) {
            type = Boolean.class;
        } else if (type == Integer.TYPE) {
            type = Integer.class;
        } else if (type == Long.TYPE) {
            type = Long.class;
        } else if (type == Character.TYPE) {
            type = Character.class;
        } else if (type == Float.TYPE) {
            type = Float.class;
        } else if (type == Double.TYPE) {
            type = Double.class;
        } else if (type == Byte.TYPE) {
            type = Byte.class;
        } else if (type == Short.TYPE) {
            type = Short.class;
        }
        this.type = type;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isValueAsParent() {
        return (this.flags & 2) == 2;
    }

    public void setValueAsParent(boolean value) {
        this.flags |= 2;
    }

    @Override
    public ILoadingType getLoadingType() {
        return this.loadingType;
    }
}

