/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import org.eclipse.core.resources.semantic.spi.FileCacheServiceFactory;
import org.eclipse.core.resources.semantic.spi.ICacheService;
import org.eclipse.core.resources.semantic.spi.ICacheUpdateCallback;
import org.eclipse.core.resources.semantic.spi.MemoryCacheServiceFactory;
import org.eclipse.core.resources.semantic.spi.SemanticFileCache;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.junit.Test;

public class TestCacheService {
    @Test
    public void testCacheService() throws Exception {
        ICacheService service = new FileCacheServiceFactory().getCacheService();
        Path path = new Path("/test/file.txt");
        String content = "test";
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes("UTF-8"));
        this.writeToCache(service, (IPath)path, input);
        String content2 = "test2";
        ByteArrayInputStream input2 = new ByteArrayInputStream(content2.getBytes("UTF-8"));
        this.writeToCache(service, (IPath)path, input2);
        this.readFromCache(service, (IPath)path, content2);
        String content3 = "test3";
        this.writeToCacheViaOutputStream(service, (IPath)path, content3);
        this.readFromCache(service, (IPath)path, content3);
        String content4 = "appended";
        ByteArrayInputStream input4 = new ByteArrayInputStream(content4.getBytes("UTF-8"));
        this.appendToCache(service, (IPath)path, input4);
        this.readFromCache(service, (IPath)path, String.valueOf(content3) + content4);
        Path path2 = new Path("/test/file2.txt");
        this.writeToCache(service, (IPath)path2, input2);
        this.removeFromCache(service, (IPath)path2);
        this.manipulateTimestamp(service, (IPath)path);
    }

    @Test
    public void testFileSystemCompaction() throws Exception {
        ICacheService service = new FileCacheServiceFactory().getCacheService();
        Path path = new Path("/test2/file.txt");
        String content = "test";
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes("UTF-8"));
        this.appendToCache(service, (IPath)path, input);
        this.removeFromCache(service, (IPath)path);
        File cacheFile = new File(SemanticFileCache.getCache().getCacheDir(), path.toString());
        Assert.assertTrue((!cacheFile.exists() ? 1 : 0) != 0);
        Assert.assertTrue((!cacheFile.getParentFile().exists() ? 1 : 0) != 0);
    }

    @Test
    public void testContentDeletion() throws Exception {
        File cacheFile;
        Path path;
        ICacheService service;
        block5: {
            service = new FileCacheServiceFactory().getCacheService();
            path = new Path("/test2/file.txt");
            String content = "test";
            ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes("UTF-8"));
            cacheFile = new File(SemanticFileCache.getCache().getCacheDir(), path.toString());
            this.appendToCache(service, (IPath)path, input);
            InputStream is = service.getContent((IPath)path);
            try {
                try {
                    this.removeFromCache(service, (IPath)path);
                }
                catch (CoreException coreException) {
                    Assert.assertTrue((!service.hasContent((IPath)path) ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)cacheFile.exists());
                    Util.safeClose((InputStream)is);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Util.safeClose((InputStream)is);
                throw throwable;
            }
            Util.safeClose((InputStream)is);
        }
        Assert.assertTrue((!service.hasContent((IPath)path) ? 1 : 0) != 0);
        Assert.assertTrue((!cacheFile.exists() ? 1 : 0) != 0);
        Assert.assertTrue((!cacheFile.getParentFile().exists() ? 1 : 0) != 0);
    }

    @Test
    public void testRecursiveContentDeletion() throws Exception {
        ICacheService service = new FileCacheServiceFactory().getCacheService();
        Path rootPath = new Path("/testrecursive/testroot/");
        IPath path = rootPath.append("/test2/file.txt");
        String content = "test";
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes("UTF-8"));
        File cacheFile = new File(SemanticFileCache.getCache().getCacheDir(), path.toString());
        IPath path2 = rootPath.append("/test2/test3/file.txt");
        String content2 = "test";
        ByteArrayInputStream input2 = new ByteArrayInputStream(content2.getBytes("UTF-8"));
        File cacheFile2 = new File(SemanticFileCache.getCache().getCacheDir(), path.toString());
        this.appendToCache(service, path, input);
        this.appendToCache(service, path2, input2);
        this.removeFromCacheRecursive(service, (IPath)rootPath);
        Assert.assertTrue((!service.hasContent(path) ? 1 : 0) != 0);
        Assert.assertTrue((!service.hasContent(path2) ? 1 : 0) != 0);
        Assert.assertTrue((!cacheFile.exists() ? 1 : 0) != 0);
        Assert.assertTrue((!cacheFile.getParentFile().exists() ? 1 : 0) != 0);
        Assert.assertTrue((!cacheFile2.exists() ? 1 : 0) != 0);
        Assert.assertTrue((!cacheFile2.getParentFile().exists() ? 1 : 0) != 0);
    }

    @Test
    public void testRecursiveContentDeletion2() throws Exception {
        ICacheService service = new FileCacheServiceFactory().getCacheService();
        Path rootPath = new Path("/testrecursive/testroot/");
        IPath path = rootPath.append("/test2/file.txt");
        String content = "test";
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes("UTF-8"));
        File cacheFile = new File(SemanticFileCache.getCache().getCacheDir(), path.toString());
        IPath path2 = rootPath.append("/test2/test3/file.txt");
        String content2 = "test";
        ByteArrayInputStream input2 = new ByteArrayInputStream(content2.getBytes("UTF-8"));
        File cacheFile2 = new File(SemanticFileCache.getCache().getCacheDir(), path.toString());
        this.appendToCache(service, path, input);
        this.appendToCache(service, path2, input2);
        InputStream is = service.getContent(path);
        try {
            this.removeFromCacheRecursive(service, (IPath)rootPath);
        }
        finally {
            Util.safeClose((InputStream)is);
        }
        if ("win32".equals(Platform.getOS())) {
            Assert.assertTrue((String)"File must still be present", (boolean)cacheFile.exists());
            Assert.assertTrue((String)"Parent folder must still be present", (boolean)cacheFile.getParentFile().exists());
        }
        Assert.assertTrue((!service.hasContent(path) ? 1 : 0) != 0);
        Assert.assertTrue((!service.hasContent(path2) ? 1 : 0) != 0);
        Assert.assertTrue((!cacheFile.exists() ? 1 : 0) != 0);
        Assert.assertTrue((!cacheFile.getParentFile().exists() ? 1 : 0) != 0);
        Assert.assertTrue((!cacheFile2.exists() ? 1 : 0) != 0);
        Assert.assertTrue((!cacheFile2.getParentFile().exists() ? 1 : 0) != 0);
    }

    @Test
    public void testRecursiveContentDeletion3() throws Exception {
        ICacheService service = new MemoryCacheServiceFactory().getCacheService();
        Path rootPath = new Path("/testrecursive/testroot/");
        IPath path = rootPath.append("/test2/file.txt");
        String content = "test";
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes("UTF-8"));
        IPath path2 = rootPath.append("/test2/test3/file.txt");
        String content2 = "test";
        ByteArrayInputStream input2 = new ByteArrayInputStream(content2.getBytes("UTF-8"));
        this.appendToCache(service, path, input);
        this.appendToCache(service, path2, input2);
        this.removeFromCacheRecursive(service, (IPath)rootPath);
        Assert.assertTrue((!service.hasContent(path) ? 1 : 0) != 0);
        Assert.assertTrue((!service.hasContent(path2) ? 1 : 0) != 0);
    }

    @Test
    public void testRecursiveContentDeletion4() throws Exception {
        ICacheService service = new MemoryCacheServiceFactory().getCacheService();
        Path rootPath = new Path("/testrecursive/testroot/");
        IPath path = rootPath.append("/test2/file.txt");
        String content = "test";
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes("UTF-8"));
        IPath path2 = rootPath.append("/test2/test3/file.txt");
        String content2 = "test";
        ByteArrayInputStream input2 = new ByteArrayInputStream(content2.getBytes("UTF-8"));
        this.appendToCache(service, path, input);
        this.appendToCache(service, path2, input2);
        this.removeFromCacheRecursive(service, path);
        Assert.assertTrue((!service.hasContent(path) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)service.hasContent(path2));
    }

    @Test
    public void testConcurrentAccess() throws Exception {
        Path path;
        ICacheService service;
        block8: {
            service = new FileCacheServiceFactory().getCacheService();
            path = new Path("/test2/file.txt");
            String content = "test";
            ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes("UTF-8"));
            this.writeToCache(service, (IPath)path, input);
            Path path1 = new Path("/test2/file1.txt");
            String content1 = "test1";
            ByteArrayInputStream input1 = new ByteArrayInputStream(content1.getBytes("UTF-8"));
            this.writeToCache(service, (IPath)path1, input1);
            InputStream is = service.getContent((IPath)path);
            InputStream is1 = service.getContent((IPath)path1);
            try {
                try {
                    this.writeToCache(service, (IPath)path, new ByteArrayInputStream("test2".getBytes("UTF-8")));
                    this.writeToCache(service, (IPath)path1, new ByteArrayInputStream("test2".getBytes("UTF-8")));
                    this.readFromCache(service, (IPath)path, "test2");
                    this.readFromCache(service, (IPath)path1, "test2");
                    InputStream is2 = service.getContent((IPath)path);
                    InputStream is3 = service.getContent((IPath)path1);
                    try {
                        this.writeToCache(service, (IPath)path, new ByteArrayInputStream("test3".getBytes("UTF-8")));
                        this.writeToCache(service, (IPath)path1, new ByteArrayInputStream("test3".getBytes("UTF-8")));
                        this.readFromCache(service, (IPath)path, "test3");
                        this.readFromCache(service, (IPath)path1, "test3");
                    }
                    finally {
                        Util.safeClose((InputStream)is2);
                        Util.safeClose((InputStream)is3);
                    }
                }
                catch (CoreException coreException) {
                    Assert.fail((String)"Should not fail even if file open");
                    Util.safeClose((InputStream)is);
                    Util.safeClose((InputStream)is1);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                Util.safeClose((InputStream)is);
                Util.safeClose((InputStream)is1);
                throw throwable;
            }
            Util.safeClose((InputStream)is);
            Util.safeClose((InputStream)is1);
        }
        File cacheFile = new File(SemanticFileCache.getCache().getCacheDir(), path.toString());
        Assert.assertTrue((boolean)cacheFile.exists());
        this.writeToCache(service, (IPath)path, new ByteArrayInputStream("test4".getBytes("UTF-8")));
        Assert.assertTrue((boolean)cacheFile.exists());
        Assert.assertTrue((boolean)service.hasContent((IPath)path));
    }

    public void manipulateTimestamp(ICacheService service, IPath path) throws CoreException {
    }

    public void writeToCache(ICacheService service, IPath path, InputStream input) throws CoreException {
        service.addContent(path, input, 0, null);
        Assert.assertTrue((boolean)service.hasContent(path));
    }

    public void appendToCache(ICacheService service, IPath path, InputStream input) throws CoreException {
        service.addContent(path, input, 1, null);
        Assert.assertTrue((boolean)service.hasContent(path));
    }

    public void removeFromCache(ICacheService service, IPath path) throws CoreException {
        service.removeContent(path, null);
        Assert.assertTrue((!service.hasContent(path) ? 1 : 0) != 0);
    }

    public void removeFromCacheRecursive(ICacheService service, IPath path) throws CoreException {
        service.removeContentRecursive(path, null);
    }

    public void writeToCacheViaOutputStream(ICacheService service, IPath path, String content) throws CoreException {
        final ByteArrayOutputStream remoteOs = new ByteArrayOutputStream();
        ICacheUpdateCallback callback = new ICacheUpdateCallback(){

            public void cacheUpdated(InputStream newContent, long cacheTimestamp, boolean append) {
                try {
                    Util.transferStreams((InputStream)newContent, (OutputStream)remoteOs, null);
                }
                catch (CoreException coreException) {}
            }
        };
        OutputStream os = service.wrapOutputStream(path, false, callback, null);
        try {
            os.write(content.getBytes());
            os.close();
            this.compareByteArrayWithContent(content, remoteOs.toByteArray());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "test", 0, content, (Throwable)e));
        }
    }

    public void readFromCache(ICacheService service, IPath path, String content) throws CoreException {
        InputStream is = null;
        try {
            try {
                is = service.getContent(path);
                this.compareInputStreamWithContent(content, is);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "test", 0, content, (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Util.safeClose(is);
            throw throwable;
        }
        Util.safeClose((InputStream)is);
    }

    private void compareInputStreamWithContent(String content, InputStream is) throws IOException {
        byte[] b = new byte[content.length() + 2];
        int size = is.read(b);
        Assert.assertEquals((int)content.length(), (int)size);
        int i = 0;
        while (i < size) {
            byte c = b[i];
            Assert.assertTrue((String)"Content is different", (c == content.charAt(i) ? 1 : 0) != 0);
            ++i;
        }
    }

    private void compareByteArrayWithContent(String content, byte[] b) {
        Assert.assertEquals((int)content.length(), (int)b.length);
        int i = 0;
        while (i < b.length) {
            byte c = b[i];
            Assert.assertTrue((String)"Content is different", (c == content.charAt(i) ? 1 : 0) != 0);
            ++i;
        }
    }
}

