/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.examples.css.rcp;

import java.util.ArrayList;
import org.eclipse.e4.ui.examples.css.rcp.ApplicationWorkbenchAdvisor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class NavigationView
extends ViewPart {
    public static final String ID = "org.eclipse.e4.ui.examples.css.rcp.navigationView";
    private TreeViewer viewer;

    private TreeObject createDummyModel() {
        TreeObject to1 = new TreeObject("Inbox");
        TreeObject to2 = new TreeObject("Drafts");
        TreeObject to3 = new TreeObject("Sent");
        TreeParent p1 = new TreeParent("me@this.com");
        p1.addChild(to1);
        p1.addChild(to2);
        p1.addChild(to3);
        TreeObject to4 = new TreeObject("Inbox");
        TreeParent p2 = new TreeParent("other@aol.com");
        p2.addChild(to4);
        TreeParent root = new TreeParent("");
        root.addChild(p1);
        root.addChild(p2);
        return root;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.setCSSID((Widget)this.viewer.getControl(), "navigation");
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput((Object)this.createDummyModel());
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void setCSSID(Widget widget, String name) {
        widget.setData("org.eclipse.e4.ui.css.id", (Object)name);
        ApplicationWorkbenchAdvisor.INSTANCE.engine.applyStyles((Object)widget, true);
    }

    class TreeObject {
        private String name;
        private TreeParent parent;

        public TreeObject(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setParent(TreeParent parent) {
            this.parent = parent;
        }

        public TreeParent getParent() {
            return this.parent;
        }

        public String toString() {
            return this.getName();
        }
    }

    class TreeParent
    extends TreeObject {
        private ArrayList children;

        public TreeParent(String name) {
            super(name);
            this.children = new ArrayList();
        }

        public void addChild(TreeObject child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void removeChild(TreeObject child) {
            this.children.remove(child);
            child.setParent(null);
        }

        public TreeObject[] getChildren() {
            return this.children.toArray(new TreeObject[this.children.size()]);
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof TreeObject) {
                return ((TreeObject)child).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).getChildren();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).hasChildren();
            }
            return false;
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            String imageKey = "IMG_OBJ_ELEMENTS";
            if (obj instanceof TreeParent) {
                imageKey = "IMG_OBJ_FOLDER";
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
    }
}

