/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.examples.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class AddFileOrFolderFromRemotePage
extends WizardPage {
    public static final String PAGE_NAME = AddFileOrFolderFromRemotePage.class.getName();
    private static final String PREF_FOLDERMODE = String.valueOf(AddFileOrFolderFromRemotePage.class.getName()) + "FolderMode";
    private static final String PREF_PATH = String.valueOf(AddFileOrFolderFromRemotePage.class.getName()) + "Path";
    private static final String PREF_NAME = String.valueOf(AddFileOrFolderFromRemotePage.class.getName()) + "Name";
    private static final String PREF_DEEP = String.valueOf(AddFileOrFolderFromRemotePage.class.getName()) + "Deep";
    final ISemanticFolder parentFolder;
    Text pathText;
    Text childNameText;
    Button deepMode;
    Button addFile;
    boolean folderMode;
    String path = "";
    String childName = "";
    boolean deep;
    boolean initialized = false;

    public AddFileOrFolderFromRemotePage(ISemanticFolder parent) {
        super(PAGE_NAME);
        this.parentFolder = parent;
    }

    public AddFileOrFolderFromRemotePage(ISemanticFolder parent, String initialPath, boolean folderMode) {
        super(PAGE_NAME);
        this.parentFolder = parent;
        this.path = initialPath;
        this.folderMode = folderMode;
        this.initialized = true;
    }

    public String getChildName() {
        return this.childName;
    }

    public String getPath() {
        return this.path.replace('\\', '/');
    }

    public boolean isFolderMode() {
        return this.folderMode;
    }

    public boolean isDeep() {
        return this.deep;
    }

    public void createControl(Composite parent) {
        this.initFromPreferences();
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)parent);
        Composite myParent = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)myParent);
        myParent.setLayout((Layout)new GridLayout(2, false));
        Label parentFolderLabel = new Label(myParent, 0);
        parentFolderLabel.setText(Messages.AddFileOrFolderFromRemotePage_ParentFolder_XFLD);
        Text parentPath = new Text(myParent, 2048);
        parentPath.setText(this.parentFolder.getAdaptedContainer().getFullPath().toString());
        parentPath.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)parentPath);
        Group localFs = new Group(myParent, 16);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)localFs);
        localFs.setText(Messages.AddFileOrFolderFromRemotePage_LocalFileOrFolder_XGRP);
        localFs.setLayout((Layout)new GridLayout(3, false));
        this.addFile = new Button((Composite)localFs, 16);
        this.addFile.setText(Messages.AddFileOrFolderFromRemotePage_File_XRBL);
        this.addFile.setSelection(!this.folderMode);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.addFile);
        Button addFolder = new Button((Composite)localFs, 16);
        addFolder.setSelection(this.folderMode);
        addFolder.setText(Messages.AddFileOrFolderFromRemotePage_Folder_XRBL);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)addFolder);
        this.addFile.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddFileOrFolderFromRemotePage.this.folderMode = !AddFileOrFolderFromRemotePage.this.addFile.getSelection();
                AddFileOrFolderFromRemotePage.this.deepMode.setEnabled(AddFileOrFolderFromRemotePage.this.folderMode);
                AddFileOrFolderFromRemotePage.this.check();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label pathLabel = new Label((Composite)localFs, 0);
        pathLabel.setText(Messages.AddFileOrFolderFromRemotePage_LocalPath_XFLD);
        this.pathText = new Text((Composite)localFs, 2048);
        this.pathText.setText(this.path);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.pathText);
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddFileOrFolderFromRemotePage.this.path = AddFileOrFolderFromRemotePage.this.pathText.getText();
                try {
                    Path selPath = new Path(AddFileOrFolderFromRemotePage.this.path);
                    AddFileOrFolderFromRemotePage.this.childNameText.setText(selPath.lastSegment());
                }
                catch (Exception exception) {}
                AddFileOrFolderFromRemotePage.this.check();
            }
        });
        Button browseButton = new Button((Composite)localFs, 8);
        browseButton.setText(Messages.AddFileOrFolderFromRemotePage_Browse_XBUT);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selected;
                if (AddFileOrFolderFromRemotePage.this.folderMode) {
                    DirectoryDialog dialog = new DirectoryDialog(AddFileOrFolderFromRemotePage.this.getShell());
                    dialog.setFilterPath(new Path(AddFileOrFolderFromRemotePage.this.path).toOSString());
                    selected = dialog.open();
                } else {
                    FileDialog dialog = new FileDialog(AddFileOrFolderFromRemotePage.this.getShell());
                    dialog.setFilterPath(new Path(AddFileOrFolderFromRemotePage.this.path).toOSString());
                    selected = dialog.open();
                }
                if (selected == null) {
                    selected = "";
                }
                AddFileOrFolderFromRemotePage.this.pathText.setText(selected);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.deepMode = new Button((Composite)localFs, 32);
        this.deepMode.setText(Messages.AddFileOrFolderFromRemotePage_Deep_XRBL);
        this.deepMode.setEnabled(this.folderMode);
        this.deepMode.setSelection(this.deep);
        this.deepMode.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddFileOrFolderFromRemotePage.this.deep = AddFileOrFolderFromRemotePage.this.deepMode.getSelection();
                AddFileOrFolderFromRemotePage.this.check();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.deepMode);
        Label nameLabel = new Label(myParent, 0);
        nameLabel.setText(Messages.AddFileOrFolderFromRemotePage_ChildName_XFLD);
        this.childNameText = new Text(myParent, 2048);
        this.childNameText.setText(this.childName);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.childNameText);
        this.childNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddFileOrFolderFromRemotePage.this.childName = AddFileOrFolderFromRemotePage.this.childNameText.getText();
                AddFileOrFolderFromRemotePage.this.check();
            }
        });
        this.setMessage(Messages.AddFileOrFolderFromRemotePage_Select_XMSG);
        this.setControl((Control)myParent);
        this.setPageComplete(!this.childName.equals("") && !this.path.equals(""));
        browseButton.setFocus();
    }

    private void initFromPreferences() {
        if (this.initialized) {
            return;
        }
        IEclipsePreferences store = new ConfigurationScope().getNode("org.eclipse.core.resources.semantic.examples");
        this.folderMode = store.getBoolean(PREF_FOLDERMODE, true);
        this.path = store.get(PREF_PATH, "");
        this.childName = store.get(PREF_NAME, "");
        this.deep = store.getBoolean(PREF_DEEP, false);
    }

    private void saveToPreferences() {
        IEclipsePreferences store = new ConfigurationScope().getNode("org.eclipse.core.resources.semantic.examples");
        store.putBoolean(PREF_FOLDERMODE, this.folderMode);
        store.put(PREF_PATH, this.path);
        store.put(PREF_NAME, this.childName);
        store.putBoolean(PREF_DEEP, this.deep);
        try {
            store.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    protected void check() {
        this.setErrorMessage(null);
        this.setPageComplete(false);
        if (this.path.equals("")) {
            this.setErrorMessage(Messages.AddFileOrFolderFromRemotePage_PathMssing_XMSG);
            return;
        }
        File test = new File(this.pathText.getText());
        if (!test.exists()) {
            this.setErrorMessage(Messages.AddFileOrFolderFromRemotePage_NotFoundAtPath_XMSG);
            return;
        }
        if (test.isDirectory() != this.folderMode) {
            if (this.folderMode) {
                this.setErrorMessage(Messages.AddFileOrFolderFromRemotePage_NotFolder_XMSG);
            } else {
                this.setErrorMessage(Messages.AddFileOrFolderFromRemotePage_NotFile_XMSG);
            }
            return;
        }
        if (this.childNameText.getText().equals("")) {
            this.setErrorMessage(Messages.AddFileOrFolderFromRemotePage_NameMissing_XMSG);
            return;
        }
        IPath validationPath = this.parentFolder.getAdaptedContainer().getFullPath().append(this.childNameText.getText());
        int type = this.folderMode ? 2 : 1;
        IStatus stat = ResourcesPlugin.getWorkspace().validatePath(validationPath.toString(), type);
        if (!stat.isOK()) {
            this.setErrorMessage(stat.getMessage());
            return;
        }
        try {
            if (this.parentFolder.hasResource(this.childNameText.getText())) {
                this.setErrorMessage(NLS.bind((String)Messages.AddFileOrFolderFromRemotePage_NameInUse_XMSG, (Object)this.childNameText.getText()));
                return;
            }
        }
        catch (CoreException coreException) {}
        this.setPageComplete(!this.childName.equals("") && !this.path.equals(""));
        if (this.isPageComplete()) {
            this.saveToPreferences();
        }
    }
}

