/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.webdav;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.eclipse.core.resources.semantic.examples.webdav.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UserCredentialsDialog
extends Dialog {
    protected Text usernameField;
    protected Text passwordField;
    protected String host;
    protected String message;
    private Credentials credentials;

    public static Credentials askForCredentials(String host, String message) {
        UserCredentialsDialog ui = new UserCredentialsDialog(null, host, message);
        ui.open();
        return ui.getCredentials();
    }

    private UserCredentialsDialog(Shell parentShell, String host, String message) {
        super(parentShell);
        this.host = host;
        this.message = message;
        this.setBlockOnOpen(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        Label label = new Label(main, 64);
        String text = NLS.bind((String)Messages.UserCredentialsDialog_ConnectTo_XFLD, (Object)this.host);
        text = String.valueOf(text) + "\n\n" + this.message;
        label.setText(text);
        GridDataFactory.generate((Control)label, (int)2, (int)1);
        Label userLabel = new Label(main, 0);
        userLabel.setText(Messages.UserCredentialsDialog_UserName_XFLD);
        GridDataFactory.fillDefaults().applyTo((Control)userLabel);
        this.usernameField = new Text(main, 2048);
        GridDataFactory.fillDefaults().applyTo((Control)this.usernameField);
        Label pwdLabel = new Label(main, 0);
        pwdLabel.setText(Messages.UserCredentialsDialog_Password_XFLD);
        GridDataFactory.fillDefaults().applyTo((Control)pwdLabel);
        this.passwordField = new Text(main, 0x400800);
        GridDataFactory.fillDefaults().applyTo((Control)this.passwordField);
        return main;
    }

    private Credentials getCredentials() {
        return this.credentials;
    }

    protected void okPressed() {
        if (this.usernameField.getText() != null && this.passwordField.getText() != null) {
            this.credentials = new UsernamePasswordCredentials(this.usernameField.getText(), this.passwordField.getText());
        }
        super.okPressed();
    }
}

