/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.widgets.CTabItem;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Display;

public class PartRenderingEngineTests
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        if (this.appContext instanceof IDisposable) {
            this.appContext.dispose();
        }
    }

    public void testCreateViewBug298415() {
        MWindow window = this.createWindowWithOneView("Part Name");
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        IPresentationEngine renderer = (IPresentationEngine)this.appContext.get(IPresentationEngine.class.getName());
        renderer.removeGui((MUIElement)part);
        renderer.removeGui((MUIElement)window);
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public void testAddWindowBug299219() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertNotNull((Object)window.getWidget());
        MWindow window2 = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window2);
        PartRenderingEngineTests.assertNotNull((Object)window2.getWidget());
    }

    public void testPartStack_SetActiveChildBug299379() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        EPartService service = (EPartService)window.getContext().get(EPartService.class.getName());
        service.activate(partB);
        PartRenderingEngineTests.assertEquals((String)"Activating another part should've altered the tab folder's selection", (int)1, (int)tabFolder.getSelectionIndex());
    }

    public void testPartStack_SetActiveChild2Bug299379() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        stack.setSelectedElement((MUIElement)partA);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        EPartService service = (EPartService)window.getContext().get(EPartService.class.getName());
        service.showPart(partB.getElementId(), EPartService.PartState.ACTIVATE);
        PartRenderingEngineTests.assertEquals((String)"Showing a part should alter the tab folder's selection", (int)1, (int)tabFolder.getSelectionIndex());
    }

    public void testPartStack_SetActiveChild3Bug299379() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MPartDescriptor descriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        descriptor.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        descriptor.setElementId("part");
        descriptor.setCategory("aStack");
        application.getDescriptors().add(descriptor);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        stack.getTags().add("aStack");
        window.getChildren().add(stack);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getItemCount());
        EPartService service = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart shownPart = service.showPart("part", EPartService.PartState.ACTIVATE);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getItemCount());
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((String)"The shown part should be the active part", (Object)shownPart, (Object)stack.getSelectedElement());
    }

    public void testPartStack_SetActiveChild4Bug299379() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        stack.setSelectedElement((MUIElement)partB);
        PartRenderingEngineTests.assertEquals((String)"Switching the active child should've changed the folder's selection", (int)1, (int)tabFolder.getSelectionIndex());
    }

    public void testPartStack_SetActiveChild5Bug295250() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertEquals((Object)partA, (Object)stack.getSelectedElement());
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partB);
        PartRenderingEngineTests.assertEquals((String)"Adding a part to a stack should not cause the stack's active child to change", (Object)partA, (Object)stack.getSelectedElement());
        PartRenderingEngineTests.assertNull((String)"The object should not have been instantiated", (Object)partB.getObject());
    }

    public void testPartStack_SetActiveChild6Bug298797() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partA, (Object)stack.getSelectedElement());
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partB);
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partA, (Object)stack.getSelectedElement());
        stack.setSelectedElement((MUIElement)partB);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partB, (Object)stack.getSelectedElement());
    }

    public void testCreateGuiBug301021() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MPartDescriptor descriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        descriptor.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        descriptor.setElementId("part");
        descriptor.setCategory("aStack");
        application.getDescriptors().add(descriptor);
        MPartDescriptor descriptor2 = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        descriptor2.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        descriptor2.setElementId("part2");
        descriptor2.setCategory("aStack");
        application.getDescriptors().add(descriptor2);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MPartSashContainer partSashContainer = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        stack.setElementId("aStack");
        partSashContainer.getChildren().add(stack);
        window.getChildren().add(partSashContainer);
        application.getChildren().add(window);
        MWindow window2 = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window2);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        IPresentationEngine engine = (IPresentationEngine)this.appContext.get(IPresentationEngine.class);
        engine.createGui((MUIElement)window2);
        EPartService service = (EPartService)window2.getContext().get(EPartService.class.getName());
        service.showPart("part", EPartService.PartState.VISIBLE);
        service.showPart("part", EPartService.PartState.CREATE);
        service.showPart("part2", EPartService.PartState.CREATE);
        while (Display.getDefault().readAndDispatch()) {
        }
    }

    public void testPart_ToBeRendered() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        EPartService service = (EPartService)window.getContext().get(EPartService.class.getName());
        service.activate(partB);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getSelectionIndex());
        partB.setToBeRendered(false);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getItemCount());
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partA, (Object)stack.getSelectedElement());
    }

    public void testPart_ToBeRendered2() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partB.setToBeRendered(false);
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        stack.setSelectedElement((MUIElement)partA);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getItemCount());
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        partB.setToBeRendered(true);
        PartRenderingEngineTests.assertEquals((String)"Rendering another part in the stack should not change the selection", (int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partA, (Object)stack.getSelectedElement());
        PartRenderingEngineTests.assertEquals((int)2, (int)tabFolder.getItemCount());
        PartRenderingEngineTests.assertNotNull((Object)partB.getObject());
    }

    public void testClientObjectUnsetWhenNotRenderedBug301439() {
        MWindow window = this.createWindowWithOneView("");
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        PartRenderingEngineTests.assertNotNull((Object)part.getWidget());
        PartRenderingEngineTests.assertNotNull((Object)part.getRenderer());
        PartRenderingEngineTests.assertNotNull((Object)part.getObject());
        part.setToBeRendered(false);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertNull((Object)part.getWidget());
        PartRenderingEngineTests.assertNull((Object)part.getRenderer());
        PartRenderingEngineTests.assertNull((Object)part.getObject());
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getItemCount());
    }

    public void testCTabItem_SetControl_Bug304211() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.setSelectedElement((MUIElement)partA);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        IPresentationEngine engine = (IPresentationEngine)this.appContext.get(IPresentationEngine.class.getName());
        CTabFolder folder = (CTabFolder)stack.getWidget();
        CTabItem itemA = folder.getItem(0);
        PartRenderingEngineTests.assertEquals((String)"The presentation engine should have created the part and set it", (Object)partA.getWidget(), (Object)itemA.getControl());
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partB);
        CTabItem item2 = folder.getItem(1);
        PartRenderingEngineTests.assertNull((String)"For a stack, the object will not be rendered unless explicitly required", (Object)item2.getControl());
        engine.createGui((MUIElement)partB);
        PartRenderingEngineTests.assertEquals((String)"The presentation engine should have created the part and set it", (Object)partB.getWidget(), (Object)item2.getControl());
        stack.setSelectedElement((MUIElement)partB);
        PartRenderingEngineTests.assertEquals((String)"Selecting the element should not have changed anything", (Object)partB.getWidget(), (Object)item2.getControl());
    }

    public void testToBeRenderedCausesSelectionChanges() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        EPartService service = (EPartService)window.getContext().get(EPartService.class.getName());
        service.activate(partB);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getSelectionIndex());
        service.activate(partA);
        partA.setToBeRendered(false);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getItemCount());
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partB, (Object)stack.getSelectedElement());
    }

    public void testCreateGuiBug301950() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getChildren().add(part);
        IPresentationEngine renderer = (IPresentationEngine)this.appContext.get(IPresentationEngine.class.getName());
        renderer.createGui((MUIElement)part);
        renderer.removeGui((MUIElement)part);
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public void testRemoveGuiBug307578() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.setSelectedElement((MUIElement)partA);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)2, (int)folder.getItemCount());
        PartRenderingEngineTests.assertNull((Object)partB.getRenderer());
        PartRenderingEngineTests.assertNull((Object)partB.getObject());
        PartRenderingEngineTests.assertNull((Object)partB.getWidget());
        IPresentationEngine renderer = (IPresentationEngine)this.appContext.get(IPresentationEngine.class.getName());
        renderer.removeGui((MUIElement)partB);
        PartRenderingEngineTests.assertEquals((int)1, (int)folder.getItemCount());
    }

    private MWindow createWindowWithOneView(String partName) {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setHeight(300);
        window.setWidth(400);
        window.setLabel("MyWindow");
        MPartSashContainer sash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        window.getChildren().add(sash);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        sash.getChildren().add(stack);
        MPart contributedPart = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(contributedPart);
        contributedPart.setLabel(partName);
        contributedPart.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        return window;
    }
}

