/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.controls.tooltip;

import java.net.URL;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;

public class ToolTip_Styles {
    private Button button;
    private static ToolTip toolTip;
    private static Tray tray;
    private static TrayItem trayItem;

    public static void main(String[] args) {
        URL url = ToolTip_Styles.class.getResource(String.valueOf(ToolTip_Styles.class.getSimpleName()) + ".xwt");
        try {
            XWT.open((URL)url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void clear(Event event) {
        if (toolTip != null && !toolTip.isDisposed()) {
            toolTip.setVisible(false);
            toolTip.dispose();
        }
        if (trayItem != null && !trayItem.isDisposed()) {
            trayItem.dispose();
        }
    }

    protected void showTooltip(Event event) {
        Group messageGrp;
        Group textGroup;
        int n;
        Group displayGrp;
        this.clear(event);
        this.button = (Button)event.widget;
        int style = 0;
        String text = "Tooltip Text";
        String message = "ToolTip Messages";
        boolean autoHide = false;
        boolean showInTray = false;
        Group stypesGroup = this.findGroup("groupStyles");
        if (stypesGroup != null) {
            style = this.createStyle(stypesGroup);
        }
        if ((displayGrp = this.findGroup("displayMode")) != null) {
            Control[] children;
            Control[] controlArray = children = displayGrp.getChildren();
            n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control instanceof Button) {
                    Button btn = (Button)control;
                    if ("AutoHide".equals(btn.getText())) {
                        autoHide = btn.getSelection();
                    } else if ("Show In Tray".equals(btn.getText())) {
                        showInTray = btn.getSelection();
                    }
                }
                ++n2;
            }
        }
        if ((textGroup = this.findGroup("groupText")) != null) {
            Control[] children;
            Control[] controlArray = children = textGroup.getChildren();
            int n3 = children.length;
            n = 0;
            while (n < n3) {
                Control control = controlArray[n];
                if (control instanceof Text) {
                    text = ((Text)control).getText();
                }
                ++n;
            }
        }
        if ((messageGrp = this.findGroup("groupMessage")) != null) {
            Control[] children;
            Control[] controlArray = children = messageGrp.getChildren();
            int n4 = children.length;
            int n5 = 0;
            while (n5 < n4) {
                Control control = controlArray[n5];
                if (control instanceof Text) {
                    message = ((Text)control).getText();
                }
                ++n5;
            }
        }
        if (toolTip != null) {
            toolTip.dispose();
        }
        toolTip = new ToolTip(this.button.getShell(), style);
        toolTip.setText(text);
        toolTip.setMessage(message);
        toolTip.setAutoHide(autoHide);
        if (showInTray) {
            if (tray == null) {
                tray = this.button.getDisplay().getSystemTray();
            }
            if (trayItem != null) {
                trayItem.dispose();
            }
            trayItem = new TrayItem(tray, 0);
            trayItem.setToolTip(toolTip);
        }
        toolTip.setVisible(true);
    }

    private int createStyle(Group stypesGroup) {
        Control[] children;
        int style = 0;
        Control[] controlArray = children = stypesGroup.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Button btn;
            Control control = controlArray[n2];
            if (control instanceof Button && (btn = (Button)control).getSelection()) {
                String text = btn.getText();
                if ("SWT.BALLOON".equals(text)) {
                    style |= 0x1000;
                } else if ("SWT.ICON_INFORMATION".equals(text)) {
                    style |= 2;
                } else if ("SWT.ICON_ERROR".equals(text)) {
                    style |= 1;
                } else if ("SWT.ICON_WARNING".equals(text)) {
                    style |= 8;
                }
            }
            ++n2;
        }
        return style;
    }

    private Group findGroup(String grpName) {
        if (this.button == null) {
            return null;
        }
        return (Group)XWT.findElementByName((Object)this.button, (String)grpName);
    }
}

