/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.inject.Inject;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;

public class ContextInjectionDisposeTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(ContextInjectionDisposeTest.class);
    }

    public ContextInjectionDisposeTest() {
    }

    public ContextInjectionDisposeTest(String name) {
        super(name);
    }

    public void testContextDisposedNoArg() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(String.class.getName(), (Object)"hello");
        class Injected
        implements IDisposable {
            boolean disposeInvoked = false;
            @Inject
            private String Field;

            Injected() {
            }

            public void dispose() {
                this.disposeInvoked = true;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        context.dispose();
        ContextInjectionDisposeTest.assertTrue((boolean)object.disposeInvoked);
    }

    public void testDisposeContext() {
        IEclipseContext context = EclipseContextFactory.create();
        Object fieldValue = new Object();
        String methodValue = "abc";
        context.set(Object.class.getName(), fieldValue);
        context.set(String.class.getName(), (Object)methodValue);
        class Injected
        implements IDisposable {
            boolean disposeInvoked = false;
            @Inject
            Object Field;
            String methodValue;

            Injected() {
            }

            public void dispose() {
                this.disposeInvoked = true;
            }

            @Inject
            public void InjectedMethod(String arg) {
                this.methodValue = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        ContextInjectionDisposeTest.assertEquals((Object)fieldValue, (Object)object.Field);
        ContextInjectionDisposeTest.assertEquals((Object)methodValue, (Object)object.methodValue);
        context.dispose();
        ContextInjectionDisposeTest.assertNull((Object)object.Field);
        ContextInjectionDisposeTest.assertNull((Object)object.methodValue);
        ContextInjectionDisposeTest.assertTrue((boolean)object.disposeInvoked);
    }

    public void testReleaseObject() {
        IEclipseContext context = EclipseContextFactory.create();
        Integer fieldValue = new Integer(123);
        String methodValue = "abc";
        context.set(Integer.class.getName(), (Object)fieldValue);
        context.set(String.class.getName(), (Object)methodValue);
        class Injected
        implements IDisposable {
            boolean disposeInvoked = false;
            boolean destroyInvoked = false;
            @Inject
            Integer Field;
            Object methodValue;

            Injected() {
            }

            public void destroy() {
                this.destroyInvoked = true;
            }

            public void dispose() {
                this.disposeInvoked = true;
            }

            @Inject
            public void InjectedMethod(String arg) {
                this.methodValue = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        ContextInjectionDisposeTest.assertEquals((Object)fieldValue, (Object)object.Field);
        ContextInjectionDisposeTest.assertEquals((Object)methodValue, (Object)object.methodValue);
        ContextInjectionFactory.uninject((Object)object, (IEclipseContext)context);
        ContextInjectionDisposeTest.assertNull((Object)object.Field);
        ContextInjectionDisposeTest.assertNull((Object)object.methodValue);
        ContextInjectionDisposeTest.assertFalse((boolean)object.disposeInvoked);
        ContextInjectionDisposeTest.assertFalse((boolean)object.destroyInvoked);
    }
}

