/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.server.bespin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.server.bespin.JSONUtil;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.internal.core.ClasspathComputer;

public class FilesServlet
extends HttpServlet {
    private static final boolean CHEAT = false;
    private IWorkspace workspace;

    private synchronized IWorkspace getWorkspace() {
        if (this.workspace == null) {
            new InstanceScope().getNode("org.eclipse.core.resources").putBoolean("refresh.enabled", true);
            this.workspace = ResourcesPlugin.getWorkspace();
        }
        return this.workspace;
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo.startsWith("/at/")) {
            try {
                String wsPath = pathInfo.substring("/at".length());
                IFile file = this.getWorkspace().getRoot().getFile((IPath)new Path(wsPath));
                ServletInputStream inputStream = req.getInputStream();
                if (file.exists()) {
                    file.setContents((InputStream)inputStream, false, true, null);
                } else {
                    file.create((InputStream)inputStream, false, null);
                }
                resp.setStatus(200);
                this.pipe(file, (OutputStream)resp.getOutputStream());
                return;
            }
            catch (Exception e) {
                e.printStackTrace(resp.getWriter());
                resp.setStatus(500);
                return;
            }
        }
        if (pathInfo.startsWith("/list/")) {
            String projectname = pathInfo.substring("/list/".length());
            boolean pde = projectname.indexOf(46) != -1;
            try {
                this.createProject(projectname, pde);
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace(resp.getWriter());
                resp.setStatus(500);
                return;
            }
        }
        super.doPut(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo.startsWith("/at/")) {
            String wsPath = pathInfo.substring("/at".length());
            IResource resource = this.getWorkspace().getRoot().findMember((IPath)new Path(wsPath));
            if (resource == null) {
                resp.getWriter().println("Resource '" + wsPath + "' does not exist");
                resp.setStatus(404);
                return;
            }
            try {
                resource.delete(false, null);
                resp.setStatus(204);
                return;
            }
            catch (CoreException e) {
                e.printStackTrace(resp.getWriter());
                resp.setStatus(500);
                return;
            }
        }
        super.doDelete(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo.startsWith("/at/")) {
            ServletOutputStream outputStream = resp.getOutputStream();
            String wsPath = pathInfo.substring("/at".length());
            IResource resource = this.getWorkspace().getRoot().findMember((IPath)new Path(wsPath));
            if (resource == null) {
                resp.setStatus(404);
                return;
            }
            if (resource.getType() != 1) {
                resp.setStatus(405);
                return;
            }
            IFile file = (IFile)resource;
            try {
                this.pipe(file, (OutputStream)outputStream);
                return;
            }
            catch (CoreException e) {
                e.printStackTrace(new PrintStream((OutputStream)outputStream, true));
                resp.setStatus(500);
                return;
            }
        }
        PrintWriter writer = resp.getWriter();
        if (pathInfo.startsWith("/list/")) {
            String wsPath = pathInfo.substring("/list".length());
            IResource resource = this.getWorkspace().getRoot().findMember((IPath)new Path(wsPath));
            if (resource == null) {
                resp.setStatus(404);
                return;
            }
            if (resource.getType() == 1) {
                resp.setStatus(405);
                return;
            }
            IContainer container = (IContainer)resource;
            try {
                IResource[] members = container.members();
                resp.setStatus(200);
                resp.setContentType("application/json; charset=UTF-8");
                ArrayList jsonArray = new ArrayList();
                int i = 0;
                while (i < members.length) {
                    HashMap<String, String> jsonObject = new HashMap<String, String>();
                    String name = members[i].getName();
                    if (members[i].getType() != 1) {
                        name = String.valueOf(name) + "/";
                    }
                    jsonObject.put("name", name);
                    jsonArray.add(jsonObject);
                    ++i;
                }
                writer.write(JSONUtil.write(jsonArray));
                return;
            }
            catch (CoreException e) {
                e.printStackTrace(writer);
                resp.setStatus(500);
                return;
            }
        }
        if (pathInfo.equals("/listopen/")) {
            resp.setStatus(200);
            resp.setContentType("application/json; charset=UTF-8");
            writer.print("{} ".replace('\'', '\"'));
            return;
        }
        super.doGet(req, resp);
    }

    private void pipe(IFile file, OutputStream outputStream) throws CoreException, IOException {
        InputStream contents = file.getContents();
        byte[] buffer = new byte[4096];
        int read = 0;
        while ((read = contents.read(buffer)) != -1) {
            outputStream.write(buffer, 0, read);
        }
        contents.close();
    }

    private void createProject(String projectname, boolean pde) throws CoreException, JavaModelException {
        IProject project = this.getWorkspace().getRoot().getProject(projectname);
        project.create(null);
        project.open(null);
        if (pde) {
            this.addNatureToProject(project, "org.eclipse.pde.PluginNature", null);
            this.setupJava(project, true);
            IFolder metaFolder = project.getFolder("META-INF");
            metaFolder.create(true, true, null);
            this.createManifest(metaFolder, projectname);
            this.createBuildProperties(project);
        } else {
            this.setupJava(project, false);
        }
    }

    private void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    private void setupJava(IProject project, boolean pde) throws CoreException, JavaModelException {
        this.addNatureToProject(project, "org.eclipse.jdt.core.javanature", null);
        IFolder srcFolder = project.getFolder("src");
        srcFolder.create(true, true, null);
        IFolder binFolder = project.getFolder("bin");
        if (!binFolder.exists()) {
            binFolder.create(true, true, null);
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        javaProject.setOutputLocation(binFolder.getFullPath(), null);
        IClasspathEntry[] entries = new IClasspathEntry[pde ? 3 : 1];
        if (pde) {
            String executionEnvironment = "J2SE-1.5";
            ClasspathComputer.setComplianceOptions((IJavaProject)javaProject, (String)executionEnvironment);
            entries[0] = ClasspathComputer.createJREEntry((String)executionEnvironment);
            entries[1] = ClasspathComputer.createContainerEntry();
        }
        entries[entries.length - 1] = JavaCore.newSourceEntry((IPath)srcFolder.getFullPath());
        javaProject.setRawClasspath(entries, null);
    }

    private void createManifest(IFolder metaFolder, String name) throws CoreException {
        IFile manifest = metaFolder.getFile("MANIFEST.MF");
        StringBuffer contents = new StringBuffer();
        contents.append("Manifest-Version: 1.0\n");
        contents.append("Bundle-ManifestVersion: 2\n");
        contents.append("Bundle-Name: " + name + "\n");
        contents.append("Bundle-SymbolicName: " + name + "\n");
        contents.append("Bundle-Version: 1.0.0\n");
        contents.append("Bundle-RequiredExecutionEnvironment: J2SE-1.5\n");
        contents.append("\n");
        manifest.create((InputStream)new ByteArrayInputStream(contents.toString().getBytes()), false, null);
    }

    private void createBuildProperties(IProject project) throws CoreException {
        IFile buildProperties = project.getFile("build.properties");
        StringBuffer contents = new StringBuffer();
        contents.append("source.. = src/\n");
        contents.append("output.. = bin/\n");
        contents.append("bin.includes = META-INF/,\\n");
        contents.append("               .\n");
        buildProperties.create((InputStream)new ByteArrayInputStream(contents.toString().getBytes()), false, null);
    }
}

