/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test.provider;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.examples.providers.RESTUtil;
import org.eclipse.core.resources.semantic.examples.providers.SampleRESTReadonlyContentProvider;
import org.eclipse.core.resources.semantic.spi.CachingContentProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.ISemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.SemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class RestTestContentProvider
extends SampleRESTReadonlyContentProvider {
    public ISemanticSpiResourceInfo fetchResourceInfo(ISemanticFileStore semanticFileStore, int options, IProgressMonitor monitor) throws CoreException {
        String uriString = SemanticSpiResourceInfo.isOptionRequested((int)64, (int)options) ? this.getURIStringInternal(semanticFileStore) : null;
        boolean existsRemotely = false;
        if (SemanticSpiResourceInfo.isOptionRequested((int)32, (int)options)) {
            String remoteURI = this.getURIString(semanticFileStore);
            if (remoteURI == null) {
                throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_URI_NOT_FOUND, semanticFileStore.getPath(), NLS.bind((String)"Remote URI is not set for file {0}", (Object)semanticFileStore.getPath().toString()));
            }
            try {
                InputStream is = RESTUtil.openInputStream((String)remoteURI, null);
                existsRemotely = is != null;
                Util.safeClose((InputStream)is);
            }
            catch (IOException iOException) {}
        }
        boolean isReadOnly = this.isReadOnlyInternal(semanticFileStore);
        return new SemanticSpiResourceInfo(options, false, false, isReadOnly, existsRemotely, uriString, this.getContentTypeInternal(semanticFileStore));
    }

    public void revertChanges(ISemanticFileStore semanticFileStore, IProgressMonitor monitor) throws CoreException {
        MultiStatus status = new MultiStatus("org.eclipse.ui.resources.semantic.examples.test", 0, NLS.bind((String)"Revert Change Result for {0}", (Object)semanticFileStore.getPath().toString()), null);
        this.dropCache(semanticFileStore, monitor, new CachingContentProvider.IDropCacheVisitor(){

            public boolean shouldDrop(ISemanticFileStore store) {
                return !store.isLocalOnly();
            }
        }, status);
        if (!status.isOK()) {
            throw new CoreException((IStatus)status);
        }
        this.setReadOnly(semanticFileStore, true, monitor);
        this.fillCache(semanticFileStore, monitor, status);
        if (!status.isOK()) {
            throw new CoreException((IStatus)status);
        }
    }

    public void synchronizeContentWithRemote(ISemanticFileStore semanticFileStore, SyncDirection direction, IProgressMonitor monitor, MultiStatus status) {
        if (semanticFileStore.getType() == 1) {
            URI uri;
            if (semanticFileStore.isLocalOnly()) {
                return;
            }
            try {
                uri = new URI(this.getURIString(semanticFileStore));
            }
            catch (URISyntaxException e) {
                status.add((IStatus)new Status(4, "org.eclipse.core.resources.semantic.examples", e.getMessage()));
                return;
            }
            catch (CoreException e) {
                status.add(e.getStatus());
                return;
            }
            boolean syncIn = false;
            boolean syncOut = false;
            if (direction == SyncDirection.BOTH) {
                long localTimestamp;
                long remoteTimestamp;
                try {
                    remoteTimestamp = uri.toURL().openConnection().getLastModified();
                }
                catch (MalformedURLException e) {
                    status.add((IStatus)new Status(4, "org.eclipse.core.resources.semantic.examples", e.getMessage()));
                    return;
                }
                catch (IOException e) {
                    status.add((IStatus)new Status(4, "org.eclipse.core.resources.semantic.examples", e.getMessage()));
                    return;
                }
                try {
                    localTimestamp = this.getResourceTimestamp(semanticFileStore, monitor);
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                    return;
                }
                syncIn = remoteTimestamp > localTimestamp;
                boolean bl = syncOut = localTimestamp > remoteTimestamp;
            }
            if (direction == SyncDirection.INCOMING || syncIn) {
                this.dropCache(semanticFileStore, monitor, this.deleteAllVisitor, status);
                this.fillCache(semanticFileStore, monitor, status);
            }
            if (direction == SyncDirection.OUTGOING || syncOut) {
                try {
                    File file = new File(uri);
                    Util.transferStreams((InputStream)this.getCacheService().getContent(semanticFileStore.getPath()), (OutputStream)new FileOutputStream(file), (IProgressMonitor)monitor);
                    file.setLastModified(this.getResourceTimestamp(semanticFileStore, monitor));
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                }
                catch (IOException e) {
                    status.add((IStatus)new Status(4, "org.eclipse.core.resources.semantic.examples", e.getMessage()));
                    return;
                }
            }
        } else {
            IFileStore[] childStores;
            try {
                childStores = semanticFileStore.childStores(0, monitor);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
                return;
            }
            IFileStore[] iFileStoreArray = childStores;
            int n = childStores.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore store = iFileStoreArray[n2];
                if (store instanceof ISemanticFileStore) {
                    this.synchronizeContentWithRemote((ISemanticFileStore)store, direction, monitor, status);
                }
                ++n2;
            }
        }
    }

    public void addResource(ISemanticFileStore childStore, String name, ISemanticFileStore.ResourceType resourceType, IProgressMonitor monitor) throws CoreException {
        switch (resourceType) {
            case FOLDER_TYPE: {
                childStore.addChildFolder(name);
                break;
            }
            default: {
                throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, childStore.getPath(), "Not supported");
            }
        }
    }

    public IStatus validateEdit(ISemanticFileStore[] stores, Object shell) {
        ISemanticFileStore[] iSemanticFileStoreArray = stores;
        int n = stores.length;
        int n2 = 0;
        while (n2 < n) {
            ISemanticFileStore store = iSemanticFileStoreArray[n2];
            try {
                this.setReadOnlyInternal(store, false);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            ++n2;
        }
        return new Status(0, "org.eclipse.core.resources.semantic.examples", null);
    }

    public IStatus validateSave(ISemanticFileStore semanticFileStore) {
        return this.validateEdit(new ISemanticFileStore[]{semanticFileStore}, null);
    }
}

