/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelElementTest
extends TestCase {
    public void testForMApplicationInterface() {
        ArrayList<EClass> failedClasses = new ArrayList<EClass>();
        this.checkPackageForMApplicationInterface(failedClasses, (EPackage)ApplicationPackageImpl.eINSTANCE);
        if (failedClasses.size() > 0) {
            StringBuilder b = new StringBuilder("The following concrete classes don't implement 'MApplicationElement':\n");
            for (EClass c : failedClasses) {
                b.append("* " + c.getName() + "\n");
            }
            System.err.println(b.toString());
            ModelElementTest.fail((String)b.toString());
        }
    }

    private void checkPackageForMApplicationInterface(List<EClass> failedClasses, EPackage ePackage) {
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            EClass c;
            if (!(classifier instanceof EClass) || (c = (EClass)classifier).isInterface() || c == ApplicationPackageImpl.Literals.STRING_TO_STRING_MAP || c == ApplicationPackageImpl.Literals.STRING_TO_OBJECT_MAP || MApplicationElement.class.isAssignableFrom(c.getInstanceClass())) continue;
            failedClasses.add(c);
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            this.checkPackageForMApplicationInterface(failedClasses, subPackage);
        }
    }

    public void testForOptimalBaseClass() {
        ArrayList<EClass> failedClasses = new ArrayList<EClass>();
        this.checkPackageForOptimalBaseClass(failedClasses, (EPackage)ApplicationPackageImpl.eINSTANCE);
        if (failedClasses.size() > 0) {
            StringBuilder b = new StringBuilder("The following concrete classes have a mixin as base 'MApplicationElement':\n");
            for (EClass c : failedClasses) {
                b.append("* " + c.getName() + "\n");
            }
            System.err.println(b.toString());
            ModelElementTest.fail((String)b.toString());
        }
    }

    private void checkPackageForOptimalBaseClass(List<EClass> failedClasses, EPackage ePackage) {
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            EClass c;
            if (!(classifier instanceof EClass) || (c = (EClass)classifier) == ApplicationPackageImpl.Literals.STRING_TO_STRING_MAP || c == ApplicationPackageImpl.Literals.STRING_TO_OBJECT_MAP || c == ApplicationPackageImpl.Literals.APPLICATION_ELEMENT || c.isInterface() || c.getESuperTypes().size() != 0 && !((EClass)c.getESuperTypes().get(0)).isInterface()) continue;
            failedClasses.add(c);
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            this.checkPackageForOptimalBaseClass(failedClasses, subPackage);
        }
    }
}

