/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class MSashTest
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    public void testSashWeights() {
        MWindow window = this.createSashWithNViews(2);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Widget topWidget = (Widget)window.getWidget();
        ((Shell)topWidget).layout(true);
        MPartSashContainer sash = (MPartSashContainer)window.getChildren().get(0);
        MSashTest.assertTrue((String)"Should be an MPartSashContainer", (boolean)(sash instanceof MPartSashContainer));
        MPart part0 = (MPart)sash.getChildren().get(0);
        MPart part1 = (MPart)sash.getChildren().get(1);
        int cdVal0 = -1;
        try {
            cdVal0 = Integer.parseInt(part0.getContainerData());
        }
        catch (NumberFormatException numberFormatException) {}
        MSashTest.assertTrue((String)"Part0 data is not an integer", (cdVal0 != -1 ? 1 : 0) != 0);
        int cdVal1 = -1;
        try {
            cdVal1 = Integer.parseInt(part1.getContainerData());
        }
        catch (NumberFormatException numberFormatException) {}
        MSashTest.assertTrue((String)"Part1 data is not an integer", (cdVal1 != -1 ? 1 : 0) != 0);
        MSashTest.assertTrue((String)"Values should be equal", (cdVal0 == cdVal1 ? 1 : 0) != 0);
    }

    private MWindow createSashWithNViews(int n) {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setHeight(300);
        window.setWidth(401);
        window.setLabel("MyWindow");
        MPartSashContainer sash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        window.getChildren().add(sash);
        int i = 0;
        while (i < n) {
            MPart contributedPart = BasicFactoryImpl.eINSTANCE.createPart();
            contributedPart.setLabel("Sample View" + i);
            contributedPart.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
            sash.getChildren().add(contributedPart);
            ++i;
        }
        return window;
    }
}

