/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.dnd.impl;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.platform.discovery.runtime.api.OnDemandLoadException;
import org.eclipse.platform.discovery.ui.internal.view.dnd.IDndInteractionListener;
import org.eclipse.platform.discovery.ui.internal.view.dnd.ISourceDndInteractionEvent;
import org.eclipse.platform.discovery.util.api.env.IErrorHandler;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class DragSrcInteractionListener
implements IDndInteractionListener<ISourceDndInteractionEvent> {
    private final ISelectionObtainer selectionObtainer;
    ITransferDataSetter<? extends Transfer>[] transfers;
    private final IErrorHandler errorHandler;

    public DragSrcInteractionListener(ISelectionObtainer selectionObtainer, ITransferDataSetter<? extends Transfer>[] transfers, IErrorHandler errorHandler) {
        this.selectionObtainer = selectionObtainer;
        this.transfers = transfers;
        this.errorHandler = errorHandler;
    }

    @Override
    public void finish(ISourceDndInteractionEvent event) {
    }

    @Override
    public void process(ISourceDndInteractionEvent event) {
        try {
            ITransferDataSetter<? extends Transfer>[] iTransferDataSetterArray = this.transfers;
            int n = this.transfers.length;
            int n2 = 0;
            while (n2 < n) {
                ITransferDataSetter<? extends Transfer> tds = iTransferDataSetterArray[n2];
                if (tds.getTransfer().isSupportedType((TransferData)event.getDataType())) {
                    tds.setData(this.selectionObtainer.getSelection(), event);
                }
                ++n2;
            }
        }
        catch (OnDemandLoadException odl) {
            this.errorHandler.handleException((Exception)((Object)odl));
        }
    }

    @Override
    public void start(ISourceDndInteractionEvent event) {
        IStructuredSelection selection = this.selectionObtainer.getSelection();
        event.setDoIt(!selection.isEmpty());
        if (event.getDoIt()) {
            ITransferDataSetter<? extends Transfer>[] iTransferDataSetterArray = this.transfers;
            int n = this.transfers.length;
            int n2 = 0;
            while (n2 < n) {
                ITransferDataSetter<? extends Transfer> tds = iTransferDataSetterArray[n2];
                tds.dragStarted(selection, event);
                ++n2;
            }
        }
    }

    public Transfer[] getTransfers() {
        Transfer[] ts = new Transfer[this.transfers.length];
        int i = 0;
        while (i < this.transfers.length) {
            ts[i] = this.transfers[i].getTransfer();
            ++i;
        }
        return ts;
    }

    public static interface ISelectionObtainer {
        public IStructuredSelection getSelection();
    }

    public static interface ITransferDataSetter<T extends Transfer> {
        public T getTransfer();

        public void setData(IStructuredSelection var1, ISourceDndInteractionEvent var2);

        public void dragStarted(IStructuredSelection var1, ISourceDndInteractionEvent var2);
    }
}

